/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import IT.picosoft.isam.IsamException;
import com.iscobol.io.DynamicLSeq8bit;
import com.iscobol.rts.KeyDescription;
import com.iscobol.rts.RuntimeErrorsNumbers;

public class DynamicLSeqACU
extends DynamicLSeq8bit
implements RuntimeErrorsNumbers {
    private byte[] myRec;
    private int actEolLength;

    @Override
    public int open(String path, int openType, int lockType, KeyDescription[] k, int maxRec, int minRec, int nKeys, int accessMode, boolean optional, boolean assignExt) {
        this.myRec = new byte[maxRec << 1 + eol.length];
        return super.open(path, openType, lockType, k, maxRec, minRec, nKeys, accessMode, optional, assignExt);
    }

    @Override
    public synchronized long next(byte[] record, int offs, int lock) {
        int len = record.length - offs;
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.theFile == null) {
            return this.mapError(new IsamException(110));
        }
        try {
            int j;
            boolean eolFound = false;
            this.actEolLength = 0;
            this.theFile.seek(this.currPos);
            int rc = this.theFile.read(this.myRec, offs, len + 2);
            if (rc <= 0) {
                return this.mapError(new IsamException(110));
            }
            int i = 0;
            for (j = 0; i < len && j < rc; ++j) {
                if (this.myRec[j] == 12 || this.myRec[j] == 13) continue;
                this.buffer[i++] = this.myRec[j];
                if (this.myRec[j] != 10) continue;
                eolFound = true;
                ++this.actEolLength;
                if (--i <= 0 || this.buffer[i] != 13) break;
                --i;
                ++this.actEolLength;
                break;
            }
            if (!eolFound) {
                while (j < rc) {
                    if (this.myRec[j] == 10) {
                        eolFound = true;
                        ++this.actEolLength;
                        if (j <= 0 || this.myRec[j - 1] != 13) break;
                        ++this.actEolLength;
                        break;
                    }
                    ++j;
                }
            }
            this.currLen = i;
            if (lock > 0) {
                this.lock(this.currPos, this.currLen);
            }
            this.currPos = eolFound ? (this.currPos += (long)(j + 1)) : (this.currPos += (long)len);
            System.arraycopy(this.buffer, 0, record, offs, i);
            int k = offs + i;
            while (i < len) {
                record[k] = 32;
                ++i;
                ++k;
            }
            while (!eolFound) {
                this.theFile.seek(this.currPos);
                rc = this.theFile.read(this.myRec, 0, len + 2);
                if (rc > 0) {
                    for (k = 0; k < rc; ++k) {
                        if (this.myRec[k] != 10) continue;
                        eolFound = true;
                        ++this.actEolLength;
                        if (k <= 0 || this.myRec[k - 1] != 13) break;
                        ++this.actEolLength;
                        break;
                    }
                    if (eolFound) {
                        this.currPos += (long)(k + 1);
                        continue;
                    }
                    this.currPos += (long)rc;
                    continue;
                }
                eolFound = true;
            }
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return this.currLen;
    }

    @Override
    public synchronized long previous(byte[] record, int offs, int lock) {
        this.errno = -3;
        return 0L;
    }

    @Override
    public long rewrite(byte[] record, int offs, int len, boolean lock) {
        this.errno = 0;
        if (len > this.maxRecordSize) {
            len = this.maxRecordSize;
        }
        if (this.currPos == 0L || this.currPos - (long)this.currLen - (long)this.actEolLength < 0L) {
            this.errno = -2;
            return 0L;
        }
        try {
            int rlen;
            this.theFile.seek(this.currPos - (long)this.currLen - (long)this.actEolLength);
            if (this.stripTrailingSpace && (rlen = this.tailTrim(record, offs, len)) > this.currLen) {
                this.errno = -1;
                return 0L;
            }
            this.theFile.write(record, offs, this.currLen);
        }
        catch (IsamException _ex) {
            return this.mapError(_ex);
        }
        return 1L;
    }
}

