/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.io;

import com.iscobol.io.AtEndException;
import com.iscobol.io.DataStream;
import com.iscobol.io.FileStatus;
import com.iscobol.io.FileStatusDefault;
import com.iscobol.io.InvalidKeyException;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;

public class CobolIOException
extends IscobolRuntimeException {
    final String initialMessage;
    final transient DataStream ds;
    final String fs;
    final String extFs;
    final String stMsg;
    static FileStatus status = new FileStatusDefault();

    protected static String buildMsg(DataStream cf) {
        String fs = cf.getFileStatus();
        String extFs = cf.getExtendedStatus();
        String msg = cf.getStatusMessage();
        StringBuffer Return2 = new StringBuffer(cf.getLogicName());
        Return2.append(" (");
        Return2.append(cf.getOsPath());
        Return2.append(") FS=[");
        Return2.append(fs);
        Return2.append("]");
        Return2.append(extFs == null ? "" : ",EXFS=[" + extFs + "]");
        if (msg != null) {
            Return2.append(": ");
            Return2.append(msg);
        }
        return Return2.toString();
    }

    public CobolIOException(CobolIOException cioe) {
        this(cioe.getErrNum(), cioe.getInitialMessage(), cioe.ds);
    }

    protected CobolIOException(int type, String msg, DataStream cf) {
        super(type, msg);
        this.initialMessage = msg;
        this.ds = cf;
        this.fs = this.ds.getFileStatus();
        String es = this.ds.getExtendedStatus();
        this.extFs = es != null && es.length() == 0 ? null : es;
        this.stMsg = this.ds.getStatusMessage();
    }

    final void throwMe() {
        this.ds.setFileStatus(this.fs);
        this.ds.setStatusMessage(this.stMsg);
        if (this.extFs != null) {
            this.ds.setExtendedStatus(this.extFs);
        }
        this.ds.setLastException(this);
        if (this.ds.getLogger() != null) {
            this.ds.getLogger().info(this.getMessage());
        }
        throw this;
    }

    public String getInitialMessage() {
        return this.initialMessage;
    }

    private CobolIOException getEx(int op) {
        CobolIOException Return2;
        switch (this.getErrNum()) {
            case 100: {
                Return2 = new InvalidKeyException(this);
                break;
            }
            case 110: {
                Return2 = new AtEndException(this);
                break;
            }
            case 111: {
                if (op == 6 || op == 7) {
                    Return2 = new AtEndException(this);
                    break;
                }
                Return2 = new InvalidKeyException(this);
                break;
            }
            default: {
                Return2 = this;
            }
        }
        return Return2;
    }

    public static void get(int code, String extFs, DataStream cf, int op) {
        if ((code = status.map(code, extFs, cf, op)) != 0) {
            CobolIOException ex = new CobolIOException(code, CobolIOException.buildMsg(cf), cf).getEx(op);
            cf.setLastException(ex);
            if (cf.getLogger() != null) {
                cf.getLogger().info(ex.getMessage());
            }
            throw ex;
        }
    }

    public static void get(Exception ex, DataStream cf) {
        CobolIOException.get(ex, cf, 0);
    }

    public static void get(Exception ex, DataStream cf, int op) {
        int code = status.map(ex, cf, op);
        if (code != 0) {
            CobolIOException cioe = new CobolIOException(code, ex.getMessage(), cf).getEx(op);
            cf.setLastException(cioe);
            if (cf.getLogger() != null) {
                cf.getLogger().info(ex.getMessage());
            }
            throw cioe;
        }
    }

    public static boolean isErrorsOk(boolean hasFs) {
        int errorsOk = Config.getProperty(".file.errors_ok", ".errors_ok", 0);
        return errorsOk == 1 ? true : errorsOk == 2 && hasFs;
    }

    public static boolean isErrorsOk() {
        return Config.getProperty(".file.errors_ok", ".errors_ok", false);
    }

    static {
        String fs = Config.getProperty(".file.status", null);
        if (fs != null) {
            try {
                status = (FileStatus)Class.forName(fs).newInstance();
            }
            catch (Exception _ex) {
                _ex.printStackTrace();
            }
        }
    }
}

