/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.IscobolLayout;
import com.iscobol.gui.client.ResizeLayout;
import com.iscobol.gui.client.ResponsiveLayout;
import com.iscobol.gui.client.ScaleLayout;
import com.iscobol.gui.client.TabChangeException;
import com.iscobol.gui.client.TabWillChangeEvent;
import com.iscobol.gui.client.TabWillChangeListener;
import com.iscobol.gui.client.ZoomLayout;
import com.iscobol.gui.client.swing.GraphTextIcon;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.IsTextIcon;
import com.iscobol.gui.client.swing.PicobolButton;
import com.iscobol.gui.client.swing.PicobolTabInterface;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteLabel;
import com.iscobol.gui.client.swing.RemoteTab;
import com.iscobol.gui.client.swing.SwingWorker;
import com.iscobol.gui.client.swing.TextIcon;
import com.iscobol.rts.RtsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class TabNative
extends JTabbedPane
implements PicobolTabInterface {
    private static final long serialVersionUID = 0L;
    private static final Class basicTabbedPaneUI;
    public static final String WRAP_LAYOUT = "LM-WRAP";
    private Vector tabWillChangeListeners = new Vector();
    private Image image;
    private int bitmapWidth;
    private Hashtable bitmapNumbers = new Hashtable();
    private boolean textnorotate;
    private boolean isribbon;
    private boolean isnative;
    private Color bg;
    private Color fg;
    private boolean set0;
    private int tabidxvisiblebeforeresizing = -1;
    private boolean hasWrapLayout;
    private String layoutType;
    private String layoutDefaults;
    private Vector addtabidxvect;
    private boolean relativeoffset;
    private Insets iborder;
    private final RemoteTab parentRbgc;
    private boolean istabflat;
    private boolean istabbuttons;
    private Color tabbg;
    private Color tabfg;
    private Color activetabbg;
    private Color activetabfg;
    private int[] borderwidth;
    private int[] activeborderwidth;
    private Color tabborderforegroundcolor;
    private Color activetabborderforegroundcolor;
    private Hashtable<Integer, Integer> tabwidths;
    private int fontw = -1;
    private int fonth = -1;
    private Color hc;
    private Color sc;

    @Override
    public void setSelectedIndex(int index) {
        if (super.getTabCount() == 1) {
            super.setSelectedIndex(index);
        } else {
            try {
                this.fireTabWillChangeEvent(index);
            }
            catch (TabChangeException tabChangeException) {
                // empty catch block
            }
        }
    }

    @Override
    public void selectIndex(int index) {
        super.setSelectedIndex(index);
    }

    public boolean get0func() {
        return this.set0;
    }

    public void set0func(boolean b) {
        this.set0 = b;
    }

    private void setui() {
        BasicTabbedPaneUI btpuiFLAT = new BasicTabbedPaneUI(){

            @Override
            protected Insets getSelectedTabPadInsets(int tabPlacement) {
                Insets Return2 = null;
                Return2 = super.getSelectedTabPadInsets(tabPlacement);
                if (tabPlacement == 1) {
                    Return2.bottom = 0;
                } else if (tabPlacement == 3) {
                    Return2.top = 0;
                } else if (tabPlacement == 2) {
                    Return2.right = 0;
                } else if (tabPlacement == 4) {
                    Return2.left = 0;
                }
                return Return2;
            }

            @Override
            protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
                Color tmp = null;
                if (isSelected && (tmp = TabNative.this.getNativeActiveBG()) != null) {
                    g.setColor(tmp);
                } else {
                    tmp = TabNative.this.getNativeBG();
                    if (tmp != null) {
                        g.setColor(tmp);
                    } else {
                        g.setColor(TabNative.this.getNativeOKBG());
                    }
                }
                g.fillRect(x, y, w, h);
                tmp = null;
                int top = -1;
                int left = -1;
                int bottom = -1;
                int right = -1;
                if (isSelected) {
                    tmp = TabNative.this.getActiveBorderForegroundColor();
                    if (tmp != null) {
                        g.setColor(tmp);
                    } else {
                        g.setColor(TabNative.this.getNativeOKFG());
                    }
                    top = TabNative.this.getActiveBorderWidthAt(0);
                    left = TabNative.this.getActiveBorderWidthAt(1);
                    bottom = TabNative.this.getActiveBorderWidthAt(2);
                    right = TabNative.this.getActiveBorderWidthAt(3);
                    if (top > 0) {
                        g.fillRect(x, y, w, top);
                    }
                    if (right > 0) {
                        g.fillRect(x + w - right, y, right, h);
                    }
                    if (left > 0) {
                        g.fillRect(x, y, left, h);
                    }
                    if (bottom > 0) {
                        g.fillRect(x, y + h - bottom, w, bottom);
                    }
                }
                if ((tmp = TabNative.this.getBorderForegroundColor()) != null) {
                    g.setColor(tmp);
                } else {
                    g.setColor(TabNative.this.getNativeOKFG());
                }
                if (top == -1 && (top = TabNative.this.getBorderWidthAt(0)) > 0) {
                    g.fillRect(x, y, w, top);
                }
                if (left == -1 && (left = TabNative.this.getBorderWidthAt(1)) > 0) {
                    g.fillRect(x, y, left, h);
                }
                if (bottom == -1 && (bottom = TabNative.this.getBorderWidthAt(2)) > 0) {
                    g.fillRect(x, y + h - bottom, w, bottom);
                }
                if (right == -1 && (right = TabNative.this.getBorderWidthAt(3)) > 0) {
                    g.fillRect(x + w - right, y, right, h);
                }
            }

            @Override
            protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            }

            @Override
            protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
                if (!TabNative.this.istabbuttons || TabNative.this.isnative) {
                    if (tabPlacement != 1) {
                        if (tabPlacement == 3) {
                            ++h;
                        } else if (tabPlacement != 2 && tabPlacement == 4) {
                            ++w;
                        }
                    }
                    TabNative.this.paintEtchedBorder(g, x, y, w, h, TabNative.this.hc, TabNative.this.sc);
                }
            }

            @Override
            protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
            }

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                Integer tmp;
                int Return2 = -1;
                if (TabNative.this.tabwidths != null && (tabPlacement == 2 || tabPlacement == 4) && (tmp = (Integer)TabNative.this.tabwidths.get(new Integer(tabIndex))) != null && (Return2 = tmp.intValue()) >= 0) {
                    return Return2 * TabNative.this.fonth;
                }
                Return2 = super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
                return Return2;
            }

            @Override
            protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
                Integer tmp;
                int Return2 = -1;
                if (TabNative.this.tabwidths != null && (tabPlacement == 1 || tabPlacement == 3) && (tmp = (Integer)TabNative.this.tabwidths.get(new Integer(tabIndex))) != null && (Return2 = tmp.intValue()) >= 0) {
                    return Return2 * TabNative.this.fontw;
                }
                Return2 = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
                return Return2;
            }

            @Override
            protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
                int titlewidth;
                boolean changed = false;
                TabNative.this.setTextIconForeground(tabIndex, isSelected);
                if (title != null && title.length() > 0 && textRect != null && ((titlewidth = this.calculateTabWidth(tabPlacement, tabIndex, metrics)) < textRect.width || textRect.width < metrics.stringWidth(title))) {
                    int i = 1;
                    String tmp = title.substring(0, i++);
                    while (i < title.length() && metrics.stringWidth(tmp) <= textRect.width) {
                        tmp = title.substring(0, i++);
                    }
                    if (i - 2 > 0) {
                        tmp = title.substring(0, i - 2);
                    }
                    title = tmp;
                    if (titlewidth < textRect.width) {
                        textRect.width = titlewidth;
                        TabNative.this.setTitleAt(tabIndex, title);
                        changed = true;
                    }
                }
                if (changed) {
                    TabNative.this.repaint();
                } else {
                    super.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
                }
            }
        };
        this.setUI(btpuiFLAT);
    }

    public TabNative(boolean multiline, boolean isribbon, boolean isnative, boolean relativeoffset, boolean istabflat, boolean istabbuttons, String layoutType, String layoutDefaults, RemoteTab parentRbgc) {
        this.parentRbgc = parentRbgc;
        this.isribbon = isribbon;
        this.isnative = isnative;
        this.istabflat = istabflat;
        this.istabbuttons = istabbuttons;
        if (!isribbon && multiline || layoutType != null && layoutType.equals(WRAP_LAYOUT)) {
            this.hasWrapLayout = true;
        } else {
            this.layoutType = layoutType;
            this.layoutDefaults = layoutDefaults;
            this.hasWrapLayout = false;
        }
        this.relativeoffset = relativeoffset;
        EtchedBorder rbb = (EtchedBorder)BorderFactory.createEtchedBorder(1);
        this.hc = rbb.getHighlightColor();
        this.sc = rbb.getShadowColor();
        this.iborder = rbb.getBorderInsets(this);
        this.setTabLayoutPolicy(this.hasWrapLayout ? 0 : 1);
        if (istabflat) {
            this.setui();
        }
    }

    private void modifysinglepanel(MyNativePanel mp, int i) {
        Component obj = null;
        MyScrollPane msp = null;
        obj = this.getComponentAt(i);
        if (obj != null && obj instanceof MyScrollPane) {
            msp = (MyScrollPane)obj;
        }
        if (this.get0func()) {
            if (mp.isVisible()) {
                this.tabidxvisiblebeforeresizing = i;
            }
            mp.setVisible(!this.get0func());
            if (msp != null) {
                msp.setVisible(!this.get0func());
                msp.setPreferredSize(new Dimension(mp.getWH().width, 1));
            }
        } else if (this.tabidxvisiblebeforeresizing == i) {
            mp.setVisible(!this.get0func());
            if (msp != null) {
                msp.setVisible(!this.get0func());
                msp.setPreferredSize(mp.getWH());
            }
            this.tabidxvisiblebeforeresizing = -1;
        } else if (this.hasWrapLayout) {
            mp.setVisible(!this.get0func());
        }
        mp.invalidate();
        if (msp != null) {
            msp.invalidate();
        }
    }

    @Override
    public boolean modifypanels() {
        MyNativePanel mp = null;
        this.set0func(!this.get0func());
        if (!this.get0func()) {
            this.tabidxvisiblebeforeresizing = this.getSelectedIndex();
        }
        for (int i = 0; i < this.getTabCount() && (mp = this.getMyNativePanel(i)) != null; ++i) {
            this.modifysinglepanel(mp, i);
        }
        return this.get0func();
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        super.addKeyListener(kl);
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        super.removeKeyListener(kl);
    }

    @Override
    public void addTabWillChangeListener(TabWillChangeListener l) {
        this.tabWillChangeListeners.addElement(l);
    }

    public void removeTabWillChangeListener(TabWillChangeListener l) {
        this.tabWillChangeListeners.remove(l);
    }

    @Override
    public void setImage(Image img) {
        this.image = img;
        for (Integer k : this.bitmapNumbers.keySet()) {
            this.setIconAt((int)k, this.image != null ? this.getIcon((Integer)this.bitmapNumbers.get(k)) : null);
        }
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public void setBitmapWidth(int w) {
        this.bitmapWidth = w;
    }

    @Override
    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    @Override
    public int addTab(RemoteTab rt, String label, int insertionIndex, JTabbedPane jtp, int tabw, int tabh) {
        MyNativePanel mp = null;
        mp = insertionIndex >= 0 && insertionIndex < this.getTabCount() ? new MyNativePanel(rt, insertionIndex, tabw, tabh) : new MyNativePanel(rt, this.getTabCount(), tabw, tabh);
        if (this.istabflat) {
            // empty if block
        }
        if (this.bg != null) {
            mp.setBackground(this.bg);
        }
        if (this.fg != null) {
            mp.setForeground(this.fg);
        }
        if (this.isribbon) {
            if (this.hasWrapLayout) {
                mp.setLayout(new IsWrapLayout(3));
                MyScrollPane js = new MyScrollPane(mp);
                js.setHorizontalScrollBarPolicy(31);
                js.setPreferredSize(new Dimension(tabw, tabh));
                js.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        JScrollPane scrollPane = (JScrollPane)e.getComponent();
                        JViewport viewport = scrollPane.getViewport();
                        Dimension d = viewport.getSize();
                        viewport.getView().setSize(d);
                    }
                });
                return this.addTab(label, insertionIndex, js, jtp);
            }
            if (this.layoutType != null) {
                if (this.layoutType.equals("LM-RESIZE")) {
                    mp.setLayout(new ResizeLayout(mp));
                } else if (this.layoutType.equals("LM-SCALE")) {
                    mp.setLayout(new ScaleLayout(mp, this.layoutDefaults));
                } else if (this.layoutType.equals("LM-ZOOM")) {
                    GuiFactoryImpl gf;
                    ZoomLayout zl = this.parentRbgc != null && (gf = this.parentRbgc.getGuiFactory()) != null ? new ZoomLayout(mp, this.layoutDefaults, gf.getCsProperty().get("iscobol.gui.layout_manager.min_font_zoom", 0), gf.getCsProperty().get("iscobol.gui.layout_manager.max_font_zoom", 0)) : new ZoomLayout(mp, this.layoutDefaults);
                    mp.setLayout(zl);
                } else if (this.layoutType.equals("LM-RESPONSIVE")) {
                    mp.setLayout(new ResponsiveLayout(mp, this.layoutDefaults, this.parentRbgc.parentWindow));
                }
            }
            return this.addTab(label, insertionIndex, mp, jtp);
        }
        return this.addTab(label, insertionIndex, mp, jtp);
    }

    public int addTab(String label, int insertionIndex, Container mp, JTabbedPane jtp) {
        String lbl = null;
        IsTextIcon icon = null;
        switch (this.getTabPlacement()) {
            case 1: 
            case 3: {
                lbl = label;
                break;
            }
            case 4: {
                if (this.textnorotate) {
                    lbl = label;
                    break;
                }
                icon = new IsTextIcon(jtp, label, 4);
                break;
            }
            case 2: {
                if (this.textnorotate) {
                    lbl = label;
                    break;
                }
                icon = new IsTextIcon(jtp, label, 2);
            }
        }
        if (insertionIndex >= 0 && insertionIndex < this.getTabCount()) {
            this.insertTab(lbl, icon, mp, this.getToolTipText(), insertionIndex);
            this.setDisabledIconAt(insertionIndex, icon);
        } else {
            this.addTab(lbl, icon, (Component)mp, this.getToolTipText());
            this.setDisabledIconAt(this.getTabCount() - 1, icon);
            insertionIndex = this.getTabCount() - 1;
        }
        if (this.tabbg != null) {
            this.setBackgroundAt(insertionIndex, this.tabbg);
        }
        if (this.tabfg != null) {
            this.setForegroundAt(insertionIndex, this.tabfg);
        }
        if (this.addtabidxvect != null) {
            this.doLayout();
            ListIterator ctlLI = this.addtabidxvect.listIterator(0);
            Rbgctotabidx ri = null;
            while (ctlLI.hasNext()) {
                ri = (Rbgctotabidx)ctlLI.next();
                if (ri == null || ri.getTabIndex() != insertionIndex || ri.getTabIndex() >= this.getTabCount()) continue;
                this.intadd(ri.getRbgc(), ri.getIndex(), ri.getTabIndex(), ri.getChildGraphics());
                ctlLI.remove();
            }
        }
        if (this.isribbon && this.get0func()) {
            if (!(mp instanceof MyNativePanel)) {
                mp = this.getMyNativePanel(insertionIndex);
            }
            if (mp != null && mp.isVisible() == this.get0func()) {
                this.modifysinglepanel((MyNativePanel)mp, insertionIndex);
            }
            final Container mpf = mp;
            new IsguiWorker(false){

                @Override
                public void launch() {
                    mpf.doLayout();
                }
            }.start();
        }
        return insertionIndex;
    }

    @Override
    public int myremoveTabAt(int idx) {
        MyNativePanel mp = this.getMyNativePanel(idx);
        this.removeTabAt(idx);
        return mp != null ? mp.getPosition() : -1;
    }

    public ImageIcon getIcon(int strip) {
        if (strip > 0) {
            Image imageStrip = ScreenUtility.getImage(this.bitmapWidth, -1, this.image, strip);
            if (imageStrip != null) {
                return new ImageIcon(imageStrip);
            }
            return null;
        }
        return null;
    }

    @Override
    public void setBitmapNumberAt(int idx, int bn) {
        if (bn > 0) {
            this.bitmapNumbers.put(new Integer(idx), new Integer(bn));
        } else {
            this.bitmapNumbers.remove(new Integer(idx));
        }
        this.setIconAt(idx, this.getIcon(bn));
    }

    @Override
    public void setIconAt(int idx, ImageIcon newIcon) {
        double theta = Math.toRadians(90.0);
        int pos = 1;
        ImageIcon graynewIcon = this.toGray(newIcon);
        switch (this.getTabPlacement()) {
            case 1: 
            case 3: {
                super.setIconAt(idx, newIcon);
                this.setDisabledIconAt(idx, graynewIcon);
                break;
            }
            case 2: {
                theta = -theta;
                pos = 3;
            }
            case 4: {
                if (this.textnorotate) {
                    super.setIconAt(idx, newIcon);
                    this.setDisabledIconAt(idx, graynewIcon);
                    break;
                }
                Icon oldIcon = this.getIconAt(idx);
                if (oldIcon instanceof TextIcon && newIcon != null) {
                    newIcon.setImage(ScreenUtility.rotate(newIcon.getImage(), theta));
                    super.setIconAt(idx, new GraphTextIcon(newIcon, (TextIcon)oldIcon, pos));
                    if (graynewIcon == null) break;
                    graynewIcon.setImage(ScreenUtility.rotate(graynewIcon.getImage(), theta));
                    this.setDisabledIconAt(idx, new GraphTextIcon(graynewIcon, (TextIcon)oldIcon, pos));
                    break;
                }
                if (!(oldIcon instanceof GraphTextIcon)) break;
                GraphTextIcon di = (GraphTextIcon)oldIcon;
                if (newIcon == null) {
                    super.setIconAt(idx, di.getTextIcon());
                    this.setDisabledIconAt(idx, this.toGray(di.getTextIcon()));
                    break;
                }
                newIcon.setImage(ScreenUtility.rotate(newIcon.getImage(), theta));
                super.setIconAt(idx, new GraphTextIcon(newIcon, di.getTextIcon(), pos));
                if (graynewIcon == null) break;
                graynewIcon.setImage(ScreenUtility.rotate(graynewIcon.getImage(), theta));
                this.setDisabledIconAt(idx, new GraphTextIcon(graynewIcon, di.getTextIcon(), pos));
            }
        }
        this.doLayout();
    }

    @Override
    public String mygetTitleAt(int idx) {
        switch (this.getTabPlacement()) {
            case 1: 
            case 3: {
                return super.getTitleAt(idx);
            }
            case 2: 
            case 4: {
                Icon i = this.getIconAt(idx);
                if (i instanceof TextIcon) {
                    return ((TextIcon)i).getLabel();
                }
                if (i instanceof GraphTextIcon) {
                    return ((GraphTextIcon)i).getTextIcon().getLabel();
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public void mysetTitleAt(final int idx, final String title, final JTabbedPane jtp) {
        new SwingWorker(true){

            @Override
            public void launch() {
                int rotate = 4;
                int pos = 1;
                switch (TabNative.this.getTabPlacement()) {
                    case 1: 
                    case 3: {
                        jtp.setTitleAt(idx, title);
                        break;
                    }
                    case 2: {
                        rotate = 2;
                        pos = 3;
                    }
                    case 4: {
                        if (TabNative.this.textnorotate) {
                            jtp.setTitleAt(idx, title);
                            break;
                        }
                        Icon oldIcon = TabNative.this.getIconAt(idx);
                        if (oldIcon instanceof GraphTextIcon) {
                            GraphTextIcon di = new GraphTextIcon(((GraphTextIcon)oldIcon).getGraphicIcon(), new IsTextIcon(jtp, title, rotate), pos);
                            TabNative.this.setIconAt(idx, di);
                            TabNative.this.setDisabledIconAt(idx, di);
                            break;
                        }
                        IsTextIcon ti = new IsTextIcon(jtp, title, rotate);
                        TabNative.this.setIconAt(idx, ti);
                        TabNative.this.setDisabledIconAt(idx, ti);
                    }
                }
                TabNative.this.doLayout();
            }
        }.start();
    }

    @Override
    public void setTabPlacement(int tp) {
        boolean oldVertical = this.getTabPlacement() == 2 || this.getTabPlacement() == 4;
        boolean newVertical = tp == 2 || tp == 4;
        super.setTabPlacement(tp);
        if (oldVertical != newVertical && !this.textnorotate) {
            this.resetTabInsets();
        }
    }

    void resetTabInsets() {
        TabbedPaneUI ui = this.getUI();
        if (ui != null) {
            try {
                Field tabInsets;
                if (basicTabbedPaneUI != null && basicTabbedPaneUI.isAssignableFrom(ui.getClass()) && (tabInsets = basicTabbedPaneUI.getDeclaredField("tabInsets")) != null && tabInsets.getType() == Insets.class) {
                    tabInsets.setAccessible(true);
                    Insets oldInsets = (Insets)tabInsets.get(ui);
                    if (oldInsets == null) {
                        oldInsets = new Insets(0, 0, 0, 0);
                    }
                    tabInsets.set(ui, new Insets(oldInsets.left, oldInsets.top, oldInsets.right, oldInsets.bottom));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeAllTabs() {
        this.removeAll();
    }

    public int getNextEnabledTab(int fromIdx) {
        int i = fromIdx + 1;
        while (true) {
            if (i == this.getTabCount()) {
                i = 0;
            }
            if (i == fromIdx || this.isEnabledAt(i)) break;
            ++i;
        }
        return i;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        int count = this.getTabCount();
        if (!this.isribbon && !this.isnative && count > this.getSelectedIndex() && this.getSelectedIndex() >= 0) {
            TabbedPaneUI ui = this.getUI();
            Rectangle r = ui.getTabBounds(this, this.getSelectedIndex());
            Rectangle r1 = null;
            int rc = ui.getTabRunCount(this);
            if (rc > 1) {
                if (this.getSelectedIndex() > 0) {
                    r1 = ui.getTabBounds(this, 0);
                } else if (count > 1) {
                    r1 = ui.getTabBounds(this, 1);
                }
            }
            if (this.getTabPlacement() == 4 || this.getTabPlacement() == 2) {
                if (r != null) {
                    d.width = r1 != null ? r.width + r1.width * (rc - 1) + 2 : r.width * rc + 2;
                }
            } else if (r != null) {
                d.height = r1 != null ? r.height + r1.height * (rc - 1) + 2 : r.height * rc + 2;
            }
        }
        return d;
    }

    public int getPreviousEnabledTab(int fromIdx) {
        int i = fromIdx - 1;
        while (true) {
            if (i == -1) {
                i = this.getTabCount() - 1;
            }
            if (i == fromIdx || this.isEnabledAt(i)) break;
            --i;
        }
        return i;
    }

    @Override
    public JTabbedPane getJTabbedPane() {
        return this;
    }

    @Override
    public Integer getPosition(Integer idx) {
        MyNativePanel mp;
        for (int i = 0; i < this.getTabCount() && (mp = this.getMyNativePanel(i)) != null; ++i) {
            if (idx.intValue() != mp.getPosition()) continue;
            return new Integer(i);
        }
        return new Integer(-1);
    }

    @Override
    public void setTextNoRotate(boolean tnr) {
        this.textnorotate = tnr;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setToolTipTextAt(i, text);
        }
    }

    @Override
    public ImageIcon toGray(Icon icon) {
        if (icon instanceof ImageIcon) {
            Image grayImage = GrayFilter.createDisabledImage(((ImageIcon)icon).getImage());
            return new ImageIcon(grayImage);
        }
        return null;
    }

    public void fireTabWillChangeEvent(int i) throws TabChangeException {
        if (i >= 0 && i < this.getTabCount()) {
            TabWillChangeEvent evt = new TabWillChangeEvent(this, i);
            Enumeration e = this.tabWillChangeListeners.elements();
            while (e.hasMoreElements()) {
                TabWillChangeListener l = (TabWillChangeListener)e.nextElement();
                l.stateWillChange(evt);
            }
        }
    }

    @Override
    public JPanel getBorderedPane() {
        return null;
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return this;
    }

    @Override
    public void mydoLayout() {
        this.doLayout();
    }

    @Override
    public void setBackground(Color bg) {
        this.bg = bg;
        super.setBackground(bg);
        for (int i = 0; i < this.getTabCount(); ++i) {
            MyNativePanel mp = this.getMyNativePanel(i);
            if (mp == null) continue;
            mp.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        this.fg = fg;
        super.setForeground(fg);
        for (int i = 0; i < this.getTabCount(); ++i) {
            MyNativePanel mp = this.getMyNativePanel(i);
            if (mp == null) continue;
            mp.setForeground(fg);
        }
    }

    @Override
    public void destroy() {
    }

    public void destroy(Hashtable childGraphics) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            MyNativePanel mp = this.getMyNativePanel(i);
            if (mp == null) continue;
            mp.removeAll();
        }
        this.removeAll();
    }

    @Override
    public void add(RemoteBaseGUIControl rbgc, int index, int tabindex, Hashtable childGraphics) {
        if (rbgc != null && rbgc.getComponent() != null) {
            if (tabindex >= 0 && tabindex < this.getTabCount()) {
                this.intadd(rbgc, index, tabindex, childGraphics);
            } else {
                if (this.addtabidxvect == null) {
                    this.addtabidxvect = new Vector();
                }
                this.addtabidxvect.add(new Rbgctotabidx(rbgc, index, tabindex, childGraphics));
            }
        }
    }

    private void intadd(RemoteBaseGUIControl rbgc, int index, int tabindex, Hashtable childGraphics) {
        MyNativePanel panel = null;
        LayoutManager lm = null;
        panel = this.getMyNativePanel(tabindex);
        if (panel != null) {
            if (this.isAlreadyAdd(rbgc, tabindex)) {
                return;
            }
            Component c = (Component)((Object)rbgc.getComponent());
            if (!this.isribbon && !this.relativeoffset) {
                IscobolLayout.LayoutData lData;
                Point p = this.getLocation();
                if (rbgc.getParentWindow() != null && (lm = rbgc.getParentWindow().getLayout()) != null && lm instanceof IscobolLayout && (lData = ((IscobolLayout)lm).getLayoutData(this)) != null) {
                    p = new Point(lData.getOrigBounds().x, lData.getOrigBounds().y);
                }
                Point pmp = panel.getLocation();
                Point pc = c.getLocation();
                int lo = 0;
                if (rbgc.getParentWindow() != null && (lm = rbgc.getParentWindow().getLayout()) != null && rbgc instanceof RemoteLabel && (lo = ((RemoteLabel)rbgc).getLabelOffset()) > 0) {
                    Rectangle rect = rbgc.getBounds();
                    pc.y = rect.y;
                }
                pc.y -= pmp.y + p.y;
                pc.x -= pmp.x + p.x;
                pc.y += 5;
                if (rbgc.getParentWindow() != null && (lm = rbgc.getParentWindow().getLayout()) != null) {
                    if (lm instanceof IscobolLayout) {
                        IscobolLayout.LayoutData lData2 = ((IscobolLayout)lm).getLayoutData(c);
                        rbgc.alreadyloc = true;
                        if (lData2 != null) {
                            rbgc.setLocation(pc.x, pc.y, false);
                        } else {
                            c.setLocation(pc);
                        }
                    }
                } else {
                    c.setLocation(pc);
                }
            }
            RemoteBaseGUIControl crbgc = null;
            Component[] controls = panel.getComponents();
            for (index = 0; index < controls.length; ++index) {
                if (controls[index] == rbgc.getComponent()) {
                    return;
                }
                crbgc = (RemoteBaseGUIControl)childGraphics.get(controls[index]);
                if (RemoteDisplayWindow.shouldInsertBefore(rbgc, crbgc)) break;
            }
            panel.add(c, index);
            if (this.isribbon && !this.hasWrapLayout && rbgc.getParentWindow() != null && (lm = panel.getLayout()) instanceof IscobolLayout) {
                rbgc.getParentWindow().addtolayout(rbgc, lm);
            }
        }
    }

    public Rectangle getButtonsBounds() {
        Rectangle r = this.getBounds();
        r.height = this.getButtonsHeight();
        return r;
    }

    public int getButtonsHeight() {
        int Return2 = 0;
        if (this.getTabCount() > 0) {
            try {
                Rectangle r = this.getUI().getTabBounds(this, 0);
                if (r != null) {
                    Return2 += r.height * this.getUI().getTabRunCount(this);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return Return2;
    }

    public Container getPanelAt(int tabIndex) {
        return this.getMyNativePanel(tabIndex);
    }

    private MyNativePanel getMyNativePanel(int tabindex) {
        Component obj = null;
        obj = this.getComponentAt(tabindex);
        if (obj != null && obj instanceof MyScrollPane) {
            obj = ((MyScrollPane)obj).getMyNativePanel();
        }
        if (obj != null && obj instanceof MyNativePanel) {
            return (MyNativePanel)obj;
        }
        return null;
    }

    protected void resetLayoutManager() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            LayoutManager lm;
            MyNativePanel mp = this.getMyNativePanel(i);
            if (mp == null || !((lm = mp.getLayout()) instanceof IscobolLayout)) continue;
            ((IscobolLayout)lm).setOriginalContainerSize(null);
        }
    }

    @Override
    public void doLayout() {
        new IsguiWorker(false){

            @Override
            public void launch() {
                TabNative.super.doLayout();
            }
        }.start();
    }

    public Point convertXY(String name, Point pc, int tabindex, Rectangle origBoundsLayout) {
        MyNativePanel panel = null;
        int tabcount = this.getTabCount();
        if (tabindex < tabcount && (panel = this.getMyNativePanel(tabindex)) != null && !this.isribbon && !this.relativeoffset) {
            Point p = this.getLocation();
            if (origBoundsLayout != null) {
                p = new Point(origBoundsLayout.x, origBoundsLayout.y);
            }
            Point pmp = panel.getLocation();
            pc.y -= pmp.y + p.y;
            pc.x -= pmp.x + p.x;
            pc.y += 5;
        }
        return pc;
    }

    @Override
    public void setAlignmentAt(int i, String a) {
    }

    @Override
    public void setTabBackgroundColor(Color c) {
        this.tabbg = c;
        int tabcount = this.getTabCount();
        for (int i = 0; i < tabcount; ++i) {
            this.setBackgroundAt(i, c);
        }
    }

    @Override
    public void setTabForegroundColor(Color c) {
        this.tabfg = c;
        int tabcount = this.getTabCount();
        for (int i = 0; i < tabcount; ++i) {
            this.setForegroundAt(i, c);
        }
    }

    private Color getNativeOKBG() {
        return this.bg;
    }

    private Color getNativeOKFG() {
        return this.fg;
    }

    private Color getNativeBG() {
        return this.tabbg;
    }

    private Color getNativeFG() {
        return this.tabfg;
    }

    private Color getNativeActiveBG() {
        Color Return2 = this.activetabbg;
        return Return2;
    }

    private Color getNativeActiveFG() {
        Color Return2 = this.activetabfg;
        return Return2;
    }

    @Override
    public void setActiveTabBackgroundColor(Color c) {
        this.activetabbg = c;
    }

    @Override
    public void setActiveTabForegroundColor(Color c) {
        this.activetabfg = c;
    }

    @Override
    public void setBackgroundAt(int idx, Color c) {
        super.setBackgroundAt(idx, c);
    }

    @Override
    public void setForegroundAt(int idx, Color c) {
        super.setForegroundAt(idx, c);
    }

    @Override
    public Color getBackgroundAt(int idx) {
        Color Return2 = null;
        Return2 = this.activetabbg != null && idx == this.getSelectedIndex() ? this.activetabbg : super.getBackgroundAt(idx);
        return Return2;
    }

    @Override
    public Color getForegroundAt(int idx) {
        Color Return2 = null;
        Return2 = this.activetabfg != null && idx == this.getSelectedIndex() ? this.activetabfg : super.getForegroundAt(idx);
        return Return2;
    }

    @Override
    public void setBorderWidth(int[] bw) {
        this.borderwidth = bw;
        this.repaint();
    }

    public int getBorderWidthAt(int idx) {
        if (this.borderwidth != null && idx < this.borderwidth.length) {
            return this.borderwidth[idx];
        }
        return -1;
    }

    @Override
    public void setActiveBorderWidth(int[] bw) {
        this.activeborderwidth = bw;
    }

    public int getActiveBorderWidthAt(int idx) {
        if (this.activeborderwidth != null && idx < this.activeborderwidth.length) {
            return this.activeborderwidth[idx];
        }
        return -1;
    }

    @Override
    public void setBorderForegroundColor(Color c) {
        this.tabborderforegroundcolor = c;
        if (c != null && this.borderwidth == null) {
            this.borderwidth = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.borderwidth[i] = 1;
            }
        }
    }

    public Color getBorderForegroundColor() {
        return this.tabborderforegroundcolor;
    }

    @Override
    public void setActiveBorderForegroundColor(Color c) {
        this.activetabborderforegroundcolor = c;
        if (c != null && this.activeborderwidth == null) {
            this.activeborderwidth = new int[4];
            for (int i = 0; i < 4; ++i) {
                this.activeborderwidth[i] = 1;
            }
        }
    }

    public Color getActiveBorderForegroundColor() {
        return this.activetabborderforegroundcolor;
    }

    @Override
    public void addTabWidths(int insertionIndex, int fontw, int fonth, Integer w) {
        this.fontw = fontw;
        this.fonth = fonth;
        if (this.tabwidths == null) {
            this.tabwidths = new Hashtable();
        }
        if (insertionIndex >= 0 && insertionIndex < this.getTabCount()) {
            this.tabwidths.remove(new Integer(insertionIndex));
            this.tabwidths.put(new Integer(insertionIndex), w);
        } else {
            this.tabwidths.put(new Integer(this.tabwidths.size()), w);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintEtchedBorder(Graphics g, int x, int y, int width, int height, Color a, Color b) {
        if (a == null) {
            a = Color.lightGray;
        }
        if (b == null) {
            b = Color.white;
        }
        Color oldColor = g.getColor();
        g.translate(x, y);
        --width;
        --height;
        try {
            g.setColor(a);
            g.drawRect(0, 0, width - 1, height - 1);
            g.setColor(b);
            g.drawLine(1, 1, width - 2, 1);
            g.drawLine(1, 2, 1, height - 2);
            g.drawLine(0, height, width, height);
            g.drawLine(width, 0, width, height - 1);
        }
        finally {
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private void setTextIconForeground(int idx, boolean isSelected) {
        if (!this.textnorotate) {
            switch (this.getTabPlacement()) {
                case 2: 
                case 4: {
                    Icon it = null;
                    IsTextIcon iti = null;
                    Icon oldIcon = this.getIconAt(idx);
                    if (oldIcon == null) break;
                    if (oldIcon instanceof GraphTextIcon) {
                        it = ((GraphTextIcon)oldIcon).getIcon2();
                        if (it instanceof IsTextIcon) {
                            iti = (IsTextIcon)it;
                        }
                    } else {
                        iti = (IsTextIcon)oldIcon;
                    }
                    if (iti == null) break;
                    iti.setForeground(this.getForegroundAt(idx));
                    this.doLayout();
                }
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        if (!(this.getTabCount() != 0 || this.isnative || this.isribbon || this.istabflat)) {
            super.setBounds(x, y, w, 0);
        } else {
            super.setBounds(x, y, w, h);
        }
    }

    @Override
    public void setSize(int w, int h) {
        if (!(this.getTabCount() != 0 || this.isnative || this.isribbon || this.istabflat)) {
            super.setSize(w, 0);
        } else {
            super.setSize(w, h);
        }
    }

    public boolean isAlreadyAdd(RemoteBaseGUIControl rbgc, int tabindex) {
        boolean Return2 = false;
        MyNativePanel panel = null;
        Object lm = null;
        if (tabindex >= 0 && tabindex < this.getTabCount() && (panel = this.getMyNativePanel(tabindex)) != null) {
            Component c = (Component)((Object)rbgc.getComponent());
            Object crbgc = null;
            Component[] controls = panel.getComponents();
            for (int index = 0; !Return2 && index < controls.length; ++index) {
                if (controls[index] != rbgc.getComponent()) continue;
                Return2 = true;
            }
        }
        return Return2;
    }

    static {
        Class<?> c;
        try {
            c = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
            RtsUtil.openModule(c, TabNative.class, "javax.swing.plaf.basic");
        }
        catch (Throwable t) {
            c = null;
        }
        basicTabbedPaneUI = c;
    }

    private class Rbgctotabidx {
        RemoteBaseGUIControl rbgc;
        int index;
        int tabindex;
        Hashtable childGraphics;

        public Rbgctotabidx(RemoteBaseGUIControl rbgc, int index, int tabindex, Hashtable childGraphics) {
            this.rbgc = rbgc;
            this.index = index;
            this.tabindex = tabindex;
            this.childGraphics = childGraphics;
        }

        public RemoteBaseGUIControl getRbgc() {
            return this.rbgc;
        }

        public int getIndex() {
            return this.index;
        }

        public int getTabIndex() {
            return this.tabindex;
        }

        public Hashtable getChildGraphics() {
            return this.childGraphics;
        }
    }

    public static class MyComponent
    extends JPanel {
        Component cmp;
        Insets iborder;
        Dimension initd;

        public MyComponent(Component cmp, Insets iborder) {
            this(cmp, iborder, -1);
        }

        public MyComponent(Component cmp, Insets iborder, int ribbontoolbarH) {
            this.cmp = cmp;
            this.iborder = iborder;
            this.initd = cmp.getSize();
            if (ribbontoolbarH > 0 && this.initd.height > ribbontoolbarH) {
                this.initd.height = ribbontoolbarH - 4;
                if (cmp != null && cmp instanceof PicobolButton && ((PicobolButton)cmp).getIcon() != null) {
                    double sy = cmp.getSize().height / cmp.getPreferredSize().height;
                    this.initd.width = (int)((double)cmp.getSize().width / sy);
                    if (this.initd.width > ((PicobolButton)cmp).getImageWidth()) {
                        this.initd.width = ((PicobolButton)cmp).getImageWidth();
                    }
                    if (this.initd.width > cmp.getPreferredSize().width) {
                        this.initd.width = cmp.getPreferredSize().width;
                    }
                }
                ((JComponent)cmp).setSize(this.initd);
            }
            if (cmp instanceof JComponent) {
                ((JComponent)cmp).setPreferredSize(this.initd);
                ((JComponent)cmp).setMaximumSize(this.initd);
                ((JComponent)cmp).setMinimumSize(this.initd);
                if (((JComponent)cmp).getBorder() != null) {
                    ((JComponent)cmp).setLocation(0, 0);
                }
            }
            Dimension Return2 = this.initd;
            if (cmp instanceof JComponent && ((JComponent)cmp).getBorder() == null) {
                if (iborder != null) {
                    Return2.width += iborder.right + iborder.left;
                    if (ribbontoolbarH == -1) {
                        Return2.height += iborder.top + iborder.bottom;
                    }
                    ((JComponent)cmp).setLocation(iborder.left, iborder.top);
                } else {
                    ((JComponent)cmp).setLocation(0, 0);
                }
            }
            this.setLayout(null);
            this.setPreferredSize(Return2);
            this.setMaximumSize(Return2);
            this.setMinimumSize(Return2);
            this.add(cmp);
        }
    }

    private class MyScrollPane
    extends JScrollPane {
        MyNativePanel mp;

        public MyScrollPane(MyNativePanel mp) {
            super(mp);
            this.mp = mp;
        }

        public MyNativePanel getMyNativePanel() {
            return this.mp;
        }
    }

    private class MyNativePanel
    extends JPanel {
        RemoteTab parent;
        int position;
        int w;
        int h;

        public MyNativePanel(RemoteTab parent, int p, int w, int h) {
            this.parent = parent;
            this.parent.gradientMgr.addPropertyChangeListener(PropertyChangeEvent2 -> this.repaint());
            this.position = p;
            this.w = w;
            this.h = h;
            this.setLayout(null);
            this.setName("IscobolTabbedPanel");
        }

        public Dimension getWH() {
            return new Dimension(this.w, this.h);
        }

        public int getPosition() {
            return this.position;
        }

        @Override
        public Dimension getSize() {
            return super.getSize();
        }

        @Override
        public Dimension getMinimumSize() {
            if (TabNative.this.isribbon && !TabNative.this.hasWrapLayout) {
                return this.getPreferredSize();
            }
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            if (TabNative.this.isribbon && !TabNative.this.hasWrapLayout) {
                return this.getPreferredSize();
            }
            return this.getMaximumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (TabNative.this.isribbon) {
                Dimension Return2 = new Dimension();
                if (!TabNative.this.set0) {
                    if (TabNative.this.hasWrapLayout) {
                        Return2 = super.getPreferredSize();
                    } else {
                        Return2.height = this.h;
                        Return2.width = this.w;
                    }
                } else {
                    Return2.height = 1;
                    Return2.width = TabNative.this.hasWrapLayout ? super.getPreferredSize().width : this.w;
                }
                return Return2;
            }
            return super.getPreferredSize();
        }

        @Override
        public Component add(Component c, int idx) {
            if (TabNative.this.isribbon && TabNative.this.hasWrapLayout) {
                MyComponent myc = new MyComponent(c, TabNative.this.iborder);
                super.add((Component)myc, idx);
                myc.setBackground(this.getBackground());
                return myc;
            }
            return super.add(c, idx);
        }

        @Override
        public LayoutManager getLayout() {
            if (!TabNative.this.isribbon && this.parent != null && this.parent.getLayout() instanceof IscobolLayout) {
                return this.parent.getLayout();
            }
            return super.getLayout();
        }

        @Override
        public Insets getInsets() {
            if (TabNative.this.istabflat) {
                return new Insets(0, 0, 0, 0);
            }
            return super.getInsets();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.parent.gradientMgr.paint((Graphics2D)g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }

    public class IsWrapLayout
    extends FlowLayout {
        private Dimension preferredLayoutSize;

        public IsWrapLayout() {
        }

        public IsWrapLayout(int align) {
            super(align);
        }

        public IsWrapLayout(int align, int hgap, int vgap) {
            super(align, hgap, vgap);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.layoutSize(target, true);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.layoutSize(target, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container target, boolean preferred) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int targetWidth = target.getSize().width;
                if (targetWidth == 0) {
                    targetWidth = Integer.MAX_VALUE;
                }
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                Insets insets = target.getInsets();
                int maxWidth = targetWidth - (insets.left + insets.right + hgap * 2);
                Dimension dim = new Dimension(0, 0);
                int rowWidth = 0;
                int rowHeight = 0;
                int nmembers = target.getComponentCount();
                for (int i = 0; i < nmembers; ++i) {
                    Dimension d;
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension dimension = d = preferred ? m.getPreferredSize() : m.getMinimumSize();
                    if (rowWidth + d.width > maxWidth) {
                        this.addRow(dim, rowWidth, rowHeight);
                        rowWidth = 0;
                        rowHeight = 0;
                    }
                    if (rowWidth > 0) {
                        rowWidth += hgap;
                    }
                    rowWidth += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                }
                this.addRow(dim, rowWidth, rowHeight);
                dim.width += insets.left + insets.right + hgap * 2;
                dim.height += insets.top + insets.bottom + vgap * 2;
                return dim;
            }
        }

        private void addRow(Dimension dim, int rowWidth, int rowHeight) {
            dim.width = Math.max(dim.width, rowWidth);
            if (dim.height > 0) {
                dim.height += this.getVgap();
            }
            dim.height += rowHeight;
        }

        @Override
        public void layoutContainer(Container target) {
            Dimension size = this.preferredLayoutSize(target);
            if (size.equals(this.preferredLayoutSize)) {
                super.layoutContainer(target);
            } else {
                this.preferredLayoutSize = size;
                target.invalidate();
                Container top = target;
                if (top.getParent() != null) {
                    top = top.getParent();
                }
                top.validate();
            }
        }
    }
}

