/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.swing.GridCell;
import com.iscobol.gui.client.swing.GridViewS;
import com.iscobol.gui.export.GridDataProvider;
import java.awt.Color;
import java.awt.Font;

public class SwingGridDataProvider
implements GridDataProvider {
    private GridViewS grid;
    private int[] modelRowsIndexes;
    private int[] modelColumnsIndexes;
    private GridCell lastCell;
    private int[] columnAlignments;
    private int[] columnDividers;
    private int[] columnDataTypes;
    private String[] columnDateFormats;
    private int lastRow = -1;
    private int lastColumn = -1;
    private Color dividerColor;
    private Color headingDividerColor;

    public SwingGridDataProvider(GridViewS grid) {
        this.grid = grid;
        this.loadData();
    }

    private void loadData() {
        int c;
        int r;
        int rowCount = this.grid.gridarray.size() + this.grid.headarraycell.size();
        int visibileRowCount = 0;
        int numColHeadings = this.grid.getNumColHeadings();
        for (r = 0; r < rowCount; ++r) {
            if (r >= numColHeadings && this.grid.hiderowscols != null && this.grid.hiderowscols.isRowHide(r - numColHeadings)) continue;
            ++visibileRowCount;
        }
        this.modelRowsIndexes = new int[visibileRowCount];
        for (r = 0; r < visibileRowCount; ++r) {
            this.modelRowsIndexes[r] = r < this.grid.getNumColHeadings() ? r : this.grid.getAbsoluteRowNoHeaderModel(r);
        }
        int columnCount = this.grid.getDataColumnSize();
        int visibleColumnCount = 0;
        int numRowHeadings = this.grid.getNumRowHeadings();
        for (c = 0; c < columnCount; ++c) {
            if (c >= numRowHeadings && this.grid.hiderowscols != null && this.grid.hiderowscols.isColumnHide(c)) continue;
            ++visibleColumnCount;
        }
        this.modelColumnsIndexes = new int[visibleColumnCount];
        this.columnAlignments = new int[visibleColumnCount];
        this.columnDividers = new int[visibleColumnCount];
        this.columnDataTypes = new int[visibleColumnCount];
        this.columnDateFormats = new String[visibleColumnCount];
        for (c = 0; c < visibleColumnCount; ++c) {
            this.modelColumnsIndexes[c] = c < numRowHeadings ? c : this.grid.getModel().convertColumnIndexToModel(c);
            String align = this.grid.getAlignmentCell(null, this.modelColumnsIndexes[c]);
            this.columnAlignments[c] = "R".equalsIgnoreCase(align) ? 4 : ("C".equalsIgnoreCase(align) ? 0 : 2);
            this.columnDividers[c] = this.grid.getDividersCell(null, this.modelColumnsIndexes[c]);
            GridViewS.DataType dt = this.grid.getDataType(this.modelColumnsIndexes[c]);
            if (dt != null) {
                if (dt.isNumeric()) {
                    this.columnDataTypes[c] = 2;
                    continue;
                }
                if (dt.getSDF() != null) {
                    this.columnDataTypes[c] = 3;
                    this.columnDateFormats[c] = dt.getSDF().toPattern();
                    continue;
                }
                this.columnDataTypes[c] = 1;
                continue;
            }
            this.columnDataTypes[c] = 0;
        }
        c = this.grid.getDividerColor();
        this.dividerColor = c >= 0 ? this.grid.parent.getGuiFactory().getRemotePalette().getDefaultColor(c - 1) : new Color(-c);
        c = this.grid.getHeadingDividerColor();
        this.headingDividerColor = c >= 0 ? this.grid.parent.getGuiFactory().getRemotePalette().getDefaultColor(c - 1) : new Color(-c);
    }

    @Override
    public int getColumnCount() {
        return this.modelColumnsIndexes.length;
    }

    @Override
    public int getColumnWidth(int colIdx) {
        return this.grid.getColWidth(colIdx);
    }

    @Override
    public int getRowCount() {
        return this.modelRowsIndexes.length;
    }

    @Override
    public int getRowHeight(int rowIdx) {
        int idx = this.modelRowsIndexes[rowIdx];
        int nch = this.grid.getNumColHeadings();
        if (idx < nch) {
            return this.grid.getRowHeightData();
        }
        return this.grid.getRowHeightData(this.grid.getModel().convertRowIndexToView(idx - nch)) + this.grid.getRowHeightDividers();
    }

    @Override
    public Color[] getCellColor(int rowIdx, int colIdx) {
        boolean isinheader = this.grid.isInHeader(this.modelRowsIndexes[rowIdx], this.modelColumnsIndexes[colIdx]);
        boolean isinregion = false;
        if (!isinheader) {
            isinregion = this.grid.isInRegion(rowIdx + this.grid.getNumColHeadings(), colIdx);
        }
        ColorCmp acolor = this.grid.getCellColor(this.getGridCell(rowIdx, colIdx), this.modelRowsIndexes[rowIdx], this.modelColumnsIndexes[colIdx], false, false, isinheader, isinregion, false, false, rowIdx);
        Color[] Return2 = new Color[]{acolor != null && acolor.isBackgroundSet() ? this.grid.getColor(ColorCmp.getRealColor(acolor.getBackground(), this.grid.getBackIntensity(acolor))) : this.grid.getJTable().getBackground(), acolor != null && acolor.isForegroundSet() ? this.grid.getColor(ColorCmp.getRealColor(acolor.getForeground(), this.grid.getForeIntensity(acolor))) : this.grid.getJTable().getForeground()};
        return Return2;
    }

    @Override
    public Font getCellFont(int rowIdx, int colIdx) {
        LocalFontCmp lfc = this.grid.getCellFont(this.getGridCell(rowIdx, colIdx), this.modelRowsIndexes[rowIdx], this.modelColumnsIndexes[colIdx]);
        if (lfc != null && lfc.getFont() != null) {
            return lfc.getFont();
        }
        return this.grid.getJTable().getFont();
    }

    @Override
    public int getColumnAlignment(int colIdx) {
        return this.columnAlignments[colIdx];
    }

    @Override
    public int getColumnDivider(int colIdx) {
        return this.columnDividers[colIdx];
    }

    @Override
    public int getColumnDataType(int colIdx) {
        return this.columnDataTypes[colIdx];
    }

    @Override
    public String getColumnDateFormat(int colIdx) {
        return this.columnDateFormats[colIdx];
    }

    @Override
    public Color getDividerColor(int rowIdx, int colIdx) {
        if (rowIdx < this.grid.getNumColHeadings() || colIdx < this.grid.getNumRowHeadings()) {
            return this.headingDividerColor;
        }
        return this.dividerColor;
    }

    @Override
    public String getCellData(int rowIdx, int colIdx) {
        return this.grid.getCellData(this.modelRowsIndexes[rowIdx], this.modelColumnsIndexes[colIdx]);
    }

    @Override
    public int getRowsDivider() {
        return this.grid.getRowHeightDividers();
    }

    private GridCell getGridCell(int rowIdx, int colIdx) {
        if (rowIdx != this.lastRow || colIdx != this.lastColumn) {
            this.lastRow = rowIdx;
            this.lastColumn = colIdx;
            int numColheadings = this.grid.getNumColHeadings();
            this.lastCell = this.modelRowsIndexes[rowIdx] < numColheadings ? (GridCell)this.grid.getValueAtHead(this.modelRowsIndexes[rowIdx], this.modelColumnsIndexes[colIdx]) : this.grid.getValueAt(this.modelRowsIndexes[rowIdx] - numColheadings, this.modelColumnsIndexes[colIdx]);
        }
        return this.lastCell;
    }

    @Override
    public int getHeadingColumnCount() {
        return this.grid.getNumColHeadings();
    }

    @Override
    public int getHeadingRowCount() {
        return this.grid.getNumRowHeadings();
    }

    @Override
    public int getCellColumnSpan(int rowIdx, int colIdx) {
        int Return2 = 1;
        Object gridcell = this.grid.getHeaderValueAt(rowIdx, colIdx);
        if (gridcell instanceof GridCell) {
            Return2 = ((GridCell)gridcell).getCellColumnsSpan();
        }
        return Math.max(1, Return2);
    }

    @Override
    public int getCellRowSpan(int rowIdx, int colIdx) {
        int Return2 = 1;
        Object gridcell = this.grid.getHeaderValueAt(rowIdx, colIdx);
        if (gridcell instanceof GridCell) {
            Return2 = ((GridCell)gridcell).getCellRowsSpan();
        }
        return Math.max(1, Return2);
    }
}

