/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ParamElementSize;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.client.swing.CobolEventCouple;
import com.iscobol.gui.client.swing.GuiFactoryImpl;
import com.iscobol.gui.client.swing.PicobolRadioButton;
import com.iscobol.gui.client.swing.RadioButtonGroup;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import com.iscobol.gui.client.swing.RemoteDisplayToolBar;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import com.iscobol.gui.client.swing.RemoteTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import javax.swing.JComponent;

public class RemoteRadioButton
extends RemoteBaseGUIControl {
    private static final float DEFAULT_WIDTH_INSETS = 17.0f;
    private static final float MINIMUM_HEIGHT = 15.0f;
    private String title;
    private boolean transparent;
    private boolean selfAct;
    private boolean leftText;
    private int groupValue;
    private String groupValueAlpha;
    private int groupID = 1;
    private boolean noGroupTab;
    private float rows;
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapDisabledSelected;
    private int bitmapPressed;
    private int bitmapSelected;
    private int bitmapRollover;
    private int bitmapRolloverSelected;
    private int bitmapWidth;
    private boolean flat;
    private boolean multiline;
    private boolean vtop;
    private String valueStr;
    private RadioButtonGroup rbGroup;
    private int titlePosition;
    private int leftTextAlign;
    private Integer disabledColor;
    private Integer disabledBackgroundColor;
    private Integer disabledForegroundColor;
    private boolean disabledBackgroundRgb;
    private boolean disabledForegroundRgb;
    private Integer rolloverColor;
    private Integer rolloverBackgroundColor;
    private Integer rolloverForegroundColor;
    private boolean rolloverBackgroundRgb;
    private boolean rolloverForegroundRgb;
    private final boolean iconsScaling;
    private int bitmapScale;
    private final boolean m25647;

    private RadioButtonGroup getRadioButtonGroup(int id) {
        Hashtable rbgList = null;
        if (this.parentToolbar != null) {
            rbgList = this.parentToolbar.getRadioButtonGroupList();
        } else if (this.parentWindow != null) {
            rbgList = this.parentWindow.getRadioButtonGroupList();
        }
        Integer key = new Integer(id);
        if (rbgList != null) {
            if (rbgList.containsKey(key)) {
                return (RadioButtonGroup)rbgList.get(key);
            }
            RadioButtonGroup rbg = new RadioButtonGroup();
            rbgList.put(key, rbg);
            return rbg;
        }
        return new RadioButtonGroup();
    }

    public RemoteRadioButton(GuiFactoryImpl gf) {
        super(gf);
        this.m25647 = gf.getCsProperty().get("iscobol.m25647", false);
        this.iconsScaling = gf.getCsProperty().get("iscobol.gui.icons_scaling", false);
    }

    @Override
    public void displayProp() {
    }

    @Override
    public float getDefaultWidth() {
        if (this.bitmapStyle) {
            return 16.0f;
        }
        if (this.title != null && this.title.length() > 0) {
            return (float)(this.font.computeScreenWidth(this.title) / this.font.computeScreenWidth("0")) + 1.3f;
        }
        return 0.0f;
    }

    @Override
    public float getDefaultHeight() {
        if (this.bitmapStyle) {
            return 15.0f;
        }
        return 1.0f;
    }

    @Override
    public int getGUIControlHeight(float h) {
        int Return2 = this.bitmapStyle ? (int)h : (int)((float)this.font.getHeight() * h);
        if ((float)Return2 < 15.0f) {
            Return2 = 15;
        }
        return Return2;
    }

    @Override
    public int getGUIControlWidth(float w) {
        int Return2 = 0;
        if (this.bitmapStyle) {
            Return2 = (int)w;
        } else if (w > 0.0f) {
            Return2 = (int)((float)this.font.getWidth() * w + 17.0f);
        }
        return Return2;
    }

    @Override
    public float getSizes() {
        float Return2 = super.getSizes();
        if (Return2 == 0.0f) {
            Dimension dim = this.guiComponent.getPreferredSize();
            Return2 = this.bitmapStyle ? (float)dim.width : ((float)dim.width - 17.0f) / (float)this.font.getWidth();
        }
        return Return2;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String setValue(String v) {
        this.valueStr = v;
        if (this.valueStr == null || this.guiComponent == null) {
            return null;
        }
        int val = -1;
        String valalpha = null;
        try {
            val = Integer.parseInt(v.trim());
        }
        catch (NumberFormatException e) {
            valalpha = v.trim();
        }
        if (valalpha == null) {
            if (this.rbGroup == null || this.groupValue == 0) {
                this.setState(val > 0);
            } else if (val == this.groupValue) {
                this.setState(val > 0);
            } else {
                ((PicobolRadioButton)this.guiComponent).setSelected(false);
            }
        } else if (valalpha != null && valalpha.equals(this.groupValueAlpha)) {
            this.setState(true);
        } else {
            ((PicobolRadioButton)this.guiComponent).setSelected(false);
        }
        return null;
    }

    @Override
    public String getValue() {
        RemoteRadioButton rb;
        String Return2 = this.groupValueAlpha == null ? (this.rbGroup == null || this.groupValue == 0 ? this.getItemValue() : ((rb = this.rbGroup.getSelectedRadioButton()) == null ? "0" : rb.getItemValue())) : ((rb = this.rbGroup.getSelectedRadioButton()) == null ? " " : rb.getItemValue());
        this.valueStr = Return2;
        return Return2;
    }

    private String getItemValue() {
        String Return2 = "0";
        if (this.getState()) {
            Return2 = this.groupValueAlpha == null ? (this.groupValue == 0 ? "1" : Integer.toString(this.groupValue)) : this.groupValueAlpha;
        }
        return Return2;
    }

    @Override
    public void initialize() {
        Color fg;
        Color bg;
        Color[] cs;
        if (this.guiComponent != null) {
            return;
        }
        this.guiComponent = new PicobolRadioButton();
        PicobolRadioButton rb = (PicobolRadioButton)this.guiComponent;
        rb.addOutAcceptListener(this);
        super.intInitialize();
        rb.setMultiline(this.multiline || this.m25647 && this.rows >= 2.0f);
        rb.setHasBitmap(this.bitmapStyle);
        if (!this.bitmapStyle && this.leftText) {
            rb.setLeftText(this.leftText);
        }
        if (this.titlePosition > 0) {
            rb.setTitlePosition(this.titlePosition);
        }
        rb.setLeftTextAlignment(this.leftTextAlign);
        rb.setVTop(this.vtop);
        if (this.title != null) {
            this.setTitle(this.title);
        }
        rb.setBitmapWidth(this.bitmapWidth);
        rb.setBitmapNumber(this.bitmapNumber);
        rb.setBitmapDisabled(this.bitmapDisabled);
        rb.setBitmapDisabledSelected(this.bitmapDisabledSelected);
        rb.setBitmapRollover(this.bitmapRollover);
        rb.setBitmapPressed(this.bitmapPressed);
        rb.setBitmapSelected(this.bitmapSelected);
        rb.setBitmapRolloverSelected(this.bitmapRolloverSelected);
        this.guiComponent.setSelfAct(this.selfAct);
        this.setValue(this.valueStr);
        rb.setFlat(this.flat);
        rb.setOpaque(!this.transparent);
        if (this.disabledColor != null) {
            cs = this.getColors(this.disabledColor);
            rb.setDisabledBackground(cs[0]);
            rb.setDisabledForeground(cs[1]);
        } else {
            if (this.disabledBackgroundColor != null) {
                bg = this.getBackgroundColor(this.disabledBackgroundColor, this.disabledBackgroundRgb);
                rb.setDisabledBackground(bg);
            }
            if (this.disabledForegroundColor != null) {
                fg = this.getForegroundColor(this.disabledForegroundColor, this.disabledForegroundRgb);
                rb.setDisabledForeground(fg);
            }
        }
        if (this.rolloverColor != null) {
            cs = this.getColors(this.rolloverColor);
            rb.setRolloverBackground(cs[0]);
            rb.setRolloverForeground(cs[1]);
        } else {
            if (this.rolloverBackgroundColor != null) {
                bg = this.getBackgroundColor(this.rolloverBackgroundColor, this.rolloverBackgroundRgb);
                rb.setRolloverBackground(bg);
            }
            if (this.rolloverForegroundColor != null) {
                fg = this.getForegroundColor(this.rolloverForegroundColor, this.rolloverForegroundRgb);
                rb.setRolloverForeground(fg);
            }
        }
        rb.setBitmapScale(this.bitmapScale);
        rb.setScaleDefaultIcon(this.iconsScaling);
        rb.addActionListener(e -> {
            if (this.skipNextEvent) {
                this.setState(!rb.isSelected());
            } else {
                this.responseOnAction(e);
            }
            this.skipNextEvent = false;
        });
        this.guiComponent.addKeyListener(this);
    }

    @Override
    public void setParentToolbar(RemoteDisplayToolBar rdt) {
        RemoteBaseGUIWindow prevCont = this.getContainer();
        super.setParentToolbar(rdt);
        RemoteBaseGUIWindow currCont = this.getContainer();
        if (currCont != null && currCont != prevCont) {
            this.setGroupID(this.groupID);
            this.setValue(this.valueStr);
        }
    }

    @Override
    public void setParentWindow(int windowId) {
        RemoteBaseGUIWindow prevCont = this.getContainer();
        super.setParentWindow(windowId);
        RemoteBaseGUIWindow currCont = this.getContainer();
        if (currCont != null && currCont != prevCont) {
            this.setGroupID(this.groupID);
            this.setValue(this.valueStr);
        }
    }

    private void setGroupID(int id) {
        this.groupID = id;
        if (this.groupID > 0) {
            if (this.rbGroup != null) {
                this.rbGroup.removeElement(this);
            }
            this.rbGroup = this.getRadioButtonGroup(this.groupID);
            this.rbGroup.addElement(this);
        } else {
            this.rbGroup = null;
        }
    }

    void responseOnAction(ActionEvent evt) {
        if ((RemoteDisplayWindow)this.parentWindow != null) {
            ((RemoteDisplayWindow)this.parentWindow).stopTimer();
        }
        CobolEventCouple cc = new CobolEventCouple(this, new RemoteRecordAccept(16, 17, evt.getID()));
        if (this.hasClickOverrideFocusChange() || (!this.getActiveAccept() || this.isProtectedField()) && !this.isSelfAct()) {
            if (this.hasClickOverrideFocusChange()) {
                cc.getRemoteRecordAccept().setResponse(true);
                cc.getRemoteRecordAccept().setWait(true);
            }
            this.setState(!((PicobolRadioButton)this.guiComponent).isSelected());
        } else {
            this.setState(true);
        }
        this.pushEvent(cc, 4);
    }

    void setState(boolean b) {
        PicobolRadioButton rb = (PicobolRadioButton)this.guiComponent;
        if (rb != null && this.rbGroup != null) {
            if (b) {
                this.rbGroup.setSelectedRadioButton(this);
            } else if (this.rbGroup.getSelectedRadioButton() == this) {
                b = true;
            }
            rb.setSelected(b);
        }
    }

    boolean getState() {
        if (this.guiComponent == null) {
            return false;
        }
        return ((PicobolRadioButton)this.getComponent()).isSelected();
    }

    @Override
    protected void intFocusGained(boolean restore) {
    }

    @Override
    public boolean isSelfAct() {
        if (this.guiComponent != null) {
            return this.guiComponent.getSelfAct();
        }
        return this.selfAct;
    }

    @Override
    public void setBorder(boolean t) {
    }

    @Override
    public void setElementAt(int[] idxs) {
    }

    @Override
    public void setImage(int viewWidth, int viewHeight, int imageId, int strip) {
        Rectangle r = this.getBounds();
        viewWidth = r.width;
        viewHeight = r.height;
        if (viewWidth == 0 || !this.bitmapStyle) {
            return;
        }
        Image image = this.getLocalImage(imageId);
        if (this.bitmapWidth == 0) {
            this.bitmapWidth = viewWidth;
        }
        PicobolRadioButton rb = (PicobolRadioButton)this.guiComponent;
        if (this.guiComponent != null) {
            rb.setImage(image, this.bitmapWidth, viewHeight);
            if (image != null && this.title != null) {
                rb.setHasBitmap(this.bitmapStyle);
                rb.setTitle(this.title);
            }
        }
    }

    @Override
    public void setRowsCols(float r, float c) {
        this.rows = r;
    }

    @Override
    public void setStyle(int s, boolean set) {
        PicobolRadioButton rb = (PicobolRadioButton)this.guiComponent;
        if ((s & 0x10000) == 65536) {
            this.transparent = set;
            if (this.guiComponent != null) {
                ((PicobolRadioButton)this.guiComponent).setOpaque(!this.transparent);
            }
        }
        if ((s & 0x400000) == 0x400000) {
            this.selfAct = set;
            if (this.getComponent() != null) {
                this.getComponent().setSelfAct(set);
            }
        }
        if ((s & 0x400) == 1024) {
            this.multiline = set;
            if (rb != null) {
                rb.setMultiline(set);
            }
        }
        if ((s & 0x200) == 512) {
            this.vtop = set;
            if (rb != null) {
                rb.setVTop(set);
            }
        }
        if ((s & 0x8000) == 32768) {
            this.bitmapStyle = set;
            if (rb != null) {
                rb.setHasBitmap(set);
            }
        }
        if ((s & 1) == 1) {
            this.noGroupTab = set;
        }
        if ((s & 2) == 2) {
            this.leftText = set;
            if (rb != null) {
                rb.setLeftText(set);
            }
        }
        if ((s & 0x800) == 2048) {
            this.flat = set;
            if (rb != null) {
                rb.setFlat(set);
            }
        }
    }

    @Override
    public void setTitle(String t) {
        this.title = t;
        if (this.guiComponent != null && t != null) {
            PicobolRadioButton rb = (PicobolRadioButton)this.guiComponent;
            rb.setTitle(t);
            if (rb.getMnemonicChar() > '\u0000' && this.parentWindow != null) {
                this.parentWindow.removeMnemonic(this);
                this.parentWindow.addMnemonic(rb.getMnemonicChar(), this);
            }
        }
    }

    @Override
    public String setProp(Integer key, String value, int length) {
        String Return2 = "0";
        int intValue = 0;
        boolean error = false;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            error = true;
        }
        boolean isrgb = false;
        PicobolRadioButton rb = (PicobolRadioButton)this.guiComponent;
        switch (key) {
            case 295: {
                if (error) break;
                this.bitmapScale = intValue;
                if (rb == null) break;
                rb.setBitmapScale(intValue);
                break;
            }
            case 409: {
                if (error) break;
                this.disabledColor = intValue;
                if (rb != null) {
                    Color[] cs = this.getColors(intValue);
                    rb.setDisabledBackground(cs[0]);
                    rb.setDisabledForeground(cs[1]);
                }
                Return2 = "1";
                break;
            }
            case 411: {
                isrgb = true;
            }
            case 410: {
                if (error) break;
                this.disabledBackgroundColor = intValue;
                this.disabledBackgroundRgb = isrgb;
                if (rb != null) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    rb.setDisabledBackground(bg);
                }
                Return2 = "1";
                break;
            }
            case 413: {
                isrgb = true;
            }
            case 412: {
                if (error) break;
                this.disabledForegroundColor = intValue;
                this.disabledForegroundRgb = isrgb;
                if (rb != null) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    rb.setDisabledForeground(fg);
                }
                Return2 = "1";
                break;
            }
            case 414: {
                if (error) break;
                this.rolloverColor = intValue;
                if (rb != null) {
                    Color[] cs = this.getColors(intValue);
                    rb.setRolloverBackground(cs[0]);
                    rb.setRolloverForeground(cs[1]);
                }
                Return2 = "1";
                break;
            }
            case 416: {
                isrgb = true;
            }
            case 415: {
                if (error) break;
                this.rolloverBackgroundColor = intValue;
                this.rolloverBackgroundRgb = isrgb;
                if (rb != null) {
                    Color bg = this.getBackgroundColor(intValue, isrgb);
                    rb.setRolloverBackground(bg);
                }
                Return2 = "1";
                break;
            }
            case 418: {
                isrgb = true;
            }
            case 417: {
                if (error) break;
                this.rolloverForegroundColor = intValue;
                this.rolloverForegroundRgb = isrgb;
                if (rb != null) {
                    Color fg = this.getForegroundColor(intValue, isrgb);
                    rb.setRolloverForeground(fg);
                }
                Return2 = "1";
                break;
            }
            case 320: {
                if (error) break;
                this.leftTextAlign = intValue;
                if (rb != null) {
                    rb.setLeftTextAlignment(this.leftTextAlign);
                }
                Return2 = "1";
                break;
            }
            case 104: {
                if (!error) {
                    this.groupValue = intValue;
                    this.groupValueAlpha = null;
                    Return2 = "1";
                    break;
                }
                this.groupValueAlpha = value;
                this.groupValue = this.rbGroup != null ? this.rbGroup.size() : 0;
                Return2 = "1";
                break;
            }
            case 103: {
                if (error) break;
                this.setGroupID(intValue);
                Return2 = "1";
                break;
            }
            case 7: 
            case 12: {
                if (error) break;
                this.bitmapNumber = intValue;
                if (rb != null) {
                    rb.setBitmapNumber(this.bitmapNumber);
                }
                Return2 = "1";
                break;
            }
            case 8: {
                if (error) break;
                this.bitmapDisabled = intValue;
                if (rb != null) {
                    rb.setBitmapDisabled(this.bitmapDisabled);
                }
                Return2 = "1";
                break;
            }
            case 13: {
                if (error) break;
                this.bitmapPressed = intValue;
                if (rb != null) {
                    rb.setBitmapPressed(this.bitmapPressed);
                }
                Return2 = "1";
                break;
            }
            case 14: {
                if (error) break;
                this.bitmapRollover = intValue;
                if (rb != null) {
                    rb.setBitmapRollover(this.bitmapRollover);
                }
                Return2 = "1";
                break;
            }
            case 16: {
                if (error) break;
                this.bitmapSelected = intValue;
                if (rb != null) {
                    rb.setBitmapSelected(this.bitmapSelected);
                }
                Return2 = "1";
                break;
            }
            case 15: {
                if (error) break;
                this.bitmapRolloverSelected = intValue;
                if (rb != null) {
                    rb.setBitmapRolloverSelected(this.bitmapRolloverSelected);
                }
                Return2 = "1";
                break;
            }
            case 240: {
                if (error) break;
                this.titlePosition = intValue;
                if (rb != null) {
                    rb.setTitlePosition(this.titlePosition);
                }
                Return2 = "1";
                break;
            }
            case 20: {
                if (error) break;
                this.bitmapWidth = intValue;
                if (rb != null) {
                    rb.setBitmapWidth(this.bitmapWidth);
                }
                Return2 = "1";
                break;
            }
            case 294: {
                if (error) break;
                this.bitmapDisabledSelected = intValue;
                if (rb != null) {
                    rb.setBitmapDisabledSelected(this.bitmapDisabledSelected);
                }
                Return2 = "1";
                break;
            }
            default: {
                return super.setProp(key, value, length);
            }
        }
        return Return2;
    }

    @Override
    public void destroy() {
        if (this.groupID > 0 && this.rbGroup != null) {
            this.rbGroup.removeElement(this);
        }
        super.destroy();
    }

    public void handleResponse(int eventAction, int eventId) {
    }

    @Override
    public void handleResponse(int eventAction, RemoteRecordAccept rra) {
        boolean changestate = false;
        super.handleResponse(eventAction, rra);
        RemoteBaseGUIControl rbgc = this.getUponCtrl();
        if (rbgc != null && rbgc instanceof RemoteTab && ((RemoteTab)rbgc).isRibbon()) {
            changestate = true;
        }
        if (this.hasClickOverrideFocusChange() && (this.getActiveAccept() || changestate) && (eventAction == 0 || eventAction == 1 || eventAction == 2) && rra.getEventType() == 17) {
            this.setState(true);
        }
    }

    @Override
    public void setCols(float cols) {
    }

    @Override
    public void setRows(float cols) {
    }

    @Override
    public void setSize(int w, int h, boolean setOnComp) {
        this.width = w;
        this.height = h;
        if (this.guiComponent != null && setOnComp) {
            this.updateLayoutManager();
            this.guiComponent.setSize(this.width, this.height);
        }
    }

    @Override
    public Rectangle getRealBounds() {
        Rectangle Return2 = this.guiComponent != null ? this.guiComponent.getBounds() : new Rectangle(this.x, this.y, this.width, this.height);
        return Return2;
    }

    @Override
    protected boolean hasToSetAllData() {
        return true;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle Return2 = this.getRealBounds();
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                Return2.width -= 8;
            }
            if (!this.linesInPixel) {
                Return2.height -= 7;
            }
        }
        return Return2;
    }

    @Override
    public Rectangle getBoundsWithoutDefaultWidth() {
        Rectangle Return2 = this.getBounds();
        if (!this.bitmapStyle && Return2 != null && Return2.width > 0) {
            Return2.width = (int)((float)Return2.width - 17.0f);
        }
        return Return2;
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v && this.guiComponent != null && this.rbGroup != null && this.rbGroup.getSelectedRadioButton() == null && this.rbGroup.size() > 0) {
            RemoteRadioButton firstElem = this.rbGroup.getElementAt(0);
            if (firstElem.valueStr == null) {
                this.rbGroup.getElementAt(0).setState(true);
            }
        }
    }

    @Override
    public boolean isInputField() {
        return true;
    }

    @Override
    protected void processMnemonic(char c) {
        super.processMnemonic(c);
        PicobolRadioButton rb = (PicobolRadioButton)this.guiComponent;
        if (rb != null) {
            rb.doClick(100);
        }
    }

    @Override
    protected float paramgetDefaultWidth(ParamElementSize ps, int origWidth) {
        String t = null;
        if (ps.sizes > 0.0f) {
            return ps.sizes;
        }
        if (!this.bitmapStyle) {
            if (ps.sizesInPixel || this.bitmapStyle && !ps.sizesInCells || ps.sizesInCells) {
                if (this.title != null) {
                    t = this.title;
                }
                if (t != null) {
                    if (this.font != null) {
                        return (float)(this.font.computeScreenWidth(t) / this.font.computeScreenWidth("0")) + 1.2f;
                    }
                    return this.title.length();
                }
            } else {
                return 0.0f;
            }
        }
        return super.paramgetDefaultWidth(ps, origWidth);
    }

    @Override
    public String getType() {
        return "radiobutton";
    }

    @Override
    public String getProp(int key) {
        PicobolRadioButton rb = (PicobolRadioButton)this.guiComponent;
        switch (key) {
            case 103: {
                return "" + this.groupID;
            }
            case 104: {
                if (this.groupValueAlpha == null) {
                    return "" + this.groupValue;
                }
                return "" + this.groupValueAlpha;
            }
            case 410: {
                if (!this.disabledBackgroundRgb && this.disabledBackgroundColor != null) {
                    return this.disabledBackgroundColor.toString();
                }
                if (rb == null || rb.getDisabledBackground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setBackRGB(rb.getDisabledBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 412: {
                if (!this.disabledForegroundRgb && this.disabledForegroundColor != null) {
                    return this.disabledForegroundColor.toString();
                }
                if (rb == null || rb.getDisabledForeground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setForeRGB(rb.getDisabledForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 409: {
                if (this.disabledColor != null) {
                    return this.disabledColor.toString();
                }
                return "0";
            }
            case 415: {
                if (!this.rolloverBackgroundRgb && this.rolloverBackgroundColor != null) {
                    return this.rolloverBackgroundColor.toString();
                }
                if (rb == null || rb.getRolloverBackground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setBackRGB(rb.getRolloverBackground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getBackground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 417: {
                if (!this.rolloverForegroundRgb && this.rolloverForegroundColor != null) {
                    return this.rolloverForegroundColor.toString();
                }
                if (rb == null || rb.getRolloverForeground() == null) break;
                ColorCmp cmp = new ColorCmp(true);
                cmp.setForeRGB(rb.getRolloverForeground().getRGB());
                Color color = this.gf.getRemotePalette().getDefaultColor(ColorCmp.getRealColor(cmp.getForeground(), false));
                return Integer.toString(color != null ? color.getRGB() : 0);
            }
            case 414: {
                if (this.rolloverColor != null) {
                    return this.rolloverColor.toString();
                }
                return "0";
            }
        }
        return super.getProp(key);
    }

    @Override
    public boolean getNoGroupTab() {
        return this.noGroupTab;
    }

    @Override
    public boolean hasNextInGroupNV() {
        return true;
    }

    @Override
    protected boolean mustreceivepressed() {
        return true;
    }

    @Override
    public void adjustBounds(Rectangle Return2) {
        if (this.bitmapStyle) {
            if (!this.sizesInPixel) {
                Return2.width -= 8;
            }
            if (!this.linesInPixel) {
                Return2.height -= 7;
            }
        }
    }

    @Override
    public boolean haveSameGroupValue(String valueNV, int controlVal) {
        boolean Return2 = false;
        Return2 = this.groupValueAlpha != null ? this.getControlValue() == controlVal : super.haveSameGroupValue(valueNV, controlVal);
        return Return2;
    }

    @Override
    public int getControlValue() {
        return this.groupValue;
    }

    @Override
    public JComponent getDragDropComponent() {
        return (PicobolRadioButton)this.guiComponent;
    }
}

