/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.ColorCmp;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.ChipsBoxContainer;
import com.iscobol.gui.client.swing.Etichetta;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ChipsBoxElement
extends JPanel
implements MouseListener {
    protected int strokeSize = 1;
    protected Color shadowColor = Color.black;
    protected boolean shady = false;
    protected boolean highQuality = true;
    protected Dimension arcs = null;
    protected int shadowGap = 5;
    protected int shadowOffset = 4;
    protected int shadowAlpha = 150;
    protected boolean isbackgroundset;
    protected boolean isforegroundset;
    protected boolean isrolloverbackgroundset;
    protected boolean isrolloverforegroundset;
    private Color cbbordercolor = null;
    private boolean cbhasborder = false;
    private Color rollovercbbordercolor = null;
    private boolean cbhasrolloverborder = false;
    private JLabel imgl;
    private JLabel l;
    private Etichetta b;
    private JPanel f;
    private Color color;
    private String text;
    private int a;
    private Component f1;
    private Component f2;
    private Component f3;
    private Component f4;
    private Component f5;
    private Component f6;
    private ChipsBoxContainer parent;
    private ColorCmp cbcolor = null;
    private ColorCmp rollovercbcolor = null;
    private Color rolloverbackground = null;
    private Color rolloverforeground = null;
    private int chipstype = 1;
    private int textwidth;
    private int textheight;
    private int FOO = 15;
    private int FOOHEIGHT = 16;
    private Image bitmaporig = null;
    private int bitmapnumber = -1;
    private int bitmapwidth = -1;
    private int bitmapid = -1;
    private int colorfgbg = 0;
    private int colorfg = 0;
    private int colorfgrgb = 0;
    private int colorbg = 0;
    private int colorbgrgb = 0;
    private int rollovercolorfgbg = 0;
    private int rollovercolorfg = 0;
    private int rollovercolorfgrgb = 0;
    private int rollovercolorbg = 0;
    private int rollovercolorbgrgb = 0;
    private int bordercolor = 0;
    private int bordercolorrgb = 0;
    private int rolloverbordercolor = 0;
    private int rolloverbordercolorrgb = 0;
    private int chipsradius = 100;
    private int radiusvalue = 0;
    private Object hiddendata;
    private boolean mouseentered = false;
    private int chipsborderwidth = -1;
    private int chipsrolloverborderwidth = -1;

    public ChipsBoxElement(ChipsBoxContainer parent, JPanel f, String text, int textwidth, int textheight, Image mouseentered, Image mouseexited, int chipstype, int chipsradius, int chipsborderwidth, int chipsrolloverborderwidth) {
        this.parent = parent;
        this.f = f;
        this.chipstype = chipstype;
        this.text = text;
        this.textwidth = textwidth;
        this.textheight = textheight;
        this.chipsborderwidth = chipsborderwidth;
        this.chipsrolloverborderwidth = chipsrolloverborderwidth;
        this.setLayout(new BoxLayout(this, 0));
        if (this.chipsradius != chipsradius && chipsradius >= 0 && chipsradius <= 100) {
            this.setChipsRadius(chipsradius);
        } else {
            this.setChipsRadius(this.chipsradius);
        }
        this.color = Color.white;
        this.l = new JLabel();
        this.l.setAlignmentY(0.5f);
        if (chipstype == 2) {
            this.b = new Etichetta(this, f, mouseentered, mouseexited);
            this.b.setAlignmentY(0.5f);
        }
        this.setOpaque(false);
        this.l.setText(text);
        this.f1 = Box.createRigidArea(new Dimension(10, 0));
        this.f2 = Box.createRigidArea(new Dimension(10, 0));
        this.f3 = Box.createRigidArea(new Dimension(10, 0));
        this.f4 = Box.createRigidArea(new Dimension(10, 0));
        this.add(this.f1);
        this.add(this.l);
        if (chipstype == 2) {
            this.add(this.f3);
            this.add(this.b);
        }
        this.add(this.f4);
        this.addMouseListener(this);
        this.doLayout();
    }

    public void setBackgroundAndCheck(Color b) {
        if (!(b instanceof SystemColor)) {
            super.setBackground(b);
            this.isbackgroundset = b != null;
        }
    }

    public void setForegroundAndCheck(Color b) {
        super.setForeground(b);
        this.l.setForeground(b);
        this.isforegroundset = b != null;
    }

    public void setBitmapNumber(int bitmapnumber) {
        this.bitmapnumber = bitmapnumber;
        this.setBitmap(this.bitmapid, this.bitmaporig, false);
    }

    public int getBitmapNumber() {
        return this.bitmapnumber;
    }

    public void setBitmapWidth(int bitmapwidth) {
        this.bitmapwidth = bitmapwidth;
        this.setBitmap(this.bitmapid, this.bitmaporig, false);
    }

    public int getBitmapWidth() {
        return this.bitmapwidth;
    }

    public int getBitmap() {
        return this.bitmapid;
    }

    private Image loadBitmap() {
        Image Return2 = this.bitmaporig;
        if (this.bitmapnumber > 0 || this.bitmapwidth > 0) {
            Return2 = ScreenUtility.getImage(this.bitmapwidth, -1, Return2, this.bitmapnumber);
        }
        return Return2;
    }

    public void setBitmap(int bitmapid, Image bitmaporig, boolean createtime) {
        this.bitmaporig = bitmaporig;
        Image bitmap = this.loadBitmap();
        if (bitmap != null) {
            this.bitmapid = bitmapid;
            ImageIcon img = new ImageIcon(bitmap);
            RGBImageFilter filter = new RGBImageFilter(){
                int transparentColor = Color.white.getRGB() | 0xFF000000;

                @Override
                public final int filterRGB(int x, int y, int rgb) {
                    if ((rgb | 0xFF000000) == this.transparentColor) {
                        return 0xFFFFFF & rgb;
                    }
                    return rgb;
                }
            };
            FilteredImageSource filteredImgProd = new FilteredImageSource(img.getImage().getSource(), filter);
            Image transparentImg = Toolkit.getDefaultToolkit().createImage(filteredImgProd);
            if (this.imgl == null) {
                this.imgl = new JLabel();
                this.imgl.setAlignmentY(0.5f);
            }
            int iconw = img.getIconWidth();
            int iconh = img.getIconHeight();
            Dimension size = new Dimension(iconw, iconh);
            this.imgl.setPreferredSize(size);
            this.imgl.setMinimumSize(size);
            this.imgl.setMaximumSize(size);
            this.imgl.setSize(size);
            this.imgl.setIcon(new ImageIcon(transparentImg));
            if (createtime) {
                this.add(this.imgl);
                this.add(this.f2);
            } else if (this.getComponentCount() == 7) {
                this.remove(1);
                this.remove(1);
                this.add((Component)this.imgl, 1);
                this.add(this.f2, 2);
            } else {
                this.add((Component)this.imgl, 1);
                this.add(this.f2, 2);
            }
        } else if (!createtime && this.getComponentCount() == 7) {
            this.imgl = null;
            this.remove(1);
            this.remove(2);
        }
        this.resizeok();
        this.repaint();
        this.doLayout();
        this.validate();
        this.parent.repaint();
        this.parent.doLayout();
        this.parent.validate();
    }

    void resizeok() {
        String s = this.l.getText();
        Font p = this.getFont();
        FontMetrics fm = this.l.getFontMetrics(this.l.getFont());
        this.textheight = fm.getHeight();
        this.radiusvalue = this.getRadiusValue(this.chipsradius);
        int w = 0;
        w = this.l.getWidth();
        int www = -1;
        int wimgl = 0;
        if (this.imgl != null) {
            wimgl = this.imgl.getWidth();
        }
        www = this.b != null ? this.FOO * 2 + w + 20 + this.b.getWidth() + wimgl : this.FOO * 2 + w + wimgl;
        this.FOO = 0;
        www = 0;
        Component[] array = this.getComponents();
        for (int i = 0; i < array.length; ++i) {
            if (array[i].getPreferredSize().getWidth() == 0.0) {
                www += 10;
                continue;
            }
            www = (int)((double)www + array[i].getPreferredSize().getWidth());
        }
        this.setPreferredSize(new Dimension(www, this.textheight + this.FOOHEIGHT));
        this.setMinimumSize(new Dimension(www, this.textheight + this.FOOHEIGHT));
        this.validate();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.parent.getMouseListener() != null) {
            this.parent.getMouseListener().mousePressed(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.parent.sendClicked(this);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseentered = true;
        this.repaint();
        this.parent.sendMouseEntered(this);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseentered = false;
        this.repaint();
        Rectangle rect = this.getBounds();
        Point thislos = this.getLocationOnScreen();
        rect.x = thislos.x;
        rect.y = thislos.y;
        Point elos = e.getLocationOnScreen();
        if (!rect.contains(elos.getX(), elos.getY())) {
            this.parent.sendMouseExited(this);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        int shadowGap = this.shadowGap;
        Color shadowColorA = new Color(this.shadowColor.getRed(), this.shadowColor.getGreen(), this.shadowColor.getBlue(), this.shadowAlpha);
        this.arcs = new Dimension(this.radiusvalue, this.radiusvalue);
        Graphics2D graphics = (Graphics2D)g;
        if (this.highQuality) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.shady) {
            graphics.setColor(shadowColorA);
            graphics.fillRoundRect(this.shadowOffset, this.shadowOffset, width - this.strokeSize - this.shadowOffset, height - this.strokeSize - this.shadowOffset, this.arcs.width, this.arcs.height);
        } else {
            shadowGap = 1;
        }
        Color back = null;
        if (this.mouseentered && this.isrolloverbackgroundset) {
            back = this.rolloverbackground;
        }
        if (back == null) {
            back = this.isbackgroundset ? this.getBackground() : this.color;
        }
        graphics.setColor(back);
        graphics.fillRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
        Color border = null;
        if (this.mouseentered && this.cbhasrolloverborder) {
            border = this.rollovercbbordercolor;
        } else if (this.cbhasborder) {
            border = this.cbbordercolor;
        }
        if (border != null) {
            graphics.setColor(border);
        }
        int bwidth = 0;
        if (this.mouseentered && this.chipsrolloverborderwidth > 0) {
            bwidth = this.chipsrolloverborderwidth;
        } else if (this.cbhasborder) {
            if (this.chipsborderwidth > 0) {
                bwidth = this.chipsborderwidth;
            } else {
                graphics.drawRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
            }
        }
        if (bwidth > 0) {
            graphics.fillRoundRect(0, 0, width - shadowGap, height - shadowGap, this.arcs.width, this.arcs.height);
            graphics.setColor(back);
            graphics.fillRoundRect(bwidth, bwidth, width - shadowGap - bwidth * 2, height - shadowGap - bwidth * 2, this.arcs.width - bwidth, this.arcs.height - bwidth);
        }
        Color fore = null;
        if (this.mouseentered && this.isrolloverforegroundset) {
            fore = this.rolloverforeground;
        }
        if (fore == null) {
            fore = this.getForeground();
        }
        this.l.setForeground(fore);
        graphics.setColor(fore);
        graphics.setStroke(new BasicStroke(this.strokeSize));
        graphics.setStroke(new BasicStroke());
    }

    public ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public String getItemText() {
        return this.text;
    }

    public void setItemText(String text, int textwidth, int textheight) {
        this.text = text;
        this.textwidth = textwidth;
        this.textheight = textheight;
        this.l.setText(text);
        this.resizeok();
        this.l.repaint();
        this.l.validate();
        this.validate();
        this.parent.repaint();
        this.parent.doLayout();
    }

    public void setTextHeight(int textheight) {
        this.textheight = textheight;
        this.radiusvalue = this.getRadiusValue(this.chipsradius);
        this.resizeok();
    }

    @Override
    public void setFont(Font f) {
        if (this.l != null) {
            this.l.setFont(f);
            this.resizeok();
            this.validate();
            this.parent.repaint();
            this.parent.doLayout();
        }
    }

    public ColorCmp getCBColor() {
        return this.cbcolor;
    }

    public int getCBColor(boolean isfg, boolean isbg, boolean isrgb) {
        if (!(isfg || isbg || isrgb)) {
            return this.colorfgbg;
        }
        if (isfg && isbg && !isrgb) {
            if (this.cbcolor == null || !this.cbcolor.isBackgroundSet()) {
                return this.colorbg;
            }
            return this.cbcolor.getBackground();
        }
        if (isfg && isbg && isrgb) {
            return this.colorbgrgb;
        }
        if (isfg && !isbg && !isrgb) {
            if (this.cbcolor == null || !this.cbcolor.isForegroundSet()) {
                return this.colorfg;
            }
            return this.cbcolor.getForeground();
        }
        if (isfg && !isbg && isrgb) {
            return this.colorfgrgb;
        }
        return -1;
    }

    public void setCBColor(ColorCmp c, int colorint, boolean isfg, boolean isbg, boolean isrgb) {
        if (!(isfg || isbg || isrgb)) {
            this.colorfgbg = colorint;
        } else if (isfg && isbg && !isrgb) {
            this.colorbg = colorint;
        } else if (isfg && isbg && isrgb) {
            this.colorbgrgb = colorint;
        } else if (isfg && !isbg && !isrgb) {
            this.colorfg = colorint;
        } else if (isfg && !isbg && isrgb) {
            this.colorfgrgb = colorint;
        }
        ColorCmp tmp = this.cbcolor;
        if (tmp == null) {
            tmp = new ColorCmp();
        }
        Color b = null;
        int idx = -1;
        if (c != null && c.isBackgroundSet()) {
            int back = c.getBackground();
            if (ColorCmp.isRGB(back)) {
                tmp.setBackRGB(back);
            } else {
                tmp.setBackground(back);
            }
            idx = ColorCmp.getRealColor(tmp.getBackground(), tmp.isBackIntensitySet());
            b = this.parent.getColor(idx);
            this.setBackgroundAndCheck(b);
        }
        if (c != null && c.isForegroundSet()) {
            int fore = c.getForeground();
            if (ColorCmp.isRGB(fore)) {
                tmp.setForeRGB(fore);
            } else {
                tmp.setForeground(fore);
            }
            idx = ColorCmp.getRealColor(tmp.getForeground(), tmp.isForeIntensitySet());
            b = this.parent.getColor(idx);
            this.setForegroundAndCheck(b);
        }
        this.cbcolor = tmp;
    }

    public ColorCmp getCBRolloverColor() {
        return this.rollovercbcolor;
    }

    public int getCBRolloverColor(boolean isfg, boolean isbg, boolean isrgb) {
        if (!(isfg || isbg || isrgb)) {
            return this.rollovercolorfgbg;
        }
        if (isfg && isbg && !isrgb) {
            if (this.rollovercbcolor == null || !this.rollovercbcolor.isBackgroundSet()) {
                return this.rollovercolorbg;
            }
            return this.rollovercbcolor.getBackground();
        }
        if (isfg && isbg && isrgb) {
            return this.rollovercolorbgrgb;
        }
        if (isfg && !isbg && !isrgb) {
            if (this.rollovercbcolor == null || !this.rollovercbcolor.isForegroundSet()) {
                return this.rollovercolorfg;
            }
            return this.rollovercbcolor.getForeground();
        }
        if (isfg && !isbg && isrgb) {
            return this.rollovercolorfgrgb;
        }
        return -1;
    }

    public void setCBRolloverColor(ColorCmp c, int colorint, boolean isfg, boolean isbg, boolean isrgb) {
        if (!(isfg || isbg || isrgb)) {
            this.rollovercolorfgbg = colorint;
        } else if (isfg && isbg && !isrgb) {
            this.rollovercolorbg = colorint;
        } else if (isfg && isbg && isrgb) {
            this.rollovercolorbgrgb = colorint;
        } else if (isfg && !isbg && !isrgb) {
            this.rollovercolorfg = colorint;
        } else if (isfg && !isbg && isrgb) {
            this.rollovercolorfgrgb = colorint;
        }
        ColorCmp tmp = this.rollovercbcolor;
        if (tmp == null) {
            tmp = new ColorCmp();
        }
        Object b = null;
        int idx = -1;
        if (c != null && c.isBackgroundSet()) {
            int back = c.getBackground();
            if (ColorCmp.isRGB(back)) {
                tmp.setBackRGB(back);
            } else {
                tmp.setBackground(back);
            }
            idx = ColorCmp.getRealColor(tmp.getBackground(), tmp.isBackIntensitySet());
            this.rolloverbackground = this.parent.getColor(idx);
            this.isrolloverbackgroundset = true;
        }
        if (c != null && c.isForegroundSet()) {
            int fore = c.getForeground();
            if (ColorCmp.isRGB(fore)) {
                tmp.setForeRGB(fore);
            } else {
                tmp.setForeground(fore);
            }
            idx = ColorCmp.getRealColor(tmp.getForeground(), tmp.isForeIntensitySet());
            this.rolloverforeground = this.parent.getColor(idx);
            this.isrolloverforegroundset = true;
        }
        this.rollovercbcolor = tmp;
    }

    public void setCBBorderColor(Color cbbordercolor, int c, boolean isrgb) {
        if (c < 0 || isrgb) {
            this.bordercolorrgb = c;
        } else {
            this.bordercolor = c;
        }
        if (cbbordercolor != null) {
            this.cbhasborder = true;
        }
        this.cbbordercolor = cbbordercolor;
        this.repaint();
    }

    public int getCBBorderColor(boolean isrgb) {
        if (isrgb) {
            return this.bordercolorrgb;
        }
        return this.bordercolor;
    }

    public void setCBRolloverBorderColor(Color rollovercbbordercolor, int c, boolean isrgb) {
        if (c < 0 || isrgb) {
            this.rolloverbordercolorrgb = c;
        } else {
            this.rolloverbordercolor = c;
        }
        if (rollovercbbordercolor != null) {
            this.cbhasrolloverborder = true;
        }
        this.rollovercbbordercolor = rollovercbbordercolor;
        this.repaint();
    }

    public int getCBRolloverBorderColor(boolean isrgb) {
        if (isrgb) {
            return this.rolloverbordercolorrgb;
        }
        return this.rolloverbordercolor;
    }

    public void sendClose() {
        this.parent.sendClose(this);
    }

    public void sendmousePressed(MouseEvent e) {
        if (this.parent.getMouseListener() != null) {
            this.parent.getMouseListener().mousePressed(e);
        }
    }

    public void setChipsRadius(int chipsradius) {
        if (this.chipsradius != chipsradius && chipsradius >= 0 && chipsradius <= 100) {
            this.chipsradius = chipsradius;
            this.radiusvalue = this.getRadiusValue(chipsradius);
            this.validate();
            this.repaint();
            this.doLayout();
            this.validate();
        }
    }

    private int getRadiusValue(int chipsradius) {
        Double perce = new Double(chipsradius);
        Double uno = new Double(this.textheight + this.FOOHEIGHT);
        Double Result2 = perce / 100.0 * uno;
        return Result2.intValue();
    }

    public void setHiddenData(Object hiddendata) {
        this.hiddendata = hiddendata;
    }

    public Object getHiddenData() {
        return this.hiddendata;
    }

    public void setMouseentered(boolean mouseentered) {
        this.mouseentered = mouseentered;
    }
}

