/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.client.IscobolLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ScaleLayout
extends IscobolLayout {
    private static Hashtable<String, Integer> defLayoutDatas = new Hashtable();
    protected Hashtable<String, Integer> cTypeLayoutDatas = new Hashtable();
    protected float containerWidthDelta;
    protected float containerHeightDelta;

    public ScaleLayout(Container container) {
        this(container, null);
    }

    public ScaleLayout(Container container, String defaultSettings) {
        super(container);
        if (defaultSettings != null) {
            StringTokenizer st = new StringTokenizer(defaultSettings, ", ");
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                int idx = tk.indexOf(61);
                if (idx <= 0 || idx >= tk.length() - 1) continue;
                try {
                    this.cTypeLayoutDatas.put(tk.substring(0, idx).toLowerCase(), Integer.valueOf(tk.substring(idx + 1)));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    @Override
    protected void layoutContainer(Dimension currContainerSize) {
        this.containerWidthDelta = (float)currContainerSize.width / (float)this.origContainerSize.width;
        this.containerHeightDelta = (float)currContainerSize.height / (float)this.origContainerSize.height;
        super.layoutContainer(currContainerSize);
    }

    @Override
    protected int getNewWidth(Rectangle origBounds) {
        return (int)((float)origBounds.width * this.containerWidthDelta);
    }

    @Override
    protected int getNewHeight(Rectangle origBounds) {
        return (int)((float)origBounds.height * this.containerHeightDelta);
    }

    @Override
    protected int getNewX(Rectangle origBounds) {
        return (int)((float)origBounds.x * this.containerWidthDelta);
    }

    @Override
    protected int getNewY(Rectangle origBounds) {
        return (int)((float)origBounds.y * this.containerHeightDelta);
    }

    @Override
    public boolean hasDefaultLayoutData(String controlType) {
        return this.cTypeLayoutDatas.containsKey(controlType.toLowerCase());
    }

    @Override
    public String getDefaultLayoutDataString(String controltype) {
        try {
            controltype = controltype.toLowerCase();
            Integer o = this.cTypeLayoutDatas.get(controltype);
            if (o != null) {
                return o.toString();
            }
            o = defLayoutDatas.get(controltype);
            if (o != null) {
                return o.toString();
            }
            return "0";
        }
        catch (Exception ex) {
            return "0";
        }
    }

    static {
        defLayoutDatas.put("vbar", 118);
        defLayoutDatas.put("hbar", 103);
        defLayoutDatas.put("bitmap", 102);
        defLayoutDatas.put("checkbox", 102);
        defLayoutDatas.put("combobox", 103);
        defLayoutDatas.put("dateentry", 103);
        defLayoutDatas.put("entryfield", 103);
        defLayoutDatas.put("textarea", 119);
        defLayoutDatas.put("spinner", 103);
        defLayoutDatas.put("frame", 119);
        defLayoutDatas.put("grid", 119);
        defLayoutDatas.put("javabean", 102);
        defLayoutDatas.put("label", 102);
        defLayoutDatas.put("listbox", 119);
        defLayoutDatas.put("pushbutton", 102);
        defLayoutDatas.put("radiobutton", 102);
        defLayoutDatas.put("hscrollbar", 103);
        defLayoutDatas.put("vscrollbar", 118);
        defLayoutDatas.put("hslider", 103);
        defLayoutDatas.put("vslider", 118);
        defLayoutDatas.put("tab", 119);
        defLayoutDatas.put("treeview", 119);
        defLayoutDatas.put("iwcpanel", 119);
        defLayoutDatas.put("webbrowser", 119);
        defLayoutDatas.put("scrollpane", 119);
        defLayoutDatas.put("chipsbox", 119);
    }
}

