/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.client.Hint;
import com.iscobol.gui.client.IscobolWindow;
import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.Terminal;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class KeyboardBuffer {
    public static String eol = System.getProperty("line.separator", "\n");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd - HH.mm.ss.SSSS");
    private static boolean clinitialized;
    private static boolean mouseDisabled;
    public static boolean tracegui;
    private static boolean traceappend;
    private static int traceval;
    public static Logger guiLog;
    public static Logger devLog;
    public static Logger problemLog;
    private static String tracelog;
    private static final ArrayList<Hint> activeHints;
    private static final Cursor BUSY_CURSOR;
    public static MyEventQueue eq;

    public static void clinit() {
        if (!clinitialized) {
            mouseDisabled = Config.getProperty("iscobol.gui.mouse_disabled", false);
            traceval = LoggerFactory.getTraceLevel();
            traceappend = Config.getProperty("iscobol.logfile.append", false);
            guiLog = LoggerFactory.get(512);
            devLog = LoggerFactory.get(2048);
            problemLog = LoggerFactory.get(64);
            tracelog = LoggerFactory.getLogFile();
            tracegui = guiLog != null;
            clinitialized = true;
        }
    }

    public static boolean getInputStatus(boolean onlyChar) {
        return eq.getInputStatus(onlyChar);
    }

    public static KeyEvent popKeyEvent() {
        return eq.popKeyEvent();
    }

    public static void setBufferOn() {
        eq.setBufferOn();
    }

    public static void setBufferOff() {
        eq.setBufferOff();
    }

    public static void enableInputStatus() {
        eq.isActive = false;
    }

    public static void enable(Component c) {
        eq.enable(c);
    }

    public static boolean isEnabled() {
        return eq.isEnabled();
    }

    public static boolean isDebugEnabled() {
        return eq.isDebugEnabled();
    }

    private static void mySetCursor(final Window win, final Cursor c) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                win.setCursor(c);
            }
        });
        Window[] wl = win instanceof IscobolWindow ? ((IscobolWindow)((Object)win)).getOwnedMyWindows() : win.getOwnedWindows();
        for (int i = 0; i < wl.length; ++i) {
            KeyboardBuffer.mySetCursor(wl[i], c);
        }
    }

    public static void disable(Window window, int delay) {
        KeyboardBuffer.eq.saveCursor(window, delay);
        eq.disable();
    }

    public static int getLastCursorX() {
        return eq.lastCursorX;
    }

    public static int getLastCursorY() {
        return eq.lastCursorY;
    }

    public static Component getLastMouseEventSource() {
        return eq.lastMouseEventSource;
    }

    public static boolean isLeftButtonDown() {
        return eq.leftButtonDown;
    }

    public static boolean isRightButtonDown() {
        return eq.rightButtonDown;
    }

    public static boolean isMiddleButtonDown() {
        return eq.middleButtonDown;
    }

    public static void addMouseListener(MouseListener l) {
        eq.addMouseListener(l);
    }

    public static void removeMouseListener(MouseListener l) {
        eq.removeMouseListener(l);
    }

    public static void insertString(Component w, String s) {
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            long when = System.currentTimeMillis();
            eq.postEvent(new KeyEvent(w, 400, when, 0, 0, a[i]));
        }
    }

    public static void postControlEvent(AWTEvent e) {
        eq.postEvent(e);
    }

    public static void setKeyboardBuffering(int ne) {
        eq.setKeyboardBuffering(ne);
    }

    public static String getStackTrace() {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        new Exception().printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static void altPauseDebugFocus(AWTEvent e) {
        KeyboardBuffer.eq.altPauseDebugFocus(e);
    }

    public static void addKeyEvent(KeyEvent ke) {
        KeyboardBuffer.eq.addKeyEvent(ke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addActiveHint(Hint popup) {
        ArrayList<Hint> arrayList = activeHints;
        synchronized (arrayList) {
            activeHints.add(popup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeActiveHint(Hint popup) {
        ArrayList<Hint> arrayList = activeHints;
        synchronized (arrayList) {
            activeHints.remove(popup);
        }
    }

    private static void hideActiveHints(MouseEvent e) {
        if (e.getID() != 502) {
            KeyboardBuffer.hideActiveHints();
        }
    }

    private static void hideActiveHints(KeyEvent e) {
        if (e.getID() == 401) {
            switch (e.getKeyCode()) {
                case 9: 
                case 10: 
                case 27: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 61440: 
                case 61441: 
                case 61442: 
                case 61443: 
                case 61444: 
                case 61445: 
                case 61446: 
                case 61447: 
                case 61448: 
                case 61449: 
                case 61450: 
                case 61451: {
                    KeyboardBuffer.hideActiveHints();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hideActiveHints() {
        ArrayList<Hint> arrayList = activeHints;
        synchronized (arrayList) {
            while (!activeHints.isEmpty()) {
                activeHints.remove(0).hide();
            }
        }
    }

    public static String getlastmsgactivate() {
        return eq.getlastmsgactivate();
    }

    public static String getlastmsgdeactivate() {
        return eq.getlastmsgdeactivate();
    }

    static {
        activeHints = new ArrayList();
        BUSY_CURSOR = new Cursor(3);
        eq = new MyEventQueue();
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(eq);
    }

    public static class MyEventQueue
    extends EventQueue {
        private Cursor lastCursor;
        private Window lastWindow;
        private int delay = 2000;
        private WaitCursorThread cursorThread;
        private int lastCursorX;
        private int lastCursorY;
        private Component lastMouseEventSource;
        private boolean rightButtonDown;
        private boolean leftButtonDown;
        private boolean middleButtonDown;
        private int bufferOn = 1;
        private boolean isActive = true;
        private LinkedList<KeyEvent> keyBuffer = new LinkedList();
        private boolean inputStatus;
        private MouseListener mouseListener;
        private boolean isDebug;
        private int sizebuffering = -1;
        private String lastmsgactivate;
        private String lastmsgdeactivate;
        private Component lastActivate;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addKeyEvent(KeyEvent ke) {
            LinkedList<KeyEvent> linkedList = this.keyBuffer;
            synchronized (linkedList) {
                this.keyBuffer.add(ke);
                this.keyBuffer.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetBufEvents() {
            LinkedList<KeyEvent> linkedList = this.keyBuffer;
            synchronized (linkedList) {
                this.keyBuffer = new LinkedList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean getInputStatus(boolean onlyChar) {
            LinkedList<KeyEvent> linkedList = this.keyBuffer;
            synchronized (linkedList) {
                if (this.inputStatus) {
                    if (onlyChar) {
                        if (this.keyBuffer.size() > 0) {
                            ListIterator lit = this.keyBuffer.listIterator();
                            while (lit.hasNext()) {
                                KeyEvent ke = (KeyEvent)lit.next();
                                if (ke.getID() != 401) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    return this.keyBuffer.size() > 0;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        KeyEvent popKeyEvent() {
            KeyEvent Return2 = null;
            while (true) {
                LinkedList<KeyEvent> linkedList = this.keyBuffer;
                synchronized (linkedList) {
                    ListIterator lit = this.keyBuffer.listIterator();
                    while (lit.hasNext()) {
                        KeyEvent ke = (KeyEvent)lit.next();
                        if (ke.getID() != 401) continue;
                        Return2 = ke;
                        lit.remove();
                        while (lit.hasNext() && (ke = (KeyEvent)lit.next()).getID() != 401 && ke.getKeyCode() == Return2.getKeyCode() && ke.getModifiersEx() == Return2.getModifiersEx()) {
                            lit.remove();
                        }
                        break block6;
                    }
                    if (Return2 != null) {
                        break;
                    }
                    try {
                        this.keyBuffer.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return Return2;
        }

        private synchronized void setBusyCursor() {
            if (this.lastWindow != null) {
                KeyboardBuffer.mySetCursor(this.lastWindow, BUSY_CURSOR);
            }
        }

        private synchronized void saveCursor(Window window, int delay) {
            if (this.lastWindow == null) {
                this.lastWindow = window;
                this.lastCursor = window != null ? window.getCursor() : null;
                this.delay = delay;
            }
        }

        private void activate() {
            this.activate(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate(Component w) {
            MyEventQueue myEventQueue = this;
            synchronized (myEventQueue) {
                if (this.lastWindow != null && this.lastCursor != null) {
                    if (this.cursorThread != null) {
                        this.cursorThread.interrupt();
                        this.cursorThread = null;
                    }
                    if (this.lastWindow.getCursor() == BUSY_CURSOR) {
                        KeyboardBuffer.mySetCursor(this.lastWindow, this.lastCursor);
                    }
                    this.lastWindow = null;
                    this.lastCursor = null;
                }
            }
            if (tracegui && !this.isActive) {
                this.lastmsgactivate = "MSG_ACTIVATE: Date " + sdf.format(new Date()) + " KeyboardBuffer: activate!! [" + this.isActive + "] event buffered [" + this.keyBuffer.size() + "] bufferon [" + this.bufferOn + "] w [" + w + "]";
                this.lastmsgactivate = this.lastmsgactivate + KeyboardBuffer.getStackTrace();
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager() != null) {
                    this.lastmsgactivate = this.lastmsgactivate + "] focus owner [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() + "]";
                }
                if (guiLog != null) {
                    guiLog.info("LMA===>>" + this.lastmsgactivate);
                }
            }
            this.middleButtonDown = false;
            this.rightButtonDown = false;
            this.leftButtonDown = false;
            this.isActive = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactivate() {
            MyEventQueue myEventQueue = this;
            synchronized (myEventQueue) {
                if (this.lastWindow != null) {
                    if (this.cursorThread != null) {
                        this.cursorThread.interrupt();
                        this.cursorThread = null;
                    }
                    if (this.delay > 0) {
                        this.cursorThread = new WaitCursorThread();
                        this.cursorThread.start();
                    }
                }
            }
            if (tracegui && this.isActive) {
                this.lastmsgdeactivate = "MSG_DEACTIVATE: Date " + sdf.format(new Date()) + " sdfKeyboardBuffer: deactivate!! [" + this.isActive + "] event buffered [" + this.keyBuffer.size() + "] bufferon [" + this.bufferOn + "] ";
                this.lastmsgdeactivate = this.lastmsgdeactivate + KeyboardBuffer.getStackTrace();
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager() != null) {
                    this.lastmsgdeactivate = this.lastmsgdeactivate + "] focus owner [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() + "]";
                }
                if (guiLog != null) {
                    guiLog.info("LMD===>>" + this.lastmsgdeactivate);
                }
            }
            this.isActive = false;
        }

        private void repostBufEvents(Component w) {
            this.repostBufEvents(w, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void repostBufEvents(Component w, boolean dispatch) {
            LinkedList<KeyEvent> linkedList = this.keyBuffer;
            synchronized (linkedList) {
                this.inputStatus = false;
                if (!this.keyBuffer.isEmpty()) {
                    KeyEvent ke;
                    int count = 0;
                    Iterator i = this.keyBuffer.iterator();
                    if (w == null) {
                        while (i.hasNext() && this.isActive) {
                            ke = (KeyEvent)i.next();
                            this.postEvent(ke);
                            ++count;
                        }
                    } else {
                        long when = System.currentTimeMillis();
                        Component[] o = new Component[this.keyBuffer.size()];
                        int oi = -1;
                        while (i.hasNext() && this.isActive) {
                            boolean send;
                            ke = (KeyEvent)i.next();
                            ++count;
                            if (ke.getID() == 401) {
                                o[++oi] = ke.getComponent();
                                send = true;
                            } else {
                                send = false;
                                Component cp = ke.getComponent();
                                for (int j = oi; j >= 0; --j) {
                                    if (cp != o[j]) continue;
                                    send = true;
                                    break;
                                }
                            }
                            if (!send) continue;
                            KeyEvent ktmp = new KeyEvent(w, ke.getID(), when++, ke.getModifiers(), ke.getKeyCode(), ke.getKeyChar());
                            if (dispatch) {
                                super.dispatchEvent(ktmp);
                                continue;
                            }
                            this.postEvent(ktmp);
                        }
                    }
                    if (count == this.keyBuffer.size()) {
                        this.keyBuffer.clear();
                    } else {
                        for (int j = 0; j < count; ++j) {
                            this.keyBuffer.remove();
                        }
                    }
                }
            }
        }

        public void setBufferOn() {
            if (this.bufferOn < 1) {
                ++this.bufferOn;
            }
        }

        public synchronized void setBufferOff() {
            --this.bufferOn;
            if (this.bufferOn == 0) {
                this.resetBufEvents();
                this.activate();
            }
        }

        public void enable(final Component w) {
            this.lastActivate = w;
            this.activate(w);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.repostBufEvents(w);
                }
            };
            thread.start();
        }

        public synchronized boolean isEnabled() {
            return this.isActive;
        }

        public synchronized boolean isDebugEnabled() {
            return this.isDebug;
        }

        public synchronized void disable() {
            this.lastActivate = null;
            if (this.bufferOn == 1) {
                this.deactivate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchEvent(AWTEvent e) {
            if (e instanceof MouseEvent) {
                MouseEvent em = (MouseEvent)e;
                KeyboardBuffer.hideActiveHints(em);
                if (mouseDisabled) {
                    return;
                }
                this.lastCursorX = em.getX();
                this.lastCursorY = em.getY();
                this.lastMouseEventSource = em.getComponent();
                switch (em.getID()) {
                    case 501: {
                        int modifiers = em.getModifiers();
                        if ((modifiers & 0x10) == 16) {
                            this.leftButtonDown = true;
                            break;
                        }
                        if ((modifiers & 8) == 8) {
                            this.middleButtonDown = true;
                            break;
                        }
                        if ((modifiers & 4) != 4) break;
                        this.rightButtonDown = true;
                        break;
                    }
                    case 502: {
                        int modifiers = em.getModifiers();
                        if ((modifiers & 0x10) == 16) {
                            this.leftButtonDown = false;
                            break;
                        }
                        if ((modifiers & 8) == 8) {
                            this.middleButtonDown = false;
                            break;
                        }
                        if ((modifiers & 4) != 4) break;
                        this.rightButtonDown = false;
                        break;
                    }
                    case 500: {
                        break;
                    }
                }
                if (this.isActive || em.getID() != 501 && (em.getID() != 500 || em.getClickCount() > 1)) {
                    if (this.mouseListener != null) {
                        switch (em.getID()) {
                            case 501: {
                                this.mouseListener.mousePressed(em);
                                break;
                            }
                            case 502: {
                                this.mouseListener.mouseReleased(em);
                                break;
                            }
                            case 500: {
                                this.mouseListener.mouseClicked(em);
                                break;
                            }
                            case 504: {
                                this.mouseListener.mouseEntered(em);
                                break;
                            }
                            case 505: {
                                this.mouseListener.mouseExited(em);
                            }
                        }
                    }
                    super.dispatchEvent(e);
                }
            } else if (e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 19 && e.getID() == 401 && ((KeyEvent)e).isAltDown()) {
                this.altPauseDebugFocus(e);
            } else if (this.isActive) {
                if (this.isDebug && guiLog != null) {
                    boolean show = true;
                    switch (e.getID()) {
                        case 100: 
                        case 504: 
                        case 505: 
                        case 1200: {
                            show = false;
                        }
                    }
                    if (show) {
                        guiLog.info("KeyboardBuffer: dispatchEvent [" + e.toString() + "]");
                    }
                }
                if (e instanceof KeyEvent) {
                    KeyEvent ke = (KeyEvent)e;
                    KeyboardBuffer.hideActiveHints(ke);
                    LinkedList<KeyEvent> linkedList = this.keyBuffer;
                    synchronized (linkedList) {
                        if (!this.keyBuffer.isEmpty()) {
                            this.repostBufEvents(this.lastActivate, true);
                        }
                    }
                    if (this.isActive) {
                        super.dispatchEvent(e);
                    } else {
                        this.addtobuffer(ke);
                    }
                } else {
                    super.dispatchEvent(e);
                }
            } else if (e instanceof KeyEvent) {
                KeyEvent ke = (KeyEvent)e;
                KeyboardBuffer.hideActiveHints(ke);
                this.addtobuffer(ke);
            } else {
                super.dispatchEvent(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addtobuffer(KeyEvent e) {
            LinkedList<KeyEvent> linkedList = this.keyBuffer;
            synchronized (linkedList) {
                if (e.getID() == 401 && e.getKeyCode() != 18 && e.getKeyCode() != 17 && e.getKeyCode() != 16) {
                    this.inputStatus = true;
                }
                String addmsg = "";
                if (this.sizebuffering == -1 || this.sizebuffering > 0 && this.keyBuffer.size() <= this.sizebuffering) {
                    this.addKeyEvent(e);
                    addmsg = " buffered [" + this.keyBuffer.size() + "] ";
                } else {
                    addmsg = " NOT buffered buffer size [" + this.keyBuffer.size() + "] >= sizebuffering [" + this.sizebuffering + "] ";
                }
                if (this.isDebug && guiLog != null && e.getID() == 401) {
                    String msg = "KeyboardBuffer: buffered [" + e + "] isActive [" + this.isActive + "]" + addmsg;
                    if (KeyboardFocusManager.getCurrentKeyboardFocusManager() != null) {
                        msg = msg + "] focus owner [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() + "]";
                    }
                    guiLog.info(msg);
                }
            }
        }

        @Override
        public void postEvent(AWTEvent e) {
            super.postEvent(e);
        }

        public void addMouseListener(MouseListener l) {
            this.mouseListener = AWTEventMulticaster.add(this.mouseListener, l);
        }

        public void removeMouseListener(MouseListener l) {
            this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, l);
        }

        public void setKeyboardBuffering(int ne) {
            this.sizebuffering = ne;
        }

        private void altPauseDebugFocus(AWTEvent e) {
            Component currfoc = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component permfoc = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            Container currfoccycleroot = KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentFocusCycleRoot();
            Window focusedwindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            Window activewindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (currfoc != null && currfoc instanceof Terminal) {
                super.dispatchEvent(e);
            }
            boolean oldactive = this.isActive;
            this.isActive = true;
            this.isDebug = true;
            String msginfofile = "==>>ALT_PAUSE PRESSED:Date " + sdf.format(new Date()) + "] tracegui [" + tracegui + "] traceval [" + traceval + "] tracelog [" + tracelog + "] append [" + traceappend + "] isActive [" + oldactive + "] buffered [" + this.keyBuffer.size() + "] lastmsgDEACTIVATE [" + this.lastmsgdeactivate + "]" + eol + " lastmsgACTIVATE [" + this.lastmsgactivate + "]" + eol + "==> focus owner: [" + currfoc + "]" + eol + "==> permanent focus owner: [" + permfoc + "]" + eol + "==> focused window: [" + focusedwindow + "]" + eol + "==> active window: [" + activewindow + "]" + eol + "==> current focus cycle root: [" + currfoccycleroot + "]" + eol + "";
            if (guiLog != null) {
                guiLog.info(msginfofile);
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager() != null) {
                    guiLog.info("KeyboardBuffer: isActive [" + oldactive + "] event buffered [" + this.keyBuffer.size() + "] e.source [" + e.getSource() + "] focus owner(JButton OK) [" + KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() + "]");
                }
            }
            String msginfo = "<html><body><p style='width:600px;'>ALT_PAUSE PRESSED:<br>tracegui [" + tracegui + "]<br>traceval [" + traceval + "]<br>tracelog [" + tracelog + "]<br>append [" + traceappend + "]<br>KeyboardBuffer: isActive [" + oldactive + "] buffered [" + this.keyBuffer.size() + "]<br>lastmsgdeactivate [" + this.lastmsgdeactivate + "]<br>lastmsgactivate [" + this.lastmsgactivate + "]<br>focus owner:<br>[" + currfoc + "]<br>permanent focus owner:<br>[" + permfoc + "]<br>focused window:<br>[" + focusedwindow + "]<br>active window:<br>[" + activewindow + "]<br>current focus cycle root:<br>[" + currfoccycleroot + "]";
            try {
                while (currfoc != null) {
                    if (currfoc.getParent() != null && (currfoc.getParent() instanceof Window || currfoc.getParent() instanceof PicobolWidget)) {
                        msginfo = msginfo + "<br>Parent:<br>" + currfoc.getParent();
                        msginfofile = msginfofile + "====> Parent:" + currfoc.getParent() + "" + eol + "";
                    }
                    currfoc = currfoc.getParent();
                }
                msginfo = msginfo + "</p></body></html>";
                Method mth = null;
                Object jsp = null;
                Object jtao = Factory.invoke("javax.swing.JTextArea", "new", null);
                if (jtao != null) {
                    Constructor<?> m;
                    Class<?> cl;
                    Class<?> cjtao = jtao.getClass();
                    mth = cjtao.getMethod("setRows", Integer.TYPE);
                    if (mth != null) {
                        mth.invoke(jtao, 35);
                    }
                    if ((mth = cjtao.getMethod("setColumns", Integer.TYPE)) != null) {
                        mth.invoke(jtao, 55);
                    }
                    if ((mth = cjtao.getMethod("setEditable", Boolean.TYPE)) != null) {
                        mth.invoke(jtao, Boolean.FALSE);
                    }
                    if ((mth = cjtao.getMethod("setText", String.class)) != null) {
                        mth.invoke(jtao, msginfofile);
                    }
                    if ((cl = Class.forName("javax.swing.JScrollPane")) != null && (m = cl.getConstructor(Component.class)) != null) {
                        m.setAccessible(true);
                        jsp = m.newInstance(jtao);
                    }
                }
                if (jsp == null) {
                    Class.forName("javax.swing.JOptionPane").getMethod("showMessageDialog", Component.class, Object.class).invoke(null, null, msginfo);
                } else {
                    Constructor<?> p;
                    Class<?> popup;
                    if (jtao != null && (popup = Class.forName("com.iscobol.gui.client.swing.GetPopupMenuImpl")) != null && (p = popup.getConstructor(Object.class)) != null) {
                        p.setAccessible(true);
                        p.newInstance(jtao);
                    }
                    Class.forName("javax.swing.JOptionPane").getMethod("showMessageDialog", Component.class, Object.class).invoke(null, new Object[]{null, jsp});
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.keyBuffer.clear();
            this.isActive = true;
        }

        public String getlastmsgactivate() {
            return this.lastmsgactivate;
        }

        public String getlastmsgdeactivate() {
            return this.lastmsgdeactivate;
        }
    }

    private static class WaitCursorThread
    extends Thread {
        private WaitCursorThread() {
        }

        @Override
        public void run() {
            try {
                WaitCursorThread.sleep(eq.delay);
                eq.setBusyCursor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

