/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

public class Justification {
    private static final int NONE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int CENTER = 3;
    public static final Justification None = new Justification(0);
    public static final Justification Left = new Justification(1);
    public static final Justification Right = new Justification(2);
    public static final Justification Center = new Justification(3);
    private final int mode;

    private Justification(int m) {
        this.mode = m;
    }

    public char[] get(char[] value) {
        switch (this.mode) {
            case 2: {
                return Justification.justRight(new String(value), value.length).toCharArray();
            }
            case 3: {
                return Justification.justCentered(new String(value), value.length).toCharArray();
            }
            case 1: {
                return Justification.justLeft(new String(value), value.length).toCharArray();
            }
        }
        return value;
    }

    public String get(String value, int len) {
        switch (this.mode) {
            case 2: {
                return Justification.justRight(value, len);
            }
            case 3: {
                return Justification.justCentered(value, len);
            }
            case 1: {
                return Justification.justLeft(value, len);
            }
        }
        return value;
    }

    private static String justRight(String v, int mlen) {
        StringBuffer Return2 = new StringBuffer();
        v = v != null ? v.trim() : "";
        for (int vlen = v.length(); vlen < mlen; ++vlen) {
            Return2.append(' ');
        }
        Return2.append(v);
        return Return2.toString();
    }

    private static String justLeft(String v, int mlen) {
        v = v != null ? v.trim() : "";
        return v;
    }

    private static String justCentered(String v, int mlen) {
        StringBuffer Return2 = new StringBuffer();
        v = v != null ? v.trim() : "";
        mlen /= 2;
        for (int vlen = v.length() / 2; vlen < mlen; ++vlen) {
            Return2.append(' ');
        }
        Return2.append(v);
        return Return2.toString();
    }

    public String toString() {
        switch (this.mode) {
            case 2: {
                return "right";
            }
            case 3: {
                return "center";
            }
            case 1: {
                return "left";
            }
        }
        return "none";
    }
}

