/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.concurrent.ConcurrentHashMap;

public abstract class IscobolLayout
implements LayoutManager2 {
    public static final int RESIZE_X = 1;
    public static final int MOVE_X = 2;
    public static final int NO_MIN_X = 4;
    public static final int RESIZE_Y = 16;
    public static final int MOVE_Y = 32;
    public static final int NO_MIN_Y = 64;
    public static final int RESIZE_X_ANY = 5;
    public static final int RESIZE_Y_ANY = 80;
    public static final int MOVE_X_ANY = 6;
    public static final int MOVE_Y_ANY = 96;
    public static final int RESIZE_BOTH = 17;
    public static final int RESIZE_BOTH_ANY = 85;
    public static final int MOVE_BOTH = 34;
    public static final int MOVE_BOTH_ANY = 102;
    protected Dimension origContainerSize;
    protected ConcurrentHashMap<Component, LayoutData> constraintsTable = new ConcurrentHashMap();
    private boolean layingOut;

    public IscobolLayout(Container container) {
        this.setOriginalContainerSize(container.getSize());
    }

    @Override
    public final void layoutContainer(Container container) {
        this.layingOut = true;
        try {
            if (this.origContainerSize == null) {
                this.setOriginalContainerSize(container.getSize());
            } else {
                this.layoutContainer(container.getSize());
            }
        }
        finally {
            this.layingOut = false;
        }
    }

    public boolean isLayingOut() {
        return this.layingOut;
    }

    protected abstract int getNewWidth(Rectangle var1);

    protected abstract int getNewHeight(Rectangle var1);

    protected abstract int getNewX(Rectangle var1);

    protected abstract int getNewY(Rectangle var1);

    protected void layoutContainer(Dimension currContainerSize) {
        for (Component comp : this.constraintsTable.keySet()) {
            int newY;
            int newX;
            int newHeight;
            int newWidth;
            LayoutData lData = this.constraintsTable.get(comp);
            boolean noMinX = (lData.getAction() & 4) == 4;
            boolean noMinY = (lData.getAction() & 0x40) == 64;
            Rectangle currCompBounds = comp.getBounds();
            if ((lData.getAction() & 1) == 1) {
                newWidth = this.getNewWidth(lData.getOrigBounds());
                int minWidth = noMinX ? lData.getMinWidth() : lData.getOrigBounds().width;
                newWidth = Math.max(minWidth, Math.min(lData.getMaxWidth(), newWidth));
            } else {
                newWidth = currCompBounds.width;
            }
            if ((lData.getAction() & 0x10) == 16) {
                newHeight = this.getNewHeight(lData.getOrigBounds());
                int minHeight = noMinY ? lData.getMinHeight() : lData.getOrigBounds().height;
                newHeight = Math.max(minHeight, Math.min(lData.getMaxHeight(), newHeight));
            } else {
                newHeight = currCompBounds.height;
            }
            if ((lData.getAction() & 2) == 2) {
                newX = this.getNewX(lData.getOrigBounds());
                newX = !noMinX ? Math.max(lData.getOrigBounds().x, newX) : Math.max(0, newX);
            } else {
                newX = currCompBounds.x;
            }
            if ((lData.getAction() & 0x20) == 32) {
                newY = this.getNewY(lData.getOrigBounds());
                newY = !noMinY ? Math.max(lData.getOrigBounds().y, newY) : Math.max(0, newY);
            } else {
                newY = currCompBounds.y;
            }
            if (newWidth == currCompBounds.width && newHeight == currCompBounds.height && newX == currCompBounds.x && newY == currCompBounds.y) continue;
            comp.setBounds(newX, newY, newWidth, newHeight);
        }
    }

    @Override
    public void removeLayoutComponent(Component c) {
        this.constraintsTable.remove(c);
    }

    public void addLayoutComponent(Component comp, LayoutData data) {
        if (data == null) {
            data = this.createLayoutData(comp, 0, 1, 0, 1, "0", null);
        }
        this.constraintsTable.put(comp, data);
    }

    public LayoutData getLayoutData(Component comp) {
        return this.constraintsTable.get(comp);
    }

    public Dimension getOriginalContainerSize() {
        return this.origContainerSize;
    }

    public void setOriginalContainerSize(Dimension d) {
        if (d != null && d.width > 0 && d.height > 0) {
            this.origContainerSize = d;
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints == null) {
            constraints = this.createLayoutData(comp, 0, 1, 0, 1, "0", null);
        }
        if (!(constraints instanceof LayoutData)) {
            throw new IllegalArgumentException("LayoutData object required.");
        }
        this.constraintsTable.put(comp, (LayoutData)constraints);
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.addLayoutComponent(comp, null);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Component[] comps = container.getComponents();
        int maxW = 0;
        int maxH = 0;
        for (int i = 0; i < comps.length; ++i) {
            Rectangle bds = comps[i].getBounds();
            maxW = Math.max(maxW, bds.x + bds.width);
            maxH = Math.max(maxH, bds.y + bds.height);
        }
        Dimension Return2 = new Dimension(maxW, maxH);
        return Return2;
    }

    public LayoutData createLayoutData(Component comp, int maxWidth, int minWidth, int maxHeight, int minHeight, String ld, String controlType) {
        return new DefaultLayoutData(comp, maxWidth, minWidth, maxHeight, minHeight, ld);
    }

    public boolean hasDefaultLayoutData(String controlType) {
        return false;
    }

    public String getDefaultLayoutDataString(String controlType) {
        return "0";
    }

    public int getAction(String ldString) {
        try {
            return Integer.parseInt(ldString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static class DefaultLayoutData
    implements LayoutData {
        private int minHeight;
        private int maxHeight;
        private int minWidth;
        private int maxWidth;
        private Rectangle origBounds;
        private int action;

        public DefaultLayoutData(Component comp, int maxWidth, int minWidth, int maxHeight, int minHeight, String ldString) {
            this(comp, maxWidth, minWidth, maxHeight, minHeight, ldString, null);
        }

        public DefaultLayoutData(Component comp, int maxWidth, int minWidth, int maxHeight, int minHeight, String ldString, String controltype) {
            this.origBounds = comp.getBounds();
            if (this.origBounds.width <= 0) {
                this.origBounds.width = comp.getPreferredSize().width;
            }
            if (this.origBounds.height <= 0) {
                this.origBounds.height = comp.getPreferredSize().height;
            }
            this.maxWidth = maxWidth <= 0 ? 1000000 : maxWidth;
            this.minWidth = minWidth < 1 ? 1 : minWidth;
            if (this.maxWidth < this.minWidth) {
                this.maxWidth = this.minWidth;
            }
            this.maxHeight = maxHeight <= 0 ? 1000000 : maxHeight;
            this.minHeight = minHeight < 1 ? 1 : minHeight;
            if (this.maxHeight < this.minHeight) {
                this.maxHeight = this.minHeight;
            }
            this.initialize(ldString, controltype);
        }

        @Override
        public int getMinHeight() {
            return this.minHeight;
        }

        @Override
        public int getMaxHeight() {
            return this.maxHeight;
        }

        @Override
        public int getMinWidth() {
            return this.minWidth;
        }

        @Override
        public int getMaxWidth() {
            return this.maxWidth;
        }

        @Override
        public Rectangle getOrigBounds() {
            return this.origBounds != null ? new Rectangle(this.origBounds) : null;
        }

        @Override
        public int getAction() {
            return this.action;
        }

        @Override
        public void setMinHeight(int minHeight) {
            this.minHeight = minHeight;
        }

        @Override
        public void setMaxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public void setMinWidth(int minWidth) {
            this.minWidth = minWidth;
        }

        @Override
        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public void setOrigBounds(Rectangle origBounds) {
            if (origBounds != null) {
                this.origBounds = new Rectangle(origBounds);
            }
        }

        @Override
        public void setAction(int action) {
            this.action = action;
        }

        @Override
        public void setOrigLocation(int x, int y) {
            this.origBounds.x = x;
            this.origBounds.y = y;
        }

        @Override
        public void initialize(String ldString, String controltype) {
            try {
                this.setAction(Integer.parseInt(ldString));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static interface LayoutData {
        public int getMinHeight();

        public int getMaxHeight();

        public int getMinWidth();

        public int getMaxWidth();

        public Rectangle getOrigBounds();

        public int getAction();

        public void setMinHeight(int var1);

        public void setMaxHeight(int var1);

        public void setMinWidth(int var1);

        public void setMaxWidth(int var1);

        public void setOrigBounds(Rectangle var1);

        public void setAction(int var1);

        public void setOrigLocation(int var1, int var2);

        public void initialize(String var1, String var2);
    }
}

