/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.tree;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.interfaces.debugger.ITree;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Tree
implements ITree,
DataExternalizable {
    private static final long serialVersionUID = 1000006L;
    private TreeNode root;
    private boolean hex;
    private String className;

    public Tree() {
    }

    public Tree(TreeNode root, boolean hex) {
        this.root = root;
        this.hex = hex;
    }

    @Override
    public TreeNode getRoot() {
        return this.root;
    }

    @Override
    public boolean isHex() {
        return this.hex;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String toString() {
        return this.root.toString();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        this.root.writeExternal(out);
        out.writeBoolean(this.hex);
        RtsUtil.writeUTFOptmz(this.className, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.root = new TreeNode();
        this.root.readExternal(in);
        this.hex = in.readBoolean();
        this.className = RtsUtil.readUTFOptmz(in);
    }
}

