/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.AbstractSettingsDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SessionSettingsDialog
extends AbstractSettingsDialog {
    private static final long serialVersionUID = 1L;
    private JCheckBox autoSaveChk;
    private JCheckBox confirmExitChk;
    private JCheckBox confirmQuitChk;
    private JCheckBox autoConnectChk;
    private JCheckBox forceStopRunChk;
    private JCheckBox exitAfterTermChk;
    private JSpinner autoConnectSpn;
    private JLabel autoConnectDelayLbl;
    private JLabel autoConnectSecLbl;
    private JTextField customFileNameTxt;
    private JRadioButton defFileNameRb;
    private JRadioButton customFileNameRb;

    public SessionSettingsDialog(JFrame parent, String title, boolean modal) {
        super(parent, title, modal);
    }

    @Override
    protected void createContents(JPanel mainPanel) {
        boolean autoSave = Settings.getAutosave();
        boolean confirmExit = Settings.getAskConfirmWhenExit();
        boolean confirmQuit = Settings.getAskConfirmWhenQuit();
        boolean exitAfterTerm = Settings.getExitAfterTermination();
        boolean autoConnect = Settings.getAutoConnect();
        int autoConnectDelay = Settings.getAutoConnectDelay();
        boolean forceStopRun = Settings.getForceStopRun();
        String filename = Settings.getSessionOutputFileName();
        LMResize layout = new LMResize(10, 10, 5, 0);
        mainPanel.setLayout(layout);
        this.autoSaveChk = new JCheckBox("Save session automatically");
        this.autoSaveChk.setSelected(autoSave);
        Dimension d = layout.getPreferredSize(this.autoSaveChk);
        this.autoSaveChk.setBounds(10, 10, d.width, d.height);
        mainPanel.add(this.autoSaveChk);
        this.exitAfterTermChk = new JCheckBox("Exit after program termination");
        this.exitAfterTermChk.setSelected(exitAfterTerm);
        this.confirmQuitChk = new JCheckBox("Ask confirm when finish session");
        this.confirmQuitChk.setSelected(confirmQuit);
        this.confirmExitChk = new JCheckBox("Ask confirm when exit");
        this.confirmExitChk.setSelected(confirmExit);
        JPanel saveSessionPanel = new JPanel();
        LMResize savePanelLayout = new LMResize(10, 10, 5, 0);
        saveSessionPanel.setLayout(savePanelLayout);
        saveSessionPanel.setBorder(BorderFactory.createTitledBorder("Session output file name"));
        ButtonGroup grp = new ButtonGroup();
        this.defFileNameRb = new JRadioButton("Automatic: <PROGRAMNAME>.isd");
        grp.add(this.defFileNameRb);
        this.defFileNameRb.setSelected(filename.length() == 0);
        d = savePanelLayout.getPreferredSize(this.defFileNameRb);
        this.defFileNameRb.setBounds(10, 20, d.width, d.height);
        saveSessionPanel.add(this.defFileNameRb);
        this.customFileNameRb = new JRadioButton("Custom:");
        grp.add(this.customFileNameRb);
        this.customFileNameRb.setSelected(filename.length() > 0);
        d = savePanelLayout.getPreferredSize(this.customFileNameRb);
        this.customFileNameRb.setBounds(LMResize.getLeft(this.defFileNameRb), LMResize.getBottom(this.defFileNameRb) + 10, d.width, d.height);
        saveSessionPanel.add(this.customFileNameRb);
        this.customFileNameTxt = new JTextField();
        this.customFileNameTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.customFileNameTxt));
        this.customFileNameTxt.setText(filename);
        this.customFileNameTxt.setEnabled(filename.length() > 0);
        d = savePanelLayout.getPreferredSize(this.customFileNameTxt);
        this.customFileNameTxt.setBounds(LMResize.getRight(this.customFileNameRb) + 5, LMResize.getTop(this.customFileNameRb), 200, d.height);
        saveSessionPanel.add((Component)this.customFileNameTxt, new LMResizeData(1));
        d = savePanelLayout.preferredLayoutSize(saveSessionPanel);
        saveSessionPanel.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(this.autoSaveChk) + 10, d.width, d.height);
        mainPanel.add((Component)saveSessionPanel, new LMResizeData(1));
        JPanel remoteSessionPanel = new JPanel();
        LMResize remotePanelLayout = new LMResize(10, 10, 5, 0);
        remoteSessionPanel.setLayout(remotePanelLayout);
        remoteSessionPanel.setBorder(BorderFactory.createTitledBorder("Remote session"));
        this.autoConnectChk = new JCheckBox("Auto Connect");
        this.autoConnectChk.setSelected(autoConnect);
        d = remotePanelLayout.getPreferredSize(this.autoConnectChk);
        this.autoConnectChk.setBounds(10, 20, d.width, d.height);
        remoteSessionPanel.add(this.autoConnectChk);
        this.autoConnectDelayLbl = new JLabel("Delay:");
        d = remotePanelLayout.getPreferredSize(this.autoConnectDelayLbl);
        this.autoConnectDelayLbl.setBounds(LMResize.getRight(this.autoConnectChk) + 10, LMResize.getTop(this.autoConnectChk) + 4, d.width, d.height);
        remoteSessionPanel.add(this.autoConnectDelayLbl);
        this.autoConnectSpn = new JSpinner(new SpinnerNumberModel(autoConnectDelay, 1, 10, 1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.autoConnectSpn);
        this.autoConnectSpn.setEditor(editor);
        editor.getTextField().setEditable(false);
        d = remotePanelLayout.getPreferredSize(this.autoConnectSpn);
        this.autoConnectSpn.setBounds(LMResize.getRight(this.autoConnectDelayLbl) + 5, LMResize.getTop(this.autoConnectDelayLbl), 70, d.height);
        remoteSessionPanel.add(this.autoConnectSpn);
        this.autoConnectSecLbl = new JLabel("seconds");
        d = remotePanelLayout.getPreferredSize(this.autoConnectSecLbl);
        this.autoConnectSecLbl.setBounds(LMResize.getRight(this.autoConnectSpn) + 5, LMResize.getTop(this.autoConnectDelayLbl), d.width, d.height);
        remoteSessionPanel.add(this.autoConnectSecLbl);
        this.forceStopRunChk = new JCheckBox("Force STOP RUN after disconnect");
        this.forceStopRunChk.setSelected(forceStopRun);
        d = remotePanelLayout.getPreferredSize(this.forceStopRunChk);
        this.forceStopRunChk.setBounds(LMResize.getLeft(this.autoConnectChk), LMResize.getBottom(this.autoConnectChk) + 10, d.width, d.height);
        remoteSessionPanel.add(this.forceStopRunChk);
        d = remotePanelLayout.preferredLayoutSize(remoteSessionPanel);
        remoteSessionPanel.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(saveSessionPanel) + 10, saveSessionPanel.getSize().width, d.height);
        mainPanel.add((Component)remoteSessionPanel, new LMResizeData(1));
        d = layout.getPreferredSize(this.exitAfterTermChk);
        this.exitAfterTermChk.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(remoteSessionPanel) + 10, d.width, d.height);
        mainPanel.add(this.exitAfterTermChk);
        d = layout.getPreferredSize(this.confirmQuitChk);
        this.confirmQuitChk.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(this.exitAfterTermChk) + 10, d.width, d.height);
        mainPanel.add(this.confirmQuitChk);
        d = layout.getPreferredSize(this.confirmExitChk);
        this.confirmExitChk.setBounds(LMResize.getLeft(this.autoSaveChk), LMResize.getBottom(this.confirmQuitChk) + 10, d.width, d.height);
        mainPanel.add(this.confirmExitChk);
        ActionListener actionListener = e -> this.setDirty(true);
        this.autoSaveChk.addActionListener(actionListener);
        this.autoConnectChk.addActionListener(actionListener);
        this.exitAfterTermChk.addActionListener(actionListener);
        this.confirmQuitChk.addActionListener(actionListener);
        this.confirmExitChk.addActionListener(actionListener);
        this.forceStopRunChk.addActionListener(actionListener);
        this.defFileNameRb.addActionListener(e -> {
            this.customFileNameTxt.setEnabled(false);
            this.setDirty(true);
        });
        this.customFileNameRb.addActionListener(e -> {
            this.customFileNameTxt.setEnabled(true);
            this.setDirty(true);
        });
        this.customFileNameTxt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SessionSettingsDialog.this.setDirty(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SessionSettingsDialog.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.autoConnectSpn.addChangeListener(e -> this.setDirty(true));
    }

    @Override
    protected void performApply() {
        Settings.setAutosave(this.autoSaveChk.isSelected());
        String filename = "";
        if (this.customFileNameRb.isSelected()) {
            filename = this.customFileNameTxt.getText().trim();
        }
        if (filename.length() > 0 && filename.lastIndexOf(46) < 0) {
            filename = filename + ".isd";
        }
        Settings.setSessionOutputFileName(filename);
        Settings.setAutoConnect(this.autoConnectChk.isSelected());
        Settings.setAutoConnectDelay((Integer)this.autoConnectSpn.getValue());
        Settings.setExitAfterTermination(this.exitAfterTermChk.isSelected());
        Settings.setAskConfirmWhenQuit(this.confirmQuitChk.isSelected());
        Settings.setAskConfirmWhenExit(this.confirmExitChk.isSelected());
        Settings.setForceStopRun(this.forceStopRunChk.isSelected());
        super.performApply();
    }
}

