/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class BreakpointDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private static final int LINE = 0;
    private static final int PARAGRAPH = 1;
    private static final int PROGRAM = 2;
    private static final int METHOD = 3;
    private ButtonGroup radioGroup = new ButtonGroup();
    private JRadioButton lineRadio;
    private JRadioButton paragraphRadio;
    private JRadioButton programRadio;
    private JRadioButton methodRadio;
    private JTextField lineTxt;
    private JTextField paragraphTxt;
    private JTextField fileTxt;
    private JTextField programTxt;
    private JTextField program2Txt;
    private JTextField methodTxt;
    private JLabel fileLbl;
    private JLabel program2Lbl;
    private JCheckBox enableChk;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel conditionPanel;
    private JCheckBox enableCondChk;
    private JCheckBox envChk;
    private JCheckBox hexChk;
    private JTextArea conditionTxt;
    private JScrollPane conditionTxtSp;
    private Breakpoint breakpoint;
    private int type = 0;

    public BreakpointDialog(JFrame parent, String title, Breakpoint bp, boolean debugIsRunning) {
        super(parent, title, true);
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.okButton = new JButton("Set");
        this.okButton.setMnemonic('s');
        this.okButton.addActionListener(e -> {
            try {
                this.makeString();
                this.closeDialog();
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(this, e1.getMessage(), "Set Breakpoint", 0);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('c');
        this.cancelButton.addActionListener(e -> this.closeDialog());
        LMResize optionPanelLayout = new LMResize(5, 5, 5, 0);
        JPanel optionPanel = new JPanel(optionPanelLayout);
        optionPanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        LMResize filePanelLayout = new LMResize(5, 5, 5, 0);
        JPanel filePanel = new JPanel(filePanelLayout);
        filePanel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.lineRadio = new JRadioButton("Line");
        this.lineRadio.setMnemonic('l');
        this.radioGroup.add(this.lineRadio);
        this.lineTxt = new JTextField();
        this.lineTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.lineTxt));
        this.lineTxt.setHorizontalAlignment(4);
        this.paragraphRadio = new JRadioButton("Paragraph");
        this.paragraphRadio.setMnemonic('p');
        this.radioGroup.add(this.paragraphRadio);
        this.paragraphTxt = new JTextField();
        this.paragraphTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.paragraphTxt));
        this.programRadio = new JRadioButton("Program");
        this.programRadio.setMnemonic('r');
        this.radioGroup.add(this.programRadio);
        this.programTxt = new JTextField();
        this.programTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.programTxt));
        this.methodRadio = new JRadioButton("Method");
        this.methodRadio.setMnemonic('m');
        this.radioGroup.add(this.methodRadio);
        this.methodTxt = new JTextField();
        this.methodTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.methodTxt));
        Dimension d = optionPanelLayout.getPreferredSize(this.lineRadio);
        this.lineRadio.setBounds(10, 10, d.width, d.height);
        optionPanel.add(this.lineRadio);
        d = optionPanelLayout.getPreferredSize(this.paragraphRadio);
        this.paragraphRadio.setBounds(LMResize.getLeft(this.lineRadio), LMResize.getBottom(this.lineRadio) + 10, d.width, d.height);
        optionPanel.add(this.paragraphRadio);
        d = optionPanelLayout.getPreferredSize(this.programRadio);
        this.programRadio.setBounds(LMResize.getLeft(this.lineRadio), LMResize.getBottom(this.paragraphRadio) + 10, d.width, d.height);
        optionPanel.add(this.programRadio);
        d = optionPanelLayout.getPreferredSize(this.methodRadio);
        this.methodRadio.setBounds(LMResize.getLeft(this.lineRadio), LMResize.getBottom(this.programRadio) + 10, d.width, d.height);
        optionPanel.add(this.methodRadio);
        this.paragraphTxt.setBounds(LMResize.getRight(this.paragraphRadio) + 10, LMResize.getTop(this.paragraphRadio), 300, this.paragraphTxt.getPreferredSize().height);
        optionPanel.add((Component)this.paragraphTxt, new LMResizeData(1));
        this.lineTxt.setBounds(LMResize.getLeft(this.paragraphTxt), LMResize.getTop(this.lineRadio), 300, this.lineTxt.getPreferredSize().height);
        optionPanel.add((Component)this.lineTxt, new LMResizeData(1));
        this.programTxt.setBounds(LMResize.getLeft(this.paragraphTxt), LMResize.getTop(this.programRadio), 300, this.programTxt.getPreferredSize().height);
        optionPanel.add((Component)this.programTxt, new LMResizeData(1));
        this.methodTxt.setBounds(LMResize.getLeft(this.paragraphTxt), LMResize.getTop(this.methodRadio), 300, this.methodTxt.getPreferredSize().height);
        optionPanel.add((Component)this.methodTxt, new LMResizeData(1));
        this.fileLbl = new JLabel("File name:");
        this.fileTxt = new JTextField();
        this.fileTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.fileTxt));
        this.program2Lbl = new JLabel("Program name:");
        this.program2Txt = new JTextField();
        this.program2Txt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.program2Txt));
        d = filePanelLayout.getPreferredSize(this.fileLbl);
        this.fileLbl.setBounds(10, 10, d.width, d.height);
        filePanel.add(this.fileLbl);
        this.fileTxt.setBounds(LMResize.getLeft(this.paragraphTxt), LMResize.getTop(this.fileLbl), 300, this.fileTxt.getPreferredSize().height);
        filePanel.add((Component)this.fileTxt, new LMResizeData(1));
        d = filePanelLayout.getPreferredSize(this.program2Lbl);
        this.program2Lbl.setBounds(LMResize.getLeft(this.fileLbl), LMResize.getBottom(this.fileLbl) + 10, d.width, d.height);
        filePanel.add(this.program2Lbl);
        this.program2Txt.setBounds(LMResize.getLeft(this.paragraphTxt), LMResize.getTop(this.program2Lbl), 300, this.program2Txt.getPreferredSize().height);
        filePanel.add((Component)this.program2Txt, new LMResizeData(1));
        this.enableChk = new JCheckBox("Enabled");
        this.enableChk.setMnemonic('e');
        this.enableChk.setSelected(true);
        d = layout.getPreferredSize(this.enableChk);
        this.enableChk.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(this.enableChk);
        d = optionPanelLayout.preferredLayoutSize(optionPanel);
        optionPanel.setBounds(LMResize.getLeft(this.enableChk), LMResize.getBottom(this.enableChk) + 10, d.width, d.height);
        this.getContentPane().add((Component)optionPanel, new LMResizeData(1));
        d = filePanelLayout.preferredLayoutSize(filePanel);
        filePanel.setBounds(LMResize.getLeft(this.enableChk), LMResize.getBottom(optionPanel) + 5, d.width, d.height);
        this.getContentPane().add((Component)filePanel, new LMResizeData(1));
        this.enableCondChk = new JCheckBox();
        this.enableCondChk.setMargin(new Insets(0, 0, 0, 0));
        this.enableCondChk.setMnemonic('n');
        d = layout.getPreferredSize(this.enableCondChk);
        this.enableCondChk.setBounds(LMResize.getLeft(this.enableChk), LMResize.getBottom(filePanel) + 10, d.width, d.height);
        this.getContentPane().add(this.enableCondChk);
        this.radioGroup.setSelected(this.lineRadio.getModel(), true);
        LMResize conditionLayout = new LMResize(5, 5, 5, 0);
        this.conditionPanel = new JPanel(conditionLayout);
        this.envChk = new JCheckBox("Environment name");
        this.envChk.setMnemonic('v');
        this.hexChk = new JCheckBox("Hexadecimal");
        this.hexChk.setMnemonic('h');
        this.conditionTxt = new JTextArea(5, 1);
        this.conditionTxt.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.conditionTxt));
        this.conditionTxtSp = new JScrollPane(this.conditionTxt, 20, 30);
        this.conditionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), "Condition"));
        this.setConditionPanelEnabled(false);
        d = conditionLayout.getPreferredSize(this.envChk);
        this.envChk.setBounds(10, 20, d.width, d.height);
        this.conditionPanel.add(this.envChk);
        d = conditionLayout.getPreferredSize(this.hexChk);
        this.hexChk.setBounds(LMResize.getRight(this.envChk) + 10, LMResize.getTop(this.envChk), d.width, d.height);
        this.conditionPanel.add(this.hexChk);
        int w = LMResize.getRight(this.paragraphTxt) - LMResize.getRight(this.enableCondChk);
        this.conditionTxtSp.setBounds(LMResize.getLeft(this.envChk), LMResize.getBottom(this.envChk) + 10, w, 100);
        this.conditionPanel.add((Component)this.conditionTxtSp, new LMResizeData(5));
        d = conditionLayout.preferredLayoutSize(this.conditionPanel);
        int l = LMResize.getRight(this.enableCondChk);
        this.conditionPanel.setBounds(l, LMResize.getTop(this.enableCondChk), LMResize.getRight(filePanel) - l + 2, d.height);
        this.getContentPane().add((Component)this.conditionPanel, new LMResizeData(5));
        d = layout.getPreferredSize(this.cancelButton);
        this.cancelButton.setBounds(LMResize.getRight(this.conditionPanel) - d.width, LMResize.getBottom(this.conditionPanel) + 10, d.width, d.height);
        this.getContentPane().add((Component)this.cancelButton, new LMResizeData(10));
        this.okButton.setBounds(LMResize.getLeft(this.cancelButton) - 15 - d.width, LMResize.getTop(this.cancelButton), d.width, d.height);
        this.getContentPane().add((Component)this.okButton, new LMResizeData(10));
        this.hexChk.setEnabled(debugIsRunning);
        this.envChk.setSelected(!debugIsRunning);
        this.envChk.setEnabled(debugIsRunning);
        if (bp != null) {
            this.breakpoint = bp;
            this.enableChk.setSelected(bp.isEnabled());
            if (bp.getParagraph() != null) {
                this.paragraphRadio.setSelected(true);
                this.paragraphTxt.setText(bp.getParagraph());
                this.type = 1;
            } else {
                this.lineRadio.setSelected(true);
                this.lineTxt.setText("" + bp.getLine());
                this.type = 0;
            }
            if (bp.getFile() != null) {
                this.fileTxt.setText(bp.getFile());
                if (bp.getProgram() != null) {
                    this.program2Txt.setText(bp.getProgram());
                }
            }
            this.lineTxt.setEnabled(false);
            this.fileLbl.setEnabled(false);
            this.fileTxt.setEnabled(false);
            this.program2Lbl.setEnabled(false);
            this.program2Txt.setEnabled(false);
            this.paragraphTxt.setEnabled(false);
            this.programTxt.setEnabled(false);
            this.methodTxt.setEnabled(false);
            this.lineRadio.setEnabled(false);
            this.paragraphRadio.setEnabled(false);
            this.programRadio.setEnabled(false);
            this.methodRadio.setEnabled(false);
            if (bp.getCondition() != null) {
                Expression cond = bp.getCondition();
                this.enableCondChk.setSelected(true);
                this.setConditionPanelEnabled(true);
                this.conditionTxt.setText(cond.toString());
                this.conditionTxt.selectAll();
                if (cond.isEnvProperty() || cond.isHex()) {
                    if (cond.isEnvProperty()) {
                        this.envChk.setSelected(true);
                    }
                    if (cond.isHex()) {
                        this.hexChk.setSelected(true);
                    }
                }
            }
        } else {
            this.breakpoint = null;
            this.enableLineSettings();
            this.hexChk.setSelected(Settings.getHexOption());
            this.type = 0;
        }
        this.lineRadio.addActionListener(e -> {
            this.enableLineSettings();
            this.lineTxt.requestFocus();
            this.type = 0;
        });
        BreakpointDialog.setFirstFocusedComponent(this.lineTxt);
        this.paragraphRadio.addActionListener(e -> {
            this.enableParagraphSettings();
            this.paragraphTxt.requestFocus();
            this.type = 1;
        });
        this.programRadio.addActionListener(e -> {
            this.enableProgramSettings();
            this.programTxt.requestFocus();
            this.type = 2;
        });
        this.methodRadio.addActionListener(e -> {
            this.enableMethodSettings();
            this.methodTxt.requestFocus();
            this.type = 3;
        });
        this.envChk.addActionListener(e -> this.hexChk.setEnabled(!this.envChk.isSelected()));
        this.hexChk.addActionListener(e -> this.envChk.setEnabled(!this.hexChk.isSelected()));
        this.enableCondChk.addActionListener(e -> this.setConditionPanelEnabled(this.enableCondChk.isSelected()));
        this.pack();
        this.setDefaultButton(this.okButton);
    }

    private void setConditionPanelEnabled(boolean e) {
        this.conditionPanel.setEnabled(e);
        this.envChk.setEnabled(e);
        this.hexChk.setEnabled(e);
        this.conditionTxtSp.setEnabled(e);
        this.conditionTxt.setEnabled(e);
    }

    private void enableLineSettings() {
        this.lineTxt.setEnabled(true);
        this.fileLbl.setEnabled(true);
        this.fileTxt.setEnabled(true);
        this.program2Lbl.setEnabled(true);
        this.program2Txt.setEnabled(true);
        this.paragraphTxt.setEnabled(false);
        this.programTxt.setEnabled(false);
        this.methodTxt.setEnabled(false);
    }

    private void enableParagraphSettings() {
        this.lineTxt.setEnabled(false);
        this.fileLbl.setEnabled(true);
        this.fileTxt.setEnabled(true);
        this.program2Lbl.setEnabled(true);
        this.program2Txt.setEnabled(true);
        this.paragraphTxt.setEnabled(true);
        this.programTxt.setEnabled(false);
        this.methodTxt.setEnabled(false);
    }

    private void enableProgramSettings() {
        this.lineTxt.setEnabled(false);
        this.fileLbl.setEnabled(false);
        this.fileTxt.setEnabled(false);
        this.program2Lbl.setEnabled(false);
        this.program2Txt.setEnabled(false);
        this.paragraphTxt.setEnabled(false);
        this.programTxt.setEnabled(true);
        this.methodTxt.setEnabled(false);
    }

    private void enableMethodSettings() {
        this.lineTxt.setEnabled(false);
        this.fileLbl.setEnabled(false);
        this.fileTxt.setEnabled(false);
        this.program2Lbl.setEnabled(false);
        this.program2Txt.setEnabled(false);
        this.paragraphTxt.setEnabled(false);
        this.programTxt.setEnabled(false);
        this.methodTxt.setEnabled(true);
    }

    private void makeString() throws Exception {
        switch (this.type) {
            case 0: {
                String txt = this.lineTxt.getText();
                if (txt.length() > 0) {
                    this.commandString = "break";
                    if (!this.enableChk.isSelected()) {
                        this.commandString = this.commandString + " -d";
                    }
                    this.commandString = this.commandString + " " + txt;
                    if (this.fileTxt.getText().length() <= 0) break;
                    this.commandString = this.commandString + " \"" + this.fileTxt.getText() + "\"";
                    if (this.breakpoint != null && this.breakpoint.getFileIndex() >= 0) {
                        this.commandString = this.commandString + " -fi " + this.breakpoint.getFileIndex();
                    }
                    if (this.program2Txt.getText().length() <= 0) break;
                    this.commandString = this.commandString + " " + this.program2Txt.getText();
                    break;
                }
                this.commandString = null;
                break;
            }
            case 1: {
                String txt = this.paragraphTxt.getText();
                if (txt.length() > 0) {
                    this.commandString = "break";
                    if (!this.enableChk.isSelected()) {
                        this.commandString = this.commandString + " -d";
                    }
                    this.commandString = this.commandString + " " + txt;
                    if (this.fileTxt.getText().length() <= 0) break;
                    this.commandString = this.commandString + " \"" + this.fileTxt.getText() + "\"";
                    if (this.breakpoint != null && this.breakpoint.getFileIndex() >= 0) {
                        this.commandString = this.commandString + " -fi " + this.breakpoint.getFileIndex();
                    }
                    if (this.program2Txt.getText().length() <= 0) break;
                    this.commandString = this.commandString + " " + this.program2Txt.getText();
                    break;
                }
                this.commandString = null;
                break;
            }
            case 2: {
                String txt = this.programTxt.getText();
                if (txt.length() > 0) {
                    this.commandString = "b0";
                    if (!this.enableChk.isSelected()) {
                        this.commandString = this.commandString + " -d";
                    }
                    this.commandString = this.commandString + " " + txt;
                    break;
                }
                this.commandString = null;
                break;
            }
            case 3: {
                String txt = this.methodTxt.getText();
                if (txt.length() > 0) {
                    this.commandString = "m0";
                    if (!this.enableChk.isSelected()) {
                        this.commandString = this.commandString + " -d";
                    }
                    this.commandString = this.commandString + " " + txt;
                    break;
                }
                this.commandString = null;
            }
        }
        if (this.enableCondChk.isSelected()) {
            if (this.conditionTxt.getText().length() == 0) {
                this.commandString = null;
                throw new Exception("The condition field cannot be empty");
            }
            this.commandString = this.commandString + " when";
            if (this.envChk.isSelected() && this.envChk.isEnabled()) {
                this.commandString = this.commandString + " -env " + this.conditionTxt.getText();
            } else {
                if (this.hexChk.isSelected()) {
                    this.commandString = this.commandString + " -x";
                }
                this.commandString = this.commandString + " " + this.conditionTxt.getText();
            }
        }
    }
}

