/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.VarName;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.interfaces.debugger.IVariableCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DisplayCommand
implements DebugCommand,
IVariableCommand {
    private static final long serialVersionUID = 1000006L;
    public static final int ID = 5;
    public static final String SHORT_DESCRIPTION = " : display value of variable (-x display in base 16)";
    public static final String STRING_ID = "display";
    public static final String HELP_PAGE = "display.html";
    public static final String USAGE = "usage:" + eol + "   display [" + "-tree" + "] [" + "-x" + "] [-c class-name[:>method-name]] variable-name" + eol + "or display [-c class-name[:>method-name]] control-name|control-handle|window-handle " + "prop" + "|" + "property" + " property-name" + eol + "or display " + "-env" + " env-name" + eol + "or display " + "-classinfo";
    public static final short SHOW_CHILDREN_DISABLED = 0;
    public static final short SHOW_CHILDREN_1_LEVEL = 1;
    public static final short SHOW_CHILDREN_ALL = 2;
    private VarName varname;
    private String propertyName;
    private boolean showHex;
    private boolean showText;
    private short showChildren = (short)2;
    private boolean tree;
    private boolean deferredIfNotRunning;
    private boolean displayClassInfo;
    private String envName;
    private String className;

    public DisplayCommand() {
    }

    public DisplayCommand(boolean displayClassInfo) {
        this.displayClassInfo = displayClassInfo;
    }

    public DisplayCommand(VarName vn, String className, boolean showHex, boolean tree) {
        this(vn, className, showHex, tree, 2);
    }

    public DisplayCommand(VarName vn, String className, boolean showHex, boolean tree, short showChildren) {
        this(vn, className, showHex);
        this.tree = tree;
        this.showChildren = showChildren;
    }

    public DisplayCommand(VarName vn, String className, String propName) {
        this.varname = vn;
        this.propertyName = propName;
        this.className = className;
    }

    public DisplayCommand(VarName vn, String className, boolean hex) {
        this.varname = vn;
        this.showHex = hex;
        this.className = className;
    }

    public DisplayCommand(String envProp) {
        this.envName = envProp;
    }

    @Override
    public VarName getVarName() {
        return this.varname;
    }

    public String getEnvName() {
        return this.envName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean displayAsHex() {
        return this.showHex;
    }

    public void setDisplayAsText(boolean set) {
        this.showText = set;
    }

    public boolean displayAsText() {
        return this.showText;
    }

    public short getShowChildren() {
        return this.showChildren;
    }

    public void setShowChildren(short s) {
        this.showChildren = s;
    }

    public void setDisplayAsHex(boolean set) {
        this.showHex = set;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public boolean displayAsTree() {
        return this.tree;
    }

    public boolean displayClassInfo() {
        return this.displayClassInfo;
    }

    public boolean isDeferredIfNotRunning() {
        return this.deferredIfNotRunning;
    }

    public void setDeferredIfNotRunning(boolean deferredIfNotRunning) {
        this.deferredIfNotRunning = deferredIfNotRunning;
    }

    @Override
    public int getId() {
        return 5;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.displayClassInfo);
        if (!this.displayClassInfo) {
            out.writeBoolean(this.varname != null);
            if (this.varname != null) {
                this.varname.writeExternal(out);
            }
            RtsUtil.writeUTFOptmz(this.propertyName, out);
            RtsUtil.writeUTFOptmz(this.envName, out);
            out.writeBoolean(this.showHex);
            out.writeBoolean(this.showText);
            out.writeBoolean(this.tree);
            out.writeBoolean(this.deferredIfNotRunning);
            out.writeShort(this.showChildren);
            RtsUtil.writeUTFOptmz(this.className, out);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.displayClassInfo = in.readBoolean();
        if (!this.displayClassInfo) {
            if (in.readBoolean()) {
                this.varname = new VarName();
                this.varname.readExternal(in);
            } else {
                this.varname = null;
            }
            this.propertyName = RtsUtil.readUTFOptmz(in);
            this.envName = RtsUtil.readUTFOptmz(in);
            this.showHex = in.readBoolean();
            this.showText = in.readBoolean();
            this.tree = in.readBoolean();
            this.deferredIfNotRunning = in.readBoolean();
            this.showChildren = in.readShort();
            this.className = RtsUtil.readUTFOptmz(in);
        }
    }
}

