/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.interfaces.debugger.IThreadObject;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ThreadObject
implements IThreadObject,
DataExternalizable {
    private static final long serialVersionUID = 1000006L;
    private static int threadProg = 1;
    private static int javaThreadProg = 100001;
    private String name;
    private String description;
    private int id;
    private ParagraphObject[] parStack;
    private transient Thread thread;

    public ThreadObject() {
    }

    private ThreadObject(Thread tr, int id) {
        this.thread = tr;
        this.name = tr != null ? tr.getName() : Thread.currentThread().getName();
        this.id = id;
    }

    public String toString() {
        return this.name + (this.description != null ? ": " + this.description : "");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ThreadObject)) {
            return false;
        }
        return ((ThreadObject)o).id == this.id;
    }

    public int compareTo(Object o) {
        if (!(o instanceof ThreadObject)) {
            throw new ClassCastException();
        }
        ThreadObject to = (ThreadObject)o;
        return this.id - to.id;
    }

    public static ThreadObject getJavaThreadObject(Thread tr) {
        return new ThreadObject(tr, javaThreadProg++);
    }

    public static ThreadObject getIscobolThreadObject(Thread tr) {
        return new ThreadObject(tr, threadProg++);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String d) {
        this.description = d;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setThread() {
        this.thread = Thread.currentThread();
        this.name = this.thread.getName();
    }

    @Override
    public boolean isAlive() {
        return this.thread == null || this.thread.isAlive();
    }

    public void setParStack(ParagraphObject[] ps) {
        this.parStack = ps;
    }

    public ParagraphObject[] getParStack() {
        return this.parStack;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Thread getThread() {
        return this.thread;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.name, out);
        RtsUtil.writeUTFOptmz(this.description, out);
        out.writeInt(this.id);
        if (this.parStack != null) {
            out.writeInt(this.parStack.length);
            for (ParagraphObject p : this.parStack) {
                p.writeExternal(out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.name = RtsUtil.readUTFOptmz(in);
        this.description = RtsUtil.readUTFOptmz(in);
        this.id = in.readInt();
        this.parStack = new ParagraphObject[in.readInt()];
        for (int i = 0; i < this.parStack.length; ++i) {
            this.parStack[i] = new ParagraphObject();
            this.parStack[i].readExternal(in);
        }
    }
}

