/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.interfaces.debugger.IParagraphObjectExtension2;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ParagraphObject
implements IParagraphObjectExtension2,
DataExternalizable {
    private static final long serialVersionUID = 1000006L;
    private String filename;
    private String parName;
    private String progName;
    private String methName;
    private String entryPointName;
    private int lineNumber;
    private int fileIndex;
    private boolean isLastPar;
    private boolean declaratives;
    private String progClassLocation;
    private int paragraphNumber;
    private transient int progStackSize;
    private transient int methStackSize;
    private transient Object method;
    private transient Object prog;
    private transient Class progClass;
    private transient String parentSection;

    public ParagraphObject() {
    }

    public ParagraphObject(String file, int fileIndex, String paragraphName, boolean isLastPar, Class programClass, Object program, String programClassLoc, Object method, String methodName, int programStackSize, int methodStackSize, int lineNumber, boolean declaratives, int paragraphNumber) {
        this.filename = file;
        this.fileIndex = fileIndex;
        this.parName = paragraphName;
        this.prog = program;
        this.isLastPar = isLastPar;
        this.progClass = programClass;
        this.progName = programClass.getName();
        this.progClassLocation = programClassLoc;
        this.method = method;
        this.lineNumber = lineNumber;
        this.methName = methodName;
        this.progStackSize = programStackSize;
        this.methStackSize = methodStackSize;
        this.declaratives = declaratives;
        this.paragraphNumber = paragraphNumber;
    }

    @Override
    public int getParagraphNumber() {
        return this.paragraphNumber;
    }

    @Override
    public boolean isDeclaratives() {
        return this.declaratives;
    }

    public int getProgStackSize() {
        return this.progStackSize;
    }

    public int getMethStackSize() {
        return this.methStackSize;
    }

    @Override
    public boolean isLastPar() {
        return this.isLastPar;
    }

    @Override
    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    @Override
    public int getLine() {
        return this.lineNumber;
    }

    public void setLine(int l) {
        this.lineNumber = l;
    }

    @Override
    public String getName() {
        return this.parName;
    }

    @Override
    public String getFile() {
        return this.filename;
    }

    public void setFile(String filename) {
        this.filename = filename;
    }

    @Override
    public String getProgName() {
        return this.progName;
    }

    @Override
    public String getMethodName() {
        return this.methName;
    }

    public Object getMethod() {
        return this.method;
    }

    public Object getProgram() {
        return this.prog;
    }

    public Class getProgClass() {
        return this.progClass;
    }

    public String getProgClassLocation() {
        return this.progClassLocation;
    }

    public String getParentSection() {
        return this.parentSection;
    }

    public void setParentSection(String parentSection) {
        this.parentSection = parentSection;
    }

    @Override
    public String getEntryPointName() {
        return this.entryPointName;
    }

    public void setEntryPointName(String entryPointName) {
        this.entryPointName = entryPointName;
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer();
        if (this.entryPointName != null) {
            Return2.append(this.entryPointName);
        } else {
            Return2.append(this.parName);
            if (this.parentSection != null) {
                Return2.append(" of ");
                Return2.append(this.parentSection);
            }
        }
        Return2.append("(");
        Return2.append(this.lineNumber);
        Return2.append(")");
        Return2.append(" [");
        Return2.append(this.progName);
        if (this.methName != null) {
            Return2.append(":>");
            Return2.append(this.methName);
        }
        Return2.append("]");
        return Return2.toString();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.parName, out);
        RtsUtil.writeUTFOptmz(this.filename, out);
        RtsUtil.writeUTFOptmz(this.progName, out);
        RtsUtil.writeUTFOptmz(this.methName, out);
        out.writeInt(this.lineNumber);
        out.writeInt(this.fileIndex);
        out.writeBoolean(this.declaratives);
        out.writeBoolean(this.isLastPar);
        out.writeInt(this.paragraphNumber);
        RtsUtil.writeUTFOptmz(this.progClassLocation, out);
        RtsUtil.writeUTFOptmz(this.entryPointName, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.parName = RtsUtil.readUTFOptmz(in);
        this.filename = RtsUtil.readUTFOptmz(in);
        this.progName = RtsUtil.readUTFOptmz(in);
        this.methName = RtsUtil.readUTFOptmz(in);
        this.lineNumber = in.readInt();
        this.fileIndex = in.readInt();
        this.declaratives = in.readBoolean();
        this.isLastPar = in.readBoolean();
        this.paragraphNumber = in.readInt();
        this.progClassLocation = RtsUtil.readUTFOptmz(in);
        this.entryPointName = RtsUtil.readUTFOptmz(in);
    }
}

