/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DataExternalizable;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EnvVarName
implements DataExternalizable,
Cloneable {
    private static final long serialVersionUID = 1000006L;
    private String name;

    EnvVarName() {
    }

    public EnvVarName(String name) {
        this.name = name;
    }

    public EnvVarName(DebugTM tm) throws DebuggerException {
        this.analyze(tm);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EnvVarName)) {
            return false;
        }
        EnvVarName vn = (EnvVarName)o;
        return this.getName().equals(vn.getName());
    }

    private void analyze(DebugTM tm) throws DebuggerException {
        String tk = tm.getToken();
        if (tk == null) {
            throw new DebuggerException(5);
        }
        this.name = tk;
        tk = tm.getAllToken();
        while (tk != null && tk.equals("*")) {
            this.name = this.name + tk;
            tk = tm.getAllToken();
            if (tk != null) {
                this.name = this.name + tk;
            }
            tk = tm.getAllToken();
        }
    }

    public String toString() {
        return this.name;
    }

    public EnvVarName Clone() {
        try {
            return (EnvVarName)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.name, out);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.name = RtsUtil.readUTFOptmz(in);
    }
}

