/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Function;
import com.iscobol.compiler.GuiWords;
import com.iscobol.compiler.OptionList;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.debugger.Breakpoint;
import com.iscobol.debugger.CobolRef;
import com.iscobol.debugger.DebugLine;
import com.iscobol.debugger.DebugOutputStream;
import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.LocalDebugInfo;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.Settings;
import com.iscobol.debugger.TextFile;
import com.iscobol.debugger.ThreadObject;
import com.iscobol.debugger.VarName;
import com.iscobol.debugger.Watch;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.DisplayCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.dialogs.FindDialog;
import com.iscobol.debugger.dialogs.treetable.model.BreakpointModel;
import com.iscobol.debugger.dialogs.treetable.model.CallStackModel;
import com.iscobol.debugger.dialogs.treetable.model.MonitorModel;
import com.iscobol.debugger.dialogs.treetable.model.ThreadModel;
import com.iscobol.debugger.dialogs.treetable.model.VariableModel;
import com.iscobol.debugger.dialogs.treetable.model.VariableNode;
import com.iscobol.debugger.tree.Tree;
import com.iscobol.debugger.tree.TreeNode;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.IsguiWorker;
import com.iscobol.gui.client.swing.treetable.JTreeTable;
import com.iscobol.interfaces.debugger.Appender;
import com.iscobol.rts.Config;
import com.iscobol.types.CobolVar;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class DebugPanel
extends JPanel {
    private static final long serialVersionUID = 123L;
    private static final Cursor BUSY_CURSOR;
    private static final Cursor HAND_CURSOR;
    private static final Cursor DEF_CURSOR;
    private static final Dimension BTN_SIZE;
    private static final int NUMBER_COLUMN_PAD = 2;
    private static final int IMG_WIDTH = 20;
    private static final int BREAKPOINT_IMG_HEIGHT = 9;
    private static final int CURR_LINE_IMG_HEIGHT = 12;
    private static final int EXP_COLL_IMG_HEIGHT = 16;
    static final int CURRENT = 0;
    static final int WATCHED = 1;
    private static final Set statements;
    private static final Set keywords;
    private static final Set guiwords;
    private static Font previewFont;
    private static Font previewLinkFont;
    private static int currentFontSize;
    private static FontMetrics previewMetrics;
    private static int numberColumnLen;
    private static int preferredPreviewWidth;
    private static Color sourceBackground;
    private static Color sourceForeground;
    private static Color highBackground;
    private static Color highForeground;
    private static Color selBackground;
    private static Color commentForeground;
    private static Color keywordForeground;
    private static Color stringForeground;
    private static Color numberForeground;
    private static Color stmtForeground;
    private static Color levnumForeground;
    private static Color figconsForeground;
    private static Color bpLineBackground;
    private static Color[] copySourcePatternColors;
    private static Color lineNumberBackground;
    private static Color lineNumberForeground;
    private static Color currLineBackground;
    private static Color bpColBackground;
    private static Font tipFont;
    private static Color tipBackground;
    private static Color tipForeground;
    private static Font perfStackFont;
    private static Color perfStackBackground;
    private static Color perfStackForeground;
    private static Color perfStackSelBackground;
    private static Color perfStackSelForeground;
    private static Font bpListFont;
    private static Color bpListBackground;
    private static Color bpListForeground;
    private static Color bpListSelBackground;
    private static Color bpListSelForeground;
    private static Font monListFont;
    private static Color monListBackground;
    private static Color monListForeground;
    private static Color monListSelBackground;
    private static Color monListSelForeground;
    private static Font cmdHistoryFont;
    private static Color cmdHistoryBackground;
    private static Color cmdHistoryForeground;
    private static Color cmdHistorySelBackground;
    private static Color cmdHistorySelForeground;
    private static Font consoleFont;
    private static Color consoleBackground;
    private static Color consoleForeground;
    private static Color consoleStdErrForeground;
    private static Color consoleSelBackground;
    private static Color consoleSelForeground;
    private static Font threadListFont;
    private static Color threadListBackground;
    private static Color threadListForeground;
    private static Font disTreeFont;
    private static Color disTreeBackground;
    private static Color disTreeForeground;
    private static Color disTreeSelBackground;
    private static Color disTreeSelForeground;
    private static Font outputFont;
    private static Color outputBackground;
    private static Color outputForeground;
    private static Color outputSelBackground;
    private static Color outputSelForeground;
    private static Font inputFont;
    private static Color inputBackground;
    private static Color inputForeground;
    private static Color inputSelBackground;
    private static Color inputSelForeground;
    private static Image breakpointImage;
    private static Image currlineImage;
    private static Image disbreakpointImage;
    private static Image expandCopyImage;
    private static Image collapseCopyImage;
    private static final String PERF_STACK_TITLE = "Perform stack";
    private static final String BREAKPOINTS_TITLE = "Breakpoints";
    private static final String THREADS_TITLE = "Threads";
    private static final String MONITORS_TITLE = "Monitors";
    private static final String COMMAND_HISTORY_TITLE = "Command history";
    private static final String CONSOLE_TITLE = "Console";
    private int lastPosForVarSearch = -1;
    private boolean lastVarSearchBackward;
    private GraphDebugger graphDebug;
    private String mainProgram;
    private Hashtable textFiles = new Hashtable();
    private FindDialog.FindParam fparam;
    private String highlightedWord;
    private String highlightedVar;
    private HighlightVarType highlightVarType = HighlightVarType.NONE;
    private int highlightedVarLine;
    private int highlightedVarCol;
    private TextFileObj tFileObj;
    private int sourceFormat = -1;
    private Popup tipPopup;
    private Timer tipTimer;
    private Timer handMouseTimer;
    private Timer linkTimer;
    private JToolBar toolbar;
    private JToolBar btnToolbar;
    private JButton btnRun;
    private JButton btnStepInto;
    private JButton btnOutPar;
    private JButton btnOutProg;
    private JButton btnNext;
    private JButton btnStepTo;
    private JButton btnStepToPgm;
    private JButton btnJump;
    private JButton btnJumpOutPar;
    private JButton btnJumpOutProg;
    private JButton btnJumpNext;
    private JButton btnFind;
    private JButton btnRepeatFind;
    private JButton btnGotoCurrLine;
    private JButton btnContinue;
    private JButton btnSuspend;
    private JButton btnStop;
    private JCheckBox btnAutoStep;
    private JLabel warnLbl = new JLabel();
    private JSpinner autoStepDelay;
    private final Hashtable nrw = new Hashtable();
    private boolean ccbas;
    private JComboBox fileChooser = new JComboBox(){
        private static final long serialVersionUID = 123L;
        {
            this.setToolTipText("");
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            Object i = this.getSelectedItem();
            if (i != null) {
                return i.toString();
            }
            return null;
        }
    };
    private List gotoList = new ArrayList();
    private int gotoIndex = -1;
    private JLabel variableLabel;
    private JTabbedPane variableTabbedPane;
    private JPanel outputArea;
    private JSplitPane topSplitPane;
    private int topSplitPaneDividerLocation;
    private int varSplitPaneDividerLocation;
    private JSplitPane bottomSplitPane;
    private JTextArea textOutput;
    private JScrollPane scrollTextOutput;
    private JTextField lineCommand;
    private JSplitPane mainSplitPane;
    private JPanel previewPanel;
    private CardLayout previewLayout = new CardLayout();
    JList previewArea;
    private JScrollPane scrollPreviewArea;
    private DebugListModel previewModel;
    private DebugListCellRenderer previewRenderer;
    private JTabbedPane bottomRightTabbedPane;
    private int currLine;
    private ParagraphObject selParObj;
    private int cursorColumn;
    private int cursorX;
    private int selLine;
    private int startDragLine = -1;
    private int endDragLine = -1;
    private KeyListener globalKeyListener = IsguiUtility.keyPressedAdapter(e -> {
        if (this.previewModel == null) {
            return;
        }
        switch (e.getKeyCode()) {
            case 36: {
                this.select(0, 0);
                break;
            }
            case 35: {
                this.select(this.previewModel.getSize() - 1, 0);
                break;
            }
            case 38: {
                if (e.isControlDown() || e.isAltDown()) break;
                if (e.isShiftDown()) {
                    int idx;
                    this.endDragLine = idx = Math.max(0, this.endDragLine - 1);
                    this.ensureVisible(this.endDragLine);
                    this.previewArea.repaint();
                    break;
                }
                int idx = Math.max(0, this.selLine - 1);
                this.select(idx, 0);
                break;
            }
            case 40: {
                if (e.isControlDown() || e.isAltDown()) break;
                if (e.isShiftDown()) {
                    int idx;
                    this.endDragLine = idx = Math.min(this.endDragLine + 1, this.previewModel.getSize() - 1);
                    this.ensureVisible(this.endDragLine);
                    this.previewArea.repaint();
                    break;
                }
                int idx = Math.min(this.selLine + 1, this.previewModel.getSize() - 1);
                this.select(idx, 0);
                break;
            }
            case 33: {
                int lvidx = this.previewArea.getLastVisibleIndex();
                int fvidx = this.previewArea.getFirstVisibleIndex();
                fvidx -= lvidx - fvidx;
                int idx = Math.max(0, fvidx);
                if (e.isShiftDown()) {
                    this.endDragLine = idx;
                    this.ensureVisible(this.endDragLine);
                    this.previewArea.repaint();
                    break;
                }
                this.select(idx, 0);
                break;
            }
            case 34: {
                int lvidx = this.previewArea.getLastVisibleIndex();
                int fvidx = this.previewArea.getFirstVisibleIndex();
                lvidx += lvidx - fvidx;
                int idx = Math.min(lvidx, this.previewModel.getSize() - 1);
                if (e.isShiftDown()) {
                    this.endDragLine = idx;
                    this.ensureVisible(this.endDragLine);
                    this.previewArea.repaint();
                    break;
                }
                this.select(idx, 0);
                break;
            }
            case 9: {
                this.displayVarsOnSelLine(true, e.isShiftDown());
            }
        }
    });
    private JPanel breakpointPanel;
    private JToolBar breakpointButtonPanel;
    private JTreeTable breakpointTable;
    private JButton breakpointEnAllBtn;
    private JButton breakpointDisAllBtn;
    private JButton breakpointModifyBtn;
    private JButton breakpointAddBtn;
    private JButton breakpointRemoveBtn;
    private JButton breakpointRemoveAllBtn;
    private JMenuItem breakpointModifyItem;
    private JMenuItem breakpointAddItem;
    private JMenuItem breakpointRemoveItem;
    private JMenuItem breakpointRemoveAllItem;
    private JMenuItem breakpointEnAllItem;
    private JMenuItem breakpointDisAllItem;
    private BreakpointModel breakpointModel;
    private JTreeTable callStackTable;
    private JPanel callStackNoInfoPanel;
    private JPanel callStackPanel;
    private CardLayout callStackLayout = new CardLayout();
    private CallStackModel callStackModel;
    private JPanel monitorPanel;
    private JToolBar monitorButtonPanel;
    private JTreeTable monitorTable;
    private JButton monitorEnAllBtn;
    private JButton monitorDisAllBtn;
    private JButton monitorRemoveBtn;
    private JButton monitorRemoveAllBtn;
    private JButton monitorModifyBtn;
    private JButton monitorAddBtn;
    private JMenuItem monitorModifyItem;
    private JMenuItem monitorAddItem;
    private JMenuItem monitorRemoveItem;
    private JMenuItem monitorRemoveAllItem;
    private JMenuItem monitorEnAllItem;
    private JMenuItem monitorDisAllItem;
    private MonitorModel monitorModel;
    private JPanel commandHistoryPanel;
    private JToolBar commandHistoryButtonPanel;
    private JList commandHistory;
    private JButton commandExecuteBtn;
    private JButton clearHistoryBtn;
    private JMenuItem commandExecuteItem;
    private JMenuItem clearHistoryItem;
    private DefaultListModel commandHistoryModel;
    private JPanel consolePanel;
    private JToolBar consoleButtonPanel;
    private JTextPane console;
    private JCheckBox consoleAttachedBtn;
    private JCheckBox showConsoleBtn;
    private JButton clearConsoleBtn;
    private JCheckBoxMenuItem consoleAttachedItem;
    private JCheckBoxMenuItem showConsoleItem;
    private JMenuItem clearConsoleItem;
    private ThreadModel threadModel;
    private JTreeTable threadTable;
    private JPanel threadNoInfoPanel;
    private JPanel threadPanel;
    private CardLayout threadLayout = new CardLayout();
    private JPanel variablesPanel;
    private MyVariableModel[] varModel = new MyVariableModel[2];
    private VariableNode[] varRootNode = new VariableNode[2];
    private JScrollPane[] varScrollPane = new JScrollPane[2];
    private JTreeTable[] varTreeTable = new JTreeTable[2];
    private JTree[] varTree = new JTree[2];
    private JTabbedPane[] varTabbed = new JTabbedPane[2];
    private JSplitPane varSplitPane;
    private JButton varExpandAllBtn;
    private JButton varCollapseAllBtn;
    private JButton varChangeValueBtn;
    private ToggleImageButton varAutoRefreshBtn;
    private ToggleImageButton varHexBtn;
    private JButton varAddMonBtn;
    private JButton varRemoveBtn;
    private JButton varRemoveAllBtn;
    private JButton varAddBtn;
    private JMenuItem varHexItem;
    private JMenuItem varAddMonitorItem;
    private JMenuItem varChangeValueItem;
    private JMenuItem varExpandAllItem;
    private JMenuItem varCollapseAllItem;
    private JMenuItem varAutoRefreshItem;
    private JMenuItem varRemoveItem;
    private JMenuItem varRemoveAllItem;
    private JMenuItem varAddItem;
    private JMenuItem varCopyItem;
    private JProgressBar memoryView;
    private JMenuItem listCopyItem;
    private JMenuItem displayOnLineItem;
    private JMenuItem currLineItem;
    private JMenuItem gotoItem;
    private JMenuItem contItem;
    private JMenuItem suspItem;
    private JMenuItem stepIntoItem;
    private JMenuItem stepOverItem;
    private JMenuItem runToItem;
    private JMenuItem runToNextPgmItem;
    private JMenuItem outParItem;
    private JMenuItem outProgItem;
    private JMenuItem jumpItem;
    private JMenuItem jumpOutItem;
    private JMenuItem jumpOutProgItem;
    private JMenuItem jumpNextItem;
    private JMenuItem toggleBrItem;
    private JMenuItem quickWatchItem;
    private JMenuItem refreshItem;
    private JMenuItem textOutputClearItem;
    private TipAction tipAction = new TipAction();
    private HandMouseAction handMouseAction = new HandMouseAction();
    private JPopupMenu listPopup;
    Point quickWatchPoint;
    private Rectangle lastMouseEventArea;
    private Rectangle lastLinkArea;
    private String currFile = "";
    private List<String[]> watchedVarnames = new ArrayList<String[]>();
    private KeyListener surrogateLineCommandListener = IsguiUtility.keyPressedAdapter(e -> {
        if (Character.isLetter(e.getKeyChar())) {
            this.lineCommand.setText(this.lineCommand.getText() + e.getKeyChar());
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new FocusEvent(this.lineCommand, 1004));
        }
    });
    private ActionListener threadActionListener = e -> {
        AbstractButton src = (AbstractButton)e.getSource();
        if (!this.graphDebug.isProcessing()) {
            this.graphDebug.setTextCommand("thread " + src.getName());
        }
    };

    public DebugPanel(GraphDebugger gd, LocalDebugInfo dInfo, boolean listing) {
        this.graphDebug = gd;
        this.mainProgram = dInfo != null && dInfo.getErrorString() == null ? this.getRealPath(dInfo.getSourcefile()) : "";
        this.setDoubleBuffered(true);
        this.previewPanel = new JPanel(this.previewLayout);
        this.getFile(dInfo, new Filename(this.mainProgram), 0L, listing, true);
        this.currFile = this.mainProgram;
        this.buildPopup();
        this.buildPanel();
        this.initNumberColumnLen();
        this.setPreferredListWidth();
    }

    private static Color[] loadCopySourcePatternColors(String copySourcePattern) {
        StringTokenizer stn0 = new StringTokenizer(copySourcePattern, ";");
        int n = stn0.countTokens();
        Color[] Return2 = new Color[n];
        for (int i = 0; i < n; ++i) {
            int rgb = Integer.parseInt(stn0.nextToken());
            Return2[i] = new Color(rgb);
        }
        return Return2;
    }

    private String getSelection() {
        if (this.previewModel == null) {
            return "";
        }
        StringBuffer Return2 = new StringBuffer();
        int start = this.startDragLine;
        int end = this.endDragLine;
        if (start >= 0) {
            if (end < start) {
                start = this.endDragLine;
                end = this.startDragLine;
            }
            for (int i = start; i <= end; ++i) {
                Return2.append(this.previewModel.getElementAt(i));
                if (i >= end) continue;
                Return2.append(GraphDebugger.eol);
            }
        }
        return Return2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy() {
        JList jList = this.previewArea;
        synchronized (jList) {
            String selection = this.getSelection();
            if (selection != null && selection.length() > 0) {
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                StringSelection clipString = new StringSelection(selection);
                clipboard.setContents(clipString, clipString);
            }
        }
    }

    private void buildPopup() {
        this.listPopup = new JPopupMenu();
        this.listCopyItem = new JMenuItem("Copy");
        this.listCopyItem.addActionListener(e -> this.copy());
        this.listCopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.listPopup.add(this.listCopyItem);
        this.listPopup.addSeparator();
        this.currLineItem = new JMenuItem("Current line");
        this.currLineItem.addActionListener(e -> this.selectCurrentLine());
        this.listPopup.add(this.currLineItem);
        this.gotoItem = new JMenuItem("Go to");
        this.gotoItem.addActionListener(e -> this.graphDebug.showGotoDialog());
        this.listPopup.add(this.gotoItem);
        this.listPopup.addSeparator();
        this.contItem = new JMenuItem("Continue", new ImageIcon(GraphUtilities.getImage("continue.gif")));
        this.contItem.addActionListener(e -> this.graphDebug.setTextCommand("continue"));
        this.listPopup.add(this.contItem);
        this.contItem.setEnabled(false);
        this.suspItem = new JMenuItem("Pause", new ImageIcon(GraphUtilities.getImage("suspend.gif")));
        this.suspItem.addActionListener(e -> this.graphDebug.setTextCommand("pause"));
        this.listPopup.add(this.suspItem);
        this.suspItem.setEnabled(false);
        this.stepIntoItem = new JMenuItem("Step into", new ImageIcon(GraphUtilities.getImage("stepinto.gif")));
        this.stepIntoItem.addActionListener(e -> this.graphDebug.setTextCommand("step"));
        this.listPopup.add(this.stepIntoItem);
        this.stepIntoItem.setEnabled(false);
        this.stepOverItem = new JMenuItem("Step over", new ImageIcon(GraphUtilities.getImage("stepover.gif")));
        this.stepOverItem.addActionListener(e -> this.graphDebug.setTextCommand("next"));
        this.listPopup.add(this.stepOverItem);
        this.stepOverItem.setEnabled(false);
        this.outParItem = new JMenuItem("Step out paragraph", new ImageIcon(GraphUtilities.getImage("stepout.gif")));
        this.outParItem.addActionListener(e -> this.graphDebug.setTextCommand("outpar"));
        this.listPopup.add(this.outParItem);
        this.outParItem.setEnabled(false);
        this.outProgItem = new JMenuItem("Step out program", new ImageIcon(GraphUtilities.getImage("stepoutprog.gif")));
        this.outProgItem.addActionListener(e -> this.graphDebug.setTextCommand("outprog"));
        this.listPopup.add(this.outProgItem);
        this.outProgItem.setEnabled(false);
        this.runToItem = new JMenuItem("Run to selected line", new ImageIcon(GraphUtilities.getImage("runtilcurs.gif")));
        this.runToItem.addActionListener(e -> this.graphDebug.runToSelectedLine(this.selLine, this.tFileObj.tf));
        this.listPopup.add(this.runToItem);
        this.runToItem.setEnabled(false);
        this.runToNextPgmItem = new JMenuItem("Run to next program", new ImageIcon(GraphUtilities.getImage("runtilpgm.gif")));
        this.runToNextPgmItem.addActionListener(e -> this.graphDebug.setTextCommand("prog"));
        this.listPopup.add(this.runToNextPgmItem);
        this.runToNextPgmItem.setEnabled(false);
        this.jumpNextItem = new JMenuItem("Jump next statement", new ImageIcon(GraphUtilities.getImage("jumpover.gif")));
        this.jumpNextItem.addActionListener(e -> this.graphDebug.setTextCommand("jump -next"));
        this.listPopup.add(this.jumpNextItem);
        this.jumpNextItem.setEnabled(false);
        this.jumpOutItem = new JMenuItem("Jump out paragraph", new ImageIcon(GraphUtilities.getImage("jumpout.gif")));
        this.jumpOutItem.addActionListener(e -> this.graphDebug.setTextCommand("jump -outpar"));
        this.listPopup.add(this.jumpOutItem);
        this.jumpOutItem.setEnabled(false);
        this.jumpOutProgItem = new JMenuItem("Jump out program", new ImageIcon(GraphUtilities.getImage("jumpoutprog.gif")));
        this.jumpOutProgItem.addActionListener(e -> this.graphDebug.setTextCommand("jump -outprog"));
        this.listPopup.add(this.jumpOutProgItem);
        this.jumpOutProgItem.setEnabled(false);
        this.jumpItem = new JMenuItem("Jump to selected line", new ImageIcon(GraphUtilities.getImage("jump.gif")));
        this.jumpItem.addActionListener(e -> this.jumpToSelectedLine());
        this.listPopup.add(this.jumpItem);
        this.jumpItem.setEnabled(false);
        this.listPopup.addSeparator();
        this.toggleBrItem = new JMenuItem("Toggle breakpoint");
        this.toggleBrItem.addActionListener(e -> {
            int row;
            if (this.quickWatchPoint != null && (row = this.previewArea.locationToIndex(this.quickWatchPoint)) >= 0) {
                this.graphDebug.toggleBreakpoint(row, this.tFileObj.tf, this.getBreakpoint(row));
            }
        });
        this.listPopup.add(this.toggleBrItem);
        this.listPopup.addSeparator();
        this.displayOnLineItem = new JMenuItem("Display variables on selected line", 89);
        this.listPopup.add(this.displayOnLineItem).addActionListener(e -> this.displayVarsOnSelLine());
        this.displayOnLineItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        this.listPopup.addSeparator();
        this.quickWatchItem = new JMenuItem("Quick watch");
        this.quickWatchItem.addActionListener(e -> {
            MyVarName vn = this.getVarName();
            this.graphDebug.showQuickWatchDialog(vn != null ? vn.varName : null, this.getSelectedModule());
        });
        this.listPopup.add(this.quickWatchItem);
        this.quickWatchItem.setEnabled(false);
        this.refreshItem = new JMenuItem("Refresh Variables Area");
        this.refreshItem.setEnabled(false);
        this.refreshItem.addActionListener(e -> this.refreshVariables());
        this.listPopup.add(this.refreshItem);
    }

    private void buildThreadArea() {
        int progColWidth;
        int parColWidth;
        this.threadPanel = new JPanel(this.threadLayout);
        this.threadNoInfoPanel = new NoInfoPanel(threadListBackground, threadListForeground, threadListFont);
        this.threadPanel.add((Component)this.threadNoInfoPanel, "EMPTY-PANEL");
        this.threadModel = new ThreadModel(this.graphDebug);
        this.threadTable = new JTreeTable(this.threadModel);
        this.threadTable.setRootVisible(false);
        this.threadTable.setEnabled(true);
        this.threadTable.setFont(threadListFont);
        this.threadTable.setBackground(threadListBackground);
        this.threadTable.setForeground(threadListForeground);
        this.threadTable.setSelectionMode(0);
        this.threadTable.setRowSelectionAllowed(true);
        this.threadTable.setFillsViewportHeight(true);
        this.threadTable.setColumnSelectionAllowed(false);
        this.threadTable.getTableHeader().setReorderingAllowed(false);
        this.threadTable.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.threadTable.getColumnModel().getColumn(0).setMaxWidth(35);
        this.threadTable.getColumnModel().getColumn(0).setResizable(false);
        this.threadTable.addKeyListener(this.surrogateLineCommandListener);
        int nameColWidth = Settings.getThreadTableNameColumnWidth();
        if (nameColWidth >= 0) {
            this.threadTable.getColumnModel().getColumn(1).setPreferredWidth(nameColWidth);
        }
        if ((parColWidth = Settings.getThreadTableParagraphColumnWidth()) >= 0) {
            this.threadTable.getColumnModel().getColumn(2).setPreferredWidth(parColWidth);
        }
        if ((progColWidth = Settings.getThreadTableProgramColumnWidth()) >= 0) {
            this.threadTable.getColumnModel().getColumn(3).setPreferredWidth(progColWidth);
        }
        this.threadPanel.add((Component)DebugPanel.createJScrollPane(this.threadTable), "THREAD-LIST");
    }

    private static JScrollPane createJScrollPane(JComponent c) {
        JScrollPane sp = new JScrollPane(c);
        sp.getVerticalScrollBar().setFocusable(false);
        sp.getHorizontalScrollBar().setFocusable(false);
        return sp;
    }

    private void buildCallStackArea() {
        int progColWidth;
        int locColWidth;
        this.callStackModel = new CallStackModel(this.graphDebug);
        this.callStackTable = new JTreeTable(this.callStackModel);
        this.callStackTable.setRootVisible(false);
        this.callStackTable.setToolTipText("Double click to go to paragraph line");
        this.callStackTable.setSelectionMode(0);
        this.callStackTable.setRowSelectionAllowed(true);
        this.callStackTable.setFillsViewportHeight(true);
        this.callStackTable.setColumnSelectionAllowed(false);
        this.callStackTable.getTableHeader().setReorderingAllowed(false);
        int parColWidth = Settings.getCallStackTableParagraphColumnWidth();
        if (parColWidth >= 0) {
            this.callStackTable.getColumnModel().getColumn(0).setPreferredWidth(parColWidth);
        }
        if ((locColWidth = Settings.getCallStackTableLocationColumnWidth()) >= 0) {
            this.callStackTable.getColumnModel().getColumn(1).setPreferredWidth(locColWidth);
        }
        if ((progColWidth = Settings.getCallStackTableProgramColumnWidth()) >= 0) {
            this.callStackTable.getColumnModel().getColumn(2).setPreferredWidth(progColWidth);
        }
        this.callStackTable.addKeyListener(this.surrogateLineCommandListener);
        this.callStackTable.addMouseListener(IsguiUtility.mouseClickedAdapter(e -> {
            ParagraphObject po;
            if (e.getClickCount() == 2 && (po = (ParagraphObject)this.callStackModel.elementAt(this.callStackTable.getSelectedRow())) != null) {
                LocalDebugInfo dInfo;
                this.selParObj = po;
                String currProg = this.tFileObj.tf.getClassName();
                if (!currProg.equals(po.getProgName()) && (dInfo = this.graphDebug.getInvoker().getInfo(po.getProgName(), this.graphDebug.isProcessing(), true)) != null) {
                    String fn = dInfo.getSourcefile() != null ? this.getRealPath(dInfo.getSourcefile()) : "";
                    this.load(dInfo, new Filename(fn), dInfo.getTimestamp(), true);
                }
                ParagraphObject lastPar = null;
                int lastParLine = -1;
                int idx = this.callStackModel.size() - 1;
                if (idx >= 0 && po != (lastPar = (ParagraphObject)this.callStackModel.elementAt(idx)) && po.getProgName().equals(lastPar.getProgName())) {
                    lastParLine = lastPar.getLine();
                }
                this.goTo(po.getLine(), null, po.getFileIndex(), po == lastPar, lastParLine);
            }
        }));
        this.callStackTable.setFont(perfStackFont);
        this.callStackTable.setBackground(perfStackBackground);
        this.callStackTable.setForeground(perfStackForeground);
        this.callStackTable.setSelectionBackground(perfStackSelBackground);
        this.callStackTable.setSelectionForeground(perfStackSelForeground);
        this.callStackTable.getSelectionModel().setSelectionMode(0);
        this.callStackPanel = new JPanel(this.callStackLayout);
        this.callStackNoInfoPanel = new NoInfoPanel(perfStackBackground, perfStackForeground, perfStackFont);
        this.callStackPanel.add((Component)this.callStackNoInfoPanel, "EMPTY-PANEL");
        this.callStackPanel.add((Component)DebugPanel.createJScrollPane(this.callStackTable), "CALL-STACK-LIST");
    }

    private void buildBreakpointArea() {
        this.breakpointModel = new BreakpointModel(this.graphDebug);
        this.breakpointPanel = new JPanel(new BorderLayout(0, 0));
        this.breakpointButtonPanel = new JToolBar();
        this.breakpointButtonPanel.setFloatable(false);
        this.breakpointEnAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("checkall.gif")), "Enable all", false, e -> this.enableAllBreakpoints());
        this.breakpointButtonPanel.add(this.breakpointEnAllBtn);
        this.breakpointDisAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("uncheckall.gif")), "Disable all", false, e -> this.disableAllBreakpoints());
        this.breakpointButtonPanel.add(this.breakpointDisAllBtn);
        this.breakpointModifyBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("edit.gif")), "Modify", false, e -> this.modifyBreakpoint());
        this.breakpointButtonPanel.add(this.breakpointModifyBtn);
        this.breakpointAddBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("add_item.gif")), "New", true, e -> this.newBreakpoint());
        this.breakpointButtonPanel.add(this.breakpointAddBtn);
        this.breakpointRemoveBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("remove.gif")), "Remove", false, e -> this.removeBreakpoint());
        this.breakpointButtonPanel.add(this.breakpointRemoveBtn);
        this.breakpointRemoveAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("removeall.gif")), "Remove all", false, e -> this.removeAllBreakpoints());
        this.breakpointButtonPanel.add(this.breakpointRemoveAllBtn);
        this.breakpointPanel.add((Component)this.breakpointButtonPanel, "North");
        this.breakpointTable = new JTreeTable(this.breakpointModel);
        this.breakpointTable.setRootVisible(false);
        this.breakpointTable.setToolTipText("Type 'Canc' to remove the selected breakpoint");
        this.breakpointTable.setFont(bpListFont);
        this.breakpointTable.setBackground(bpListBackground);
        this.breakpointTable.setForeground(bpListForeground);
        this.breakpointTable.setSelectionBackground(bpListSelBackground);
        this.breakpointTable.setSelectionForeground(bpListSelForeground);
        this.breakpointTable.setSelectionMode(0);
        this.breakpointTable.setRowSelectionAllowed(true);
        this.breakpointTable.setFillsViewportHeight(true);
        this.breakpointTable.setColumnSelectionAllowed(false);
        this.breakpointTable.getTableHeader().setReorderingAllowed(false);
        this.breakpointTable.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.breakpointTable.getColumnModel().getColumn(0).setMaxWidth(35);
        this.breakpointTable.getColumnModel().getColumn(0).setResizable(false);
        this.breakpointPanel.add((Component)DebugPanel.createJScrollPane(this.breakpointTable), "Center");
        final JPopupMenu breakpointPopup = new JPopupMenu();
        this.breakpointEnAllItem = new JMenuItem("Enable all", new ImageIcon(GraphUtilities.getImage("checkall.gif")));
        this.breakpointEnAllItem.setEnabled(false);
        this.breakpointEnAllItem.addActionListener(e -> this.enableAllBreakpoints());
        breakpointPopup.add(this.breakpointEnAllItem);
        this.breakpointDisAllItem = new JMenuItem("Disable all", new ImageIcon(GraphUtilities.getImage("uncheckall.gif")));
        this.breakpointDisAllItem.setEnabled(false);
        this.breakpointDisAllItem.addActionListener(e -> this.disableAllBreakpoints());
        breakpointPopup.add(this.breakpointDisAllItem);
        breakpointPopup.addSeparator();
        this.breakpointModifyItem = new JMenuItem("Modify", new ImageIcon(GraphUtilities.getImage("edit.gif")));
        this.breakpointModifyItem.setEnabled(false);
        this.breakpointModifyItem.addActionListener(e -> this.modifyBreakpoint());
        breakpointPopup.add(this.breakpointModifyItem);
        this.breakpointAddItem = new JMenuItem("New", new ImageIcon(GraphUtilities.getImage("add_item.gif")));
        this.breakpointAddItem.addActionListener(e -> this.newBreakpoint());
        breakpointPopup.add(this.breakpointAddItem);
        this.breakpointRemoveItem = new JMenuItem("Remove", new ImageIcon(GraphUtilities.getImage("remove.gif")));
        this.breakpointRemoveItem.setEnabled(false);
        this.breakpointRemoveItem.addActionListener(e -> this.removeBreakpoint());
        breakpointPopup.add(this.breakpointRemoveItem);
        this.breakpointRemoveAllItem = new JMenuItem("Remove all", new ImageIcon(GraphUtilities.getImage("removeall.gif")));
        this.breakpointRemoveAllItem.setEnabled(false);
        this.breakpointRemoveAllItem.addActionListener(e -> this.removeAllBreakpoints());
        breakpointPopup.add(this.breakpointRemoveAllItem);
        this.breakpointTable.addKeyListener(IsguiUtility.keyPressedAdapter(e -> {
            if (e.getKeyCode() == 127 && this.breakpointTable.getSelectedRowCount() > 0) {
                this.removeBreakpoint();
            }
            this.surrogateLineCommandListener.keyPressed((KeyEvent)e);
        }));
        this.breakpointTable.addMouseListener(new GraphUtilities.PopupMouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Breakpoint bp;
                if (e.getClickCount() == 2 && (bp = (Breakpoint)DebugPanel.this.breakpointModel.elementAt(DebugPanel.this.breakpointTable.getSelectedRow())) != null) {
                    String currProg = ((DebugPanel)DebugPanel.this).tFileObj.tf.getClassName();
                    if (!currProg.equals(bp.getProgram())) {
                        LocalDebugInfo dInfo = DebugPanel.this.graphDebug.getInvoker().getInfo(bp.getProgram(), DebugPanel.this.graphDebug.isProcessing(), true);
                        if (dInfo != null) {
                            String fn = dInfo.getSourcefile() != null ? DebugPanel.this.getRealPath(dInfo.getSourcefile()) : "";
                            DebugPanel.this.load(dInfo, new Filename(fn), dInfo.getTimestamp(), true);
                        } else {
                            DebugPanel.this.load(null, new Filename(bp.getFile()), 0L, false);
                        }
                    }
                    DebugPanel.this.goTo(bp.getLine(), null, bp.getFileIndex());
                }
            }

            @Override
            public void showPopup(MouseEvent e) {
                breakpointPopup.show(DebugPanel.this.breakpointTable, e.getX(), e.getY());
            }
        });
        this.breakpointTable.getSelectionModel().addListSelectionListener(e -> this.breakpointTableSelectionChanged(this.breakpointTable.getSelectedRowCount()));
    }

    private void buildMonitorArea() {
        int valueColWidth;
        this.monitorPanel = new JPanel(new BorderLayout(0, 0));
        this.monitorButtonPanel = new JToolBar();
        this.monitorButtonPanel.setFloatable(false);
        this.monitorEnAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("checkall.gif")), "Enable all", false, e -> this.enableAllMonitors());
        this.monitorButtonPanel.add(this.monitorEnAllBtn);
        this.monitorDisAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("uncheckall.gif")), "Disable all", false, e -> this.disableAllMonitors());
        this.monitorButtonPanel.add(this.monitorDisAllBtn);
        this.monitorModifyBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("edit.gif")), "Modify", false, e -> this.modifyMonitor());
        this.monitorButtonPanel.add(this.monitorModifyBtn);
        this.monitorAddBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("add_item.gif")), "New", true, e -> this.newMonitor());
        this.monitorButtonPanel.add(this.monitorAddBtn);
        this.monitorRemoveBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("remove.gif")), "Remove", false, e -> this.removeMonitor());
        this.monitorButtonPanel.add(this.monitorRemoveBtn);
        this.monitorRemoveAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("removeall.gif")), "Remove all", false, e -> this.removeAllMonitors());
        this.monitorButtonPanel.add(this.monitorRemoveAllBtn);
        this.monitorPanel.add((Component)this.monitorButtonPanel, "North");
        this.monitorModel = new MonitorModel(this.graphDebug);
        this.monitorTable = new JTreeTable(this.monitorModel);
        this.monitorTable.setDefaultEditor(String.class, GraphUtilities.getValueEditor(this.monitorTable));
        this.monitorTable.setRootVisible(false);
        this.monitorTable.setEnabled(true);
        this.monitorTable.setToolTipText("Type 'Canc' to remove the selected monitor");
        this.monitorTable.setFont(monListFont);
        this.monitorTable.setBackground(monListBackground);
        this.monitorTable.setForeground(monListForeground);
        this.monitorTable.setSelectionBackground(monListSelBackground);
        this.monitorTable.setSelectionForeground(monListSelForeground);
        this.monitorTable.setSelectionMode(0);
        this.monitorTable.setRowSelectionAllowed(true);
        this.monitorTable.setFillsViewportHeight(true);
        this.monitorTable.setColumnSelectionAllowed(false);
        this.monitorTable.getTableHeader().setReorderingAllowed(false);
        this.monitorTable.getColumnModel().getColumn(0).setPreferredWidth(35);
        this.monitorTable.getColumnModel().getColumn(0).setMaxWidth(35);
        this.monitorTable.getColumnModel().getColumn(0).setResizable(false);
        this.monitorPanel.add((Component)DebugPanel.createJScrollPane(this.monitorTable), "Center");
        int nameColWidth = Settings.getMonitorTableNameColumnWidth();
        if (nameColWidth >= 0) {
            this.monitorTable.getColumnModel().getColumn(1).setPreferredWidth(nameColWidth);
        }
        if ((valueColWidth = Settings.getMonitorTableValueColumnWidth()) >= 0) {
            this.monitorTable.getColumnModel().getColumn(2).setPreferredWidth(valueColWidth);
        }
        this.monitorTable.getSelectionModel().addListSelectionListener(e -> this.monitorTableSelectionChanged(this.monitorTable.getSelectedRowCount()));
        final JPopupMenu monitorPopup = new JPopupMenu();
        this.monitorEnAllItem = new JMenuItem("Enable all", new ImageIcon(GraphUtilities.getImage("checkall.gif")));
        this.monitorEnAllItem.setEnabled(false);
        this.monitorEnAllItem.addActionListener(e -> this.enableAllMonitors());
        monitorPopup.add(this.monitorEnAllItem);
        this.monitorDisAllItem = new JMenuItem("Disable all", new ImageIcon(GraphUtilities.getImage("uncheckall.gif")));
        this.monitorDisAllItem.setEnabled(false);
        this.monitorDisAllItem.addActionListener(e -> this.disableAllMonitors());
        monitorPopup.add(this.monitorDisAllItem);
        monitorPopup.addSeparator();
        this.monitorModifyItem = new JMenuItem("Modify", new ImageIcon(GraphUtilities.getImage("edit.gif")));
        this.monitorModifyItem.setEnabled(false);
        this.monitorModifyItem.addActionListener(e -> this.modifyMonitor());
        monitorPopup.add(this.monitorModifyItem);
        this.monitorAddItem = new JMenuItem("New", new ImageIcon(GraphUtilities.getImage("add_item.gif")));
        this.monitorAddItem.addActionListener(e -> this.newMonitor());
        monitorPopup.add(this.monitorAddItem);
        this.monitorRemoveItem = new JMenuItem("Remove", new ImageIcon(GraphUtilities.getImage("remove.gif")));
        this.monitorRemoveItem.setEnabled(false);
        this.monitorRemoveItem.addActionListener(e -> this.removeMonitor());
        monitorPopup.add(this.monitorRemoveItem);
        this.monitorRemoveAllItem = new JMenuItem("Remove all", new ImageIcon(GraphUtilities.getImage("removeall.gif")));
        this.monitorRemoveAllItem.setEnabled(false);
        this.monitorRemoveAllItem.addActionListener(e -> this.removeAllMonitors());
        monitorPopup.add(this.monitorRemoveAllItem);
        this.monitorTable.addKeyListener(IsguiUtility.keyPressedAdapter(e -> {
            if (!this.graphDebug.isProcessing() && e.getKeyCode() == 127 && this.monitorTable.getSelectedRow() >= 0) {
                this.removeMonitor();
            }
            this.surrogateLineCommandListener.keyPressed((KeyEvent)e);
        }));
        this.monitorTable.addMouseListener(new GraphUtilities.PopupMouseListener(){

            @Override
            public void showPopup(MouseEvent e) {
                monitorPopup.show(DebugPanel.this.monitorTable, e.getX(), e.getY());
            }
        });
    }

    private void buildCommandHistoryArea() {
        this.commandHistoryPanel = new JPanel(new BorderLayout(0, 0));
        this.commandHistoryButtonPanel = new JToolBar();
        this.commandHistoryButtonPanel.setFloatable(false);
        this.commandExecuteBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("execute.gif")), "Execute", false, e -> this.graphDebug.executeCommand(this.commandHistory.getSelectedValue().toString()));
        this.commandHistoryButtonPanel.add(this.commandExecuteBtn);
        this.clearHistoryBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("removeall.gif")), "Clear history", false, e -> this.clearCommandHistory());
        this.commandHistoryButtonPanel.add(this.clearHistoryBtn);
        this.commandHistoryPanel.add((Component)this.commandHistoryButtonPanel, "North");
        this.commandHistoryModel = new DefaultListModel();
        this.commandHistory = new JList(this.commandHistoryModel);
        this.commandHistory.setSelectionMode(0);
        this.commandHistory.setFont(cmdHistoryFont);
        this.commandHistory.setBackground(cmdHistoryBackground);
        this.commandHistory.setForeground(cmdHistoryForeground);
        this.commandHistory.setSelectionBackground(cmdHistorySelBackground);
        this.commandHistory.setSelectionForeground(cmdHistorySelForeground);
        this.commandHistoryPanel.add((Component)DebugPanel.createJScrollPane(this.commandHistory), "Center");
        this.commandHistory.getSelectionModel().addListSelectionListener(e -> {
            this.commandExecuteBtn.setEnabled(this.commandHistory.getSelectedIndex() >= 0);
            this.commandExecuteItem.setEnabled(this.commandHistory.getSelectedIndex() >= 0);
        });
        final JPopupMenu commandHistoryPopup = new JPopupMenu();
        this.commandExecuteItem = new JMenuItem("Execute", new ImageIcon(GraphUtilities.getImage("execute.gif")));
        this.commandExecuteItem.setEnabled(false);
        this.commandExecuteItem.addActionListener(e -> this.graphDebug.executeCommand(this.commandHistory.getSelectedValue().toString()));
        commandHistoryPopup.add(this.commandExecuteItem);
        this.clearHistoryItem = new JMenuItem("Clear history", new ImageIcon(GraphUtilities.getImage("removeall.gif")));
        this.clearHistoryItem.setEnabled(false);
        this.clearHistoryItem.addActionListener(e -> this.clearCommandHistory());
        commandHistoryPopup.add(this.clearHistoryItem);
        this.commandHistory.addMouseListener(new GraphUtilities.PopupMouseListener(){

            @Override
            public void showPopup(MouseEvent e) {
                commandHistoryPopup.show(DebugPanel.this.commandHistory, e.getX(), e.getY());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && DebugPanel.this.commandHistory.getSelectedIndex() >= 0) {
                    DebugPanel.this.graphDebug.executeCommand(DebugPanel.this.commandHistory.getSelectedValue().toString());
                }
            }
        });
        this.commandHistory.addKeyListener(this.surrogateLineCommandListener);
    }

    private void setRedirectStreams(boolean b) {
        if (b != Settings.isConsoleAttached()) {
            this.setRedirectStreams0(b);
            Settings.setConsoleAttached(b);
        }
    }

    private void setRedirectStreams0(boolean b) {
        if (this.graphDebug.getInvoker().isRemoteDebug()) {
            this.graphDebug.getInvoker().processCommand(new SetRedirectStreamsCommand(b));
        }
        if (b) {
            this.overwriteSysOut();
            this.overwriteSysErr();
        } else {
            GraphUtilities.setOut(GraphUtilities.systemOut);
            GraphUtilities.setErr(GraphUtilities.systemErr);
        }
    }

    public void updateConsoleButtons() {
        if (this.graphDebug.isRemoteThinClient()) {
            return;
        }
        boolean b = Settings.isConsoleAttached();
        if (this.consoleAttachedBtn.isSelected() != b) {
            this.consoleAttachedBtn.setSelected(b);
            this.consoleAttachedItem.setSelected(b);
            this.setRedirectStreams0(b);
        }
        b = Settings.isShowConsole();
        if (this.showConsoleBtn.isSelected() != b) {
            this.showConsoleBtn.setSelected(b);
            this.showConsoleItem.setSelected(b);
        }
    }

    private void buildConsoleArea() {
        this.consolePanel = new JPanel(new BorderLayout(0, 0));
        this.consoleButtonPanel = new JToolBar();
        this.consoleButtonPanel.setFloatable(false);
        this.consoleAttachedBtn = new ToggleImageButton("Attached", GraphUtilities.getImage("attached.gif"), e -> {
            boolean b = this.consoleAttachedBtn.isSelected();
            this.setRedirectStreams(b);
        }, Settings.isConsoleAttached());
        this.consoleButtonPanel.add(this.consoleAttachedBtn);
        this.consoleAttachedBtn.setEnabled(!this.graphDebug.isRemoteThinClient());
        this.showConsoleBtn = new ToggleImageButton("Show Console when the content changes", GraphUtilities.getImage("showconsole.png"), e -> Settings.setShowConsole(this.showConsoleBtn.isSelected()), Settings.isShowConsole());
        this.consoleButtonPanel.add(this.showConsoleBtn);
        this.clearConsoleBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("clearconsole.png")), "Clear Console", true, e -> this.console.setText(""));
        this.consoleButtonPanel.add(this.clearConsoleBtn);
        this.consolePanel.add((Component)this.consoleButtonPanel, "North");
        this.console = new JTextPane();
        this.console.setFont(consoleFont);
        this.console.setBackground(consoleBackground);
        this.console.setForeground(consoleForeground);
        this.console.setSelectionColor(consoleSelBackground);
        this.console.setSelectedTextColor(consoleSelForeground);
        Style consoleStdOutStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style consoleStdErrStyle = this.console.getStyledDocument().addStyle("stderr", consoleStdOutStyle);
        StyleConstants.setForeground(consoleStdErrStyle, consoleStdErrForeground);
        this.console.setEditable(false);
        this.console.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (Settings.isShowConsole()) {
                    DebugPanel.this.selectConsoleTab();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.consolePanel.add((Component)DebugPanel.createJScrollPane(this.console), "Center");
        this.console.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.console){

            @Override
            protected void fillPopup() {
                super.fillPopup();
                this.popup.add(new JPopupMenu.Separator());
                DebugPanel.this.consoleAttachedItem = new JCheckBoxMenuItem(DebugPanel.this.consoleAttachedBtn.getToolTipText(), new ImageIcon(GraphUtilities.getImage("attached.gif")));
                DebugPanel.this.consoleAttachedItem.setSelected(true);
                DebugPanel.this.consoleAttachedItem.addActionListener(e -> {
                    boolean b = DebugPanel.this.consoleAttachedItem.isSelected();
                    DebugPanel.this.setRedirectStreams(b);
                });
                DebugPanel.this.consoleAttachedItem.setEnabled(!DebugPanel.this.graphDebug.isRemoteThinClient());
                this.popup.add(DebugPanel.this.consoleAttachedItem);
                DebugPanel.this.showConsoleItem = new JCheckBoxMenuItem(DebugPanel.this.showConsoleBtn.getToolTipText(), new ImageIcon(GraphUtilities.getImage("showconsole.png")));
                DebugPanel.this.showConsoleItem.addActionListener(e -> Settings.setShowConsole(DebugPanel.this.showConsoleItem.isSelected()));
                this.popup.add(DebugPanel.this.showConsoleItem);
                DebugPanel.this.clearConsoleItem = new JMenuItem(DebugPanel.this.clearConsoleBtn.getToolTipText(), new ImageIcon(GraphUtilities.getImage("clearconsole.png")));
                DebugPanel.this.clearConsoleItem.addActionListener(e -> DebugPanel.this.console.setText(""));
                this.popup.add(DebugPanel.this.clearConsoleItem);
            }
        });
        this.console.addKeyListener(this.surrogateLineCommandListener);
    }

    private void buildVariableArea() {
        this.variableLabel = new JLabel();
        this.variableTabbedPane = new JTabbedPane();
        this.variableTabbedPane.setFocusable(false);
        this.variablesPanel = new JPanel(new BorderLayout(0, 0));
        this.varRootNode[0] = new VariableNode("Current Variables", null, null, null);
        this.varRootNode[1] = new VariableNode("Watched Variables", null, null, null);
        for (int i = 0; i < this.varRootNode.length; ++i) {
            this.varModel[i] = new MyVariableModel(this.varRootNode[i], false);
        }
        JToolBar buttonPanel = new JToolBar();
        buttonPanel.setFloatable(false);
        this.varExpandAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("expandall.gif")), "Expand all", true, e -> {
            for (int i = 0; i < this.varModel.length; ++i) {
                GraphUtilities.expandNode(this.varTree[i], this.varModel[i].getRootNode());
            }
        });
        buttonPanel.add(this.varExpandAllBtn);
        this.varCollapseAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("collapseall.gif")), "Collapse all", true, e -> {
            for (int i = 0; i < this.varModel.length; ++i) {
                GraphUtilities.collapseNode(this.varTree[i], this.varModel[i].getRootNode());
            }
        });
        buttonPanel.add(this.varCollapseAllBtn);
        this.varChangeValueBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("changevalue.gif")), "Change value", false, e -> this.changeValue());
        buttonPanel.add(this.varChangeValueBtn);
        this.varAddMonBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("newmonitor.gif")), "Add monitor", false, e -> this.addMonitor());
        buttonPanel.add(this.varAddMonBtn);
        this.varAutoRefreshBtn = new ToggleImageButton("Auto Refresh", GraphUtilities.getImage("refresh.gif"), e -> {
            if (this.varAutoRefreshBtn.isSelected()) {
                this.refreshVariables();
            }
            this.varAutoRefreshItem.setSelected(this.varAutoRefreshBtn.isSelected());
        }, false);
        this.varAutoRefreshBtn.setSelected(true);
        buttonPanel.add(this.varAutoRefreshBtn);
        this.varHexBtn = new ToggleImageButton("Show Hex Values", GraphUtilities.getImage("hex.gif"), e -> {
            for (int i = 0; i < this.varModel.length; ++i) {
                this.varModel[i].setShowHexValues(this.varHexBtn.isSelected());
            }
            this.refreshVariables();
            this.varHexItem.setSelected(this.varHexBtn.isSelected());
        }, false);
        buttonPanel.add(this.varHexBtn);
        buttonPanel.add(this.newToolBarSeparator(new Dimension(4, DebugPanel.BTN_SIZE.height - 2), false));
        buttonPanel.add(this.newToolBarSeparator());
        buttonPanel.add(this.newToolBarSeparator(new Dimension(4, DebugPanel.BTN_SIZE.height - 2), false));
        this.varAddBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("add_item.gif")), "New watched variable", true, e -> this.addWatchedVar());
        buttonPanel.add(this.varAddBtn);
        this.varRemoveBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("remove.gif")), "Remove", false, e -> this.removeWatchedVar());
        buttonPanel.add(this.varRemoveBtn);
        this.varRemoveAllBtn = DebugPanel.createJButton(new ImageIcon(GraphUtilities.getImage("removeall.gif")), "Remove All", false, e -> this.removeAllWatchedVars());
        buttonPanel.add(this.varRemoveAllBtn);
        this.variablesPanel.add((Component)buttonPanel, "North");
        this.varSplitPane = new JSplitPane(0);
        for (int i = 0; i < this.varTreeTable.length; ++i) {
            this.varTreeTable[i] = new JTreeTable(this.varModel[i]);
            this.varScrollPane[i] = DebugPanel.createJScrollPane(this.varTreeTable[i]);
            this.varTreeTable[i].setRootVisible(false);
            this.varTreeTable[i].getTreeTableCellRenderer().setShowsRootHandles(true);
            this.varTreeTable[i].setSelectionMode(0);
            this.varTreeTable[i].setRowSelectionAllowed(true);
            this.varTreeTable[i].setFillsViewportHeight(true);
            this.varTreeTable[i].setColumnSelectionAllowed(false);
            this.varTreeTable[i].getTableHeader().setReorderingAllowed(false);
            this.varTreeTable[i].setFont(disTreeFont);
            this.varTreeTable[i].setBackground(disTreeBackground);
            this.varTreeTable[i].setForeground(disTreeForeground);
            this.varTreeTable[i].setSelectionBackground(disTreeSelBackground);
            this.varTreeTable[i].setSelectionForeground(disTreeSelForeground);
            this.varTreeTable[i].setDefaultEditor(String.class, GraphUtilities.getValueEditor(this.varTreeTable[i]));
            this.varTabbed[i] = new JTabbedPane();
            this.varTabbed[i].setFocusable(false);
            if (i == 0) {
                this.varTabbed[i].addTab("Current Variables", this.varScrollPane[i]);
                this.varSplitPane.setTopComponent(this.varTabbed[i]);
            } else {
                this.varTabbed[i].addTab("Watched Variables", this.varScrollPane[i]);
                this.varSplitPane.setBottomComponent(this.varTabbed[i]);
            }
            this.varTree[i] = this.varTreeTable[i].getTreeTableCellRenderer();
            this.varTree[i].setFont(disTreeFont);
            this.varTree[i].setBackground(disTreeBackground);
            this.varTree[i].setForeground(disTreeForeground);
            this.varTree[i].setCellRenderer(new DefaultTreeCellRenderer(){
                private static final long serialVersionUID = 123L;

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    this.setIcon(null);
                    this.setOpaque(true);
                    if (sel) {
                        this.setBackground(disTreeSelBackground);
                        this.setForeground(disTreeSelForeground);
                    } else {
                        this.setBackground(disTreeBackground);
                        this.setForeground(disTreeForeground);
                    }
                    this.doLayout();
                    return this;
                }
            });
            int fi = i;
            this.varTree[i].addTreeSelectionListener(e -> {
                Object node = this.varTree[fi].getLastSelectedPathComponent();
                boolean en = this.varAutoRefreshBtn.isEnabled();
                this.varChangeValueBtn.setEnabled(en && node != null);
                this.varAddMonBtn.setEnabled(en && node != null);
                this.varRemoveBtn.setEnabled(en && node != null && fi == 1 && ((VariableNode)node).getParent() == this.varRootNode[fi]);
                if (node != null) {
                    int i2 = fi == 1 ? 0 : 1;
                    this.varTree[i2].clearSelection();
                }
            });
            this.varTree[i].addTreeWillExpandListener(new TreeWillExpandListener(){

                @Override
                public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                    VariableNode node = (VariableNode)event.getPath().getLastPathComponent();
                    if (node.getChildCount() == 0) {
                        if (DebugPanel.this.graphDebug.isProcessing()) {
                            throw new ExpandVetoException(event);
                        }
                        try {
                            DisplayCommand dc = new DisplayCommand(new VarName(new DebugTM(node.getName())), node.getClassName(), true, true, 1);
                            dc.setDisplayAsText(true);
                            DebugResponse r = DebugPanel.this.graphDebug.getInvoker().processCommand(dc);
                            Tree[] tree = r.getTrees();
                            if (tree != null && tree.length > 0) {
                                boolean isHex = tree[0].isHex();
                                TreeNode root = tree[0].getRoot();
                                TreeNode[] c = root.getChildren();
                                for (int i = 0; i < c.length; ++i) {
                                    GraphUtilities.buildVariableNode(c[i], tree[0].getClassName(), node, isHex);
                                }
                            }
                        }
                        catch (DebuggerException debuggerException) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                }
            });
            this.varTreeTable[i].addKeyListener(this.surrogateLineCommandListener);
        }
        this.variablesPanel.add((Component)this.varSplitPane, "Center");
        final JPopupMenu popup = new JPopupMenu();
        this.varExpandAllItem = new JMenuItem("Expand all", new ImageIcon(GraphUtilities.getImage("expandall.gif")));
        this.varExpandAllItem.addActionListener(e -> {
            for (int i = 0; i < this.varModel.length; ++i) {
                GraphUtilities.expandNode(this.varTree[i], this.varModel[i].getRootNode());
            }
        });
        popup.add(this.varExpandAllItem);
        this.varCollapseAllItem = new JMenuItem("Collapse all", new ImageIcon(GraphUtilities.getImage("collapseall.gif")));
        this.varCollapseAllItem.addActionListener(e -> {
            for (int i = 0; i < this.varModel.length; ++i) {
                GraphUtilities.collapseNode(this.varTree[i], this.varModel[i].getRootNode());
            }
        });
        popup.add(this.varCollapseAllItem);
        popup.addSeparator();
        this.varChangeValueItem = new JMenuItem("Change value", new ImageIcon(GraphUtilities.getImage("changevalue.gif")));
        this.varChangeValueItem.addActionListener(e -> this.changeValue());
        popup.add(this.varChangeValueItem);
        this.varAddMonitorItem = new JMenuItem("Add monitor", new ImageIcon(GraphUtilities.getImage("newmonitor.gif")));
        this.varAddMonitorItem.addActionListener(e -> this.addMonitor());
        popup.add(this.varAddMonitorItem);
        this.varAutoRefreshItem = new JCheckBoxMenuItem("Auto Refresh", new ImageIcon(GraphUtilities.getImage("refresh.gif")));
        this.varAutoRefreshItem.setSelected(true);
        this.varAutoRefreshItem.addActionListener(e -> {
            if (this.varAutoRefreshItem.isSelected()) {
                this.refreshVariables();
            }
            this.varAutoRefreshBtn.setSelected(this.varAutoRefreshItem.isSelected());
        });
        popup.add(this.varAutoRefreshItem);
        this.varHexItem = new JCheckBoxMenuItem("Show Hex Values", new ImageIcon(GraphUtilities.getImage("hex.gif")));
        this.varHexItem.setSelected(false);
        this.varHexItem.addActionListener(e -> {
            for (int i = 0; i < this.varModel.length; ++i) {
                this.varModel[i].setShowHexValues(this.varHexItem.isSelected());
            }
            this.refreshVariables();
            this.varHexBtn.setSelected(this.varHexItem.isSelected());
        });
        popup.add(this.varHexItem);
        popup.addSeparator();
        this.varAddItem = new JMenuItem("New watched variable", new ImageIcon(GraphUtilities.getImage("add_item.gif")));
        this.varAddItem.addActionListener(e -> this.addWatchedVar());
        popup.add(this.varAddItem);
        this.varRemoveItem = new JMenuItem("Remove", new ImageIcon(GraphUtilities.getImage("remove.gif")));
        this.varRemoveItem.addActionListener(e -> this.removeWatchedVar());
        popup.add(this.varRemoveItem);
        this.varRemoveAllItem = new JMenuItem("Remove All", new ImageIcon(GraphUtilities.getImage("removeall.gif")));
        this.varRemoveAllItem.addActionListener(e -> this.removeAllWatchedVars());
        popup.add(this.varRemoveAllItem);
        popup.addSeparator();
        this.varCopyItem = new JMenuItem("Copy");
        this.varCopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.varCopyItem.addActionListener(e -> {
            JTreeTable tt = this.varTreeTable[Integer.parseInt(this.varCopyItem.getActionCommand())];
            ActionMap am = tt.getActionMap();
            Action a = am.get("copy");
            a.actionPerformed(new ActionEvent(tt, 1001, "copy"));
        });
        popup.add(this.varCopyItem);
        for (int i = 0; i < this.varTreeTable.length; ++i) {
            final int fi = i;
            this.varTreeTable[i].addMouseListener(new GraphUtilities.PopupMouseListener(){

                @Override
                public void showPopup(MouseEvent e) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                    Object node = DebugPanel.this.varTree[fi].getLastSelectedPathComponent();
                    boolean en = DebugPanel.this.refreshItem.isEnabled();
                    DebugPanel.this.varChangeValueItem.setEnabled(en && node != null);
                    DebugPanel.this.varAddMonitorItem.setEnabled(en && node != null);
                    DebugPanel.this.varRemoveItem.setEnabled(fi == 1 && node != null && ((VariableNode)node).getParent() == DebugPanel.this.varRootNode[fi]);
                    DebugPanel.this.varRemoveAllItem.setEnabled(DebugPanel.this.watchedVarnames.size() > 0);
                    DebugPanel.this.varCopyItem.setEnabled(en && node != null);
                    DebugPanel.this.varCopyItem.setActionCommand("" + fi);
                }
            });
        }
        this.variableTabbedPane.addTab("Variables", null, this.variablesPanel, null);
    }

    private void buildOutputArea() {
        this.outputArea = new JPanel();
        this.outputArea.setLayout(new BorderLayout(1, 1));
        this.textOutput = new JTextArea();
        this.textOutput.setFont(outputFont);
        this.textOutput.setBackground(outputBackground);
        this.textOutput.setForeground(outputForeground);
        this.textOutput.setCaretColor(outputForeground);
        this.textOutput.setSelectionColor(outputSelBackground);
        this.textOutput.setSelectedTextColor(outputSelForeground);
        this.textOutput.setEditable(false);
        this.textOutput.setLineWrap(true);
        this.textOutput.setWrapStyleWord(true);
        this.textOutput.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.textOutput){

            @Override
            protected void fillPopup() {
                super.fillPopup();
                this.popup.add(new JPopupMenu.Separator());
                DebugPanel.this.textOutputClearItem = new JMenuItem("Clear");
                DebugPanel.this.textOutputClearItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        textComponent.setText("");
                    }
                });
                this.popup.add(DebugPanel.this.textOutputClearItem);
            }
        });
        this.textOutput.addKeyListener(this.surrogateLineCommandListener);
        this.scrollTextOutput = DebugPanel.createJScrollPane(this.textOutput);
        this.lineCommand = new JTextField(){
            private static final long serialVersionUID = 123L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 25);
            }
        };
        this.lineCommand.addActionListener(e -> {
            if (this.graphDebug.isProcessing() && this.graphDebug.isRunning() && !this.graphDebug.isCommandAllowedInProcessing(this.lineCommand.getText())) {
                this.graphDebug.getInvoker().putInput(e.getActionCommand());
                this.lineCommand.setText("");
            } else {
                String[] ss = this.graphDebug.setTextCommand(this.lineCommand.getText());
                if (ss != null) {
                    this.lineCommand.setText(ss[0]);
                    if (ss.length > 1) {
                        this.lineCommand.setCaretPosition(Integer.parseInt(ss[1]));
                    }
                } else {
                    this.lineCommand.setText("");
                }
            }
        });
        this.lineCommand.addKeyListener(this.globalKeyListener);
        this.lineCommand.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.lineCommand.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        this.lineCommand.setFont(inputFont);
        this.lineCommand.setBackground(inputBackground);
        this.lineCommand.setForeground(inputForeground);
        this.lineCommand.setCaretColor(inputForeground);
        this.lineCommand.setSelectionColor(inputSelBackground);
        this.lineCommand.setSelectedTextColor(inputSelForeground);
        this.lineCommand.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.lineCommand));
    }

    void changeValue() {
        String cn;
        Object node = null;
        for (int i = 0; i < this.varTree.length && (node = this.varTree[i].getLastSelectedPathComponent()) == null; ++i) {
        }
        if (node == null) {
            return;
        }
        VariableNode vn = (VariableNode)node;
        String varname = GraphUtilities.nodeToVarname(vn);
        String defvalue = null;
        String cmd = "display";
        boolean hex = Settings.getHexOption();
        if (hex) {
            cmd = cmd + " -x";
        }
        if ((cn = vn.getClassName()) != null) {
            cmd = cmd + " -c " + cn;
        }
        cmd = cmd + " " + varname;
        DebugResponse resp = this.graphDebug.getInvoker().processCommand(cmd);
        if (resp != null && resp.getReturnCode() == 0) {
            defvalue = resp.getVarValue().trim();
            if (resp.getVarType() == 12) {
                defvalue = defvalue.substring(0, defvalue.indexOf(32));
                hex = false;
            }
        }
        if ((cmd = this.graphDebug.showAcceptVariableDialog(varname, cn, defvalue, null, hex)) != null && (resp = this.graphDebug.getInvoker().processCommand(cmd)) != null) {
            if (resp.getReturnCode() == 0) {
                this.refreshVariables();
            } else {
                this.outputResult0(resp.getMessage());
            }
        }
    }

    private void newMonitor() {
        this.graphDebug.showMonitorDialog();
    }

    void addMonitor() {
        VariableNode node = null;
        for (int i = 0; i < this.varTree.length && (node = (VariableNode)this.varTree[i].getLastSelectedPathComponent()) == null; ++i) {
        }
        if (node == null) {
            return;
        }
        String varname = GraphUtilities.nodeToVarname(node);
        String cmd = "display " + varname;
        boolean hex = Settings.getHexOption();
        DebugResponse resp = this.graphDebug.getInvoker().processCommand(cmd);
        if (resp != null && resp.getReturnCode() == 0 && resp.getVarType() == 12) {
            hex = false;
        }
        this.graphDebug.showMonitorDialog(varname, this.getSelectedModule(), null, true, hex);
    }

    private void addWatchedVar() {
        this.graphDebug.showDisplayVariableDialog(null, null, true);
    }

    private void removeWatchedVar() {
        VariableNode node = (VariableNode)this.varTree[1].getLastSelectedPathComponent();
        if (node == null || node.getParent() != this.varRootNode[1]) {
            return;
        }
        int idx = this.varRootNode[1].getIndex(node);
        if (idx >= 0) {
            VariableNode nodeToRemove = (VariableNode)this.varRootNode[1].getChildAt(idx);
            String name = nodeToRemove.getName();
            String cn = nodeToRemove.getClassName();
            this.removeFromWatchedVarNames(name, cn, this.watchedVarnames);
            this.varRemoveAllBtn.setEnabled(this.watchedVarnames.size() > 0);
            this.varRootNode[1].removeChildAt(idx);
            this.varTreeTable[1].reload();
        }
    }

    private void removeFromWatchedVarNames(String name, String cn, List<String[]> watchedVarnames) {
        for (int i = 0; i < watchedVarnames.size(); ++i) {
            String[] ss = watchedVarnames.get(i);
            if (!ss[0].equals(name) || (cn == null || !cn.equals(ss[1])) && (cn != null || ss[1] != null)) continue;
            watchedVarnames.remove(i);
            break;
        }
    }

    private void removeAllWatchedVars() {
        this.watchedVarnames.clear();
        this.varRemoveAllBtn.setEnabled(false);
        this.varRootNode[1].removeAllChildren();
        this.varTreeTable[1].reload();
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout(1, 1));
        this.buildToolBar();
        this.add((Component)this.toolbar, "North");
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setResizeWeight(1.0);
        this.add((Component)this.mainSplitPane, "Center");
        this.buildVariableArea();
        this.buildOutputArea();
        this.topSplitPane = new JSplitPane(1);
        this.topSplitPane.setOneTouchExpandable(true);
        this.topSplitPane.setResizeWeight(1.0);
        this.bottomSplitPane = new JSplitPane(1);
        this.bottomSplitPane.setOneTouchExpandable(true);
        this.buildMonitorArea();
        this.buildBreakpointArea();
        this.buildCallStackArea();
        this.buildThreadArea();
        this.buildCommandHistoryArea();
        this.buildConsoleArea();
        this.bottomRightTabbedPane = new JTabbedPane();
        this.bottomRightTabbedPane.setFocusable(false);
        this.bottomRightTabbedPane.setTabLayoutPolicy(0);
        this.bottomRightTabbedPane.add(PERF_STACK_TITLE, this.callStackPanel);
        this.bottomRightTabbedPane.add(MONITORS_TITLE, this.monitorPanel);
        this.bottomRightTabbedPane.add(BREAKPOINTS_TITLE, this.breakpointPanel);
        this.bottomRightTabbedPane.add(THREADS_TITLE, this.threadPanel);
        this.bottomRightTabbedPane.add(COMMAND_HISTORY_TITLE, this.commandHistoryPanel);
        this.bottomRightTabbedPane.add(CONSOLE_TITLE, this.consolePanel);
        this.bottomRightTabbedPane.setMnemonicAt(0, 80);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(0, 0);
        this.bottomRightTabbedPane.setMnemonicAt(1, 77);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(1, 0);
        this.bottomRightTabbedPane.setMnemonicAt(2, 66);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(2, 0);
        this.bottomRightTabbedPane.setMnemonicAt(3, 84);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(3, 0);
        this.bottomRightTabbedPane.setMnemonicAt(4, 67);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(4, 0);
        this.bottomRightTabbedPane.setMnemonicAt(5, 79);
        this.bottomRightTabbedPane.setDisplayedMnemonicIndexAt(5, 1);
        this.outputArea.add((Component)this.lineCommand, "South");
        this.outputArea.add((Component)this.scrollTextOutput, "Center");
        this.topSplitPane.setLeftComponent(this.previewPanel);
        this.topSplitPane.setRightComponent(this.variableLabel);
        this.bottomSplitPane.setLeftComponent(this.outputArea);
        this.bottomSplitPane.setRightComponent(this.bottomRightTabbedPane);
        this.mainSplitPane.setTopComponent(this.topSplitPane);
        this.mainSplitPane.setBottomComponent(this.bottomSplitPane);
        this.tipTimer = new Timer(Settings.getVariableHintDelay(), this.tipAction);
        this.tipTimer.setRepeats(false);
        this.handMouseTimer = new Timer(Settings.getVariableHandMouseDelay(), this.handMouseAction);
        this.handMouseTimer.setRepeats(false);
        Object obj = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        int clickDelay = obj instanceof Integer ? (Integer)obj : 500;
        this.linkTimer = new Timer(clickDelay, e -> {
            int listingLine;
            LocalDebugInfo.Location loc;
            if (this.highlightedVar != null && DebugPanel.isLink(this.highlightVarType) && this.highlightedVarLine >= 0 && (loc = this.getMemberLocation(this.tFileObj.ldInfo, this.highlightedVar, listingLine = this.getListingline(this.highlightedVarLine))) != null) {
                this.goTo(loc.line, null, loc.fileIndex);
                this.setHighlightedVar(null, HighlightVarType.NONE, -1, -1);
            }
        });
        this.linkTimer.setRepeats(false);
    }

    private void disableAllBreakpoints() {
        if (!(this.breakpointModel.isEmpty() || this.graphDebug.isProcessing() && this.graphDebug.stopImmediately)) {
            this.graphDebug.setAllBreakpointsEnabledCommand(false);
        }
    }

    private void enableAllBreakpoints() {
        if (!(this.breakpointModel.isEmpty() || this.graphDebug.isProcessing() && this.graphDebug.stopImmediately)) {
            this.graphDebug.setAllBreakpointsEnabledCommand(true);
        }
    }

    private void monitorTableSelectionChanged(int selectionCount) {
        boolean en = selectionCount > 0 && !this.graphDebug.isProcessing() && this.graphDebug.isRunning();
        this.monitorRemoveBtn.setEnabled(en);
        this.monitorModifyBtn.setEnabled(en);
        this.monitorRemoveItem.setEnabled(en);
        this.monitorModifyItem.setEnabled(en);
    }

    private void breakpointTableSelectionChanged(int selectionCount) {
        boolean en = selectionCount > 0 && !this.graphDebug.isProcessing();
        this.breakpointRemoveBtn.setEnabled(en);
        this.breakpointModifyBtn.setEnabled(en);
        this.breakpointRemoveItem.setEnabled(en);
        this.breakpointModifyItem.setEnabled(en);
    }

    private void removeBreakpoint() {
        Breakpoint bp = (Breakpoint)this.breakpointModel.elementAt(this.breakpointTable.getSelectedRow());
        if (bp != null) {
            String cmd = "clear ";
            cmd = bp.getParagraph() != null ? cmd + bp.getParagraph() : cmd + bp.getLine();
            if (bp.getFile() != null) {
                cmd = cmd + " \"" + bp.getFile() + "\"";
            }
            if (bp.getFileIndex() >= 0) {
                cmd = cmd + " -fi " + bp.getFileIndex();
            }
            if (bp.getProgram() != null) {
                cmd = cmd + " " + bp.getProgram();
            }
            this.graphDebug.setTextCommand(cmd);
        }
    }

    private void removeAllBreakpoints() {
        this.graphDebug.setTextCommand("clear -a");
    }

    private void modifyBreakpoint() {
        Breakpoint bp = (Breakpoint)this.breakpointModel.elementAt(this.breakpointTable.getSelectedRow());
        if (bp != null) {
            if (bp.getCondition() != null && !this.graphDebug.isRunning()) {
                JOptionPane.showMessageDialog(this.graphDebug.getFrame(), "Cannot modify a conditional breakpoint when the debugger is not running", this.graphDebug.getFrame().getTitle(), 0);
            } else {
                this.graphDebug.showBreakpointDialog(bp);
            }
        }
    }

    private void newBreakpoint() {
        this.graphDebug.showBreakpointDialog(null);
    }

    private void modifyMonitor() {
        Watch w = (Watch)this.monitorModel.elementAt(this.monitorTable.getSelectedRow());
        if (w != null) {
            this.graphDebug.showModifyMonitorDialog(w);
        }
    }

    private void enableAllMonitors() {
        if (!this.graphDebug.isProcessing() && !this.monitorModel.isEmpty()) {
            this.graphDebug.setAllMonitorsEnabledCommand(true);
        }
    }

    private void disableAllMonitors() {
        if (!this.graphDebug.isProcessing() && !this.monitorModel.isEmpty()) {
            this.graphDebug.setAllMonitorsEnabledCommand(false);
        }
    }

    private void removeMonitor() {
        Watch selItem = (Watch)this.monitorModel.elementAt(this.monitorTable.getSelectedRow());
        if (selItem != null) {
            this.graphDebug.setTextCommand(selItem.getDebugDelCommand());
        }
    }

    private void removeAllMonitors() {
        this.graphDebug.setTextCommand("unmonitor -a");
    }

    public int getSourceFontSize() {
        return currentFontSize;
    }

    public void setSourceFontSize(int size) {
        if (size >= 9 && size <= 20) {
            Font newFont = previewFont.deriveFont((float)size);
            this.setSourceFont(newFont);
            Settings.setFont("Source code", newFont);
            this.previewArea.repaint();
        }
    }

    public void setSourceFont(Font f) {
        currentFontSize = f.getSize();
        previewFont = f;
        previewLinkFont = previewFont.deriveFont(DebugPanel.getUnderlineAttrs());
        previewMetrics = this.previewArea.getFontMetrics(previewFont);
        this.initNumberColumnLen();
        this.previewRenderer.updateFontSettings(previewMetrics);
        this.previewArea.setFont(previewFont);
        this.previewArea.setFixedCellHeight(previewMetrics.getHeight() + 2);
        this.setPreferredListWidth();
    }

    private static Map<TextAttribute, Integer> getUnderlineAttrs() {
        HashMap<TextAttribute, Integer> fontAttributes = new HashMap<TextAttribute, Integer>();
        fontAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        return fontAttributes;
    }

    public void setSourceBackground(Color c) {
        sourceBackground = c;
        this.previewArea.setBackground(c);
    }

    public void setSourceForeground(Color c) {
        sourceForeground = c;
        this.previewArea.setForeground(c);
    }

    public void setHighBackground(Color c) {
        highBackground = c;
        this.previewArea.repaint();
    }

    public void setHighForeground(Color c) {
        highForeground = c;
        this.previewArea.repaint();
    }

    public void setSelectedBackground(Color c) {
        selBackground = c;
        this.previewArea.repaint();
    }

    public void setCommentForeground(Color c) {
        commentForeground = c;
        this.previewArea.repaint();
    }

    public void setKeywordForeground(Color c) {
        keywordForeground = c;
        this.previewArea.repaint();
    }

    public void setStringForeground(Color c) {
        stringForeground = c;
        this.previewArea.repaint();
    }

    public void setNumberForeground(Color c) {
        numberForeground = c;
        this.previewArea.repaint();
    }

    public void setStatementForeground(Color c) {
        stmtForeground = c;
        this.previewArea.repaint();
    }

    public void setLevelNumberForeground(Color c) {
        levnumForeground = c;
        this.previewArea.repaint();
    }

    public void setFigurativeConstantForeground(Color c) {
        figconsForeground = c;
        this.previewArea.repaint();
    }

    public void setBreakpointBackground(Color c) {
        bpLineBackground = c;
        this.previewArea.repaint();
    }

    public void setCopySourcePattern(String copySourcePattern) {
        copySourcePatternColors = DebugPanel.loadCopySourcePatternColors(copySourcePattern);
        this.previewArea.repaint();
    }

    public void setLNBackground(Color c) {
        lineNumberBackground = c;
        this.previewArea.repaint();
    }

    public void setLNForeground(Color c) {
        lineNumberForeground = c;
        this.previewArea.repaint();
    }

    public void setCurrLineBackground(Color c) {
        currLineBackground = c;
        this.previewArea.repaint();
    }

    public void setBPColBackground(Color c) {
        bpColBackground = c;
        this.previewArea.repaint();
    }

    public void setTipFont(Font f) {
        tipFont = f;
    }

    public void setTipBackground(Color c) {
        tipBackground = c;
    }

    public void setTipForeground(Color c) {
        tipForeground = c;
    }

    public void setPSFont(Font f) {
        perfStackFont = f;
        this.callStackTable.setFont(f);
        this.callStackNoInfoPanel.setFont(f);
    }

    public void setPSBackground(Color c) {
        perfStackBackground = c;
        this.callStackTable.setBackground(c);
        this.callStackNoInfoPanel.setBackground(c);
    }

    public void setPSForeground(Color c) {
        perfStackForeground = c;
        this.callStackTable.setForeground(c);
        this.callStackNoInfoPanel.setForeground(c);
    }

    public void setPSSelBackground(Color c) {
        perfStackSelBackground = c;
        this.callStackTable.setSelectionBackground(c);
    }

    public void setPSSelForeground(Color c) {
        perfStackSelForeground = c;
        this.callStackTable.setSelectionForeground(c);
    }

    public void setBPLFont(Font f) {
        bpListFont = f;
        this.breakpointTable.setFont(f);
    }

    public void setBPLBackground(Color c) {
        bpListBackground = c;
        this.breakpointTable.setBackground(c);
    }

    public void setBPLForeground(Color c) {
        bpListForeground = c;
        this.breakpointTable.setForeground(c);
    }

    public void setBPLSelBackground(Color c) {
        bpListSelBackground = c;
        this.breakpointTable.setSelectionBackground(c);
    }

    public void setBPLSelForeground(Color c) {
        bpListSelForeground = c;
        this.breakpointTable.setSelectionForeground(c);
    }

    public void setMLFont(Font f) {
        monListFont = f;
        this.monitorTable.setFont(f);
    }

    public void setMLBackground(Color c) {
        monListBackground = c;
        this.monitorTable.setBackground(c);
    }

    public void setMLForeground(Color c) {
        monListForeground = c;
        this.monitorTable.setForeground(c);
    }

    public void setMLSelBackground(Color c) {
        monListSelBackground = c;
        this.monitorTable.setSelectionBackground(c);
    }

    public void setMLSelForeground(Color c) {
        monListSelForeground = c;
        this.monitorTable.setSelectionForeground(c);
    }

    public void setCHFont(Font f) {
        cmdHistoryFont = f;
        this.commandHistory.setFont(f);
    }

    public void setCHBackground(Color c) {
        cmdHistoryBackground = c;
        this.commandHistory.setBackground(c);
    }

    public void setCHForeground(Color c) {
        cmdHistoryForeground = c;
        this.commandHistory.setForeground(c);
    }

    public void setCHSelBackground(Color c) {
        cmdHistorySelBackground = c;
        this.commandHistory.setSelectionBackground(c);
    }

    public void setCHSelForeground(Color c) {
        cmdHistorySelForeground = c;
        this.commandHistory.setSelectionForeground(c);
    }

    public void setTLFont(Font f) {
        threadListFont = f;
        this.threadNoInfoPanel.setFont(f);
        this.threadTable.setFont(f);
    }

    public void setTLBackground(Color c) {
        threadListBackground = c;
        this.threadNoInfoPanel.setBackground(c);
        this.threadTable.setBackground(c);
    }

    public void setTLForeground(Color c) {
        threadListForeground = c;
        this.threadNoInfoPanel.setForeground(c);
        this.threadTable.setForeground(c);
    }

    public void setDTFont(Font f) {
        int i;
        disTreeFont = f;
        if (this.varTreeTable != null) {
            for (i = 0; i < this.varTreeTable.length; ++i) {
                this.varTreeTable[i].setFont(disTreeFont);
            }
        }
        if (this.varTree != null) {
            for (i = 0; i < this.varTree.length; ++i) {
                this.varTree[i].setFont(disTreeFont);
            }
        }
        this.variablesPanel.repaint();
    }

    public void setDTBackground(Color c) {
        int i;
        disTreeBackground = c;
        if (this.varTreeTable != null) {
            for (i = 0; i < this.varTreeTable.length; ++i) {
                this.varTreeTable[i].setBackground(disTreeBackground);
            }
        }
        if (this.varTree != null) {
            for (i = 0; i < this.varTree.length; ++i) {
                this.varTree[i].setBackground(disTreeBackground);
            }
        }
        this.variablesPanel.repaint();
    }

    public void setDTForeground(Color c) {
        int i;
        disTreeForeground = c;
        if (this.varTreeTable != null) {
            for (i = 0; i < this.varTreeTable.length; ++i) {
                this.varTreeTable[i].setForeground(disTreeForeground);
            }
        }
        if (this.varTree != null) {
            for (i = 0; i < this.varTree.length; ++i) {
                this.varTree[i].setForeground(disTreeForeground);
            }
        }
        this.variablesPanel.repaint();
    }

    public void setDTSelBackground(Color c) {
        disTreeSelBackground = c;
        this.variablesPanel.repaint();
    }

    public void setDTSelForeground(Color c) {
        disTreeSelForeground = c;
        this.variablesPanel.repaint();
    }

    public void setOutputFont(Font f) {
        outputFont = f;
        this.textOutput.setFont(f);
    }

    public void setOutputBackground(Color c) {
        outputBackground = c;
        this.textOutput.setBackground(c);
    }

    public void setOutputForeground(Color c) {
        outputForeground = c;
        this.textOutput.setForeground(c);
        this.textOutput.setCaretColor(c);
    }

    public void setOutputSelBackground(Color c) {
        outputSelBackground = c;
        this.textOutput.setSelectionColor(c);
    }

    public void setOutputSelForeground(Color c) {
        outputSelForeground = c;
        this.textOutput.setSelectedTextColor(c);
    }

    public void setConsoleFont(Font f) {
        consoleFont = f;
        this.console.setFont(f);
    }

    public void setConsoleBackground(Color c) {
        consoleBackground = c;
        this.console.setBackground(c);
    }

    public void setConsoleForeground(Color c) {
        consoleForeground = c;
        this.console.setForeground(c);
        this.console.setCaretColor(c);
    }

    public void setConsoleSelBackground(Color c) {
        consoleSelBackground = c;
        this.console.setSelectionColor(c);
    }

    public void setConsoleSelForeground(Color c) {
        consoleSelForeground = c;
        this.console.setSelectedTextColor(c);
    }

    public void setConsoleStdErrForeground(Color c) {
        consoleStdErrForeground = c;
        StyleConstants.setForeground(this.console.getStyledDocument().getStyle("stderr"), c);
    }

    public void setInputFont(Font f) {
        inputFont = f;
        this.lineCommand.setFont(f);
    }

    public void setInputBackground(Color c) {
        inputBackground = c;
        this.lineCommand.setBackground(c);
    }

    public void setInputForeground(Color c) {
        inputForeground = c;
        this.lineCommand.setForeground(c);
        this.lineCommand.setCaretColor(c);
    }

    public void setInputSelBackground(Color c) {
        inputSelBackground = c;
        this.lineCommand.setSelectionColor(c);
    }

    public void setInputSelForeground(Color c) {
        inputSelForeground = c;
        this.lineCommand.setSelectedTextColor(c);
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        if (v) {
            int mainDivLoc = Settings.getMainSplitPaneDividerLocation();
            if (mainDivLoc >= 0) {
                this.mainSplitPane.setDividerLocation(mainDivLoc);
            } else {
                this.mainSplitPane.setDividerLocation(0.75);
            }
            int outDivLoc = Settings.getOutputSplitPaneDividerLocation();
            if (outDivLoc >= 0) {
                this.bottomSplitPane.setDividerLocation(outDivLoc);
            } else {
                this.bottomSplitPane.setDividerLocation(0.7f);
            }
            this.openVariablesArea();
            this.topSplitPaneDividerLocation = -1;
        }
    }

    private boolean isVariablesAreaOpen() {
        return this.topSplitPane.isEnabled();
    }

    private void openVariablesArea() {
        if (this.topSplitPane.getRightComponent() != null) {
            this.topSplitPane.remove(this.topSplitPane.getRightComponent());
        }
        this.topSplitPane.setRightComponent(this.variableTabbedPane);
        this.topSplitPane.setEnabled(true);
        this.topSplitPane.setOneTouchExpandable(true);
        int divLoc = Settings.getSourceSplitPaneDividerLocation();
        if (divLoc > 0 && divLoc < this.topSplitPane.getMaximumDividerLocation()) {
            this.topSplitPane.setDividerLocation(divLoc);
        } else {
            this.topSplitPane.setDividerLocation(0.75);
        }
        this.topSplitPaneDividerLocation = this.topSplitPane.getDividerLocation();
        SwingUtilities.invokeLater(() -> {
            int divLoc0 = Settings.getVariableSplitPaneDividerLocation();
            if (divLoc0 > 0 && divLoc0 < this.varSplitPane.getMaximumDividerLocation()) {
                this.varSplitPane.setDividerLocation(divLoc0);
            } else {
                this.varSplitPane.setDividerLocation(0.5);
            }
            this.varSplitPaneDividerLocation = this.varSplitPane.getDividerLocation();
        });
    }

    protected void selectBreakpointsTab() {
        int idx = this.bottomRightTabbedPane.indexOfTab(BREAKPOINTS_TITLE);
        if (idx >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(idx);
        }
    }

    protected void selectThreadsTab() {
        int idx = this.bottomRightTabbedPane.indexOfTab(THREADS_TITLE);
        if (idx >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(idx);
        }
    }

    protected void selectMonitorsTab() {
        int idx = this.bottomRightTabbedPane.indexOfTab(MONITORS_TITLE);
        if (idx >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(idx);
        }
    }

    protected void selectPerformStackTab() {
        int idx = this.bottomRightTabbedPane.indexOfTab(PERF_STACK_TITLE);
        if (idx >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(idx);
        }
    }

    protected void selectConsoleTab() {
        int idx = this.bottomRightTabbedPane.indexOfTab(CONSOLE_TITLE);
        if (idx >= 0) {
            this.bottomRightTabbedPane.setSelectedIndex(idx);
        }
    }

    private static JButton createJButton(ImageIcon icon, boolean enabled, ActionListener listener) {
        return DebugPanel.createJButton(icon, "", enabled, listener);
    }

    private static JButton createJButton(ImageIcon icon, String toolTipText, boolean enabled, ActionListener listener) {
        JButton btn = new JButton(icon);
        btn.setFocusable(false);
        btn.addActionListener(listener);
        btn.setToolTipText(toolTipText);
        btn.setEnabled(enabled);
        return btn;
    }

    private void buildToolBar() {
        this.toolbar = new JToolBar();
        this.toolbar.setLayout(new BorderLayout(3, 0){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void layoutContainer(Container target) {
                Object object = DebugPanel.this.toolbar.getTreeLock();
                synchronized (object) {
                    Dimension toolSize = DebugPanel.this.toolbar.getSize();
                    Insets insets = DebugPanel.this.toolbar.getInsets();
                    int top = insets.top;
                    int bottom = toolSize.height - insets.bottom;
                    int left = insets.left;
                    int right = toolSize.width - insets.right;
                    JComponent c = DebugPanel.this.btnToolbar;
                    Dimension cd = c.getSize();
                    c.setSize(cd.width, bottom - top);
                    Dimension d = ((Component)c).getPreferredSize();
                    Rectangle r = new Rectangle(right - d.width, top, d.width, bottom - top);
                    right -= d.width + 3;
                    c = DebugPanel.this.memoryView;
                    cd = c.getSize();
                    c.setSize(cd.width, bottom - top);
                    d = ((Component)c).getPreferredSize();
                    c.setBounds(left, top, d.width, bottom - top);
                    c = DebugPanel.this.fileChooser;
                    int w = right - (left += d.width + 3);
                    int x = left;
                    int diff = w - 180;
                    if (diff < 0) {
                        w += -diff;
                        r.width += diff;
                        r.x += -diff;
                    }
                    DebugPanel.this.btnToolbar.setBounds(r);
                    c.setBounds(x, top, w, bottom - top);
                }
            }
        });
        ImageIcon run = this.graphDebug.isRemote() ? new ImageIcon(GraphUtilities.getImage("connect.gif")) : new ImageIcon(GraphUtilities.getImage("rundebug.gif"));
        ImageIcon cont = new ImageIcon(GraphUtilities.getImage("continue.gif"));
        ImageIcon susp = new ImageIcon(GraphUtilities.getImage("suspend.gif"));
        ImageIcon stepOver = new ImageIcon(GraphUtilities.getImage("stepover.gif"));
        ImageIcon stepInto = new ImageIcon(GraphUtilities.getImage("stepinto.gif"));
        ImageIcon stepOut = new ImageIcon(GraphUtilities.getImage("stepout.gif"));
        ImageIcon stepOutProg = new ImageIcon(GraphUtilities.getImage("stepoutprog.gif"));
        ImageIcon runTillCurs = new ImageIcon(GraphUtilities.getImage("runtilcurs.gif"));
        ImageIcon runTillPgm = new ImageIcon(GraphUtilities.getImage("runtilpgm.gif"));
        ImageIcon jump = new ImageIcon(GraphUtilities.getImage("jump.gif"));
        ImageIcon jumpout = new ImageIcon(GraphUtilities.getImage("jumpout.gif"));
        ImageIcon jumpover = new ImageIcon(GraphUtilities.getImage("jumpover.gif"));
        ImageIcon jumpoutprog = new ImageIcon(GraphUtilities.getImage("jumpoutprog.gif"));
        ImageIcon gotocurrline = new ImageIcon(GraphUtilities.getImage("gotocurrline.gif"));
        ImageIcon stopDebug = this.graphDebug.isRemote() ? new ImageIcon(GraphUtilities.getImage("disconnect.gif")) : new ImageIcon(GraphUtilities.getImage("stop.gif"));
        ImageIcon findIcon = new ImageIcon(GraphUtilities.getImage("find.gif"));
        ImageIcon repeatFind = new ImageIcon(GraphUtilities.getImage("find_repeat.gif"));
        breakpointImage = GraphUtilities.getImage("breakpoint.gif");
        disbreakpointImage = GrayFilter.createDisabledImage(breakpointImage);
        currlineImage = GraphUtilities.getImage("currline.gif");
        expandCopyImage = GraphUtilities.getImage("expand.gif");
        collapseCopyImage = GraphUtilities.getImage("collapse.gif");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(breakpointImage, 0);
        mt.addImage(disbreakpointImage, 1);
        mt.addImage(currlineImage, 2);
        mt.addImage(collapseCopyImage, 3);
        mt.addImage(expandCopyImage, 4);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        UIManager.put("ProgressBar.selectionForeground", Color.blue);
        this.memoryView = new JProgressBar();
        this.memoryView.setPreferredSize(new Dimension(100, 23));
        this.memoryView.setOrientation(0);
        this.memoryView.setMinimum(0);
        this.memoryView.setMaximum(1);
        this.memoryView.setBackground(Color.white);
        this.memoryView.setForeground(Color.green);
        this.memoryView.setValue(0);
        this.memoryView.setString("");
        this.memoryView.setToolTipText("Click to force garbage collector");
        this.memoryView.setStringPainted(true);
        this.memoryView.setBorderPainted(true);
        this.memoryView.setEnabled(false);
        this.memoryView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                DebugPanel.this.memoryView.setBorder(BorderFactory.createLineBorder(Color.white));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DebugPanel.this.memoryView.setBorder(BorderFactory.createLineBorder(Color.black));
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DebugPanel.this.graphDebug.setTextCommand("gc");
                DebugPanel.this.memoryView.setBorder(BorderFactory.createLineBorder(Color.black));
            }
        });
        this.toolbar.add((Component)this.memoryView, "West");
        this.fileChooser.setFocusable(false);
        this.fileChooser.setFont(new Font("sansserif", 0, 12));
        this.fileChooser.setPreferredSize(new Dimension(180, DebugPanel.BTN_SIZE.height));
        this.fileChooser.addActionListener(evt -> {
            String file = (String)this.fileChooser.getSelectedItem();
            if (file != null && !this.currFile.equals(file)) {
                this.changeFile(true, new Filename(file), 0L, true);
            }
        });
        this.toolbar.add((Component)this.fileChooser, "Center");
        this.btnToolbar = new JToolBar();
        this.btnToolbar.setFloatable(false);
        this.btnToolbar.setLayout(new FlowLayout(0, 3, 0));
        this.warnLbl.setText("!");
        this.warnLbl.setHorizontalAlignment(0);
        this.warnLbl.setFont(new Font("sanserif", 1, 20));
        this.btnToolbar.add(this.warnLbl);
        this.btnFind = DebugPanel.createJButton(findIcon, true, e -> {
            this.hideTipPopup();
            this.graphDebug.getFindDialog().setVisible(this.getHighlightedWord());
        });
        this.btnToolbar.add(this.btnFind);
        this.btnRepeatFind = DebugPanel.createJButton(repeatFind, "Repeat find", true, e -> this.repeatFind());
        this.btnToolbar.add(this.btnRepeatFind);
        this.btnToolbar.add(this.newToolBarSeparator());
        this.btnGotoCurrLine = DebugPanel.createJButton(gotocurrline, true, e -> this.selectCurrentLine());
        this.btnToolbar.add(this.btnGotoCurrLine);
        this.btnToolbar.add(this.newToolBarSeparator());
        this.btnRun = DebugPanel.createJButton(run, true, e -> this.graphDebug.setTextCommand("run " + GraphDebugger.getChainingString()));
        this.btnToolbar.add(this.btnRun);
        this.btnStop = DebugPanel.createJButton(stopDebug, false, e -> {
            if (this.graphDebug.isProcessing()) {
                if (this.graphDebug.showConfirmQuitDialog()) {
                    this.graphDebug.setQuitCommandExecuted(true);
                    this.graphDebug.getInvoker().exitDebug(this.graphDebug.isRemote() && Settings.getForceStopRun());
                }
            } else {
                this.graphDebug.setTextCommand("quit");
            }
        });
        this.btnToolbar.add(this.btnStop);
        this.btnToolbar.add(this.newToolBarSeparator());
        this.btnContinue = DebugPanel.createJButton(cont, false, e -> this.graphDebug.setTextCommand("continue"));
        this.btnToolbar.add(this.btnContinue);
        this.btnSuspend = DebugPanel.createJButton(susp, "Pause", false, e -> this.graphDebug.setTextCommand("pause"));
        this.btnToolbar.add(this.btnSuspend);
        this.btnStepInto = DebugPanel.createJButton(stepInto, false, e -> this.graphDebug.setTextCommand("step"));
        this.btnToolbar.add(this.btnStepInto);
        this.btnNext = DebugPanel.createJButton(stepOver, false, e -> this.graphDebug.setTextCommand("next"));
        this.btnToolbar.add(this.btnNext);
        this.btnOutPar = DebugPanel.createJButton(stepOut, false, e -> this.graphDebug.setTextCommand("outpar"));
        this.btnToolbar.add(this.btnOutPar);
        this.btnOutProg = DebugPanel.createJButton(stepOutProg, false, e -> this.graphDebug.setTextCommand("outprog"));
        this.btnToolbar.add(this.btnOutProg);
        this.btnStepTo = DebugPanel.createJButton(runTillCurs, false, e -> this.graphDebug.runToSelectedLine(this.selLine, this.tFileObj.tf));
        this.btnToolbar.add(this.btnStepTo);
        this.btnStepToPgm = DebugPanel.createJButton(runTillPgm, false, e -> this.graphDebug.setTextCommand("prog"));
        this.btnToolbar.add(this.btnStepToPgm);
        this.btnAutoStep = new ToggleImageButton("", GraphUtilities.getImage("autostep.gif"), e -> this.autostepStateChanged(), false);
        this.btnAutoStep.setPreferredSize(BTN_SIZE);
        this.btnToolbar.add(this.btnAutoStep);
        SpinnerNumberModel spinModel = new SpinnerNumberModel(1.0, 0.1, 3.0, 0.1);
        this.autoStepDelay = new JSpinner(spinModel);
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.autoStepDelay);
        editor.getTextField().setEditable(false);
        this.autoStepDelay.setFocusable(false);
        editor.getTextField().setFocusable(false);
        editor.getTextField().setFont(new Font("sansserif", 0, 9));
        editor.getTextField().setBackground(Color.white);
        this.autoStepDelay.setEditor(editor);
        this.autoStepDelay.addChangeListener(e -> {
            int d = (int)(1000.0 * (Double)this.autoStepDelay.getValue());
            this.graphDebug.setAutostepDelay(d);
        });
        this.autoStepDelay.setPreferredSize(new Dimension(50, 25));
        editor.getTextField().setToolTipText("Autostep delay");
        this.btnToolbar.add(this.autoStepDelay);
        this.btnJumpNext = DebugPanel.createJButton(jumpover, false, e -> this.graphDebug.setTextCommand("jump -next"));
        this.btnToolbar.add(this.btnJumpNext);
        this.btnJumpOutPar = DebugPanel.createJButton(jumpout, false, e -> this.graphDebug.setTextCommand("jump -outpar"));
        this.btnToolbar.add(this.btnJumpOutPar);
        this.btnJumpOutProg = DebugPanel.createJButton(jumpoutprog, false, e -> this.graphDebug.setTextCommand("jump -outprog"));
        this.btnToolbar.add(this.btnJumpOutProg);
        this.btnJump = DebugPanel.createJButton(jump, false, e -> this.jumpToSelectedLine());
        this.btnToolbar.add(this.btnJump);
        this.toolbar.add((Component)this.btnToolbar, "East");
    }

    private void autostepStateChanged() {
        if (this.btnAutoStep.isSelected()) {
            this.btnAutoStep.setBorder(BorderFactory.createLoweredBevelBorder());
            this.btnAutoStep.setBorderPainted(true);
            this.btnAutoStep.setToolTipText("Stop autostep" + DebugPanel.getShortcutText("graphdebugger.shortcut.stoff"));
            this.graphDebug.startAutostep();
        } else {
            this.btnAutoStep.setBorder(BorderFactory.createRaisedBevelBorder());
            this.btnAutoStep.setBorderPainted(false);
            this.btnAutoStep.setToolTipText("Start autostep" + DebugPanel.getShortcutText("graphdebugger.shortcut.ston"));
            this.graphDebug.stopAutostep();
        }
    }

    private JComponent newToolBarSeparator() {
        return this.newToolBarSeparator(new Dimension(1, DebugPanel.BTN_SIZE.height - 2), true);
    }

    private JComponent newToolBarSeparator(Dimension prefSize, boolean showBorder) {
        Box.Filler sep = new Box.Filler(prefSize, prefSize, prefSize);
        if (showBorder) {
            class DashedBorder
            extends AbstractBorder {
                private static final long serialVersionUID = 1L;

                DashedBorder() {
                }

                @Override
                public void paintBorder(Component comp, Graphics g, int x, int y, int w, int h) {
                    Graphics2D gg = (Graphics2D)g;
                    gg.setColor(Color.darkGray);
                    gg.setStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f}, 0.0f));
                    gg.drawRect(x, y, w - 1, h - 1);
                }
            }
            sep.setBorder(new DashedBorder());
        }
        return sep;
    }

    protected MyVarName getVarName() {
        MyVarName varname = null;
        if (this.quickWatchPoint != null) {
            varname = this.getVarName(this.quickWatchPoint);
        }
        return varname;
    }

    private MyVarName getVarName(Point p) {
        int cp;
        int row = this.previewArea.locationToIndex(p);
        int lstLine = this.getListingline(row);
        String line = this.tFileObj.tf.getLine(lstLine, false);
        MyVarName Return2 = this.getVarName(line, cp = GraphUtilities.pixelsToOffset(previewMetrics, line, p.x - 20 - numberColumnLen));
        if (Return2 != null) {
            Return2.lstLine = lstLine;
        }
        return Return2;
    }

    private MyVarName getVarName(String line, int caretPosition) {
        List<MyVarName> varNames = this.getVarNames(line, caretPosition, this.getSourceFormat(), Collections.EMPTY_SET);
        if (varNames != null && varNames.size() > 0) {
            return varNames.get(varNames.size() - 1);
        }
        return null;
    }

    private boolean isComment(Token tk, int format, int ansiCommentColumn_1) {
        return (format == 1 || format == 5) && tk.getOffset() == ansiCommentColumn_1 || format == 4 && (tk.getOffset() == ansiCommentColumn_1 || tk.getOffset() == 0) || format == 2 && tk.getOffset() == 0;
    }

    private int getAnsiCommentColumn(String line) {
        int ansiCommentColumn = 7;
        if (this.ccbas && line.length() > 3) {
            try {
                byte[] b = line.substring(0, 3).getBytes(CobolVar.encoding);
                ansiCommentColumn += 3 - b.length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return ansiCommentColumn;
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<MyVarName> getVarNames(String line, int caretPosition, int format, Set<String> parNames) {
        ArrayList<MyVarName> vars = new ArrayList<MyVarName>();
        TokenList tl = new TokenList();
        PreProcessor.tokenizer(tl, new StringBuffer(line), 0, "", 0, '.', null, null, false, true, format);
        Token tk = tl.getFirst();
        while (tk != null) {
            if (tk.getToknum() == 10000) {
                tk.putKeyword(this.nrw);
            }
            tk = tl.getNext();
        }
        StringBuffer Return2 = null;
        int startIndex = 0;
        int ansiCommentColumn_1 = this.getAnsiCommentColumn(line) - 1;
        Token tk2 = tl.getFirst();
        while (tk2 != null) {
            block16: {
                int currIdx;
                block19: {
                    Token lastToken;
                    block17: {
                        int openPar;
                        block18: {
                            boolean hostVar = false;
                            if (tk2.getToknum() == 42 && tk2.getOffset() <= caretPosition && this.isComment(tk2, format, ansiCommentColumn_1)) {
                                return vars;
                            }
                            if (tk2.getToknum() != 10009 || caretPosition >= 0 && tk2.getOffset() > caretPosition) break block16;
                            currIdx = tl.getCurrentIndex();
                            if (currIdx > 0) {
                                Token prev = tl.getAt(currIdx - 1);
                                hostVar = prev.getToknum() == 58;
                                tl.getAt(currIdx);
                            }
                            Return2 = new StringBuffer();
                            startIndex = tk2.getOffset();
                            Return2.append(tk2.getOriginalWord());
                            lastToken = tk2;
                            Token tk22 = tl.getNext();
                            while (tk22 != null && (tk22.getToknum() == 609 || tk22.getToknum() == 526 || tk22.getToknum() == 10006)) {
                                lastToken = tk22;
                                tk22 = tl.getNext();
                                if (tk22 != null && tk22.getToknum() == 10009) {
                                    if (lastToken.getToknum() != 10006) {
                                        Return2.append(" ");
                                        Return2.append(lastToken.getOriginalWord());
                                        Return2.append(" ");
                                    } else {
                                        Return2.append(".");
                                    }
                                    Return2.append(tk22.getOriginalWord());
                                    lastToken = tk22;
                                    tk22 = tl.getNext();
                                    continue;
                                }
                                if (lastToken.getToknum() == 10006 || hostVar && lastToken.getToknum() == 526) break;
                                Return2 = null;
                                tk2 = tl.getAt(currIdx);
                                break block16;
                            }
                            if (tk22 == null || tk22.getToknum() != 40) break block17;
                            openPar = 1;
                            Return2.append(tk22.getOriginalWord()).append(" ");
                            lastToken = tk22;
                            tk22 = tl.getNext();
                            while (tk22 != null) {
                                Return2.append(tk22.getOriginalWord()).append(" ");
                                lastToken = tk22;
                                if (tk22.getToknum() == 40) {
                                    ++openPar;
                                }
                                if (tk22.getToknum() == 41 && --openPar <= 0) break;
                                tk22 = tl.getNext();
                            }
                            if (openPar == 0) break block18;
                            Return2 = null;
                            tk2 = tl.getAt(currIdx);
                            break block16;
                        }
                        Token tk3 = tl.getNext();
                        if (tk3 == null || tk3.getToknum() != 40) break block17;
                        openPar = 1;
                        Return2.append(tk3.getOriginalWord()).append(" ");
                        lastToken = tk3;
                        tk3 = tl.getNext();
                        while (tk3 != null) {
                            Return2.append(tk3.getOriginalWord()).append(" ");
                            lastToken = tk3;
                            if (tk3.getToknum() == 40) {
                                ++openPar;
                            }
                            if (tk3.getToknum() == 41 && --openPar <= 0) break;
                            tk3 = tl.getNext();
                        }
                        if (openPar == 0) break block17;
                        Return2 = null;
                        tk2 = tl.getAt(currIdx);
                        break block16;
                    }
                    if (caretPosition >= 0 && lastToken.getOffset() + lastToken.getWord().length() - 1 < caretPosition) break block19;
                    String v = Return2.toString().trim();
                    String vu = v.toUpperCase();
                    if (this.nrw.contains(vu) || !statements.contains(vu) && !keywords.contains(vu) && !parNames.contains(vu)) {
                        int endIdx = Math.min(line.length(), lastToken.getOffset() + lastToken.getWord().length());
                        MyVarName mvn = new MyVarName(v, line.substring(startIndex, endIdx));
                        mvn.offs = startIndex;
                        vars.add(mvn);
                        if (v.indexOf(46) < 0) {
                            tk2 = tl.getAt(currIdx);
                        }
                        break block16;
                    } else {
                        tk2 = tl.getAt(currIdx);
                    }
                    break block16;
                }
                tk2 = tl.getAt(currIdx);
            }
            tk2 = tl.getNext();
        }
        return vars;
    }

    public static boolean isLevelNumber(String str) {
        try {
            int num = Integer.parseInt(str);
            return num >= 1 && num <= 49 || num == 66 || num == 77 || num == 78 || num == 88;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private DebugResponse displayVar(String word, int listingLine) {
        if (word != null && word.length() > 0 && (word = this.normalizeVarName(this.tFileObj.ldInfo, word, listingLine)) != null) {
            String cmd = "display";
            String module = this.getSelectedModule();
            if (module != null) {
                cmd = cmd + " ";
                cmd = cmd + "-c";
                cmd = cmd + " ";
                cmd = cmd + module;
            }
            cmd = cmd + " ";
            cmd = cmd + word;
            return this.graphDebug.getInvoker().processCommand(cmd);
        }
        return null;
    }

    private void initNumberColumnLen() {
        if (this.tFileObj.tf.getNumLines() > 0) {
            numberColumnLen = String.valueOf(this.tFileObj.tf.getNumLines()).length() * previewMetrics.stringWidth("0") + 4;
        }
    }

    private void setPreferredListWidth() {
        if (this.tFileObj != null && previewMetrics != null) {
            preferredPreviewWidth = previewMetrics.stringWidth(this.tFileObj.tf.getLongestLine()) + 20 + numberColumnLen + 2;
        }
    }

    private void changeFile(boolean reloadTextFile, Filename file, long timestamp, boolean showErrorMsg) {
        this.currFile = file.getOrigName();
        this.graphDebug.setUnloadEnabled(!this.currFile.equals(this.mainProgram));
        if (this.tFileObj != null) {
            this.tFileObj.tf.setCurrLine(this.currLine);
        }
        if (reloadTextFile) {
            this.getFile(null, file, timestamp, false, showErrorMsg);
        }
        this.initNumberColumnLen();
        this.setPreferredListWidth();
        this.setCurrentLine(this.tFileObj.tf.getCurrLine());
    }

    void resetIdxs() {
        this.currLine = -1;
        this.setSelectedLine(-1);
    }

    public void doFind(String cmd, boolean backSearch, boolean fromTop) {
        new IsguiWorker(false, () -> {
            StringTokenizer st = new StringTokenizer(cmd);
            if (st.countTokens() < 2) {
                this.outputResult("- usage " + st.nextToken() + " text" + GraphDebugger.eol);
            } else {
                String text = st.nextToken();
                text = st.nextToken("\n").trim();
                this.fparam = new FindDialog.FindParam(text, false, false, backSearch, true, fromTop, false);
                this.find(this.fparam);
            }
        }).start();
    }

    public void repeatFind() {
        if (this.fparam != null) {
            this.find(this.fparam);
        }
    }

    public void find(FindDialog.FindParam fp) {
        new IsguiWorker(false, () -> {
            boolean up;
            String match;
            this.graphDebug.getFindDialog().addItemToSearchList(fp.toSearch);
            this.fparam = fp;
            int len = this.fparam.toSearch.length();
            if (this.fparam.searchFromTop) {
                this.fparam.searchFromTop = false;
                this.setSelectedLine(0);
                this.setCursorColumn(0, this.selLine);
                this.cursorX = 20 + numberColumnLen;
            }
            if (this.fparam.matchCase) {
                match = this.fparam.toSearch;
                up = false;
            } else {
                match = this.fparam.toSearch.toUpperCase();
                up = true;
            }
            boolean mMinusUnderscore = this.fparam.matchMinusUnderscore;
            if (!mMinusUnderscore) {
                match = match.replaceAll("_", "-");
            }
            TextFile tFile = this.tFileObj.tf;
            int selListingLine = this.getListingline(this.selLine);
            if (this.fparam.backSearch) {
                int rc;
                String s = tFile.getLine(selListingLine, up, mMinusUnderscore);
                if (this.cursorColumn < s.length()) {
                    s = s.substring(0, this.cursorColumn);
                }
                if ((rc = s.lastIndexOf(match)) >= 0 && rc + match.length() == s.length()) {
                    s = s.substring(0, s.length() - match.length());
                    rc = s.lastIndexOf(match);
                }
                if (rc >= 0) {
                    if (!this.fparam.wholeWords || this.isWholeWord(s, rc, len)) {
                        this.select(this.selLine, rc + len, this.fparam.toSearch);
                        return;
                    }
                } else {
                    int i;
                    for (i = selListingLine - 1; i >= 0; --i) {
                        s = tFile.getLine(i, up, mMinusUnderscore);
                        rc = s.lastIndexOf(match);
                        if (rc < 0 || this.fparam.wholeWords && !this.isWholeWord(s, rc, len)) continue;
                        this.select(this.getLineIndex(i, true), rc + len, this.fparam.toSearch);
                        return;
                    }
                    if (this.fparam.wrapSearch) {
                        for (i = tFile.getNumLines() - 1; i >= selListingLine; --i) {
                            s = tFile.getLine(i, up, mMinusUnderscore);
                            rc = s.lastIndexOf(match);
                            if (rc < 0 || this.fparam.wholeWords && !this.isWholeWord(s, rc, len)) continue;
                            this.select(this.getLineIndex(i, true), rc + len, this.fparam.toSearch);
                            return;
                        }
                    }
                }
                JOptionPane.showMessageDialog(this.graphDebug.getFrame(), "'" + this.fparam.toSearch + "' not found", "Find", 1);
            } else {
                String s = tFile.getLine(selListingLine, up, mMinusUnderscore);
                int rc = s.indexOf(match, this.cursorColumn);
                if (rc >= 0) {
                    if (!this.fparam.wholeWords || this.isWholeWord(s, rc, len)) {
                        this.select(this.selLine, rc + len, this.fparam.toSearch);
                        return;
                    }
                } else {
                    int i;
                    for (i = selListingLine + 1; i < tFile.getNumLines(); ++i) {
                        s = tFile.getLine(i, up, mMinusUnderscore);
                        rc = s.indexOf(match);
                        if (rc < 0 || this.fparam.wholeWords && !this.isWholeWord(s, rc, len)) continue;
                        this.select(this.getLineIndex(i, true), rc + len, this.fparam.toSearch);
                        return;
                    }
                    if (this.fparam.wrapSearch) {
                        for (i = 0; i <= selListingLine; ++i) {
                            s = tFile.getLine(i, up, mMinusUnderscore);
                            rc = s.indexOf(match);
                            if (rc < 0 || this.fparam.wholeWords && !this.isWholeWord(s, rc, len)) continue;
                            this.select(this.getLineIndex(i, true), rc + len, this.fparam.toSearch);
                            return;
                        }
                    }
                }
                this.setHighlightedWord(null);
                JOptionPane.showMessageDialog(this.graphDebug.getFrame(), "'" + this.fparam.toSearch + "' not found", "Find", 1);
            }
        }).start();
    }

    String getHighlightedWord() {
        return this.highlightedWord;
    }

    private void setHighlightedWord(String w) {
        this.highlightedWord = w;
        if (this.highlightedWord != null) {
            this.highlightedVar = null;
        }
    }

    private void setHighlightedVar(String v) {
        this.setHighlightedVar(v, HighlightVarType.HIGHLIGHT, -1, -1);
    }

    private void setHighlightedVar(String v, HighlightVarType hvt, int line, int col) {
        this.highlightedVar = v;
        this.highlightVarType = hvt;
        this.highlightedVarLine = line;
        this.highlightedVarCol = col;
        this.highlightedWord = null;
        if (DebugPanel.isLink(this.highlightVarType)) {
            this.graphDebug.getFrame().setCursor(HAND_CURSOR);
        } else {
            this.graphDebug.getFrame().setCursor(DEF_CURSOR);
        }
        this.previewArea.repaint();
    }

    boolean isWholeWord(String s, int rc, int len) {
        char ch = rc == 0 ? (char)' ' : s.charAt(rc - 1);
        if (Character.isLetterOrDigit(ch) || ch == '-' || ch == '_') {
            return false;
        }
        if (rc + len < s.length()) {
            ch = s.charAt(rc + len);
        }
        return !Character.isLetterOrDigit(ch) && ch != '-' && ch != 95;
    }

    public TextFile loadFile(LocalDebugInfo dInfo, Filename newFile, long timestamp, boolean listing) {
        return this.load((LocalDebugInfo)dInfo, (Filename)newFile, (long)timestamp, (boolean)listing).tf;
    }

    private TextFileObj load(LocalDebugInfo dInfo, Filename newFile, long timestamp, boolean listing) {
        this.tFileObj.tf.setCurrLine(this.currLine);
        this.getFile(dInfo, newFile, timestamp, listing, true);
        this.currLine = -1;
        this.changeFile(false, newFile, timestamp, false);
        this.fileChooser.setSelectedItem(newFile.getOrigName());
        return this.tFileObj;
    }

    public void unload() {
        this.unload(this.tFileObj.tf);
    }

    void unload(TextFile tf) {
        if (!tf.getFilename().equals(this.mainProgram)) {
            this.textFiles.remove(new Filename(tf.getFilename()).getOrigName());
            this.fileChooser.removeItem(new Filename(tf.getFilename()).getOrigName());
        }
    }

    public void goTo(int line, String par, int fileIndex) {
        this.goTo(line, par, fileIndex, false, -1);
    }

    private LocalDebugInfo.Location getMemberLocation(LocalDebugInfo ldInfo, String name, int listingLine) {
        this.checkLdInfoReady(ldInfo);
        return ldInfo.getMemberLocation(name, listingLine, this.tFileObj.tf);
    }

    private String normalizeVarName(LocalDebugInfo ldInfo, String name, int listingLine) {
        this.checkLdInfoReady(ldInfo);
        return ldInfo.normalizeVarName(name, listingLine, this.tFileObj.tf);
    }

    private void checkLdInfoReady(LocalDebugInfo ldInfo) {
        if (!ldInfo.isReady()) {
            JFrame frame = this.graphDebug.getFrame();
            Cursor cursor = frame.getCursor();
            frame.setCursor(BUSY_CURSOR);
            ldInfo.waitUntilIsReady();
            frame.setCursor(cursor);
        }
    }

    public void goTo(int line, String par, int fileIndex, boolean islastparagraph, int lastline) {
        TextFile tFile = this.tFileObj.tf;
        int listingLine = tFile.toListingLine(line, fileIndex);
        LocalDebugInfo ldInfo = this.tFileObj.ldInfo;
        if (par != null) {
            LocalDebugInfo.Location loc;
            if (ldInfo != null && (loc = this.getMemberLocation(ldInfo, par, listingLine)) != null) {
                listingLine = tFile.toListingLine(loc.line, loc.file, loc.fileIndex);
            } else {
                CobolRef ref = tFile.paragraphToLine(par.trim());
                if (ref != null) {
                    listingLine = tFile.toListingLine(ref.lineNo(), new Filename(ref.filename()), ref.getFileIndex());
                }
            }
        }
        int selListingLine = this.getListingline(this.selLine);
        int selectedLine = this.getLineIndex(listingLine, true);
        if (selectedLine >= 0) {
            if (this.currLine == -1) {
                int tmpgotoLine;
                if (islastparagraph) {
                    this.setCurrentLine(selectedLine);
                }
                if (lastline > 0 && (tmpgotoLine = this.getLineIndex(tFile.toListingLine(lastline, fileIndex), false)) >= 0) {
                    this.setCurrentLine(tmpgotoLine, false);
                }
            }
            this.gotoList.add(new Integer(selListingLine));
            this.select(selectedLine, 0);
            this.gotoList.add(new Integer(listingLine));
            this.gotoIndex = this.gotoList.size() - 1;
            this.graphDebug.updateGotoActions(true, false);
        }
    }

    public void back() {
        --this.gotoIndex;
        int listingLine = (Integer)this.gotoList.get(this.gotoIndex);
        this.select(this.getLineIndex(listingLine, true), 0);
        this.graphDebug.updateGotoActions(this.gotoIndex > 0, this.gotoIndex < this.gotoList.size() - 1);
    }

    public void forward() {
        ++this.gotoIndex;
        int listingLine = (Integer)this.gotoList.get(this.gotoIndex);
        this.select(this.getLineIndex(listingLine, true), 0);
        this.graphDebug.updateGotoActions(this.gotoIndex > 0, this.gotoIndex < this.gotoList.size() - 1);
    }

    public TextFile getFile() {
        return this.tFileObj.tf;
    }

    private TextFileObj getNewFile(LocalDebugInfo dInfo, Filename filename, long timestamp, boolean listing, boolean showErrorMsg) {
        TextFileObj Return2 = new TextFileObj();
        boolean debugReplSrc = true;
        if (dInfo != null) {
            if (dInfo.getInfoFormat() > 3) {
                if (dInfo.getCompilerProps() != null) {
                    for (String p : dInfo.getCompilerProps()) {
                        if (!p.startsWith("iscobol.compiler.debug.replaced_source=")) continue;
                        debugReplSrc = Config.isTrue(p.substring(39));
                        break;
                    }
                }
            } else {
                debugReplSrc = false;
            }
        }
        Return2.tf = filename.getBaseName().length() > 0 ? new TextFile(this.graphDebug.getInvoker().getFileLoader(), dInfo, filename, timestamp, listing) : new TextFile(dInfo != null ? dInfo.getErrorString() : null);
        Return2.ldInfo = dInfo;
        Return2.listing = listing;
        String[] fnf = Return2.tf.getFilesNotFound();
        this.textFiles.put(filename.getOrigName(), Return2);
        if (Return2.tf.getNumLines() > 0) {
            if (fnf.length > 0 && showErrorMsg) {
                this.showFileNotFoundErrorMessage(fnf);
            }
            this.buildList(Return2);
            this.fileChooser.addItem(filename.getOrigName());
            this.setSourceBackground(sourceBackground);
            this.setSourceForeground(sourceForeground);
            if (this.previewPanel.getComponentCount() > 1) {
                this.previewLayout.show(this.previewPanel, filename.getOrigName());
            }
            if (showErrorMsg && dInfo != null && dInfo.getErrorString() == null && debugReplSrc && dInfo.getListingInfos() == null) {
                JOptionPane.showMessageDialog(this.previewArea, "The source code could be wrong".toString(), "WARNING", 0);
            }
        } else {
            if (showErrorMsg) {
                this.showFileNotFoundErrorMessage(fnf);
            }
            if (this.textFiles.size() == 1) {
                this.previewArea = new DebugList();
            }
        }
        return Return2;
    }

    private String[] getUnsynchFiles(TextFile tf, DebugResponse.DebugInfo dInfo) {
        Vector<String> unsynchFileList = new Vector<String>();
        if (dInfo != null && dInfo.getTimestamp() > 0L) {
            Filename[] filenames = tf.getFilenames();
            for (int i = 0; i < filenames.length; ++i) {
                File f;
                String origName = filenames[i].getOrigName();
                String path = this.graphDebug.getInvoker().getFileLoader().getAbsolutePath(origName);
                if (path == null || !(f = new File(path)).exists() || f.lastModified() <= dInfo.getTimestamp()) continue;
                unsynchFileList.addElement(origName);
            }
        }
        String[] Return2 = new String[unsynchFileList.size()];
        unsynchFileList.toArray(Return2);
        return Return2;
    }

    private void getFile(LocalDebugInfo dInfo, Filename filename, long timestamp, boolean listing, boolean showErrorMsg) {
        TextFileObj tfo = null;
        tfo = (TextFileObj)this.textFiles.get(filename.getOrigName());
        boolean newFile = false;
        if (tfo == null || tfo.tf.getNumLines() == 0) {
            tfo = this.getNewFile(dInfo, filename, timestamp, listing, showErrorMsg);
            newFile = true;
        } else if (tfo.ldInfo != dInfo || tfo.tf.getTimestamp() > 0L && !this.graphDebug.getInvoker().getFileLoader().checkTimestamp(tfo.tf.getFilenames(), tfo.tf.getTimestamp())) {
            LocalDebugInfo tmp;
            this.unload(tfo.tf);
            if (dInfo == null && tfo.listing && (tmp = this.graphDebug.getInvoker().getInfo(tfo.tf.getClassName(), this.graphDebug.isProcessing(), true)) != null) {
                dInfo = tmp;
            }
            tfo = this.getNewFile(dInfo, filename, timestamp, tfo.listing, showErrorMsg);
            newFile = true;
        } else {
            String[] fnf = tfo.tf.getFilesNotFound();
            if (tfo.tf.getNumLines() > 0) {
                if (fnf.length > 0 && showErrorMsg) {
                    this.showFileNotFoundErrorMessage(fnf);
                }
                this.scrollPreviewArea = tfo.sp;
                this.previewArea = (JList)this.scrollPreviewArea.getViewport().getView();
                this.previewModel = (DebugListModel)this.previewArea.getModel();
                this.previewRenderer = (DebugListCellRenderer)this.previewArea.getCellRenderer();
                this.setSourceBackground(sourceBackground);
                this.setSourceForeground(sourceForeground);
                if (!this.previewArea.getFont().equals(previewFont)) {
                    this.setSourceFont(previewFont);
                }
                this.previewLayout.show(this.previewPanel, filename.getOrigName());
            } else if (showErrorMsg) {
                this.showFileNotFoundErrorMessage(fnf);
            }
        }
        String[] unsynchFiles = null;
        boolean loadFromClass = false;
        if (dInfo != null) {
            boolean bl = loadFromClass = dInfo.getListingInfos() != null;
            if (!loadFromClass) {
                unsynchFiles = this.getUnsynchFiles(tfo.tf, dInfo);
            }
        }
        if (loadFromClass) {
            this.warnLbl.setForeground(Color.green.darker());
            this.warnLbl.setToolTipText("source extracted from class");
        } else if (unsynchFiles != null && unsynchFiles.length > 0) {
            StringBuffer msg = new StringBuffer("<html>");
            if (unsynchFiles.length == 1) {
                msg.append("File");
            } else {
                msg.append("Files");
            }
            if (unsynchFiles.length == 1) {
                msg.append(" '" + unsynchFiles[0] + "'");
            } else {
                for (int i = 0; i < unsynchFiles.length; ++i) {
                    msg.append(", ");
                    msg.append("   '" + unsynchFiles[i] + "'");
                }
            }
            msg.append("<br>");
            if (unsynchFiles.length == 1) {
                msg.append(" has");
            } else {
                msg.append(" have");
            }
            msg.append(" been modified since last compilation!");
            this.warnLbl.setForeground(Color.red);
            this.warnLbl.setToolTipText(msg.toString());
        } else {
            this.warnLbl.setForeground(Color.blue);
            this.warnLbl.setToolTipText("source loaded from disk");
        }
        this.tFileObj = tfo;
        this.sourceFormat = -1;
        this.nrw.clear();
        this.ccbas = false;
        if (this.tFileObj != null && this.tFileObj.ldInfo != null) {
            String[] compOpts = this.tFileObj.ldInfo.getCompilerOptions();
            if (compOpts != null) {
                OptionList ol = new OptionList(new String[0]);
                ol.addOptions(compOpts);
                String rw = ol.getOption("-rw=");
                if (rw != null) {
                    StringTokenizer stn = new StringTokenizer(rw, ",");
                    while (stn.hasMoreTokens()) {
                        String kw = stn.nextToken().toUpperCase();
                        this.nrw.put(kw, kw);
                    }
                }
                boolean bl = this.ccbas = ol.getOption("-ccbas") != null;
            }
            if (newFile && !Settings.isExpandCopiesOnLoad()) {
                this.collapseAllCopies();
            }
        }
    }

    private void showFileNotFoundErrorMessage(String[] filenames) {
        StringBuffer msg = new StringBuffer();
        if (filenames.length == 1) {
            msg.append("File");
        } else {
            msg.append("Files");
        }
        msg.append(" not found:");
        if (filenames.length == 1) {
            msg.append(" '" + filenames[0] + "'");
        } else {
            for (int i = 0; i < filenames.length; ++i) {
                msg.append(GraphDebugger.eol);
                msg.append("   '" + filenames[i] + "'");
            }
        }
        msg.append(GraphDebugger.eol);
        msg.append("Make sure the directory containing ");
        if (filenames.length == 1) {
            msg.append("this file");
        } else {
            msg.append("these files");
        }
        msg.append(" is listed");
        msg.append(GraphDebugger.eol);
        msg.append("in CLASSPATH or iscobol.debug.code_prefix");
        JOptionPane.showMessageDialog(this.previewArea, msg.toString(), "ERROR", 0);
    }

    Breakpoint getBreakpoint(int row) {
        CobolRef ref = this.tFileObj.tf.getBPArgs(this.getListingline(row));
        if (ref == null || this.breakpointModel == null || this.breakpointModel.size() == 0) {
            return null;
        }
        Breakpoint target = new Breakpoint(ref);
        int idx = this.breakpointModel.indexOf(target);
        if (idx >= 0) {
            return (Breakpoint)this.breakpointModel.elementAt(idx);
        }
        return null;
    }

    private void buildList(TextFileObj tfo) {
        this.previewModel = new DebugListModel();
        this.loadList(tfo.tf, this.previewModel);
        this.previewArea = new DebugList();
        MouseInputAdapter mouseAdapt = new MouseInputAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DebugPanel.this.endDragLine = DebugPanel.this.previewArea.locationToIndex(e.getPoint());
                DebugPanel.this.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                if (DebugPanel.this.graphDebug.getFrame().isActive()) {
                    Point p = me.getPoint();
                    if (DebugPanel.this.tipPopup != null) {
                        if (!DebugPanel.this.lastMouseEventArea.contains(p)) {
                            DebugPanel.this.hideTipPopup();
                            DebugPanel.this.lastMouseEventArea = null;
                            DebugPanel.this.tipAction.setMousePos(p);
                            DebugPanel.this.tipTimer.restart();
                        }
                    } else {
                        DebugPanel.this.tipAction.setMousePos(p);
                        DebugPanel.this.tipTimer.restart();
                    }
                    if (DebugPanel.isLink(DebugPanel.this.highlightVarType)) {
                        if (!DebugPanel.this.lastLinkArea.contains(p)) {
                            if (DebugPanel.this.highlightVarType == HighlightVarType.LINK) {
                                DebugPanel.this.setHighlightedVar(null, HighlightVarType.NONE, -1, -1);
                            } else {
                                DebugPanel.this.setHighlightedVar(DebugPanel.this.highlightedVar, HighlightVarType.HIGHLIGHT, DebugPanel.this.highlightedVarLine, DebugPanel.this.highlightedVarCol);
                            }
                            DebugPanel.this.lastLinkArea = null;
                            DebugPanel.this.handMouseAction.setMousePos(p);
                            DebugPanel.this.handMouseTimer.restart();
                        }
                    } else {
                        DebugPanel.this.handMouseAction.setMousePos(p);
                        DebugPanel.this.handMouseTimer.restart();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DebugPanel.this.quickWatchPoint = e.getPoint();
                if (e.isPopupTrigger()) {
                    DebugPanel.this.listPopup.show(DebugPanel.this.previewArea, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DebugPanel.this.setHighlightedWord(null);
                if (DebugPanel.this.previewModel == null) {
                    return;
                }
                DebugPanel.this.quickWatchPoint = e.getPoint();
                if (e.isPopupTrigger()) {
                    DebugPanel.this.listPopup.show(DebugPanel.this.previewArea, e.getX(), e.getY());
                    return;
                }
                int row = DebugPanel.this.previewArea.locationToIndex(e.getPoint());
                if (row < DebugPanel.this.previewModel.getSize()) {
                    if (e.getX() < 20) {
                        CobolRef ref = ((DebugPanel)DebugPanel.this).tFileObj.tf.getBPArgs(DebugPanel.this.getListingline(row));
                        if (ref.isCopyStatement()) {
                            if (((DebugPanel)DebugPanel.this).previewModel.getLineAt((int)row).copyExpanded) {
                                DebugPanel.this.collapseCopy(row);
                            } else {
                                DebugPanel.this.expandCopy(row);
                            }
                        } else {
                            Breakpoint bp = DebugPanel.this.getBreakpoint(row);
                            String cmd = bp != null ? "clear" : "break";
                            cmd = cmd + " ";
                            cmd = bp != null && bp.getParagraph() != null ? cmd + bp.getParagraph() : cmd + ref.lineNo();
                            cmd = cmd + " \"" + ref.filename() + "\"";
                            if (ref.getFileIndex() >= 0) {
                                cmd = cmd + " -fi " + ref.getFileIndex();
                            }
                            if (ref.progname() != null) {
                                cmd = cmd + " " + ref.progname();
                            }
                            DebugPanel.this.graphDebug.setTextCommand(cmd);
                        }
                    } else if (e.getX() > numberColumnLen + 20) {
                        String line = ((DebugPanel)DebugPanel.this).previewModel.getLineAt((int)row).lineStr;
                        int cc = GraphUtilities.pixelsToOffset(previewMetrics, line, e.getX() - 20 - numberColumnLen);
                        DebugPanel.this.setCursorColumn(cc, row);
                    }
                }
                if (e.getButton() == 1) {
                    if (e.isShiftDown()) {
                        DebugPanel.this.endDragLine = DebugPanel.this.previewArea.locationToIndex(e.getPoint());
                        DebugPanel.this.repaint();
                    } else {
                        DebugPanel.this.setSelectedLine(DebugPanel.this.previewArea.locationToIndex(e.getPoint()));
                    }
                }
                DebugPanel.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                block0 : switch (e.getClickCount()) {
                    case 1: {
                        DebugPanel.this.linkTimer.restart();
                        break;
                    }
                    case 2: {
                        int row = DebugPanel.this.previewArea.locationToIndex(e.getPoint());
                        int listingLine = DebugPanel.this.getListingline(row);
                        CobolRef cobolLine = DebugPanel.this.getFile().toCobolLine(listingLine);
                        MyVarName vn = DebugPanel.this.getVarName(e.getPoint());
                        if (vn == null || vn.varName.length() <= 0) break;
                        String word = vn.varName.trim();
                        if (DebugPanel.this.graphDebug.isRunning() && !DebugPanel.this.graphDebug.isProcessing()) {
                            DebugPanel.this.restartTimers(e.getPoint());
                            DebugResponse resp = DebugPanel.this.displayVar(word, listingLine);
                            if (resp != null) {
                                switch (resp.getReturnCode()) {
                                    case 0: 
                                    case 22: {
                                        DebugPanel.this.setHighlightedVar(vn.origText);
                                        if (resp.getReturnCode() != 0) break block0;
                                        DebugPanel.this.outputResult(resp.getMessage() + GraphDebugger.eol);
                                        break;
                                    }
                                    case 6: 
                                    case 25: {
                                        break;
                                    }
                                    default: {
                                        DebugPanel.this.goTo(cobolLine.lineNo(), word, cobolLine.getFileIndex());
                                        break;
                                    }
                                }
                                break;
                            }
                            DebugPanel.this.goTo(cobolLine.lineNo(), word, cobolLine.getFileIndex());
                            break;
                        }
                        DebugPanel.this.goTo(cobolLine.lineNo(), word, cobolLine.getFileIndex());
                    }
                }
                DebugPanel.this.lineCommand.requestFocusInWindow();
            }
        };
        this.previewArea.addMouseMotionListener(mouseAdapt);
        this.previewArea.addMouseListener(mouseAdapt);
        this.previewArea.addKeyListener(this.globalKeyListener);
        this.previewArea.setFocusTraversalKeys(1, Collections.EMPTY_SET);
        this.previewArea.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        KeyStroke ks = KeyStroke.getKeyStroke(67, 2);
        String copyActionKey = "previewArea.copy";
        InputMap inputMap = this.previewArea.getInputMap();
        if (inputMap != null) {
            for (InputMap im = inputMap; im != null; im = im.getParent()) {
                im.remove(ks);
            }
        } else {
            inputMap = new InputMap();
            this.previewArea.setInputMap(0, inputMap);
        }
        inputMap.put(ks, "previewArea.copy");
        ActionMap actionMap = this.previewArea.getActionMap();
        if (actionMap == null) {
            actionMap = new ActionMap();
            this.previewArea.setActionMap(actionMap);
        }
        actionMap.put("previewArea.copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebugPanel.this.copy();
            }
        });
        this.previewArea.setModel(this.previewModel);
        this.previewArea.setFont(previewFont);
        if (previewMetrics == null) {
            previewMetrics = this.previewArea.getFontMetrics(previewFont);
        }
        this.previewRenderer = new DebugListCellRenderer(previewMetrics);
        this.previewArea.setCellRenderer(this.previewRenderer);
        this.previewArea.setFixedCellHeight(previewMetrics.getHeight() + 2);
        this.scrollPreviewArea = DebugPanel.createJScrollPane(this.previewArea);
        this.scrollPreviewArea.getVerticalScrollBar().setUnitIncrement(this.previewArea.getFixedCellHeight());
        tfo.sp = this.scrollPreviewArea;
        this.previewPanel.add((Component)this.scrollPreviewArea, new Filename(tfo.tf.getFilename()).getOrigName());
    }

    private void loadList(TextFile tf, DebugListModel lm) {
        int n = tf.getNumLines();
        lm.allocate(n);
        for (int i = 0; i < n; ++i) {
            CobolRef cb = tf.toCobolLine(i);
            if (cb == null) continue;
            Line ln = new Line(cb.lineNo(), i, tf.getLine(i, false), cb.getCopyDeep(), cb.getCopyFileIndex());
            lm.add(ln);
        }
    }

    public void setBreakpoints(Breakpoint[] bps) {
        this.breakpointModel.setItems(bps);
        this.breakpointTable.reload();
        boolean enabledFound = false;
        boolean disabledFound = false;
        if (bps != null) {
            for (int i = 0; i < bps.length; ++i) {
                if (bps[i].isEnabled()) {
                    enabledFound = true;
                    continue;
                }
                disabledFound = true;
            }
        }
        this.breakpointEnAllBtn.setEnabled(disabledFound);
        this.breakpointDisAllBtn.setEnabled(enabledFound);
        this.breakpointEnAllItem.setEnabled(disabledFound);
        this.breakpointDisAllItem.setEnabled(enabledFound);
        this.breakpointRemoveAllBtn.setEnabled(bps != null && bps.length > 0);
        this.breakpointRemoveAllItem.setEnabled(bps != null && bps.length > 0);
        this.breakpointTableSelectionChanged(0);
        this.previewArea.repaint();
    }

    public void overwriteSysOut() {
        GraphUtilities.setOut(new DebugOutputStream(new MyAppender(false)));
    }

    public void overwriteSysErr() {
        GraphUtilities.setErr(new DebugOutputStream(new MyAppender(true)));
    }

    void displayVarsOnSelLine() {
        this.displayVarsOnSelLine(false, false);
    }

    private void displayVarsOnSelLine(boolean onlyHighlight, boolean backward) {
        block10: {
            int sl = this.getSelListingLine();
            if (sl < 0) {
                return;
            }
            String selectedLine = this.tFileObj.tf.getLine(sl, false);
            List<MyVarName> varNames = this.getVarNames(selectedLine, -1, this.getSourceFormat(), Collections.EMPTY_SET);
            if (varNames == null || varNames.size() == 0) {
                if (!onlyHighlight) {
                    this.outputResult("No variables found on selected line" + GraphDebugger.eol);
                }
                return;
            }
            if (backward != this.lastVarSearchBackward) {
                this.lastPosForVarSearch = backward ? (this.lastPosForVarSearch -= 2) : (this.lastPosForVarSearch += 2);
                this.lastVarSearchBackward = backward;
            }
            if (this.lastPosForVarSearch < 0 || this.lastPosForVarSearch >= varNames.size()) {
                this.lastPosForVarSearch = backward ? varNames.size() - 1 : 0;
            }
            int posSave = this.lastPosForVarSearch;
            do {
                boolean ok;
                MyVarName mvn = varNames.get(backward ? posSave-- : posSave++);
                DebugResponse resp = this.displayVar(mvn.varName, sl);
                boolean bl = ok = resp != null;
                if (ok) {
                    ok = onlyHighlight ? (ok &= resp.getReturnCode() == 0 || resp.getReturnCode() == 22) : (ok &= resp.getReturnCode() == 0);
                    if (onlyHighlight) {
                        this.cursorColumn = mvn.offs;
                        this.setHighlightedVar(mvn.origText);
                    } else {
                        String msg = "+ " + resp.getVarName() + " = " + resp.getVarValue() + GraphDebugger.eol;
                        this.outputResult(msg);
                    }
                    this.lastPosForVarSearch = posSave;
                    break block10;
                }
                if (backward) {
                    if (posSave >= 0) continue;
                    posSave = varNames.size() - 1;
                    continue;
                }
                if (posSave != varNames.size()) continue;
                posSave = 0;
            } while (posSave != this.lastPosForVarSearch);
            if (onlyHighlight) break block10;
            this.outputResult("No variables found on selected line" + GraphDebugger.eol);
        }
    }

    protected String[] getVarNamesOnSelectedLine() {
        if (this.selLine < 0) {
            return null;
        }
        String selectedLine = this.tFileObj.tf.getLine(this.selLine, false);
        List<MyVarName> varnames = this.getVarNames(selectedLine, -1, this.getSourceFormat(), Collections.EMPTY_SET);
        String[] ret = null;
        if (varnames != null) {
            ret = new String[varnames.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = varnames.get((int)i).varName;
            }
        }
        return ret;
    }

    public void outputResult(String str) {
        new IsguiWorker(false, () -> this.outputResult0(str)).start();
    }

    void outputResult0(String str) {
        this.textOutput.append(str);
        this.textOutput.setCaretPosition(this.textOutput.getDocument().getLength());
    }

    public void selectLast() {
        if (this.previewModel != null) {
            this.select(this.previewModel.getSize() - 1, 0);
        }
    }

    public void selectCurrentLine() {
        this.select(this.currLine, 0);
    }

    public void select(int line, int cp) {
        this.select(line, cp, null);
    }

    private void select(int line, int cp, String highlightedWord) {
        this.setHighlightedWord(highlightedWord);
        this.setSelectedLine(line);
        this.setCursorColumn(cp, line);
        this.ensureVisible(line);
        this.previewArea.repaint();
    }

    protected void setSelectedLine(int sl) {
        if (this.selLine != sl) {
            if (sl < 0) {
                sl = 0;
            }
            this.startDragLine = this.endDragLine = sl;
            this.selLine = this.endDragLine;
            this.lastPosForVarSearch = -1;
            this.lastVarSearchBackward = false;
        }
    }

    protected int getSelectedLine() {
        return this.selLine;
    }

    private void setCursorColumn(int cc, int line) {
        if (this.previewModel == null) {
            return;
        }
        this.cursorColumn = cc;
        this.cursorX = 20 + numberColumnLen;
        if (cc > 0 && line < this.previewModel.getSize()) {
            this.cursorX += previewMetrics.stringWidth(this.previewModel.getLineAt((int)line).lineStr.substring(0, cc));
        }
    }

    private void ensureVisible(int idx) {
        new IsguiWorker(true, () -> this.previewArea.ensureIndexIsVisible(idx)).start();
    }

    private void restartTimers(Point p) {
        this.hideTipPopup();
        this.tipAction.setMousePos(p);
        this.handMouseAction.setMousePos(p);
        this.tipTimer.restart();
        this.handMouseTimer.restart();
    }

    public void setCurrentLine(int l) {
        this.setCurrentLine(l, true);
    }

    public void setCurrentLine(int l, boolean ensurevis) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setCurrentLine0(l, ensurevis);
        } else {
            SwingUtilities.invokeLater(() -> this.setCurrentLine0(l, ensurevis));
        }
    }

    private void setCurrentLine0(int l, boolean ensurevis) {
        int newLine;
        this.currLine = newLine = l;
        this.setSelectedLine(newLine);
        int svidx = this.previewArea.getFirstVisibleIndex();
        int lvidx = this.previewArea.getLastVisibleIndex();
        if (this.previewModel != null && lvidx > 0 && this.currLine >= lvidx + 1) {
            newLine = Math.min(newLine + lvidx - svidx - 1, this.previewModel.getSize() - 1);
        }
        if (ensurevis) {
            this.ensureVisible(newLine);
        }
        this.setCursorColumn(0, newLine);
        this.previewArea.repaint();
        this.gotoList.clear();
        this.gotoIndex = -1;
        this.graphDebug.updateGotoActions(false, false);
    }

    public int getCurrentLine() {
        return this.currLine;
    }

    void repaintSource() {
        this.previewArea.repaint();
    }

    public void clearOutput() {
        new IsguiWorker(false, () -> this.textOutput.setText("")).start();
    }

    public void setEnabledAll(boolean en, boolean canJump) {
        if (en) {
            this.callStackLayout.last(this.callStackPanel);
            this.threadLayout.last(this.threadPanel);
        } else {
            this.callStackLayout.first(this.callStackPanel);
            this.threadLayout.first(this.threadPanel);
        }
        this.btnStepInto.setEnabled(en);
        this.btnNext.setEnabled(en);
        this.btnContinue.setEnabled(en);
        this.btnSuspend.setEnabled(!en && this.graphDebug.isRunning());
        this.setJumpCommandEnabled(en && canJump);
        this.btnOutPar.setEnabled(en);
        this.btnOutProg.setEnabled(en);
        this.btnStepTo.setEnabled(en);
        this.btnStepToPgm.setEnabled(en);
        this.btnAutoStep.setEnabled(en);
        this.contItem.setEnabled(en);
        this.suspItem.setEnabled(!en);
        this.stepIntoItem.setEnabled(en);
        this.stepOverItem.setEnabled(en);
        this.runToItem.setEnabled(en);
        this.runToNextPgmItem.setEnabled(en);
        this.jumpItem.setEnabled(en && canJump);
        this.jumpOutItem.setEnabled(en && canJump);
        this.jumpOutProgItem.setEnabled(en && canJump);
        this.jumpNextItem.setEnabled(en && canJump);
        this.outParItem.setEnabled(en);
        this.outProgItem.setEnabled(en);
        this.quickWatchItem.setEnabled(en);
        this.refreshItem.setEnabled(en);
        if (this.graphDebug.stopImmediately) {
            this.toggleBrItem.setEnabled(en);
        }
        this.displayOnLineItem.setEnabled(en);
        this.varAddBtn.setEnabled(en);
        this.varHexBtn.setEnabled(en);
        this.varAddItem.setEnabled(en);
        this.varHexItem.setEnabled(en);
        if (this.graphDebug.stopImmediately) {
            boolean bpen = this.graphDebug.isRunning() ? en : true;
            boolean hasSel = this.breakpointTable.getSelectedRowCount() > 0;
            boolean enFound = false;
            boolean disFound = false;
            Breakpoint[] breakpointArray = this.getBreakpoints();
            int n = breakpointArray.length;
            for (int i = 0; i < n; ++i) {
                Breakpoint bp = breakpointArray[i];
                if (bp.isEnabled()) {
                    enFound = true;
                } else {
                    disFound = true;
                }
                if (enFound && disFound) break;
            }
            this.breakpointAddBtn.setEnabled(bpen);
            this.breakpointEnAllBtn.setEnabled(bpen && disFound);
            this.breakpointDisAllBtn.setEnabled(bpen && enFound);
            this.breakpointModifyBtn.setEnabled(bpen && hasSel);
            this.breakpointRemoveBtn.setEnabled(bpen && hasSel);
            this.breakpointRemoveAllBtn.setEnabled(bpen);
            this.breakpointAddItem.setEnabled(bpen);
            this.breakpointEnAllItem.setEnabled(bpen && disFound);
            this.breakpointDisAllItem.setEnabled(bpen && enFound);
            this.breakpointModifyItem.setEnabled(bpen && hasSel);
            this.breakpointRemoveItem.setEnabled(bpen && hasSel);
            this.breakpointRemoveAllItem.setEnabled(bpen);
        }
        boolean hasSel = this.monitorTable.getSelectedRowCount() > 0;
        boolean enFound = false;
        boolean disFound = false;
        for (Watch w : this.getMonitors()) {
            if (w.isEnabled()) {
                enFound = true;
            } else {
                disFound = true;
            }
            if (enFound && disFound) break;
        }
        this.monitorAddBtn.setEnabled(en);
        this.monitorEnAllBtn.setEnabled(en && disFound);
        this.monitorDisAllBtn.setEnabled(en && enFound);
        this.monitorModifyBtn.setEnabled(en && hasSel);
        this.monitorRemoveBtn.setEnabled(en && hasSel);
        this.monitorRemoveAllBtn.setEnabled(en);
        this.monitorAddItem.setEnabled(en);
        this.monitorEnAllItem.setEnabled(en && disFound);
        this.monitorDisAllItem.setEnabled(en && enFound);
        this.monitorModifyItem.setEnabled(en && hasSel);
        this.monitorRemoveItem.setEnabled(en && hasSel);
        this.monitorRemoveAllItem.setEnabled(en);
    }

    void setRunQuitEnabled(boolean b) {
        this.btnRun.setEnabled(!b);
        this.btnStop.setEnabled(b);
    }

    void setRunEnabled(boolean b) {
        this.btnRun.setEnabled(b);
    }

    void setQuitEnabled(boolean b) {
        this.btnStop.setEnabled(b);
    }

    public void setRunCommandsButtonsEnabled(boolean b, boolean canJump) {
        this.btnRun.setEnabled(!b);
        this.btnStop.setEnabled(b);
        this.btnContinue.setEnabled(b);
        this.btnSuspend.setEnabled(b);
        this.setJumpCommandEnabled(b && canJump);
        this.btnNext.setEnabled(b);
        this.btnOutPar.setEnabled(b);
        this.btnOutProg.setEnabled(b);
        this.btnStepInto.setEnabled(b);
        this.btnStepTo.setEnabled(b);
        this.btnStepToPgm.setEnabled(b);
        this.memoryView.setEnabled(b);
    }

    void clearTrees() {
        for (int i = 0; i < this.varRootNode.length; ++i) {
            this.varRootNode[i].removeAllChildren();
            this.varTreeTable[i].reload();
        }
    }

    protected void setAutostepState(boolean b) {
        new IsguiWorker(false, () -> {
            this.btnAutoStep.setSelected(b);
            this.autostepStateChanged();
        }).start();
    }

    public Watch[] getMonitors() {
        Object[] mons = this.monitorModel.toArray();
        Watch[] Return2 = new Watch[mons.length];
        System.arraycopy(mons, 0, Return2, 0, mons.length);
        return Return2;
    }

    public Breakpoint[] getBreakpoints() {
        Object[] bps = this.breakpointModel.toArray();
        Breakpoint[] Return2 = new Breakpoint[bps.length];
        System.arraycopy(bps, 0, Return2, 0, bps.length);
        return Return2;
    }

    public String[][] getWatchedVariableNames() {
        String[][] Return2 = new String[this.watchedVarnames.size()][2];
        for (int i = 0; i < this.watchedVarnames.size(); ++i) {
            Return2[i] = this.watchedVarnames.get(i);
        }
        return Return2;
    }

    protected void setWatchedVariableNames(List<String[]> wvn) {
        this.watchedVarnames = wvn;
        this.varRemoveAllBtn.setEnabled(this.watchedVarnames.size() > 0);
    }

    String[] getWatchedVariableCommands() {
        String[] vars = new String[this.watchedVarnames.size()];
        String pfx = "display -tree -x";
        int i = 0;
        while (i < vars.length) {
            String[] ss = this.watchedVarnames.get(i);
            vars[i] = "display -tree -x";
            if (ss[1] != null) {
                int n = i;
                vars[n] = vars[n] + " -c " + ss[1];
            }
            int n = i++;
            vars[n] = vars[n] + " " + ss[0];
        }
        return vars;
    }

    public boolean hasBreakpoints() {
        return this.breakpointModel.size() > 0;
    }

    public boolean hasMonitors() {
        return this.monitorModel.size() > 0;
    }

    public void setMonitors(Watch[] ws) {
        this.monitorModel.setItems(ws);
        this.monitorTable.reload();
        boolean enabledFound = false;
        boolean disabledFound = false;
        if (ws != null) {
            for (int i = 0; i < ws.length; ++i) {
                if (ws[i].isEnabled()) {
                    enabledFound = true;
                    continue;
                }
                disabledFound = true;
            }
        }
        this.monitorEnAllBtn.setEnabled(disabledFound);
        this.monitorDisAllBtn.setEnabled(enabledFound);
        this.monitorEnAllItem.setEnabled(disabledFound);
        this.monitorDisAllItem.setEnabled(enabledFound);
        this.monitorRemoveAllBtn.setEnabled(ws != null && ws.length > 0);
        this.monitorRemoveAllItem.setEnabled(ws != null && ws.length > 0);
        this.monitorTableSelectionChanged(0);
    }

    public void deactivateMonitors() {
        new IsguiWorker(false, () -> {
            Object[] wcs = new Watch[this.monitorModel.size()];
            this.monitorModel.toArray(wcs);
            for (int i = 0; i < wcs.length; ++i) {
                ((Watch)wcs[i]).setActive(false);
            }
            this.setMonitors((Watch[])wcs);
        }).start();
    }

    public void setParStack(ParagraphObject[] parStack) {
        if (parStack != null && parStack.length > 0) {
            for (ParagraphObject po : parStack) {
                this.graphDebug.getInvoker().setSection(po);
            }
            this.selParObj = parStack[parStack.length - 1];
        }
        this.callStackModel.setItems(parStack);
        this.callStackTable.reload();
        new IsguiWorker(false, () -> {
            Rectangle rect = this.callStackTable.getCellRect(this.callStackModel.size() - 1, 0, true);
            this.callStackTable.scrollRectToVisible(rect);
        }).start();
    }

    private Set<String> findVarNamesInStatement(int line, int fileIndex, DebugLine[] dLines, Set<String> parNames) {
        CobolRef cr;
        LinkedHashSet<String> varnames = new LinkedHashSet<String>();
        if (dLines == null) {
            return varnames;
        }
        TextFile file = this.getFile();
        int startLstLine = -1;
        int endLstLine = file.getNumLines();
        for (int idx = 0; idx < dLines.length; ++idx) {
            if (dLines[idx].getLineNumber() != line || dLines[idx].getFileIndex() != fileIndex) continue;
            startLstLine = file.toListingLine(dLines[idx].getLineNumber(), fileIndex);
            if (idx >= dLines.length - 1) break;
            endLstLine = file.toListingLine(dLines[idx + 1].getLineNumber(), dLines[idx + 1].getFileIndex()) - 1;
            break;
        }
        if (startLstLine < 0) {
            return varnames;
        }
        int format = this.getSourceFormat();
        for (int i = startLstLine; i <= endLstLine && (cr = file.toCobolLine(i)) != null; ++i) {
            String text = file.getLine(i, false);
            List<MyVarName> vns = this.getVarNames(text, -1, format, parNames);
            for (int j = 0; j < vns.size(); ++j) {
                varnames.add(vns.get((int)j).varName);
            }
        }
        return varnames;
    }

    boolean isAutoRefreshEnabled() {
        return this.varAutoRefreshBtn.isSelected();
    }

    void refreshCurrentVariables(int currentLine, int currentFileIndex, int previousLine, int previousFileIndex) {
        DebugLine[] dLines = this.getFile().getDebugLines();
        HashSet<String> parnames = new HashSet<String>();
        this.getFile().getParagraphsNames(parnames);
        Set<String> varnames = this.findVarNamesInStatement(currentLine, currentFileIndex, dLines, parnames);
        if (previousLine > 0) {
            varnames.addAll(this.findVarNamesInStatement(previousLine, previousFileIndex, dLines, parnames));
        }
        if (!varnames.isEmpty()) {
            String currModule = this.getCurrentModule();
            Vector<DebugCommand> cmdList = new Vector<DebugCommand>();
            LinkedHashMap<String, VariableNode> nodeList = new LinkedHashMap<String, VariableNode>();
            for (String vn : varnames) {
                Tree[] node = null;
                for (int i = 0; i < this.varRootNode[0].getChildCount(); ++i) {
                    Tree[] n = (Tree[])this.varRootNode[0].getChildAt(i);
                    if (!n.getName().equalsIgnoreCase(vn)) continue;
                    if (n.getClassName() != null) {
                        if (!n.getClassName().equals(currModule)) continue;
                        node = n;
                        break;
                    }
                    if (currModule != null) continue;
                    node = n;
                    break;
                }
                if (node != null && node.getChildCount() > 0) {
                    this.addDisplayCommand((VariableNode)node, nodeList, cmdList);
                    continue;
                }
                String cn = null;
                cn = node != null ? node.getClassName() : currModule;
                nodeList.put(DebugPanel.getKey(vn, cn), (VariableNode)node);
                this.addDisplayCommand(vn, cn, (short)0, cmdList);
            }
            CompositeCommand cmd = new CompositeCommand(cmdList);
            DebugResponse r = this.graphDebug.getInvoker().processCommand(cmd);
            Tree[] tree = r.getTrees();
            if (tree != null && tree.length > 0) {
                IdentityHashMap<VariableNode, VariableNode> activeRootNodes = new IdentityHashMap<VariableNode, VariableNode>();
                for (Tree t : tree) {
                    TreeNode root = t.getRoot();
                    String rootName = root.getVarName();
                    String rn = DebugPanel.getKey(rootName, t.getClassName());
                    if (!nodeList.containsKey(rn)) continue;
                    VariableNode node = nodeList.get(rn);
                    TreeNode tn = root;
                    TreeNode[] children = tn.getChildren();
                    if (children.length == 1 && children[0].getVarName().equals(tn.getVarName())) {
                        tn = children[0];
                    }
                    if (node != null && node.getParent() != null) {
                        VariableNode newNode = GraphUtilities.buildVariableNode(tn, t.getClassName(), null, t.isHex());
                        this.varModel[0].updateNode(node, newNode);
                        VariableNode par = (VariableNode)node.getParent();
                        while (par != this.varRootNode[0]) {
                            node = par;
                            par = (VariableNode)node.getParent();
                        }
                    } else {
                        node = GraphUtilities.buildVariableNode(tn, t.getClassName(), this.varRootNode[0], t.isHex());
                    }
                    activeRootNodes.put(node, node);
                }
                int i = 0;
                while (i < this.varRootNode[0].getChildCount()) {
                    if (!activeRootNodes.containsKey((VariableNode)this.varRootNode[0].getChildAt(i))) {
                        this.varRootNode[0].removeChildAt(i);
                        continue;
                    }
                    ++i;
                }
            } else {
                this.varRootNode[0].removeAllChildren();
            }
        } else {
            this.varRootNode[0].removeAllChildren();
        }
        this.reloadAndRestoreExpandedPaths(0);
    }

    private void addDisplayCommand(String varname, String clName, short showChildren, Vector<DebugCommand> cmdList) {
        try {
            DisplayCommand dc = new DisplayCommand(new VarName(new DebugTM(varname)), clName, true, true, showChildren);
            dc.setDisplayAsText(true);
            cmdList.addElement(dc);
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
    }

    private void addDisplayCommand(VariableNode node, LinkedHashMap<String, VariableNode> nodeList, Vector<DebugCommand> cmdList) {
        this.addDisplayCommand(node.getName(), node.getClassName(), (short)1, cmdList);
        nodeList.put(DebugPanel.getKey(node.getName(), node.getClassName()), node);
        for (int i = 0; i < node.getChildCount(); ++i) {
            VariableNode child = (VariableNode)node.getChildAt(i);
            if (child.getChildCount() <= 0) continue;
            this.addDisplayCommand(child, nodeList, cmdList);
        }
    }

    void refreshVariables() {
        for (int i = 0; i < this.varRootNode.length; ++i) {
            this.refreshVariables(i);
        }
    }

    private static String getKey(String s1, String s2) {
        String Return2 = new DebugTM(s1.toLowerCase()).toString();
        if (s2 != null) {
            Return2 = Return2 + "[" + s2 + "]";
        }
        return Return2;
    }

    void refreshVariables(int idx) {
        Vector<DebugCommand> cmdList = new Vector<DebugCommand>();
        LinkedHashMap<String, VariableNode> nodeList = new LinkedHashMap<String, VariableNode>();
        VariableNode node = null;
        ArrayList<String[]> watchedTmp = new ArrayList<String[]>();
        if (idx == 1) {
            watchedTmp.addAll(this.watchedVarnames);
        }
        for (int i = 0; i < this.varRootNode[idx].getChildCount(); ++i) {
            node = (VariableNode)this.varRootNode[idx].getChildAt(i);
            if (node != null && node.getChildCount() > 0) {
                this.addDisplayCommand(node, nodeList, cmdList);
            } else {
                nodeList.put(DebugPanel.getKey(node.getName(), node.getClassName()), node);
                this.addDisplayCommand(node.getName(), node.getClassName(), (short)0, cmdList);
            }
            this.removeFromWatchedVarNames(node.getName(), node.getClassName(), watchedTmp);
        }
        if (idx == 1) {
            for (String[] s : watchedTmp) {
                this.addDisplayCommand(s[0], s[1], (short)0, cmdList);
                nodeList.put(DebugPanel.getKey(s[0], s[1]), null);
            }
        }
        CompositeCommand cmd = new CompositeCommand(cmdList);
        DebugResponse r = this.graphDebug.getInvoker().processCommand(cmd);
        Tree[] tree = r.getTrees();
        if (tree != null && tree.length > 0) {
            for (Tree t : tree) {
                TreeNode root = t.getRoot();
                String rootName = root.getVarName();
                String rn = DebugPanel.getKey(rootName, t.getClassName());
                if (!nodeList.containsKey(rn)) continue;
                node = nodeList.get(rn);
                TreeNode tn = root;
                TreeNode[] children = tn.getChildren();
                if (children.length == 1 && children[0].getVarName().equals(tn.getVarName())) {
                    tn = children[0];
                }
                if (node != null && node.getParent() != null) {
                    VariableNode newNode = GraphUtilities.buildVariableNode(tn, t.getClassName(), null, t.isHex());
                    this.varModel[idx].updateNode(node, newNode);
                    continue;
                }
                node = GraphUtilities.buildVariableNode(tn, t.getClassName(), this.varRootNode[idx], t.isHex());
            }
            this.reloadAndRestoreExpandedPaths(idx);
        }
    }

    private boolean isWatchedVarName(String varName, String className) {
        for (String[] s : this.watchedVarnames) {
            if (!varName.equals(s[0]) || (className == null || !className.equals(s[1])) && (className != null || s[1] != null)) continue;
            return true;
        }
        return false;
    }

    public void setTree(Tree tree, boolean reload) {
        this.setTree(tree, reload, 1);
    }

    private void setTree(Tree tree, boolean reload, int treeIndex) {
        VariableNode newNode;
        if (tree == null) {
            return;
        }
        String varName = tree.getRoot().getVarName();
        VariableNode varNode = null;
        for (int i = 0; i < this.varRootNode[treeIndex].getChildCount(); ++i) {
            VariableNode node = (VariableNode)this.varRootNode[treeIndex].getChildAt(i);
            if (!node.getName().equalsIgnoreCase(varName)) continue;
            varNode = node;
            break;
        }
        if ((newNode = GraphUtilities.buildVariableNode(tree)).getChildCount() == 1) {
            VariableNode child0 = (VariableNode)newNode.getChildAt(0);
            String n1 = newNode.getName();
            String n2 = child0.getName();
            int idx = n1.indexOf(40);
            if (idx >= 0) {
                n1 = n1.substring(0, idx).trim();
                idx = n2.indexOf(40);
                if (idx >= 0) {
                    n2 = n2.substring(0, idx).trim();
                }
            }
            if (n1.equals(n2)) {
                child0.setName(newNode.getName());
                newNode = child0;
            }
        }
        if (varNode != null) {
            this.varModel[treeIndex].updateNode(varNode, newNode);
        } else {
            this.varRootNode[treeIndex].addChild(newNode);
            if (treeIndex == 1 && !this.isWatchedVarName(varName, tree.getClassName())) {
                this.watchedVarnames.add(new String[]{varName, tree.getClassName()});
                this.varRemoveAllBtn.setEnabled(true);
            }
        }
        if (reload) {
            this.reloadAndRestoreExpandedPaths(treeIndex);
        }
        if (!this.isVariablesAreaOpen()) {
            this.openVariablesArea();
        }
    }

    private void reloadAndRestoreExpandedPaths(int treeIndex) {
        SwingUtilities.invokeLater(() -> {
            Vector<TreePath> expPaths = new Vector<TreePath>();
            JTree jtree = this.varTree[treeIndex];
            DebugPanel.getAllExpandedPaths(jtree, new TreePath(this.varRootNode[treeIndex].getPath()), expPaths);
            JScrollPane treePanel = this.varScrollPane[treeIndex];
            int vScroll = treePanel.getVerticalScrollBar().getValue();
            this.varTreeTable[treeIndex].reload();
            if (!expPaths.isEmpty()) {
                DebugPanel.setExpandedPaths(jtree, expPaths);
            }
            treePanel.getVerticalScrollBar().setValue(vScroll);
        });
    }

    private static void getAllExpandedPaths(JTree tree, TreePath parent, Vector<TreePath> v) {
        if (!tree.isExpanded(parent)) {
            return;
        }
        v.add(parent);
        VariableNode node = (VariableNode)parent.getLastPathComponent();
        if (node != null && node.getChildCount() > 0) {
            Enumeration e = node.children();
            while (e.hasMoreElements()) {
                VariableNode n = (VariableNode)e.nextElement();
                TreePath path = new TreePath(n.getPath());
                DebugPanel.getAllExpandedPaths(tree, path, v);
            }
        }
    }

    private static void setExpandedPaths(JTree tree, Vector<TreePath> v) {
        for (TreePath tp : v) {
            if (tree.isExpanded(tp)) continue;
            tree.expandPath(tp);
        }
    }

    public void setThreads(ThreadObject[] threads, ThreadObject currThread) {
        if (currThread != null) {
            this.threadModel.setCurrThread(currThread.getName());
        } else {
            this.threadModel.setCurrThread("");
        }
        this.threadModel.setItems(threads);
        this.threadTable.reload();
    }

    public void setMemory(long tot, long free) {
        new IsguiWorker(false, () -> {
            if (tot > 0L) {
                StringBuffer ttt = new StringBuffer();
                ttt.append("<html>Total memory: ");
                long used = tot - free;
                long totM = tot / 1000000L;
                ttt.append(totM);
                ttt.append(".");
                ttt.append(tot % 1000000L / 1000L);
                ttt.append("Mb<br>");
                ttt.append("Used memory: ");
                long usedM = used / 1000000L;
                ttt.append(usedM);
                ttt.append(".");
                ttt.append(used % 1000000L / 1000L);
                ttt.append("Mb<br>");
                ttt.append("Free memory: ");
                long freeM = free / 1000000L;
                ttt.append(freeM);
                ttt.append(".");
                ttt.append(free % 1000000L / 1000L);
                ttt.append("Mb<br>");
                ttt.append("Click to force garbage collector<html>");
                StringBuffer memStr = new StringBuffer();
                memStr.append(usedM);
                memStr.append(".");
                memStr.append(used % 1000000L / 1000L);
                memStr.append("/");
                memStr.append(totM);
                memStr.append(".");
                memStr.append(tot % 1000000L / 1000L);
                memStr.append("Mb");
                this.memoryView.setString(memStr.toString());
                this.memoryView.setMaximum((int)tot);
                this.memoryView.setValue((int)used);
                this.memoryView.setToolTipText(ttt.toString());
            } else {
                this.memoryView.setValue(0);
                this.memoryView.setMaximum(1);
                this.memoryView.setString("");
                this.memoryView.setToolTipText("Click to force garbage collector");
            }
        }).start();
    }

    public void setInitFocus() {
        GraphUtilities.setFirstFocusedComponent(this.lineCommand);
    }

    public String menuBPintoCMD(int row) {
        return "\"" + this.tFileObj.tf.getFilename() + "\"";
    }

    public void setVariableHintDelay(int t) {
        this.graphDebug.dataSettingsChanged = true;
        this.tipAction.enabled = t > 0;
        if (this.tipAction.enabled) {
            this.tipTimer.setInitialDelay(t);
            this.tipTimer.restart();
        }
    }

    public void setVariableHandMouseDelay(int t) {
        this.handMouseAction.enabled = t > 0;
        if (this.handMouseAction.enabled) {
            this.handMouseTimer.setInitialDelay(t);
            this.handMouseTimer.restart();
        }
    }

    public void hideTipPopup() {
        if (this.tipPopup != null) {
            this.tipPopup.hide();
            this.tipPopup = null;
        }
    }

    protected void setLineCommandText(String text) {
        this.lineCommand.setText(text);
    }

    protected void setAutostepDelay(double v) {
        this.autoStepDelay.setValue(new Double(v));
    }

    protected double getAutostepDelay() {
        return (Double)this.autoStepDelay.getValue();
    }

    protected void setJumpCommandEnabled(boolean e) {
        this.btnJump.setEnabled(e);
        this.btnJumpOutPar.setEnabled(e);
        this.btnJumpOutProg.setEnabled(e);
        this.btnJumpNext.setEnabled(e);
    }

    protected ActionListener getThreadActionListener() {
        return this.threadActionListener;
    }

    protected String getHighlightedVariable(boolean always) {
        return always || this.highlightVarType == HighlightVarType.HIGHLIGHT ? this.highlightedVar : null;
    }

    protected String getHighlightedVariable() {
        return this.getHighlightedVariable(false);
    }

    private void jumpToSelectedLine() {
        int row = this.getSelectedLine();
        if (row >= 0) {
            CobolRef ref = this.tFileObj.tf.getBPArgs(this.getListingline(row));
            this.graphDebug.setTextCommand("jump " + ref.lineNo() + " \"" + ref.filename() + "\" " + "-fi" + " " + ref.getFileIndex());
        }
    }

    protected void saveWindowLayout() {
        Settings.setMainSplitPaneDividerLocation(this.mainSplitPane.getDividerLocation());
        Settings.setOutputSplitPaneDividerLocation(this.bottomSplitPane.getDividerLocation());
        this.topSplitPaneDividerLocation = this.topSplitPane.getDividerLocation();
        this.varSplitPaneDividerLocation = this.varSplitPane.getDividerLocation();
        Settings.setSourceSplitPaneDividerLocation(this.topSplitPaneDividerLocation);
        Settings.setVariableSplitPaneDividerLocation(this.varSplitPaneDividerLocation);
        Settings.setThreadTableColumnsWidths(this.threadTable.getColumnModel().getColumn(1).getWidth(), this.threadTable.getColumnModel().getColumn(2).getWidth(), this.threadTable.getColumnModel().getColumn(3).getWidth());
        Settings.setMonitorTableColumnsWidths(this.monitorTable.getColumnModel().getColumn(1).getWidth(), this.monitorTable.getColumnModel().getColumn(2).getWidth());
        Settings.setCallStackTableColumnsWidths(this.callStackTable.getColumnModel().getColumn(0).getWidth(), this.callStackTable.getColumnModel().getColumn(1).getWidth(), this.callStackTable.getColumnModel().getColumn(2).getWidth());
    }

    protected void setLastCommand(String cmd) {
        if (this.commandHistoryModel.size() == 50) {
            this.commandHistoryModel.remove(0);
        }
        this.commandHistoryModel.addElement(cmd);
        this.commandHistory.ensureIndexIsVisible(this.commandHistoryModel.size() - 1);
        this.clearHistoryItem.setEnabled(true);
        this.clearHistoryBtn.setEnabled(true);
    }

    private void clearCommandHistory() {
        this.graphDebug.clearCommandHistory();
        this.commandHistoryModel.clear();
        this.clearHistoryItem.setEnabled(false);
        this.clearHistoryBtn.setEnabled(false);
    }

    private int getCurrListingLine() {
        return this.previewModel != null && this.currLine >= 0 && this.currLine < this.previewModel.getSize() ? this.previewModel.getLineAt((int)this.currLine).listingLine : -1;
    }

    private void setCurrListingLine(int line) {
        this.currLine = Math.max(0, this.getLineIndex(line, false));
    }

    private int getSelListingLine() {
        return this.previewModel != null && this.selLine >= 0 && this.selLine < this.previewModel.getSize() ? this.previewModel.getLineAt((int)this.selLine).listingLine : -1;
    }

    private void setSelListingLine(int line) {
        this.selLine = Math.max(0, this.getLineIndex(line, false));
    }

    public void expandCopy(int row) {
        if (this.previewModel == null || row >= this.previewModel.getSize()) {
            return;
        }
        int currListingLine = this.getCurrListingLine();
        int selListingLine = this.getSelListingLine();
        this.previewModel.expandCopy(this.previewModel.getLineAt(row), row);
        if (currListingLine >= 0) {
            this.setCurrListingLine(currListingLine);
        }
        if (selListingLine >= 0) {
            this.setSelListingLine(selListingLine);
        }
        this.startDragLine = -1;
        this.endDragLine = -1;
    }

    public void expandAllCopies() {
        if (this.previewModel == null) {
            return;
        }
        int currListingLine = this.getCurrListingLine();
        int selListingLine = this.getSelListingLine();
        this.previewModel.expandAllCopies();
        if (currListingLine >= 0) {
            this.setCurrListingLine(currListingLine);
        }
        if (selListingLine >= 0) {
            this.setSelListingLine(selListingLine);
        }
        this.startDragLine = -1;
        this.endDragLine = -1;
    }

    public void collapseCopy(int row) {
        if (this.previewModel == null || row >= this.previewModel.getSize()) {
            return;
        }
        int currListingLine = this.getCurrListingLine();
        int selListingLine = this.getSelListingLine();
        this.previewModel.collapseCopy(this.previewModel.getLineAt(row), this.getFile(), row);
        if (currListingLine >= 0) {
            this.setCurrListingLine(currListingLine);
        }
        if (selListingLine >= 0) {
            this.setSelListingLine(selListingLine);
        }
        this.startDragLine = -1;
        this.endDragLine = -1;
    }

    public void collapseAllCopies() {
        if (this.previewModel == null) {
            return;
        }
        int currListingLine = this.getCurrListingLine();
        int selListingLine = this.getSelListingLine();
        this.previewModel.collapseAllCopies(this.getFile());
        if (currListingLine >= 0) {
            this.setCurrListingLine(currListingLine);
        }
        if (selListingLine >= 0) {
            this.setSelListingLine(selListingLine);
        }
        this.startDragLine = -1;
        this.endDragLine = -1;
    }

    int getListingline(int index) {
        return this.previewModel != null && index < this.previewModel.getSize() ? this.previewModel.getLineAt((int)index).listingLine : -1;
    }

    int getLineIndex(int listingLine, boolean expand) {
        if (this.previewModel == null) {
            return -1;
        }
        int currListingLine = this.getCurrListingLine();
        int selListingLine = this.getSelListingLine();
        int modelSize = this.previewModel.getSize();
        int Return2 = this.previewModel.getLineIndex(listingLine, expand);
        if (modelSize != this.previewModel.getSize()) {
            if (currListingLine >= 0) {
                this.setCurrListingLine(currListingLine);
            }
            if (selListingLine >= 0) {
                this.setSelListingLine(selListingLine);
            }
            this.startDragLine = -1;
            this.endDragLine = -1;
        }
        return Return2;
    }

    private String getRealPath(String s) {
        return this.graphDebug.getInvoker().getRealPath(s);
    }

    private static KeyStroke getKeyStroke(JMenuItem item, String propName) {
        String shortcut = Settings.getShortcut(propName);
        int[] params = Settings.getShortcutParams(shortcut);
        return KeyStroke.getKeyStroke(params[1], params[0]);
    }

    void setAccelerators() {
        this.currLineItem.setAccelerator(DebugPanel.getKeyStroke(this.currLineItem, "graphdebugger.shortcut.curr_line"));
        this.gotoItem.setAccelerator(DebugPanel.getKeyStroke(this.gotoItem, "graphdebugger.shortcut.goto"));
        this.contItem.setAccelerator(DebugPanel.getKeyStroke(this.contItem, "graphdebugger.shortcut.continue"));
        this.stepIntoItem.setAccelerator(DebugPanel.getKeyStroke(this.stepIntoItem, "graphdebugger.shortcut.step"));
        this.stepOverItem.setAccelerator(DebugPanel.getKeyStroke(this.stepOverItem, "graphdebugger.shortcut.next"));
        this.outParItem.setAccelerator(DebugPanel.getKeyStroke(this.outParItem, "graphdebugger.shortcut.outpar"));
        this.outProgItem.setAccelerator(DebugPanel.getKeyStroke(this.outProgItem, "graphdebugger.shortcut.outprog"));
        this.runToItem.setAccelerator(DebugPanel.getKeyStroke(this.runToItem, "graphdebugger.shortcut.toline"));
        this.runToNextPgmItem.setAccelerator(DebugPanel.getKeyStroke(this.runToNextPgmItem, "graphdebugger.shortcut.prog"));
        this.toggleBrItem.setAccelerator(DebugPanel.getKeyStroke(this.toggleBrItem, "graphdebugger.shortcut.togglebreak"));
        this.displayOnLineItem.setAccelerator(DebugPanel.getKeyStroke(this.displayOnLineItem, "graphdebugger.shortcut.displayonselline"));
        this.quickWatchItem.setAccelerator(DebugPanel.getKeyStroke(this.quickWatchItem, "graphdebugger.shortcut.quickwatch"));
        this.refreshItem.setAccelerator(DebugPanel.getKeyStroke(this.refreshItem, "graphdebugger.shortcut.refreshvararea"));
        this.btnFind.setToolTipText("Find..." + DebugPanel.getShortcutText("graphdebugger.shortcut.find"));
        this.btnGotoCurrLine.setToolTipText("Go to current line" + DebugPanel.getShortcutText("graphdebugger.shortcut.curr_line"));
        this.btnRun.setToolTipText(this.graphDebug.isRemote() ? "Connect" : "Run" + DebugPanel.getShortcutText("graphdebugger.shortcut.run"));
        this.btnStop.setToolTipText(this.graphDebug.isRemote() ? "Disconnect" : "Finish session" + DebugPanel.getShortcutText("graphdebugger.shortcut.quit"));
        this.btnContinue.setToolTipText("Continue" + DebugPanel.getShortcutText("graphdebugger.shortcut.continue"));
        this.btnStepInto.setToolTipText("Step into" + DebugPanel.getShortcutText("graphdebugger.shortcut.step"));
        this.btnNext.setToolTipText("Step over" + DebugPanel.getShortcutText("graphdebugger.shortcut.next"));
        this.btnOutPar.setToolTipText("Step out paragraph" + DebugPanel.getShortcutText("graphdebugger.shortcut.outpar"));
        this.btnOutProg.setToolTipText("Step out program" + DebugPanel.getShortcutText("graphdebugger.shortcut.outprog"));
        this.btnStepTo.setToolTipText("Run to selected line" + DebugPanel.getShortcutText("graphdebugger.shortcut.toline"));
        this.btnStepToPgm.setToolTipText("Run to next program" + DebugPanel.getShortcutText("graphdebugger.shortcut.prog"));
        this.btnJump.setToolTipText("Jump to selected line" + DebugPanel.getShortcutText("graphdebugger.shortcut.jumptoline"));
        this.btnJumpNext.setToolTipText("Jump next statement" + DebugPanel.getShortcutText("graphdebugger.shortcut.jumpnext"));
        this.btnJumpOutPar.setToolTipText("Jump out paragraph" + DebugPanel.getShortcutText("graphdebugger.shortcut.jumpoutpar"));
        this.btnJumpOutProg.setToolTipText("Jump out program" + DebugPanel.getShortcutText("graphdebugger.shortcut.jumpoutprog"));
        if (this.btnAutoStep.isSelected()) {
            this.btnAutoStep.setToolTipText("Stop autostep" + DebugPanel.getShortcutText("graphdebugger.shortcut.stoff"));
        } else {
            this.btnAutoStep.setToolTipText("Start autostep" + DebugPanel.getShortcutText("graphdebugger.shortcut.ston"));
        }
    }

    private static String getShortcutText(String propName) {
        String shortcut = Settings.getShortcut(propName);
        int[] params = Settings.getShortcutParams(shortcut);
        String modTxt = KeyEvent.getKeyModifiersText(params[0]);
        String codeTxt = KeyEvent.getKeyText(params[1]);
        String txt = modTxt.length() > 0 ? modTxt + "-" + codeTxt : codeTxt;
        return " (" + txt + ")";
    }

    public GraphDebugger getGraphDebugger() {
        return this.graphDebug;
    }

    private int getSourceFormat() {
        if (this.sourceFormat < 0) {
            int f = Settings.getSourceFormat();
            if (f == 0 && this.tFileObj != null) {
                if (this.tFileObj.tf.isFreeFormat()) {
                    f = 3;
                } else if (this.tFileObj.ldInfo != null) {
                    f = this.tFileObj.ldInfo.getFormat();
                }
            }
            this.sourceFormat = f;
        }
        return this.sourceFormat;
    }

    String getSelectedModule() {
        String Return2 = null;
        if (this.selParObj != null) {
            Return2 = this.selParObj.getProgName();
            if (this.selParObj.getMethodName() != null) {
                Return2 = Return2 + ":>" + this.selParObj.getMethodName();
            }
        }
        return Return2;
    }

    String getCurrentModule() {
        String Return2 = null;
        if (this.callStackModel.size() > 0) {
            ParagraphObject po = (ParagraphObject)this.callStackModel.elementAt(this.callStackModel.size() - 1);
            Return2 = po.getProgName();
            if (po.getMethodName() != null) {
                Return2 = Return2 + ":>" + po.getMethodName();
            }
        }
        return Return2;
    }

    private static boolean isLink(HighlightVarType ht) {
        return ht == HighlightVarType.LINK || ht == HighlightVarType.HIGHLIGHT_LINK;
    }

    static /* synthetic */ int access$1700(DebugPanel x0, String x1) {
        return x0.getAnsiCommentColumn(x1);
    }

    static /* synthetic */ Color access$1800() {
        return bpColBackground;
    }

    static /* synthetic */ Image access$1900() {
        return collapseCopyImage;
    }

    static /* synthetic */ Image access$2000() {
        return expandCopyImage;
    }

    static /* synthetic */ Image access$2200() {
        return currlineImage;
    }

    static /* synthetic */ Image access$2300() {
        return breakpointImage;
    }

    static /* synthetic */ Image access$2400() {
        return disbreakpointImage;
    }

    static /* synthetic */ Color access$2500() {
        return lineNumberBackground;
    }

    static /* synthetic */ Color access$2600() {
        return lineNumberForeground;
    }

    static /* synthetic */ int access$2700(DebugPanel x0) {
        return x0.getSourceFormat();
    }

    static /* synthetic */ Color access$3000() {
        return commentForeground;
    }

    static /* synthetic */ Color access$3100() {
        return levnumForeground;
    }

    static /* synthetic */ Color access$3200() {
        return numberForeground;
    }

    static /* synthetic */ Color access$3300() {
        return stringForeground;
    }

    static /* synthetic */ Color access$3400() {
        return figconsForeground;
    }

    static /* synthetic */ boolean access$3500(DebugPanel x0, Token x1, int x2, int x3) {
        return x0.isComment(x1, x2, x3);
    }

    static {
        int i;
        BUSY_CURSOR = new Cursor(3);
        HAND_CURSOR = new Cursor(12);
        DEF_CURSOR = new Cursor(0);
        BTN_SIZE = new Dimension(25, 25);
        statements = new HashSet();
        keywords = new HashSet();
        guiwords = new HashSet();
        for (i = 0; i < CobolToken.tokDesc.length; ++i) {
            if (CobolToken.isStat[i]) {
                statements.add(CobolToken.tokDesc[i]);
                continue;
            }
            keywords.add(CobolToken.tokDesc[i]);
        }
        statements.add("::");
        statements.add(":>");
        for (i = 0; i < GuiWords.guiWords.length; ++i) {
            guiwords.add(GuiWords.guiWords[i]);
        }
        previewFont = Settings.getFont("Source code");
        previewLinkFont = previewFont.deriveFont(DebugPanel.getUnderlineAttrs());
        currentFontSize = previewFont.getSize();
        sourceBackground = Settings.getBackground("Source code");
        sourceForeground = Settings.getForeground("Source code");
        highBackground = Settings.getBackground("Highlighted by search");
        highForeground = Settings.getForeground("Highlighted by search");
        selBackground = Settings.getBackground("Source code (selected)");
        commentForeground = Settings.getForeground("Comments");
        keywordForeground = Settings.getForeground("Keywords");
        stringForeground = Settings.getForeground("String literals");
        numberForeground = Settings.getForeground("Numeric literals");
        stmtForeground = Settings.getForeground("Statements");
        levnumForeground = Settings.getForeground("Level numbers");
        figconsForeground = Settings.getForeground("Figurative constants");
        bpLineBackground = Settings.getBackground("Breakpoint line");
        copySourcePatternColors = DebugPanel.loadCopySourcePatternColors(Settings.getCopySourcePattern());
        lineNumberBackground = Settings.getBackground("Line number column");
        lineNumberForeground = Settings.getForeground("Line number column");
        currLineBackground = Settings.getBackground("Current line");
        bpColBackground = Settings.getBackground("Breakpoint column");
        tipFont = Settings.getFont("Variable hint");
        tipBackground = Settings.getBackground("Variable hint");
        tipForeground = Settings.getForeground("Variable hint");
        perfStackFont = Settings.getFont(PERF_STACK_TITLE);
        perfStackBackground = Settings.getBackground(PERF_STACK_TITLE);
        perfStackForeground = Settings.getForeground(PERF_STACK_TITLE);
        perfStackSelBackground = Settings.getBackground("Perform stack (selected)");
        perfStackSelForeground = Settings.getForeground("Perform stack (selected)");
        bpListFont = Settings.getFont("Breakpoint list");
        bpListBackground = Settings.getBackground("Breakpoint list");
        bpListForeground = Settings.getForeground("Breakpoint list");
        bpListSelBackground = Settings.getBackground("Breakpoint list (selected)");
        bpListSelForeground = Settings.getForeground("Breakpoint list (selected)");
        monListFont = Settings.getFont("Monitor list");
        monListBackground = Settings.getBackground("Monitor list");
        monListForeground = Settings.getForeground("Monitor list");
        monListSelBackground = Settings.getBackground("Monitor list (selected)");
        monListSelForeground = Settings.getForeground("Monitor list (selected)");
        cmdHistoryFont = Settings.getFont(COMMAND_HISTORY_TITLE);
        cmdHistoryBackground = Settings.getBackground(COMMAND_HISTORY_TITLE);
        cmdHistoryForeground = Settings.getForeground(COMMAND_HISTORY_TITLE);
        cmdHistorySelBackground = Settings.getBackground("Command history (selected)");
        cmdHistorySelForeground = Settings.getForeground("Command history (selected)");
        consoleFont = Settings.getFont(CONSOLE_TITLE);
        consoleBackground = Settings.getBackground(CONSOLE_TITLE);
        consoleForeground = Settings.getForeground(CONSOLE_TITLE);
        consoleStdErrForeground = Settings.getForeground("Console StdErr");
        consoleSelBackground = Settings.getBackground("Console (selected)");
        consoleSelForeground = Settings.getForeground("Console (selected)");
        threadListFont = Settings.getFont("Thread list");
        threadListBackground = Settings.getBackground("Thread list");
        threadListForeground = Settings.getForeground("Thread list");
        disTreeFont = Settings.getFont("Display tree area");
        disTreeBackground = Settings.getBackground("Display tree area");
        disTreeForeground = Settings.getForeground("Display tree area");
        disTreeSelBackground = Settings.getBackground("Display tree area (selected)");
        disTreeSelForeground = Settings.getForeground("Display tree area (selected)");
        outputFont = Settings.getFont("Output area");
        outputBackground = Settings.getBackground("Output area");
        outputForeground = Settings.getForeground("Output area");
        outputSelBackground = Settings.getBackground("Output area (selected)");
        outputSelForeground = Settings.getForeground("Output area (selected)");
        inputFont = Settings.getFont("Line command");
        inputBackground = Settings.getBackground("Line command");
        inputForeground = Settings.getForeground("Line command");
        inputSelBackground = Settings.getBackground("Line command (selected)");
        inputSelForeground = Settings.getForeground("Line command (selected)");
    }

    private class TipAction
    extends MyAction {
        final int maxCols = 120;
        final int maxRows = 10;
        int numRows;

        TipAction() {
            this.maxCols = 120;
            this.maxRows = 10;
            this.enabled = Settings.isVariableHintEnabled();
        }

        private String split(String s) {
            StringBuffer sb = new StringBuffer(s.length());
            this.numRows = 1;
            while (120 < s.length()) {
                sb.append(s.substring(0, 120) + GraphDebugger.eol);
                s = s.substring(120);
                ++this.numRows;
            }
            sb.append(s);
            return sb.toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Line line;
            if (!this.check()) {
                return;
            }
            String tipText = null;
            if (this.mousePos.x < 20) {
                int row = DebugPanel.this.previewArea.locationToIndex(this.mousePos);
                if (row < DebugPanel.this.previewModel.getSize() && (line = DebugPanel.this.previewModel.getLineAt(row)).copyStmt()) {
                    String origName = DebugPanel.this.getFile().getFilenames()[line.copyFileIndex].getOrigName();
                    String path = DebugPanel.this.graphDebug.getInvoker().getFileLoader().getAbsolutePath(origName);
                    tipText = (line.copyExpanded ? "Collapse" : "Expand") + " copy '" + path + "'";
                }
            } else if (this.mousePos.x < 20 + numberColumnLen) {
                int row = DebugPanel.this.previewArea.locationToIndex(this.mousePos);
                if (row < DebugPanel.this.previewModel.getSize()) {
                    line = DebugPanel.this.previewModel.getLineAt(row);
                    CobolRef ref = ((DebugPanel)DebugPanel.this).tFileObj.tf.getBPArgs(line.listingLine);
                    tipText = ref != null ? "Line " + ref.lineNo() + " of \"" + ref.filename() + "\"" : "Line " + line.cobolLine;
                }
            } else {
                String word;
                DebugResponse resp;
                MyVarName vn = DebugPanel.this.getVarName(this.mousePos);
                if (!DebugPanel.this.graphDebug.isRunning() || DebugPanel.this.graphDebug.isProcessing() || DebugPanel.this.listPopup.isVisible()) {
                    return;
                }
                if (vn != null && (resp = DebugPanel.this.displayVar(word = vn.varName.trim(), vn.lstLine)) != null && resp.getReturnCode() == 0) {
                    boolean addOffsLen;
                    switch (resp.getVarType()) {
                        case 12: 
                        case 13: 
                        case 15: {
                            addOffsLen = false;
                            break;
                        }
                        default: {
                            addOffsLen = true;
                        }
                    }
                    String msg = addOffsLen ? resp.getVarName() + ": offset = " + resp.getVarOffset() + ", length = " + resp.getVarLength() + ", value = '" + resp.getVarValue() + "'" : resp.getVarName() + ": " + resp.getVarValue();
                    tipText = this.split(msg);
                }
            }
            if (tipText != null) {
                JTextArea tipArea = new JTextArea(tipText);
                tipArea.setFont(tipFont);
                tipArea.setRows(Math.min(10, this.numRows));
                tipArea.setEditable(false);
                tipArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
                tipArea.setBackground(tipBackground);
                tipArea.setForeground(tipForeground);
                Point loconscr = DebugPanel.this.previewArea.getLocationOnScreen();
                JComponent c = this.numRows > 10 ? new JScrollPane(tipArea) : tipArea;
                DebugPanel.this.lastMouseEventArea = new Rectangle(this.mousePos.x - 5, this.mousePos.y - 5, 11, 11);
                DebugPanel.this.tipPopup = PopupFactory.getSharedInstance().getPopup(null, c, this.mousePos.x + loconscr.x + 5, this.mousePos.y + loconscr.y + 22);
                tipArea.setCaretPosition(0);
                DebugPanel.this.tipPopup.show();
            }
        }
    }

    private class HandMouseAction
    extends MyAction {
        HandMouseAction() {
            this.enabled = Settings.isVariableHandMouseEnabled();
        }

        private boolean isFunction(String s) {
            int idx = s.indexOf(40);
            return Function.is(idx > 0 ? s.substring(0, idx) : s);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MyVarName vn;
            if (!this.check()) {
                return;
            }
            if (this.mousePos.x >= 20 + numberColumnLen && (vn = DebugPanel.this.getVarName(this.mousePos)) != null) {
                String up = vn.varName.toUpperCase();
                if (!(statements.contains(up) || keywords.contains(up) || guiwords.contains(up) || this.isFunction(up))) {
                    int row = DebugPanel.this.previewArea.locationToIndex(this.mousePos);
                    String line = ((DebugPanel)DebugPanel.this).previewModel.getLineAt((int)row).lineStr;
                    int cc = GraphUtilities.pixelsToOffset(previewMetrics, line, this.mousePos.x - 20 - numberColumnLen);
                    HighlightVarType ht = vn.origText.equals(DebugPanel.this.highlightedVar) || vn.origText.equals(DebugPanel.this.highlightedWord) ? HighlightVarType.HIGHLIGHT_LINK : HighlightVarType.LINK;
                    DebugPanel.this.setHighlightedVar(vn.origText, ht, row, cc);
                    Point p = DebugPanel.this.previewArea.indexToLocation(row);
                    int textX = p.x + 20 + numberColumnLen;
                    if (vn.offs > 0) {
                        textX += previewMetrics.stringWidth(line.substring(0, vn.offs));
                    }
                    DebugPanel.this.lastLinkArea = new Rectangle(textX, p.y, previewMetrics.stringWidth(vn.origText), previewMetrics.getHeight());
                }
            }
        }
    }

    private abstract class MyAction
    implements ActionListener {
        Point mousePos;
        boolean enabled = true;

        private MyAction() {
        }

        void setMousePos(Point p) {
            this.mousePos = p;
        }

        boolean check() {
            return this.enabled && this.mousePos != null && DebugPanel.this.previewModel != null;
        }
    }

    private class MyAppender
    implements Appender {
        final boolean stderr;

        MyAppender(boolean stderr) {
            this.stderr = stderr;
        }

        @Override
        public void appendLine(String s) {
            StyledDocument doc = DebugPanel.this.console.getStyledDocument();
            Style attr = this.stderr ? doc.getStyle("stderr") : null;
            try {
                doc.insertString(doc.getLength(), s + "\n", attr);
                DebugPanel.this.console.setCaretPosition(doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static class DebugListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 123L;
        private List delegate;
        private Map collapsedCopyLines;

        private DebugListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return index < this.delegate.size() ? this.delegate.get(index) : null;
        }

        Line getLineAt(int index) {
            return (Line)this.getElementAt(index);
        }

        @Override
        public int getSize() {
            return this.delegate.size();
        }

        void allocate(int size) {
            this.delegate = new ArrayList(size);
            this.collapsedCopyLines = new HashMap();
        }

        void add(Line l) {
            this.delegate.add(l);
        }

        void expandCopy(int listingLine) {
            for (Line line : this.collapsedCopyLines.keySet()) {
                List copyLines = (List)this.collapsedCopyLines.get(line);
                Line first = (Line)copyLines.get(0);
                Line last = (Line)copyLines.get(copyLines.size() - 1);
                if (listingLine < first.listingLine || listingLine > last.listingLine) continue;
                int lineIndex = this.getLineIndex0(line.listingLine);
                this.expandCopy(line, lineIndex);
                break;
            }
        }

        void expandCopy(Line line, int lineIndex) {
            int startIndex = lineIndex + 1;
            List lines = (List)this.collapsedCopyLines.remove(line);
            if (lines != null) {
                if (startIndex < this.getSize()) {
                    this.delegate.addAll(startIndex, lines);
                } else {
                    this.delegate.addAll(lines);
                }
                this.fireIntervalAdded(this, startIndex, lines.size() - 1);
            }
            line.copyExpanded = true;
        }

        void expandAllCopies() {
            for (int i = 0; i < this.getSize(); ++i) {
                Line line = this.getLineAt(i);
                if (!line.copyStmt() || line.copyExpanded) continue;
                this.expandCopy(line, i);
            }
        }

        void collapseCopy(Line line, TextFile tFile, int lineIndex) {
            int startIndex;
            CobolRef ref;
            int endIndex;
            short fileIndex = tFile.toCobolLine(line.listingLine).getFileIndex();
            for (endIndex = startIndex = lineIndex + 1; endIndex < this.getSize() && (ref = tFile.toCobolLine(this.getLineAt((int)endIndex).listingLine)).getFileIndex() > fileIndex; ++endIndex) {
            }
            if (endIndex > startIndex) {
                ArrayList lines = new ArrayList();
                int len = endIndex - startIndex;
                for (int i = 0; i < len; ++i) {
                    lines.add(this.delegate.remove(startIndex));
                }
                this.fireIntervalRemoved(this, startIndex, endIndex - 1);
                this.collapsedCopyLines.put(line, lines);
            }
            line.copyExpanded = false;
        }

        public void collapseAllCopies(TextFile tFile) {
            for (int i = 0; i < this.getSize(); ++i) {
                Line line = this.getLineAt(i);
                if (!line.copyStmt() || !line.copyExpanded) continue;
                this.collapseCopy(line, tFile, i);
            }
        }

        int getLineIndex(int listingLine, boolean expand) {
            int Return2 = this.getLineIndex0(listingLine);
            if (Return2 >= 0 || !expand) {
                return Return2;
            }
            this.expandCopy(listingLine);
            return this.getLineIndex0(listingLine);
        }

        private int getLineIndex0(int listingLine) {
            int p = 0;
            int u = this.getSize() - 1;
            if (u < 0) {
                return -1;
            }
            while (p <= u) {
                int m = (p + u) / 2;
                Line line = this.getLineAt(m);
                if (line.listingLine == listingLine) {
                    return m;
                }
                if (line.listingLine < listingLine) {
                    p = m + 1;
                    continue;
                }
                u = m - 1;
            }
            return -1;
        }
    }

    private class DebugListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 123L;
        private final int imageX = 5;
        private int index;
        private int prefHeight;
        private FontMetrics metrics;
        private int baseline;
        private int bpImageY = 3;
        private int clImageY = 3;
        private int expCollImageY = 3;
        private Line lineObj;

        public DebugListCellRenderer(FontMetrics fm) {
            this.setLayout(null);
            this.updateFontSettings(fm);
        }

        public void updateFontSettings(FontMetrics fm) {
            this.metrics = fm;
            this.baseline = fm.getAscent();
            this.prefHeight = fm.getHeight() + 2;
            this.bpImageY = Math.max((this.prefHeight - 9) / 2, 0);
            this.clImageY = Math.max((this.prefHeight - 12) / 2, 0);
            this.expCollImageY = Math.max((this.prefHeight - 16) / 2, 0);
        }

        private void drawHighlight(Graphics g) {
            boolean matchCase;
            boolean matchMinusUnderscore;
            String compareWord;
            if (this.lineObj == null) {
                return;
            }
            if (DebugPanel.this.highlightedWord == null && DebugPanel.this.highlightVarType != HighlightVarType.NONE) {
                compareWord = DebugPanel.this.highlightedVar;
                matchMinusUnderscore = false;
                matchCase = false;
            } else {
                compareWord = DebugPanel.this.highlightedWord;
                matchMinusUnderscore = DebugPanel.this.fparam == null || ((DebugPanel)DebugPanel.this).fparam.matchMinusUnderscore;
                matchCase = DebugPanel.this.fparam == null || ((DebugPanel)DebugPanel.this).fparam.matchCase;
            }
            boolean link = DebugPanel.isLink(DebugPanel.this.highlightVarType);
            if ((this.index == DebugPanel.this.selLine || this.index == DebugPanel.this.highlightedVarLine && link) && compareWord != null) {
                int cc;
                int idx;
                String compareLine = this.lineObj.lineStr;
                if (!matchMinusUnderscore) {
                    compareWord = compareWord.replaceAll("-", "_");
                    compareLine = compareLine.replaceAll("-", "_");
                }
                if (!matchCase) {
                    compareWord = compareWord.toUpperCase();
                    compareLine = compareLine.toUpperCase();
                }
                if ((idx = compareLine.indexOf(compareWord, Math.max(0, (cc = link ? DebugPanel.this.highlightedVarCol : DebugPanel.this.cursorColumn) - compareWord.length()))) >= 0 && idx <= cc) {
                    int startX = numberColumnLen + 20 + this.metrics.stringWidth(this.lineObj.lineStr.substring(0, idx));
                    String highstr = this.lineObj.lineStr.substring(idx, idx + compareWord.length());
                    switch (DebugPanel.this.highlightVarType) {
                        case LINK: {
                            g.setColor(Color.blue);
                            g.setFont(previewLinkFont);
                            break;
                        }
                        case HIGHLIGHT_LINK: {
                            g.setFont(previewLinkFont);
                        }
                        default: {
                            g.setColor(highBackground);
                            g.fillRect(startX, 0, this.metrics.stringWidth(highstr), this.prefHeight);
                            g.setColor(highForeground);
                        }
                    }
                    g.drawString(highstr, startX, this.baseline);
                }
            }
        }

        private boolean isFirstToken(Token tk, int format) {
            return (format == 1 || format == 5) && tk.getOffset() < 7;
        }

        String getWordUp(Token tk) {
            String word = tk.getWord();
            switch (tk.getToknum()) {
                case 10001: 
                case 10024: {
                    if (word.length() <= 1) break;
                    switch (word.charAt(0)) {
                        case 'H': 
                        case 'R': 
                        case 'X': {
                            return word.substring(1);
                        }
                        case 'N': {
                            switch (word.charAt(1)) {
                                case 'X': {
                                    return word.substring(2);
                                }
                            }
                            return word.substring(1);
                        }
                    }
                }
            }
            return word;
        }

        @Override
        public void paint(Graphics g) {
            if (this.lineObj == null) {
                return;
            }
            this.paint(g, this.lineObj.lineStr);
        }

        /*
         * Unable to fully structure code
         */
        public void paint(Graphics g, String lineForPreProc) {
            tlk = Toolkit.getDefaultToolkit();
            map = (Map)tlk.getDesktopProperty("awt.font.desktophints");
            if (map != null) {
                ((Graphics2D)g).addRenderingHints(map);
            }
            ansiCommentColumn = DebugPanel.access$1700(DebugPanel.this, lineForPreProc);
            ansiCommentColumn_1 = ansiCommentColumn - 1;
            startX = DebugPanel.access$1300() + 20;
            g.setColor(DebugPanel.access$1800());
            g.fillRect(0, 0, 20, this.prefHeight);
            if (this.lineObj.copyStmt()) {
                g.drawImage(this.lineObj.copyExpanded != false ? DebugPanel.access$1900() : DebugPanel.access$2000(), 5, this.expCollImageY, null);
            } else {
                if (this.index == DebugPanel.access$2100(DebugPanel.this)) {
                    g.drawImage(DebugPanel.access$2200(), 5, this.clImageY, null);
                }
                if ((bp = DebugPanel.this.getBreakpoint(this.index)) != null) {
                    g.drawImage(bp.isEnabled() != false ? DebugPanel.access$2300() : DebugPanel.access$2400(), 5, this.bpImageY, null);
                }
            }
            g.setColor(DebugPanel.access$2500());
            g.fillRect(20, 0, DebugPanel.access$1300(), this.prefHeight);
            g.setColor(DebugPanel.access$2600());
            lineNoStr = "" + this.lineObj.cobolLine;
            g.drawString(lineNoStr, startX - 2 - this.metrics.stringWidth(lineNoStr), this.baseline);
            g.setColor(this.getBackground());
            g.fillRect(startX, 0, DebugPanel.this.previewArea.getWidth() - startX, this.prefHeight);
            format = DebugPanel.access$2700(DebugPanel.this);
            isComment = false;
            firstToken = true;
            tl = PreProcessor.tokenizer(new StringBuffer(lineForPreProc), '.', true, true, DebugPanel.access$2800(DebugPanel.this));
            end = 0;
            beg = 0;
            tk = tl.getFirstWithSep();
            while (tk != null) {
                block34: {
                    block36: {
                        block35: {
                            wordUp = this.getWordUp(tk);
                            offs = tk.getOffset();
                            diff = end - offs;
                            end = Math.min(this.lineObj.lineStr.length(), offs + wordUp.length());
                            if (diff >= 0) {
                                beg = Math.min(end, offs + diff);
                                word = this.lineObj.lineStr.substring(beg, end);
                            } else {
                                beg = Math.min(offs, offs + diff);
                                word = this.lineObj.lineStr.substring(beg, offs);
                                g.setColor(DebugPanel.access$2900());
                                g.drawString(word, startX, this.baseline);
                                startX += this.metrics.stringWidth(word);
                                word = this.lineObj.lineStr.substring(offs, end);
                            }
                            if (word.length() == 0) break block34;
                            if (!isComment) break block35;
                            g.setColor(DebugPanel.access$3000());
                            break block36;
                        }
                        switch (tk.getToknum()) {
                            case 10016: 
                            case 10020: {
                                s = "*>";
                                if (tk.getWord().startsWith("*>")) ** GOTO lbl60
                                s = "|";
                                if (!tk.getWord().startsWith("|")) ** GOTO lbl71
lbl60:
                                // 2 sources

                                if ((format == 1 || format == 5) && (s == "*>" && tk.getOffset() < ansiCommentColumn_1 || s == "|" && tk.getOffset() < ansiCommentColumn) || format == 4 && (s == "*>" && tk.getOffset() < ansiCommentColumn_1 && tk.getOffset() > 0 || s == "|" && tk.getOffset() < ansiCommentColumn)) {
                                    newText = lineForPreProc.substring(0, tk.getOffset());
                                    for (i = 0; i < s.length(); ++i) {
                                        newText = newText + " ";
                                    }
                                    newText = newText + tk.getWord().substring(s.length());
                                    this.paint(g, newText);
                                    return;
                                }
                                g.setColor(DebugPanel.access$3000());
                                firstToken = this.isFirstToken(tk, format);
                                break;
lbl71:
                                // 1 sources

                                if (word.trim().length() > 0) {
                                    firstToken = this.isFirstToken(tk, format);
                                }
                                g.setColor(DebugPanel.access$2900());
                                break;
                            }
                            case 10002: {
                                if (firstToken && DebugPanel.isLevelNumber(word)) {
                                    g.setColor(DebugPanel.access$3100());
                                } else {
                                    g.setColor(DebugPanel.access$3200());
                                }
                                firstToken = this.isFirstToken(tk, format);
                                break;
                            }
                            case 10017: {
                                g.setColor(DebugPanel.access$3200());
                                firstToken = this.isFirstToken(tk, format);
                                break;
                            }
                            case 10001: 
                            case 10024: {
                                g.setColor(DebugPanel.access$3300());
                                firstToken = this.isFirstToken(tk, format);
                                break;
                            }
                            case 576: 
                            case 577: 
                            case 601: 
                            case 660: 
                            case 661: 
                            case 736: 
                            case 737: 
                            case 822: 
                            case 824: 
                            case 825: {
                                g.setColor(DebugPanel.access$3400());
                                firstToken = this.isFirstToken(tk, format);
                                break;
                            }
                            case 10005: {
                                if (format != 1 && format != 5) ** GOTO lbl100
                                s = "*>";
                                if (tk.getWord().startsWith("*>") && tk.getOffset() < ansiCommentColumn_1) ** GOTO lbl105
                                s = "|";
                                if (tk.getWord().startsWith("|") && tk.getOffset() < ansiCommentColumn) ** GOTO lbl105
lbl100:
                                // 2 sources

                                if (format != 4) ** GOTO lbl112
                                s = "*>";
                                if (tk.getWord().startsWith("*>") && tk.getOffset() < ansiCommentColumn_1 && tk.getOffset() > 0) ** GOTO lbl105
                                s = "|";
                                if (!tk.getWord().startsWith("|") || tk.getOffset() >= ansiCommentColumn) ** GOTO lbl112
lbl105:
                                // 4 sources

                                newText = lineForPreProc.substring(0, tk.getOffset());
                                for (i = 0; i < s.length(); ++i) {
                                    newText = newText + " ";
                                }
                                newText = newText + tk.getWord().substring(s.length());
                                this.paint(g, newText);
                                return;
lbl112:
                                // 2 sources

                                g.setColor(DebugPanel.access$3000());
                                isComment = true;
                                break;
                            }
                            case 10003: {
                                if (tk.getWord().startsWith(">>")) {
                                    repl = (format == 1 || format == 5) && tk.getOffset() < ansiCommentColumn_1 || format == 4 && tk.getOffset() < ansiCommentColumn_1 ? "  " : "*>";
                                    newText = lineForPreProc.substring(0, tk.getOffset()) + repl + lineForPreProc.substring(tk.getOffset() + 2);
                                    this.paint(g, newText);
                                    return;
                                }
                                this.drawDefault(g, wordUp);
                                firstToken = this.isFirstToken(tk, format);
                                break;
                            }
                            case 36: 
                            case 42: {
                                if (DebugPanel.access$3500(DebugPanel.this, tk, format, ansiCommentColumn_1)) {
                                    g.setColor(DebugPanel.access$3000());
                                    isComment = true;
                                } else {
                                    g.setColor(DebugPanel.access$2900());
                                }
                                firstToken = this.isFirstToken(tk, format);
                                break;
                            }
                            default: {
                                this.drawDefault(g, wordUp);
                                firstToken = this.isFirstToken(tk, format);
                            }
                        }
                    }
                    g.drawString(word, startX, this.baseline);
                    startX += this.metrics.stringWidth(word);
                }
                tk = tl.getNextWithSep();
            }
            if (end < this.lineObj.lineStr.length()) {
                g.setColor(DebugPanel.access$2900());
                g.drawString(this.lineObj.lineStr.substring(end), startX, this.baseline);
            }
            this.drawHighlight(g);
            this.drawCursor(g);
        }

        private void drawDefault(Graphics g, String wordUp) {
            if (!DebugPanel.this.nrw.contains(wordUp)) {
                if (statements.contains(wordUp)) {
                    g.setColor(stmtForeground);
                } else if (keywords.contains(wordUp) || guiwords.contains(wordUp)) {
                    g.setColor(keywordForeground);
                } else {
                    g.setColor(sourceForeground);
                }
            } else {
                g.setColor(sourceForeground);
            }
        }

        private void drawCursor(Graphics g) {
            if (this.index == DebugPanel.this.selLine) {
                g.setColor(this.getForeground());
                g.drawLine(DebugPanel.this.cursorX, 0, DebugPanel.this.cursorX, g.getClipBounds().height);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.lineObj = (Line)value;
            if (this.lineObj == null) {
                return this;
            }
            this.setForeground(sourceForeground);
            if (index == DebugPanel.this.currLine) {
                this.setBackground(currLineBackground);
            } else {
                Breakpoint bp = DebugPanel.this.getBreakpoint(index);
                if (bp != null) {
                    if (bp.isEnabled()) {
                        this.setBackground(bpLineBackground);
                    } else {
                        this.setBackground(bpLineBackground.darker());
                    }
                } else if (index == DebugPanel.this.selLine || index >= DebugPanel.this.startDragLine && index <= DebugPanel.this.endDragLine || index >= DebugPanel.this.endDragLine && index <= DebugPanel.this.startDragLine) {
                    this.setBackground(selBackground);
                } else if (this.lineObj.copyDeep > 0) {
                    int idx = (this.lineObj.copyDeep - 1) % copySourcePatternColors.length;
                    this.setBackground(copySourcePatternColors[idx]);
                } else {
                    this.setBackground(sourceBackground);
                }
            }
            this.index = index;
            return this;
        }
    }

    private static enum HighlightVarType {
        NONE,
        HIGHLIGHT,
        LINK,
        HIGHLIGHT_LINK;

    }

    private class DebugList
    extends JList {
        private static final long serialVersionUID = 123L;

        private DebugList() {
        }

        @Override
        public Dimension getPreferredSize() {
            if (preferredPreviewWidth > 0) {
                return new Dimension(preferredPreviewWidth, super.getPreferredSize().height);
            }
            return super.getPreferredSize();
        }

        public List getSelectedValuesList() {
            ArrayList<String> result = new ArrayList<String>();
            if (DebugPanel.this.previewModel == null) {
                return result;
            }
            int start = DebugPanel.this.startDragLine;
            int end = DebugPanel.this.endDragLine;
            if (start < 0 || end < 0) {
                return result;
            }
            if (start > end) {
                start = DebugPanel.this.endDragLine;
                end = DebugPanel.this.startDragLine;
            }
            for (int i = start; i <= end; ++i) {
                result.add(((DebugPanel)DebugPanel.this).previewModel.getLineAt((int)i).lineStr);
            }
            return result;
        }
    }

    private static class ToggleImageButton
    extends JCheckBox
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        ActionListener listener;

        ToggleImageButton(String toolTipText, Image image, ActionListener listener, boolean selection) {
            super(new ImageIcon(image));
            this.setToolTipText(toolTipText);
            this.setSelected(selection);
            this.addActionListener(this);
            this.setFocusable(false);
            this.listener = listener;
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
            this.updateBorder();
        }

        void updateBorder() {
            if (this.isSelected()) {
                this.setBorder(BorderFactory.createLoweredBevelBorder());
                this.setBorderPainted(true);
            } else {
                this.setBorder(BorderFactory.createRaisedBevelBorder());
                this.setBorderPainted(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateBorder();
            this.listener.actionPerformed(e);
        }
    }

    static class Line {
        final int cobolLine;
        final int listingLine;
        final String lineStr;
        final byte copyDeep;
        final short copyFileIndex;
        boolean copyExpanded = true;

        Line(int cobolLine, int listingLine, String lineStr, byte copyDeep, short copyFileIndex) {
            this.cobolLine = cobolLine;
            this.listingLine = listingLine;
            this.lineStr = lineStr;
            this.copyDeep = copyDeep;
            this.copyFileIndex = copyFileIndex;
        }

        boolean copyStmt() {
            return this.copyFileIndex > 0;
        }

        public String toString() {
            return this.lineStr;
        }
    }

    private static class NoInfoPanel
    extends JPanel {
        JLabel lbl;
        private static final long serialVersionUID = 123L;

        NoInfoPanel(Color back, Color fore, Font f) {
            super(new FlowLayout());
            this.setBackground(back);
            this.lbl = new JLabel("<no information>");
            this.lbl.setForeground(fore);
            this.add(this.lbl);
            this.lbl.setFont(f);
        }

        @Override
        public void setForeground(Color c) {
            if (this.lbl == null) {
                super.setForeground(c);
            } else {
                this.lbl.setForeground(c);
            }
        }

        @Override
        public void setFont(Font f) {
            if (this.lbl == null) {
                super.setFont(f);
            } else {
                this.lbl.setFont(f);
            }
        }
    }

    private static class TextFileObj {
        TextFile tf;
        JScrollPane sp;
        boolean listing;
        LocalDebugInfo ldInfo;

        private TextFileObj() {
        }
    }

    static class MyVarName {
        String varName;
        String origText;
        int lstLine = -1;
        int offs;

        MyVarName(String v, String t) {
            this.varName = v;
            if (t.endsWith(".")) {
                t = t.substring(0, t.length() - 1);
            }
            this.origText = t;
        }
    }

    static class MyVariableModel
    extends VariableModel {
        public MyVariableModel(VariableNode root, boolean showHexValues) {
            super(root, showHexValues);
        }

        @Override
        public Object[] getChildren(Object parent) {
            if (parent == this.rootNode) {
                return ((VariableNode)parent).getChildren().toArray();
            }
            return super.getChildren(parent);
        }

        @Override
        public boolean isLeaf(Object node) {
            return ((VariableNode)node).isLeaf();
        }
    }
}

