/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger;

import com.iscobol.debugger.DebugResponse;
import com.iscobol.debugger.Debugger;
import com.iscobol.debugger.DebuggerConstants;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.FileLoader;
import com.iscobol.debugger.commands.ClearBreakpointCommand;
import com.iscobol.debugger.commands.CompositeCommand;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.debugger.commands.ExitCommand;
import com.iscobol.debugger.commands.GetFileCommand;
import com.iscobol.debugger.commands.MethodBreakpointCommand;
import com.iscobol.debugger.commands.ProgramBreakpointCommand;
import com.iscobol.debugger.commands.RawTextCommand;
import com.iscobol.debugger.commands.SetBreakpointCommand;
import com.iscobol.debugger.commands.SetRedirectStreamsCommand;
import com.iscobol.debugger.commands.SuspendCommand;
import com.iscobol.rts.Config;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Vector;

public class CommandListener
extends Thread {
    private DataInputStream debuggerInput;
    private PrintStream outputStream;
    private PipedOutputStream ppos;
    private PipedInputStream ppis;
    private LinkedList commandQueue = new LinkedList();
    private int blockingMode;
    private boolean throwStopRunExceptionOnExit;
    private volatile boolean go = true;

    public CommandListener(DataInputStream debuggerInput, int blockingMode) {
        this.setDaemon(true);
        this.debuggerInput = debuggerInput;
        this.ppos = new PipedOutputStream();
        this.outputStream = new PrintStream(this.ppos);
        this.blockingMode = blockingMode;
        try {
            this.ppis = new PipedInputStream(this.ppos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setName(this.getClass().getName());
    }

    public boolean isCanceled() {
        return !this.go;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Config.markNoIscobolRuntimeThread();
        while (!this.isCanceled()) {
            LinkedList linkedList = this.commandQueue;
            synchronized (linkedList) {
                if (!this.commandQueue.isEmpty()) {
                    try {
                        this.commandQueue.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            DebugCommand c = this.acceptCommand();
            if (c != null) {
                DebugResponse resp;
                if (c instanceof RawTextCommand) {
                    String s = ((RawTextCommand)c).getRawText();
                    this.outputStream.println(s);
                    this.outputStream.flush();
                    continue;
                }
                if (c instanceof SuspendCommand) {
                    Debugger.suspending();
                    continue;
                }
                if (c instanceof ExitCommand) {
                    this.throwStopRunExceptionOnExit = ((ExitCommand)c).isThrowStopRunException();
                    Debugger.writeResponse(new DebugResponse(0, ""));
                    continue;
                }
                if (c instanceof SetRedirectStreamsCommand) {
                    Debugger.setRedirectStreams(((SetRedirectStreamsCommand)c).getValue());
                    Debugger.writeResponse(new DebugResponse(0, ""));
                    continue;
                }
                if (c instanceof GetFileCommand) {
                    if (Config.getProperty(".debug.remote_source_enabled", false)) {
                        try {
                            String fileContents = this.getFile((GetFileCommand)c);
                            resp = new DebugResponse(0, fileContents);
                        }
                        catch (DebuggerException ex) {
                            resp = new DebugResponse(ex.getErrorId(), ex.getMessage());
                        }
                    } else {
                        DebuggerException ex = new DebuggerException(18);
                        resp = new DebugResponse(ex.getErrorId(), ex.getMessage());
                    }
                    Debugger.writeResponse(resp);
                    continue;
                }
                if (this.blockingMode == 1 && Debugger.getActiveDebuggerStatus() != 1) {
                    resp = null;
                    switch (c.getId()) {
                        case 0: {
                            resp = this.setBreakpoint((SetBreakpointCommand)c);
                            break;
                        }
                        case 9: {
                            resp = this.clearBreakpoint((ClearBreakpointCommand)c);
                            break;
                        }
                        case 19: {
                            resp = this.setProgramBreakpoint((ProgramBreakpointCommand)c);
                            break;
                        }
                        case 52: {
                            resp = this.setMethodBreakpoint((MethodBreakpointCommand)c);
                            break;
                        }
                        case 1000: {
                            boolean allBp = true;
                            Vector<DebugCommand> cmdList = ((CompositeCommand)c).getCommandList();
                            block24: for (DebugCommand dc : cmdList) {
                                switch (dc.getId()) {
                                    case 0: 
                                    case 9: 
                                    case 19: 
                                    case 52: {
                                        continue block24;
                                    }
                                }
                                allBp = false;
                                break;
                            }
                            if (allBp) {
                                block25: for (DebugCommand dc : cmdList) {
                                    switch (dc.getId()) {
                                        case 0: {
                                            resp = this.setBreakpoint((SetBreakpointCommand)dc);
                                            continue block25;
                                        }
                                        case 9: {
                                            resp = this.clearBreakpoint((ClearBreakpointCommand)dc);
                                            continue block25;
                                        }
                                        case 19: {
                                            resp = this.setProgramBreakpoint((ProgramBreakpointCommand)dc);
                                            continue block25;
                                        }
                                        case 52: {
                                            resp = this.setMethodBreakpoint((MethodBreakpointCommand)dc);
                                            continue block25;
                                        }
                                    }
                                    resp = null;
                                }
                                break;
                            }
                            this.setCommand(c);
                            resp = null;
                            break;
                        }
                        default: {
                            this.setCommand(c);
                            resp = null;
                        }
                    }
                    if (resp == null) continue;
                    Debugger.writeResponse(resp);
                    continue;
                }
                this.setCommand(c);
                continue;
            }
            this.cancel();
        }
    }

    private DebugResponse setBreakpoint(SetBreakpointCommand c) {
        try {
            String s = Debugger.setBreakpoint(c, "", 0, null);
            return Debugger.getResponse(s, c.getId());
        }
        catch (DebuggerException ex) {
            return new DebugResponse(ex.getErrorId(), ex.getMessage());
        }
    }

    private DebugResponse setProgramBreakpoint(ProgramBreakpointCommand c) {
        try {
            String s = Debugger.setProgramBreakpoint(c, null);
            return Debugger.getResponse(s, c.getId());
        }
        catch (DebuggerException ex) {
            return new DebugResponse(ex.getErrorId(), ex.getMessage());
        }
    }

    private DebugResponse setMethodBreakpoint(MethodBreakpointCommand c) {
        try {
            String s = Debugger.setMethodBreakpoint(c, null);
            return Debugger.getResponse(s, c.getId());
        }
        catch (DebuggerException ex) {
            return new DebugResponse(ex.getErrorId(), ex.getMessage());
        }
    }

    private DebugResponse clearBreakpoint(ClearBreakpointCommand c) {
        try {
            String s = Debugger.clearBreakpoint(c, "", 0);
            return Debugger.getResponse(s, c.getId());
        }
        catch (DebuggerException ex) {
            return new DebugResponse(ex.getErrorId(), ex.getMessage());
        }
    }

    private String getFile(GetFileCommand cmd) throws DebuggerException {
        FileLoader fl = Debugger.getFileLoader();
        if (fl == null) {
            throw new DebuggerException(18, "'" + cmd.getPath() + "'");
        }
        String path = fl.getAbsolutePath(cmd.getPath());
        if (path != null) {
            try {
                FileInputStream is = new FileInputStream(path);
                byte[] b = new byte[((InputStream)is).available()];
                ((InputStream)is).read(b);
                ((InputStream)is).close();
                return new String(b);
            }
            catch (IOException ex) {
                throw new DebuggerException(18, "'" + path + "'");
            }
        }
        throw new DebuggerException(18, "'" + path + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCommand(DebugCommand c) {
        LinkedList linkedList = this.commandQueue;
        synchronized (linkedList) {
            this.commandQueue.addLast(c);
            this.commandQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Debugger.unattach(this.throwStopRunExceptionOnExit);
        this.go = false;
        try {
            this.ppis.close();
            this.ppos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LinkedList linkedList = this.commandQueue;
        synchronized (linkedList) {
            this.commandQueue.notifyAll();
        }
    }

    private DebugCommand acceptCommand() {
        try {
            int id = this.debuggerInput.readInt();
            DebugCommand c = DebuggerConstants.commandClasses.get(id).newInstance();
            c.readExternal(this.debuggerInput);
            return c;
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public InputStream getInputStream() {
        return this.ppis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugCommand getDebugCommand() {
        DebugCommand Return2 = null;
        LinkedList linkedList = this.commandQueue;
        synchronized (linkedList) {
            if (this.commandQueue.isEmpty()) {
                try {
                    this.commandQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Return2 = this.commandQueue.isEmpty() ? null : (DebugCommand)this.commandQueue.removeFirst();
            this.commandQueue.notify();
        }
        return Return2;
    }
}

