/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.coverage;

import com.iscobol.coverage.CoverageCopyStatement;
import com.iscobol.coverage.CoverageElement;
import com.iscobol.coverage.CoverageParagraph;
import com.iscobol.coverage.CoverageStatement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class CoverageProgram
extends CoverageElement {
    private LinkedHashMap<String, CoverageParagraph> paragraphs = new LinkedHashMap();
    private Map<CoverageStatement, CoverageCopyStatement> copyStatements = new TreeMap<CoverageStatement, CoverageCopyStatement>();
    public String name;
    public String fileName;
    public String location = "";

    public int getTotalParagraphs() {
        return this.paragraphs.size();
    }

    public Collection<CoverageParagraph> getParagraphs() {
        return this.paragraphs.values();
    }

    public void addParagraph(CoverageParagraph paragraph) {
        this.paragraphs.put(paragraph.name, paragraph);
    }

    public CoverageParagraph getParagraph(String name) {
        return this.paragraphs.get(name);
    }

    public CoverageParagraph removeParagraph(String name) {
        return (CoverageParagraph)this.paragraphs.remove(name);
    }

    public CoverageCopyStatement getCopyStatement(CoverageStatement stmt) {
        return this.copyStatements.get(stmt);
    }

    public CoverageCopyStatement removeCopyStatement(CoverageCopyStatement stmt) {
        return this.copyStatements.remove(stmt);
    }

    public Collection<CoverageCopyStatement> getCopyStatements() {
        return this.copyStatements.values();
    }

    public void addCopyStatement(CoverageCopyStatement cstmt) {
        this.copyStatements.put(cstmt, cstmt);
    }

    public int getMissedParagraphs() {
        Collection<CoverageParagraph> paragraphs = this.getParagraphs();
        int missed = 0;
        for (CoverageParagraph p : paragraphs) {
            if (!"red".equals(p.color)) continue;
            ++missed;
        }
        return missed;
    }

    public int getTotalStatements() {
        Collection<CoverageParagraph> paragraphs = this.getParagraphs();
        int total = 0;
        for (CoverageParagraph p : paragraphs) {
            total += p.getTotalStatements();
        }
        return total;
    }

    public int getMissedStatements() {
        Collection<CoverageParagraph> paragraphs = this.getParagraphs();
        int missed = 0;
        for (CoverageParagraph p : paragraphs) {
            missed += p.getMissedStatements();
        }
        return missed;
    }

    public double getStatementCoverageRatio() {
        int missed = this.getMissedStatements();
        int total = this.getTotalStatements();
        double covRatio = 0.0;
        if (total > 0) {
            covRatio = 1.0 - (double)missed / (double)total;
        }
        return covRatio;
    }

    public double getParagraphCoverageRatio() {
        int missed = this.getMissedParagraphs();
        int total = this.getTotalParagraphs();
        double covRatio = 0.0;
        if (total > 0) {
            covRatio = 1.0 - (double)missed / (double)total;
        }
        return covRatio;
    }
}

