/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.Verb;

public class Unlock
extends Verb
implements CobolToken,
ErrorsNumbers {
    private Select sel;
    private boolean all;

    public Unlock(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 262) {
            this.all = true;
            if (this.pc.getSelectList() == null) {
                this.error.print(53, 2, tk, tk.getWord());
            }
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 10009) {
            this.sel = this.pc.getSelect(tk.getWord());
            if (this.sel == null) {
                throw new GeneralErrorException(53, 4, tk, tk.getWord(), this.error);
            }
            if (this.sel.isSort()) {
                throw new GeneralErrorException(103, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 262) {
                tk = this.tm.getToken();
            }
        } else {
            throw new GeneralErrorException(174, 4, kw, kw.getWord(), this.error);
        }
        if (tk.getToknum() != 670 && tk.getToknum() != 672) {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        boolean hasDeclaratives = this.sel != null && this.pc.getDeclarative(this.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append("try {");
        Return2.append(eol);
        if (this.all) {
            SelectList sl = this.pc.getSelectList();
            if (sl == null) {
                return "";
            }
            this.sel = sl.getFirst();
            while (this.sel != null) {
                if (!this.sel.isSort()) {
                    Return2.append(this.parent.getIndent());
                    Return2.append("if (");
                    Return2.append(this.sel.getName());
                    Return2.append(".isOpen()) ");
                    Return2.append(this.sel.getName());
                    Return2.append(".unlock();");
                    Return2.append(eol);
                }
                this.sel = sl.getNext();
            }
            Return2.append(this.parent.getIndent());
            Return2.append("} catch (CobolIOException dex$) {}");
        } else {
            Return2.append(this.parent.getIndent());
            Return2.append(this.sel.getName());
            Return2.append(".unlock();");
            Return2.append(eol);
            Use.putFileStatus(Return2, this.sel, this.parent.getIndent());
            Use.putDeclaratives(Return2, this.pc, this.sel, this.parent.getIndent(), hasDeclaratives);
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public Select getSelect() {
        return this.sel;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }
}

