/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Transform
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName source;
    private VariableName pattern1Vn;
    private Token pattern1Tk;
    private VariableName pattern2Vn;
    private Token pattern2Tk;
    private boolean hasNational;

    public Transform(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009 && tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.source = VariableName.get(this.tm, this.error, this.pc);
        if (this.source.isSetGetProperty() || !this.source.getVarDecl().isUsageDisplay()) {
            throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
        }
        this.setHasNational(this.source);
        tk = this.tm.getToken();
        if (tk.getToknum() == 324) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 498) {
            throw new ExpectedFoundException(tk, this.error, "FROM");
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10002: {
                if (tk.isFigurativeZero()) {
                    this.pattern1Tk = Transform.cloneToken(tk, 10001, "'0'");
                    break;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            case 10001: {
                this.pattern1Tk = tk;
                break;
            }
            case 10009: {
                this.tm.ungetToken();
                this.pattern1Vn = VariableName.get(this.tm, this.error, this.pc);
                this.setHasNational(this.pattern1Vn);
                break;
            }
            default: {
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 773) {
            throw new ExpectedFoundException(tk, this.error, "TO");
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10002: {
                if (tk.isFigurativeZero()) {
                    this.pattern2Tk = Transform.cloneToken(tk, 10001, "'0'");
                    break;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            case 10001: {
                this.pattern2Tk = tk;
                break;
            }
            case 10009: {
                this.tm.ungetToken();
                this.pattern2Vn = VariableName.get(this.tm, this.error, this.pc);
                this.setHasNational(this.pattern2Vn);
                break;
            }
            default: {
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    static Token cloneToken(Token tk, int toknum, String word) {
        Token Return2 = new Token(tk);
        Return2.setToknum(toknum);
        Return2.setWord(word);
        Return2.setAll(tk.isAll());
        return Return2;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append(this.source.getCode());
        Return2.append(".transform");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            Return2.append("Byte");
        }
        Return2.append("(");
        if (this.pattern1Tk != null) {
            Return2.append(this.getCodeLiteral(this.pattern1Tk));
        } else {
            Return2.append(this.pattern1Vn.getCode());
        }
        Return2.append(" , ");
        if (this.pattern2Tk != null) {
            Return2.append(this.getCodeLiteral(this.pattern2Tk));
        } else {
            Return2.append(this.pattern2Vn.getCode());
        }
        Return2.append(");");
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public VariableName getSource() {
        return this.source;
    }

    public VariableName getPattern1Vn() {
        return this.pattern1Vn;
    }

    public Token getPattern1Tk() {
        return this.pattern1Tk;
    }

    public VariableName getPattern2Vn() {
        return this.pattern2Vn;
    }

    public Token getPattern2Tk() {
        return this.pattern2Tk;
    }

    private void setHasNational(VariableName vn) {
        if (!this.hasNational) {
            VariableDeclaration vd = vn.getVarDecl();
            this.hasNational = vd != null && (vd.isNational() || vd.isPicG());
        }
    }
}

