/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.Enumeration;
import java.util.Vector;

public class Strings
extends Verb
implements CobolToken,
ErrorsNumbers {
    Vector itemList = new Vector();
    VariableName destination = null;
    VariableName pointer = null;
    Vector src = new Vector();
    Vector delimiters = new Vector();
    Block overflowBlock;
    Block notOverflowBlock;
    boolean destNational;
    private boolean hasNational;

    public Strings(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.allowAllLitGen = false;
        Token tk = this.tm.getToken();
        boolean not = false;
        do {
            VariableName vn;
            int j = 0;
            while (true) {
                if (tk.getToknum() == 10001) {
                    this.itemList.addElement(tk);
                } else if (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    vn = VariableName.get(this.tm, this.error, this.pc);
                    if (!vn.isUsageDisplay()) {
                        this.error.print(288, 3, tk, tk.getWord());
                    }
                    this.setHasNational(vn);
                    this.itemList.addElement(vn);
                } else if (tk.isFigurativeZero()) {
                    tk = Strings.cloneToken(tk, 10001, "'0'");
                    this.itemList.addElement(tk);
                } else {
                    if (j != 0) break;
                    throw new UnexpectedTokenException(tk, this.error);
                }
                tk = this.tm.getToken();
                ++j;
            }
            Delim delim = new Delim();
            if (tk.getToknum() != 398) {
                this.src.addElement(this.itemList);
                delim.delimSize = true;
                this.delimiters.addElement(delim);
            } else {
                tk = this.tm.getToken();
                if (tk.getToknum() == 312) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 776) {
                    delim.isTrailing = true;
                    tk = this.tm.getToken();
                }
                switch (tk.getToknum()) {
                    case 10002: {
                        if (tk.isFigurativeZero()) {
                            tk = Strings.cloneToken(tk, 10001, "'0'");
                        }
                    }
                    case 10001: {
                        this.src.addElement(this.itemList);
                        if (delim.isTrailing && tk.getWord().length() > 3) {
                            throw new GeneralErrorException(69, 4, tk, tk.getWord(), this.error);
                        }
                        delim.delimTk = tk;
                        this.delimiters.addElement(delim);
                        break;
                    }
                    case 10009: {
                        this.tm.ungetToken();
                        vn = VariableName.get(this.tm, this.error, this.pc);
                        if (!vn.isUsageDisplay()) {
                            throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
                        }
                        if (delim.isTrailing && vn.getVariableLength() > 1) {
                            throw new GeneralErrorException(69, 4, vn.getNameToken(), vn.getName(), this.error);
                        }
                        this.setHasNational(vn);
                        this.src.addElement(this.itemList);
                        delim.delimVn = vn;
                        this.delimiters.addElement(delim);
                        break;
                    }
                    case 728: {
                        if (delim.isTrailing) {
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        this.src.addElement(this.itemList);
                        delim.delimSize = true;
                        this.delimiters.addElement(delim);
                        break;
                    }
                    default: {
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                }
                tk = this.tm.getToken();
            }
            this.itemList = new Vector();
        } while (tk.getToknum() != 542);
        tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.destination = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
        if (!this.destination.isUsageDisplay() || this.destination.getVarDecl().isEdited() || this.destination.getVarDecl().isJustified() && this.pc.getOption("-ca") == null && this.pc.getOption("-cm") == null) {
            throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
        }
        this.setHasNational(this.destination);
        this.destNational = this.destination.getVarDecl().isNational;
        tk = this.tm.getToken();
        if (tk.getToknum() == 813 && (tk = this.tm.getToken()).getToknum() != 638) {
            throw new ExpectedFoundException(tk, this.error, "'POINTER'");
        }
        if (tk.getToknum() == 638) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.pointer = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            if (!this.pointer.getVarDecl().isInteger()) {
                throw new GeneralErrorException(46, 4, tk, tk.getWord(), this.error);
            }
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 598 || tk.getToknum() == 613 || tk.getToknum() == 624) {
            boolean on = false;
            if (tk.getToknum() == 598) {
                not = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 613) {
                on = true;
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 624) {
                if (not) {
                    this.notOverflowBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 10);
                } else {
                    this.overflowBlock = new Block(this.parent, this.parent.parent, (Verb)this, this.pc, this.tm, this.error, this.parent.nesting + 1, 9);
                }
                tk = this.tm.getToken();
                if (!not && tk.getToknum() == 598) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 613) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 624) {
                        this.notOverflowBlock = new Block(this.parent, this.parent.parent, this, this.pc, this.tm, this.error, this.parent.nesting + 1);
                    }
                } else {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
                if (not) {
                    this.tm.ungetToken();
                }
                if (on) {
                    this.tm.ungetToken();
                }
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() != 448) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    static Token cloneToken(Token tk, int toknum, String word) {
        Token Return2 = new Token(tk);
        Return2.setToknum(toknum);
        Return2.setWord(word);
        Return2.setAll(tk.isAll());
        return Return2;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.overflowBlock != null) {
            Return2.append("if(");
        } else if (this.notOverflowBlock != null) {
            Return2.append("if(!");
        }
        Return2.append(this.destination.getCode());
        Return2.append(".string");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            Return2.append("Byte");
        }
        Return2.append("(");
        Return2.append(this.getSourceCode());
        if (this.pointer != null) {
            Return2.append("," + this.pointer.getCode());
        } else {
            Return2.append(",null");
        }
        Return2.append(",");
        Return2.append(this.pc.getOption("-cudc") != null);
        Return2.append(")");
        if (this.overflowBlock != null || this.notOverflowBlock != null) {
            Return2.append(")");
            if (this.overflowBlock != null) {
                Return2.append(this.overflowBlock.getCode());
                if (this.notOverflowBlock != null) {
                    Return2.append(" else ");
                    Return2.append(this.notOverflowBlock.getCode());
                }
            } else if (this.notOverflowBlock != null) {
                Return2.append(this.notOverflowBlock.getCode());
            }
        } else {
            Return2.append(";");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private String getSourceCode() {
        StringBuffer source = new StringBuffer();
        StringBuffer delims = new StringBuffer();
        StringBuffer trailing = new StringBuffer();
        source.append("new CobolVar[] {");
        delims.append("new CobolVar[] {");
        trailing.append("new boolean[] {");
        Enumeration srcElements = this.src.elements();
        Enumeration delimElements = this.delimiters.elements();
        while (srcElements.hasMoreElements()) {
            Enumeration eItemList = ((Vector)srcElements.nextElement()).elements();
            Delim delim = (Delim)delimElements.nextElement();
            while (eItemList.hasMoreElements()) {
                Object item = eItemList.nextElement();
                if (item instanceof Token) {
                    Token tk = (Token)item;
                    if (this.destNational && tk.isFigurativeHighValue()) {
                        tk.setAll(false);
                        tk.setNational(true);
                    }
                    source.append(this.getCodeLiteral((Token)item));
                } else {
                    VariableName vn = (VariableName)item;
                    source.append(vn.getCode());
                    if (!this.hasNational && vn.getVarDecl() == this.destination.getVarDecl() && !vn.getVarDecl().isAnyLength() && this.pc.getOption("-b") != null) {
                        source.append(".copy()");
                    }
                }
                if (delim.delimSize) {
                    delims.append("null");
                } else if (delim.delimTk != null) {
                    if (this.destNational && delim.delimTk.isFigurativeHighValue()) {
                        delim.delimTk.setAll(false);
                        delim.delimTk.setNational(true);
                    }
                    delims.append(this.getCodeLiteral(delim.delimTk));
                } else {
                    delims.append(delim.delimVn.getCode());
                }
                trailing.append(delim.isTrailing);
                if (!eItemList.hasMoreElements() && !srcElements.hasMoreElements()) continue;
                source.append(",");
                delims.append(",");
                trailing.append(",");
            }
        }
        source.append(" }");
        delims.append(" }");
        trailing.append(" }");
        return source.append(",").append(delims).append(",").append(trailing).toString();
    }

    public Vector getSources() {
        return this.src;
    }

    public Vector getDelimiters() {
        return this.delimiters;
    }

    public Block getOverflowBlock() {
        return this.overflowBlock;
    }

    public Block getNotOverflowBlock() {
        return this.notOverflowBlock;
    }

    public VariableName getDestination() {
        return this.destination;
    }

    public VariableName getPointer() {
        return this.pointer;
    }

    private void setHasNational(VariableName vn) {
        if (!this.hasNational) {
            VariableDeclaration vd = vn.getVarDecl();
            this.hasNational = vd != null && (vd.isNational() || vd.isPicG());
        }
    }

    public static class Delim {
        public Token delimTk;
        public VariableName delimVn;
        public boolean isTrailing;
        public boolean delimSize;
    }
}

