/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.InvalidKey;
import com.iscobol.compiler.LikeFlags;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Use;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Start
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int OP_EQ = 1;
    public static final int OP_GE = 3;
    public static final int OP_LE = 4;
    public static final int OP_GT = 5;
    public static final int OP_LT = 6;
    public static final int OP_FIRST = 7;
    public static final int OP_LAST = 8;
    private Select sel;
    private InvalidKey invKey;
    private VariableName keyName;
    private Token keyIndexTk;
    private VariableName keyIndexVn;
    private VariableDeclaration[] key;
    private int type = 0;
    private int op = 0;
    private Expression withLength;
    private int varKeySize;
    private LikeFlags whileLike;
    private VariableName whileRegexVar;
    private Token whileRegexTok;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Start(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 777) {
            this.type = 777;
            return;
        }
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
        }
        this.sel = this.pc.getSelect(tk.getWord());
        if (this.sel == null) {
            throw new GeneralErrorException(53, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (this.sel.isSort()) {
            throw new GeneralErrorException(103, 4, this.keyWord, tk.getWord(), this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 489 || tk.getToknum() == 554 || tk.getToknum() == 551) {
            this.type = tk.getToknum();
            if (this.type == 551) {
                if (this.sel.isXml()) {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                    this.tm.ungetToken();
                    this.keyName = VariableName.get(this.tm, this.error, this.pc);
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 528) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 545) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.tm.ungetToken();
                            this.keyIndexVn = VariableName.get(this.tm, this.error, this.pc);
                            return;
                        } else {
                            if (!Token.isIntLit(tk)) throw new GeneralErrorException(22, 4, this.keyWord, tk.getWord(), this.error);
                            this.keyIndexTk = tk;
                        }
                        return;
                    } else {
                        this.tm.ungetToken();
                    }
                    return;
                }
                this.relationalOperator();
                tk = this.tm.getToken();
                if (tk.getToknum() != 10009) throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
                this.tm.ungetToken();
                this.keyName = VariableName.get(this.tm, this.error);
                if (this.sel.organization == 677) {
                    this.key = new VariableDeclaration[]{this.sel.relativeKey.getVarDecl()};
                } else {
                    this.key = this.sel.getKeyByName(this.keyName.getName());
                    if (this.key == null) {
                        this.keyName.check(this.pc);
                        this.varKeySize = this.keyName.getVarDecl().getPhisicLen();
                        FileDescriptor fd = this.pc.getFdByRecord(this.keyName.getVarDecl().getGrandPa());
                        if (fd != null) {
                            if (fd.sel != this.sel || !fd.getVirtualParent().isChild(this.keyName.getName())) {
                                throw new GeneralErrorException(56, 4, this.keyWord, tk.getWord(), this.error);
                            }
                            this.key = this.sel.getKeyByOffset(this.keyName.getVarDecl().getOffset());
                        }
                        if (this.key == null) {
                            throw new GeneralErrorException(56, 4, this.keyWord, tk.getWord(), this.error);
                        }
                    }
                }
            }
        } else {
            this.tm.ungetToken();
        }
        if ((tk = this.tm.getToken()).getToknum() == 813 || tk.isLength() || tk.getToknum() == 728) {
            if (tk.getToknum() == 813) {
                tk = this.tm.getToken();
            }
            if (!tk.isLength() && tk.getToknum() != 728) {
                throw new ExpectedFoundException(tk, this.error, "LENGTH");
            }
            int[] openPar = new int[]{0};
            this.withLength = new Expression(openPar, kw, par, p, t, err);
            if (!this.withLength.isNumeric()) {
                throw new GeneralErrorException(49, 4, kw, kw.getWord(), this.error);
            }
            if (openPar[0] != 0) {
                throw new GeneralErrorException(44, 4, kw, kw.getWord(), this.error);
            }
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if ("WHILE".equals(tk.getWord())) {
            if (this.sel.organization != 529) {
                throw new ClauseClashException(tk, this.error, "WHILE");
            }
            tk.setToknum(10025);
            tk = this.tm.getToken();
            if (tk.getToknum() == 551) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 545) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 598) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 561) {
                throw new ExpectedFoundException(tk, this.error, "LIKE");
            }
            this.whileLike = new LikeFlags(this.tm, this.error, this.pc);
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.whileRegexVar = VariableName.get(this.tm, this.error, this.pc);
            } else {
                if (tk.getToknum() != 10001) throw new UnexpectedTokenException(tk, this.error);
                this.whileRegexTok = tk;
            }
        } else {
            this.tm.ungetToken();
        }
        this.invKey = new InvalidKey(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
        tk = this.tm.getToken();
        if (tk.getToknum() != 447) {
            this.tm.ungetToken();
            return;
        } else {
            this.endStmt = true;
        }
    }

    void relationalOperator() throws GeneralErrorException, EndOfProgramException {
        boolean not = false;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 545) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 489) {
            this.op = 7;
            return;
        }
        if (tk.getToknum() == 554) {
            this.op = 8;
            return;
        }
        if (tk.getToknum() == 598) {
            not = true;
            tk = this.tm.getToken();
        }
        switch (tk.getToknum()) {
            case 61: 
            case 462: 
            case 463: {
                if (not) {
                    throw new ClauseClashException(tk, this.error, "NOT");
                }
                this.op = 1;
                tk = this.tm.getToken();
                if (tk.getToknum() == 773) break;
                this.tm.ungetToken();
                break;
            }
            case 60: 
            case 62: 
            case 471: 
            case 507: 
            case 560: {
                this.op = tk.getToknum() == 560 || tk.getToknum() == 60 ? (not ? 3 : 6) : (not ? 4 : 5);
                tk = this.tm.getToken();
                if (tk.getToknum() == 761) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 617) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 462 || tk.getToknum() == 61 || tk.getToknum() == 463) {
                    switch (this.op) {
                        case 3: {
                            this.op = 5;
                            break;
                        }
                        case 6: {
                            this.op = 4;
                            break;
                        }
                        case 4: {
                            this.op = 6;
                            break;
                        }
                        case 5: {
                            this.op = 3;
                        }
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 773) break;
                    this.tm.ungetToken();
                    break;
                }
                if (tk.getToknum() == 761) break;
                this.tm.ungetToken();
                break;
            }
            default: {
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.whileLike != null && this.whileRegexTok != null) {
            this.whileLike.check(this.whileRegexTok);
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append("try {");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        if (this.sel != null && this.sel.isXml()) {
            Return2.append(this.sel.getName());
            Return2.append(".startXml(");
            if (this.keyName != null) {
                Return2.append(this.keyName.getCode());
            } else {
                Return2.append("null");
            }
            Return2.append(",");
            if (this.keyIndexTk != null) {
                Return2.append(this.tm.getCodeLiteral(this.keyIndexTk)).append(".toint()");
            } else if (this.keyIndexVn != null) {
                Return2.append(this.keyIndexVn.getCode()).append(".toint()");
            } else {
                Return2.append("1");
            }
            Return2.append(");");
        } else {
            int i;
            if (this.type == 777) {
                Return2.append("Factory.beginTrans();");
                Return2.append(eol);
                Use.putDeclTransaction(Return2, this.pc, this.parent.getIndent());
                this.getCodeDebugEnd(Return2);
                return Return2.toString();
            }
            if (this.invKey != null) {
                Return2.append(this.invKey.getCodeBefore());
            }
            Return2.append(this.sel.getName());
            Return2.append(".start(");
            if (this.type == 551) {
                if (this.op == 0) {
                    this.op = 1;
                }
                if (this.key == null) {
                    if (this.sel.organization == 529) {
                        this.key = this.sel.getPrimaryKey();
                    } else if (this.sel.organization == 677) {
                        this.key = new VariableDeclaration[]{this.sel.relativeKey.getVarDecl()};
                    }
                }
                if (this.key != null) {
                    Return2.append("new CobolVar[] {");
                    i = 0;
                    while (true) {
                        Return2.append(this.key[i].getQualUnivoqueName());
                        if (++i >= this.key.length) break;
                        Return2.append(",");
                    }
                    Return2.append("}");
                } else {
                    Return2.append("null");
                }
            } else {
                if (this.sel.organization == 529) {
                    this.key = this.sel.getPrimaryKey();
                } else if (this.sel.organization == 677) {
                    this.key = new VariableDeclaration[]{this.sel.relativeKey.getVarDecl()};
                }
                if (this.key != null) {
                    Return2.append("new CobolVar[] {");
                    i = 0;
                    while (true) {
                        Return2.append(this.key[i].getQualUnivoqueName());
                        if (++i >= this.key.length) break;
                        Return2.append(",");
                    }
                    Return2.append("}");
                } else {
                    Return2.append("null");
                }
            }
            Return2.append(",");
            if (this.type == 489) {
                Return2.append("CobolFile.START_FIRST");
            } else if (this.type == 554) {
                Return2.append("CobolFile.START_LAST");
            } else {
                switch (this.op) {
                    case 1: {
                        Return2.append("CobolFile.START_EQUAL");
                        break;
                    }
                    case 4: {
                        Return2.append("CobolFile.START_LTEQ");
                        break;
                    }
                    case 5: {
                        Return2.append("CobolFile.START_GREAT");
                        break;
                    }
                    case 6: {
                        Return2.append("CobolFile.START_LESS");
                        break;
                    }
                    case 7: {
                        Return2.append("CobolFile.START_FIRST");
                        break;
                    }
                    case 8: {
                        Return2.append("CobolFile.START_LAST");
                        break;
                    }
                    default: {
                        Return2.append("CobolFile.START_GTEQ");
                    }
                }
            }
            Return2.append(",");
            if (this.withLength != null) {
                Return2.append(this.withLength.getCode());
                Return2.append(".intValue())");
            } else {
                Return2.append(this.varKeySize);
                Return2.append(")");
            }
            Return2.append(";");
            if (this.whileLike != null && this.key != null) {
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
                Return2.append(this.sel.getName());
                Return2.append(".like(new CobolVar[] {");
                i = 0;
                while (true) {
                    Return2.append(this.key[i].getQualUnivoqueName());
                    if (++i >= this.key.length) break;
                    Return2.append(",");
                }
                Return2.append("},");
                if (this.whileRegexVar != null) {
                    Return2.append(this.whileRegexVar.getCode());
                } else {
                    Return2.append(this.getCodeLiteral(this.whileRegexTok));
                }
                Return2.append(",");
                Return2.append(this.whileLike.getCode());
                Return2.append(");");
            }
        }
        Use.putFileStatus(Return2, this.sel, this.parent.getIndent());
        if (this.invKey != null) {
            Return2.append(this.invKey.getCode());
        }
        boolean hasDeclaratives = this.pc.getDeclarative(this.sel) != null || this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
        Use.putDeclaratives(Return2, this.pc, this.sel, this.parent.getIndent(), hasDeclaratives);
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public int getType() {
        return this.type;
    }

    public int getOp() {
        return this.op;
    }

    public Expression getWithLength() {
        return this.withLength;
    }

    public VariableDeclaration[] getKey() {
        return this.key;
    }

    public InvalidKey getInvalidKey() {
        return this.invKey;
    }

    public Select getSelect() {
        return this.sel;
    }

    public int getVarKeySize() {
        return this.varKeySize;
    }

    public boolean hasGlobalDecl() {
        return this.pc.declInput != null || this.pc.declOutput != null || this.pc.declIO != null || this.pc.declExtend != null;
    }
}

