/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SqlDeclareCursor;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;

public class SqlPrepare
extends SqlStatement {
    private String name;
    private VariableName selVar;
    private VariableName prepHndl;
    private VariableName intoSqlda;
    private Token selToken;
    private Pcc pc;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlPrepare(ExecSql es, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, par, p, t, err);
        this.isSqljStat = false;
        this.pc = p;
        Token tk = this.getSqlToken();
        if (tk.getToknum() == 58) {
            this.prepHndl = VariableName.get(this.tm, this.error, this.pc);
            if (this.prepHndl.getVarDecl().getHandleType() == 0) {
                throw new GeneralErrorException(11, 4, this.prepHndl.getNameToken(), this.prepHndl.getName(), this.error);
            }
        } else {
            this.name = tk.getWord();
        }
        if (this.db2Esql) {
            tk = this.getSqlToken();
            if (tk.getToknum() == 542) {
                tk = this.getSqlToken();
                if (tk.getToknum() != 58) throw new ExpectedFoundException(tk, this.error, "hostVariable");
                this.intoSqlda = VariableName.get(this.tm, this.error, this.pc);
            } else {
                this.ungetAllSqlToken();
            }
        }
        if ((tk = this.getSqlToken()).getToknum() != 498) {
            throw new ExpectedFoundException(tk, this.error, "'FROM'");
        }
        tk = this.getSqlToken(true);
        if (tk.getToknum() == 10001) {
            this.selToken = tk;
            return;
        } else {
            if (tk.getToknum() != 58) throw new ExpectedFoundException(tk, this.error, "':'");
            this.selVar = VariableName.get(this.tm, this.error, this.pc);
            if (this.selVar != null) return;
            tk = this.getSqlToken();
            throw new GeneralErrorException(196, 4, tk, tk.getWord(), this.error);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void check() throws GeneralErrorException {
        SqlDeclareCursor c;
        if (this.name != null && (c = this.pc.getCursor(this.name)) != null) {
            c.isSqljStat = false;
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        Return2.append(this.getReturnCode());
        if (this.intoSqlda != null) {
            Return2.append(".set(Esql.PREPARE_DB2_SQLDA(new Object[] {" + this.pc.sqlca.SQLCA + ",");
        } else {
            Return2.append(".set(Esql.PREPARE(new Object[] {" + this.pc.sqlca.SQLCA + ",");
        }
        if (this.prepHndl != null) {
            Return2.append(this.prepHndl.getCode());
        } else {
            Return2.append("\"");
            Return2.append(this.name);
            Return2.append("\"");
        }
        if (this.selVar != null) {
            Return2.append(",true,");
        } else {
            Return2.append(",false,");
        }
        if (this.selVar != null) {
            if (this.selVar.getVarDecl().isVarying() || this.selVar.getVarDecl().isLob() || this.selVar.getVarDecl().isVarChar()) {
                Return2.append(this.selVar.getVarDecl().getChildren().getLast().getUnivoqueName());
                if (this.selVar.hasIndexes()) {
                    Return2.append(this.selVar.getIndexes().getCode(this.selVar.getVarDecl().isObjectReference(), this.selVar.getVarDecl().getOccurs() > 0, this.selVar.isEdited() && this.selVar.isNumeric()));
                }
            } else {
                Return2.append(this.selVar.getVarDecl().getUnivoqueName());
            }
        } else {
            Return2.append(this.getCodeLiteral(this.selToken));
        }
        if (this.intoSqlda != null) {
            Return2.append(", null, " + this.intoSqlda.getVarDecl().getUnivoqueName());
            if (this.optionCP) {
                Return2.append(", ");
                Return2.append("" + this.optionD64);
            }
            Return2.append("}));");
        } else {
            Return2.append(", null}));");
        }
        Return2.append(eol);
        this.addWhenever(Return2);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public VariableName getPrepHndl() {
        return this.prepHndl;
    }

    public VariableName getSelVar() {
        return this.selVar;
    }

    public Token getSelToken() {
        return this.selToken;
    }
}

