/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ExecSql;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.SqlCall;
import com.iscobol.compiler.SqlSelect;
import com.iscobol.compiler.SqlStatement;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import java.util.Vector;

public class SqlDeclareCursor
extends SqlStatement {
    private SqlSelect sel;
    private SqlSelect selWith;
    private SqlCall call;
    private String prepStat;
    private String withStat = null;
    private VariableName prepHndl;
    private boolean forUpdate;
    private int holdOption;
    private boolean currentOf = false;
    private String declareCursorMethodName;
    private int cursorType;
    private boolean rowset;
    private int withReturn;
    public Vector bindVars;
    public Vector bindInds;
    public boolean changeBind = true;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SqlDeclareCursor(ExecSql es, Token kw, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, null, p, t, err, false);
        Token tk;
        this.rowset = false;
        this.curName = this.getSqlToken().getWord();
        if (this.sqlj) {
            if (this.db2Esql) {
                this.pc.addResultSet("DB2ResultSet " + this.curName + ";");
            } else {
                this.pc.addResultSet("ResultSet " + this.curName + ";");
            }
        }
        if ((tk = this.getSqlToken()).getWord().equals("SENSITIVE") || tk.getWord().equals("INSENSITIVE")) {
            this.cursorType = tk.getWord().equals("SENSITIVE") ? 2 : 3;
            tk = this.getSqlToken();
        }
        if (tk.getToknum() == 706) {
            tk = this.getSqlToken();
        }
        if (tk.getToknum() == 386) {
            boolean with = false;
            while (tk != null && ((tk = this.getSqlToken()).getToknum() == 813 || tk.getWord().equals("WITHOUT"))) {
                if (tk.getToknum() == 813) {
                    with = true;
                }
                if ((tk = this.getSqlToken()).getToknum() == 596 && with) {
                    this.holdOption = 2;
                    tk = this.getSqlToken();
                    if (tk.getToknum() == 10009 || tk.getWord().equals("HOLD")) continue;
                    throw new ExpectedFoundException(tk, this.error, "'HOLD'");
                }
                if (tk.getWord().equals("HOLD")) {
                    if (with) {
                        this.holdOption = 1;
                        continue;
                    }
                    this.holdOption = 2;
                    continue;
                }
                if (tk.getWord().equals("ROWSET")) {
                    if (with) {
                        this.rowset = true;
                    }
                    if ((tk = this.getSqlToken()).getToknum() == 10009 || tk.getWord().equals("POSITIONING")) continue;
                    throw new ExpectedFoundException(tk, this.error, "'POSITIONING'");
                }
                if (tk.getToknum() != 693 || !with) continue;
                tk = this.getSqlToken();
                if (tk.getToknum() == 773) {
                    tk = this.getSqlToken();
                    if (!tk.getWord().equals("CLIENT") && !tk.getWord().equals("CALLER")) {
                        throw new ExpectedFoundException(tk, this.error, "'CLIENT/CALLER'");
                    }
                } else {
                    this.ungetSqlToken();
                }
                this.withReturn = ++this.pc.sqlDeclareCursorProg;
            }
            this.init(tk);
            return;
        }
        if (tk.getToknum() == 756) {
            tk = this.getSqlToken();
            if (tk.getToknum() != 40) throw new ExpectedFoundException(tk, this.error, "'('");
            int openPar = 0;
            do {
                if (tk.getToknum() == 40) {
                    ++openPar;
                    continue;
                }
                if (tk.getToknum() == 41) {
                    --openPar;
                    continue;
                }
                if (tk.getToknum() != 432) continue;
                this.ungetAllSqlToken();
                return;
            } while (openPar > 0 && (tk = this.getSqlToken()) != null);
            return;
        }
        if (tk.getWord().equalsIgnoreCase("STATEMENT")) return;
        throw new ExpectedFoundException(tk, this.error, "'CURSOR'");
    }

    public SqlDeclareCursor(VariableName vn, ExecSql es, Token kw, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(es, kw, null, p, t, err, false);
        this.cursHndl = vn;
        this.init(this.getSqlToken());
    }

    private void init(Token tk) throws GeneralErrorException, EndOfProgramException {
        if (tk.getToknum() == 494) {
            tk = this.getSqlToken();
            if (tk.getToknum() == 712) {
                this.sel = new SqlSelect(this.exec, tk, null, this.pc, this.tm, null, 0, this.error, false);
                tk = this.getSqlToken();
                if (tk.getToknum() == 494) {
                    tk = this.getSqlToken();
                    if (tk.getToknum() == 793) {
                        this.forUpdate = true;
                        tk = this.getSqlToken();
                    } else {
                        throw new ExpectedFoundException(tk, this.error, "'UPDATE'");
                    }
                }
                if (tk.getWord().equalsIgnoreCase("ORDER")) {
                    while ((tk = this.getSqlToken()).getToknum() != 432) {
                        this.sel.addToken(tk);
                    }
                    this.ungetAllSqlToken();
                } else {
                    this.ungetAllSqlToken();
                }
            } else if (tk.getToknum() == 813) {
                this.withStat = "WITH";
                tk = this.getSqlToken();
                this.withStat = this.withStat + " " + tk.getWord();
                tk = this.getSqlToken();
                if (tk.getToknum() == 280) {
                    this.withStat = this.withStat + " " + tk.getWord();
                    tk = this.getSqlToken();
                }
                if (tk.getToknum() == 40) {
                    this.withStat = this.withStat + " " + tk.getWord();
                    tk = this.getSqlToken();
                    this.selWith = new SqlSelect(this.exec, tk, null, this.pc, this.tm, null, 0, this.error, false, 41);
                    tk = this.getSqlToken();
                }
                this.sel = new SqlSelect(this.exec, tk, null, this.pc, this.tm, null, 0, this.error, false);
                tk = this.getSqlToken();
                if (tk.getToknum() == 494) {
                    tk = this.getSqlToken();
                    if (tk.getToknum() == 793) {
                        this.forUpdate = true;
                        tk = this.getSqlToken();
                    } else {
                        throw new ExpectedFoundException(tk, this.error, "'UPDATE'");
                    }
                }
                if (tk.getWord().equalsIgnoreCase("ORDER")) {
                    while ((tk = this.getSqlToken()).getToknum() != 432) {
                        this.sel.addToken(tk);
                    }
                    this.ungetAllSqlToken();
                } else {
                    this.ungetAllSqlToken();
                }
            } else if (tk.getToknum() == 313) {
                this.call = new SqlCall(this.exec, tk, null, this.pc, this.tm, this.error, null);
            } else if (tk.getToknum() == 58) {
                this.prepHndl = this.getHostVariable();
                if (this.prepHndl.getVarDecl().getHandleType() == 0) {
                    throw new GeneralErrorException(11, 4, this.prepHndl.getNameToken(), this.prepHndl.getName(), this.error);
                }
            } else {
                this.prepStat = tk.getWord();
            }
        } else {
            throw new ExpectedFoundException(tk, this.error, "'FOR'");
        }
        if (this.curName != null && !this.pc.addSqlCursor(this)) {
            throw new GeneralErrorException(137, 4, tk, this.getName(), this.error);
        }
        this.createCursHndl(this.pc);
    }

    public String getName() {
        return this.curName;
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.selWith != null) {
            this.selWith.check();
        }
        if (this.sel != null) {
            this.sel.check(true);
        } else if (this.call != null) {
            this.call.check();
        }
    }

    @Override
    public String getCode() {
        if (this.prepStat != null && sqlDescribeOracle.contains(this.prepStat)) {
            StringBuffer Return2 = new StringBuffer();
            this.getCodeGeneric(this.pc, Return2, this.curName, this.prepStat, null, false, null, null, null, null);
            return Return2.toString();
        }
        if (this.prepStat != null || this.prepHndl != null) {
            this.setSqljStatFalse();
        }
        return "";
    }

    public String getCode(Pcc ppcc, Block par) {
        this.parent = par;
        StringBuffer Return2 = new StringBuffer();
        boolean bigOpt = ppcc.getSplitFlag();
        if (this.declareCursorMethodName == null) {
            this.declareCursorMethodName = "EXEC_SQL_DECLARE_CURSOR$$" + ppcc.sqlCursorMethodsCode.size();
            StringBuffer buf = new StringBuffer();
            buf.append("   ");
            if (!bigOpt) {
                buf.append("private ");
            }
            buf.append("final int ");
            buf.append(this.declareCursorMethodName);
            buf.append("()");
            ProcedureDivision procedure = ppcc.getProcedureDivision();
            if (procedure.raising != null) {
                procedure.getThrows(buf);
                buf.append(", GotoException {");
            } else {
                buf.append(" throws GotoException {");
            }
            buf.append(eol);
            if (this.selWith != null) {
                this.sel.parent = par;
                this.sel.pc = ppcc;
                this.sel.cursHndl = this.cursHndl;
                this.sel.setCursorType(this.cursorType);
                this.sel.getCodeWith(buf, this.curName, false, this.holdOption, this.currentOf, this.selWith, this.withStat);
            } else if (this.sel != null) {
                this.sel.parent = par;
                this.sel.pc = ppcc;
                this.sel.cursHndl = this.cursHndl;
                this.sel.setCursorType(this.cursorType);
                this.sel.setWithReturn(this.withReturn);
                this.sel.getCode(buf, this.curName, false, this.holdOption, this.currentOf);
            } else if (this.call != null) {
                this.call.parent = par;
                this.call.pc = ppcc;
                this.call.cursHndl = this.cursHndl;
                buf.append(this.call.getCode(false));
            } else {
                this.getCodeGeneric(ppcc, buf, this.curName, this.prepStat, this.prepHndl, false, null, null, null, null, this.holdOption, this.currentOf, this.cursorType, this.withReturn, null);
            }
            buf.append("      return 0;");
            buf.append(eol);
            buf.append("   }");
            buf.append(eol);
            ppcc.sqlCursorMethodsCode.add(buf);
        }
        String varname = "declare_cursor_ret$" + SqlDeclareCursor.getUniqueId();
        Return2.append("int " + varname + ";");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        Return2.append("if((" + varname + "=");
        if (bigOpt) {
            if (this.pc instanceof CobolMethod) {
                Return2.append("$$theMethod$$.");
            } else {
                Return2.append("$$theProgram$$.");
            }
        }
        Return2.append(this.declareCursorMethodName + "()) > 0)");
        Return2.append(eol);
        Return2.append(this.parent.getIndent());
        Return2.append("   return " + varname + ";");
        Return2.append(eol);
        return Return2.toString();
    }

    public void setCurrentOf() {
        this.currentOf = true;
    }

    public void setCurrentOf(Vector nameCols) {
        this.currentOf = true;
        if (this.sel != null) {
            String intQuery = this.sel.getQuery();
            String queryFun = intQuery.replace(".", " ").replace(":", " ").replace(",", " ").toUpperCase();
            queryFun = queryFun.substring(0, queryFun.indexOf(" FROM "));
            String toAdd = "";
            String colName = "";
            for (int i = 0; i < nameCols.size(); ++i) {
                colName = " " + ((Token)nameCols.elementAt(i)).getWord().toUpperCase() + " ";
                if (queryFun.contains(colName)) continue;
                toAdd = toAdd + "," + colName;
            }
            if (toAdd.length() > 0) {
                queryFun = intQuery.substring(0, intQuery.indexOf(" FROM ")) + toAdd + intQuery.substring(intQuery.indexOf(" FROM "));
                this.sel.resetQuery();
                this.sel.addToQuery(queryFun);
            }
        }
    }

    public boolean getCurrentOf() {
        return this.currentOf;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public int getHold() {
        return this.holdOption;
    }

    public SqlSelect getSelect() {
        return this.sel;
    }

    public VariableName getPrepHndl() {
        return this.prepHndl;
    }

    public String getPrepStat() {
        return this.prepStat;
    }

    public boolean isRowset() {
        return this.rowset;
    }

    public String getIterName() {
        if (this.sel != null) {
            return this.sel.getIterName();
        }
        return this.iterator;
    }

    public void setSqljStatFalse() {
        this.isSqljStat = false;
        if (this.sel != null) {
            this.sel.isSqljStat = false;
        }
    }
}

