/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Alphabet;
import com.iscobol.compiler.ClauseClashException;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ConfigurationSection;
import com.iscobol.compiler.EfdHint;
import com.iscobol.compiler.EfdParser;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.EnvironmentDivision;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Key;
import com.iscobol.compiler.KeyList;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SpecialNames;
import com.iscobol.compiler.StringList;
import com.iscobol.compiler.SyntaxErrorException;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.ISelectExtension;
import com.iscobol.interfaces.compiler.IToken;
import com.iscobol.interfaces.compiler.IVariableName;
import com.iscobol.rts.Config;
import java.io.File;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;

public class Select
implements CobolToken,
ErrorsNumbers,
ISelectExtension {
    private Pcc pc;
    private TokenManager tm;
    private Token device;
    private Token opSysName;
    private VariableName opSysNameVar;
    private Token memLengthTk;
    private VariableName memLengthVar;
    private EfdParser efdExtraInfo;
    private StringList efdKeysParts;
    private String efdName;
    private Token paddingChar;
    private VariableName paddingCharVar;
    private Errors error;
    private int lockMode = 290;
    private boolean isLockSet;
    private boolean recordDelimiterStd1;
    private int reserveArea = 0;
    private boolean optional;
    private boolean line;
    private boolean flsu;
    private boolean massUpdate;
    private boolean rollback;
    private boolean multipleRecords;
    private boolean explicitBinary;
    private boolean trailingSpaces = false;
    private FileDescriptor fd;
    private VariableName fileStatus;
    private VariableName fileStatus2;
    private Token collating;
    private Alphabet alphabet;
    private Key recordKey;
    private KeyList altKeys;
    private boolean isExternal;
    private Token classToken;
    private VariableName classVar;
    private VariableName addressVar;
    private Select sameRecordAreaOf;
    private Vector masterRecordAreaFor;
    private final Token keyWord;
    private boolean compression;
    private boolean encryption;
    private int comprCntrlValue = 1;
    final Token fileName;
    VariableName relativeKey;
    int organization = 717;
    int accessMode = 717;
    VariableName useGiving;
    boolean isPrinter;
    Token isPrinterTok = null;
    boolean writeSimple = false;
    private boolean sort;
    private boolean assignExt;
    boolean hasBefore;
    private boolean xmlLineFeed = true;
    private boolean xml;
    private Token xmlDocTypeTk;
    private VariableName xmlDocTypeVn;
    private boolean xmlCheckValidityI;
    private boolean xmlCheckValidityO;

    void setExternal(boolean x) {
        this.isExternal = x;
    }

    @Override
    public boolean isSort() {
        return this.sort;
    }

    public boolean isXml() {
        return this.xml;
    }

    @Override
    public boolean isLine() {
        return this.line;
    }

    boolean allowsOpenIO() {
        return !(this.isPrinter && this.pc.options.getOption("-cm") == null || this.line && this.flsu);
    }

    boolean allowsDelete() {
        return !this.isPrinter && !this.line;
    }

    void check(Pcc pc) throws GeneralErrorException {
        Key k;
        VariableDeclaration vd;
        if (pc.data != null && pc.data.fileSec != null && (this.fd = pc.data.fileSec.getFD(this.fileName.getWord())) != null) {
            if (!(this.isExternal || pc instanceof CobolMethod || this.fd.threadLocal)) {
                pc.addFinalizeCode("   " + this.getName() + ".finalize();" + eol);
            }
        } else {
            throw new GeneralErrorException(51, 4, this.fileName, this.fileName.getWord(), this.error);
        }
        this.sort = this.fd.isSort();
        if (this.addressVar != null) {
            this.addressVar.check(pc);
        }
        if (this.xmlDocTypeVn != null) {
            this.xmlDocTypeVn.check(pc);
        }
        if (this.classVar != null) {
            this.classVar.check(pc);
        }
        if (this.opSysNameVar != null) {
            if (pc.getAny(this.opSysNameVar, true, true) == null) {
                vd = VariableDeclaration.getPicX(pc, this.tm, this.opSysName, 256, null);
                pc.fixedVars.addItem(vd);
                pc.loadVariable(vd);
                vd.setUsed();
            }
            this.opSysNameVar.check(pc);
            if (!(this.memLengthTk == null || this.xml && (this.opSysNameVar.getVarDecl().isPointer() || this.opSysNameVar.getVarDecl().isHandle()))) {
                throw new GeneralErrorException(29, 4, this.memLengthTk, this.memLengthTk.getWord(), this.error);
            }
            if (this.memLengthVar != null) {
                this.memLengthVar.check(pc);
            }
        }
        if (this.organization == 677) {
            if (this.relativeKey == null) {
                if (this.accessMode != 717) {
                    throw new GeneralErrorException(57, 4, this.fileName, this.fileName.getWord(), this.error);
                }
            } else {
                this.relativeKey.check(pc);
                if (!this.relativeKey.getVarDecl().isInteger()) {
                    throw new GeneralErrorException(56, 4, this.fileName, this.relativeKey.getName(), this.error);
                }
            }
        }
        if (this.paddingCharVar != null) {
            this.paddingCharVar.check(pc);
        }
        if (this.fileStatus != null) {
            this.fileStatus.check(pc);
            vd = this.fileStatus.getVarDecl();
            if (this.xml) {
                if (!vd.isNumeric() || vd.isEdited() || !vd.isSigned()) {
                    throw new GeneralErrorException(284, 4, this.fileStatus.name, this.fileStatus.name.getWord(), this.error);
                }
            } else if (vd.isNumeric() && this.tm.getOptionList().getOption("-cv") == null || vd.isEdited || vd.phisicLen != 2) {
                throw new GeneralErrorException(52, 4, this.fileStatus.name, this.fileStatus.name.getWord(), this.error);
            }
        }
        if (this.fileStatus2 != null) {
            this.fileStatus2.check(pc);
        }
        if (this.recordKey != null) {
            this.recordKey.check(pc, this.fd.getVirtualParent());
            if (this.altKeys != null) {
                k = this.altKeys.getFirst();
                while (k != null) {
                    k.check(pc, this.fd.getVirtualParent());
                    k = this.altKeys.getNext();
                }
            }
        }
        if (this.fd.hasLinage()) {
            this.isPrinter = true;
        }
        if (this.collating != null) {
            SpecialNames sn;
            ConfigurationSection c;
            EnvironmentDivision e = pc.getEnvironmentDivision();
            if (e != null && (c = e.getConfigurationSection()) != null && (sn = c.getSpecialNames()) != null) {
                this.alphabet = sn.getAlphabet(this.collating);
            }
            if (this.alphabet == null) {
                throw new GeneralErrorException(25, 4, this.fileName, "ALPHABET " + this.collating.getWord(), this.error);
            }
        }
        if ((k = this.checkAltKeys()) != null) {
            throw new GeneralErrorException(210, 2, this.fileName, k.keyName.getName(), this.error);
        }
    }

    public VariableDeclaration[] getPrimaryKey() {
        if (this.recordKey != null) {
            return this.recordKey.getVars();
        }
        return null;
    }

    VariableDeclaration[] getKeyByOffset(int offset) {
        VariableDeclaration[] Return2;
        if (this.recordKey != null && (Return2 = this.recordKey.getVars()) != null && Return2[0] != null && Return2[0].getOffset() == offset) {
            return Return2;
        }
        if (this.altKeys != null) {
            Key k = this.altKeys.getFirst();
            while (k != null) {
                Return2 = k.getVars();
                if (Return2 != null && Return2[0] != null && Return2[0].getOffset() == offset) {
                    return Return2;
                }
                k = this.altKeys.getNext();
            }
        }
        return null;
    }

    VariableDeclaration[] getKeyByName(String name) {
        if (this.recordKey != null && name.equals(this.recordKey.keyName.name.getWord())) {
            return this.recordKey.getVars();
        }
        if (this.altKeys != null) {
            Key k = this.altKeys.getFirst();
            while (k != null) {
                if (name.equals(k.keyName.name.getWord())) {
                    return k.getVars();
                }
                k = this.altKeys.getNext();
            }
        }
        return null;
    }

    String getKeysPartsByName(String name) {
        String part = null;
        part = this.efdKeysParts.getFirst();
        while (part != null) {
            if (name.equalsIgnoreCase(part)) {
                return part;
            }
            part = this.efdKeysParts.getNext();
        }
        return null;
    }

    public String getEfdCobTrigger() {
        String Return2 = this.efdExtraInfo != null ? this.efdExtraInfo.getCobtrigger() : null;
        return Return2;
    }

    public String getEfdName() {
        if (this.efdName == null) {
            this.efdName = this.fd.getEfdName();
            if (this.opSysNameVar != null && this.efdName == null) {
                this.error.print(119, 2, this.fd.fileName, "SELECT");
            }
            if (this.efdName == null) {
                this.efdName = this.opSysNameVar != null ? this.opSysNameVar.getName().replace('-', '_').replace('.', '_').toLowerCase(Locale.US) : (this.opSysName != null ? this.opSysName.getCode().replace('-', '_').replace('.', '_').toLowerCase(Locale.US) : this.fd.fileName.getCode().replace('-', '_').replace('.', '_').toLowerCase(Locale.US));
            }
            File f = new File(this.efdName);
            this.efdName = f.getName();
        }
        return this.efdName;
    }

    @Override
    public String getName() {
        String s = "";
        if (this.fd != null && this.fd.threadLocal) {
            s = s + "$my_thloc_stg$.";
        }
        s = s + this.getBaseName();
        return s;
    }

    String getBaseName() {
        return "file$" + this.fileName.getWord().replace('-', Pcc.hyphenRepl);
    }

    @Override
    public String getMemBufName() {
        return this.getBaseName() + "$0";
    }

    private void addKey(StringBuffer buff, Key k) {
        VariableDeclaration[] vda = k.getVars();
        int i = 0;
        while (true) {
            buff.append(vda[i].getUnivoqueName());
            if (++i >= vda.length) break;
            buff.append(",");
        }
    }

    private static void addToVec(Vector vdv, VariableDeclaration vd) {
        boolean haveChild = false;
        if (vd != null && vd.children.getItemNum() > 0) {
            haveChild = true;
            int child7888 = 0;
            VariableDeclaration vdn = vd.children.getFirst();
            while (vdn != null) {
                if (vdn.level == 88 || vdn.level == 78) {
                    ++child7888;
                }
                vdn = vd.children.getNext();
            }
            if (vd.children.getItemNum() == child7888) {
                haveChild = false;
            }
        }
        if (vd != null) {
            if (!haveChild) {
                vdv.addElement(vd);
            } else {
                VariableDeclaration v = vd.children.getFirst();
                while (v != null) {
                    Select.addToVec(vdv, v);
                    v = vd.children.getNext();
                }
            }
        }
    }

    VariableDeclaration[] getAllKeyFields() {
        VariableDeclaration[] Return2 = new VariableDeclaration[]{};
        if (this.organization == 529) {
            int i;
            Vector vdv = new Vector();
            VariableDeclaration[] vda = this.recordKey.getVars();
            for (i = 0; i < vda.length; ++i) {
                Select.addToVec(vdv, vda[i]);
            }
            if (this.altKeys != null) {
                Key k = this.altKeys.getFirst();
                while (k != null) {
                    vda = k.getVars();
                    for (i = 0; i < vda.length; ++i) {
                        Select.addToVec(vdv, vda[i]);
                    }
                    k = this.altKeys.getNext();
                }
            }
            Return2 = new VariableDeclaration[vdv.size()];
            for (i = 0; i < Return2.length; ++i) {
                Return2[i] = (VariableDeclaration)vdv.elementAt(i);
            }
        }
        return Return2;
    }

    private void addEfdKey(StringBuffer buff, Key k, int numIdx, String eol) throws GeneralErrorException {
        VariableDeclaration[] vda = k.getVars();
        boolean part = true;
        int i = 0;
        Vector hints = this.fd.getHints();
        buff.append(" <key segCount='");
        buff.append(vda.length);
        buff.append("' duplicate='");
        buff.append(k.duplicates);
        buff.append("'>");
        buff.append(eol);
        if (hints != null) {
            Enumeration en = hints.elements();
            while (en.hasMoreElements()) {
                EfdHint eh = (EfdHint)en.nextElement();
                if (numIdx != eh.getIdx()) continue;
                buff.append(" <hint ");
                if (eh.getString() != null) {
                    buff.append("string='");
                    buff.append(eh.getString());
                } else {
                    buff.append("idx='");
                    buff.append(eh.getNumber());
                }
                buff.append("'/>");
                buff.append(eol);
            }
        }
        for (i = 0; i < vda.length; ++i) {
            buff.append("  <segment offset='");
            buff.append(vda[i].getOffset());
            buff.append("' size='");
            buff.append(vda[i].getPhisicLen());
            buff.append("'/>");
            buff.append(eol);
        }
        for (i = 0; i < vda.length; ++i) {
            if (vda[i].getEfdKeyCode(buff, eol, vda, this.efdKeysParts)) continue;
            part = false;
        }
        if (!part) {
            if (this.pc.isEasyDBActivated()) {
                throw new GeneralErrorException(245, 4, this.fileName, this.fileName.getWord(), this.error);
            }
            buff.append("<part name='!!!!Error in FD'/>" + eol);
        }
        buff.append(" </key>");
        buff.append(eol);
    }

    private void addEfcKey(StringBuffer buff, Key k, String eol) {
        VariableDeclaration[] vda = k.getVars();
        boolean part = true;
        int i = 0;
        buff.append(" <key segCount='");
        buff.append(vda.length);
        buff.append("' duplicate='");
        buff.append(k.duplicates);
        buff.append("'>");
        buff.append(eol);
        for (i = 0; i < vda.length; ++i) {
            buff.append("  <segment offset='");
            buff.append(vda[i].getOffset());
            buff.append("' size='");
            buff.append(vda[i].getPhisicLen());
            buff.append("'/>");
            buff.append(eol);
        }
        for (i = 0; i < vda.length; ++i) {
            if (vda[i].getEfcKeyCode(buff, eol, true)) continue;
            part = false;
        }
        if (!part) {
            buff.append("<part name='!!!!Error in FD'/>" + eol);
        }
        buff.append(" </key>");
        buff.append(eol);
    }

    @Override
    public boolean hasLinage() {
        return this.fd != null && this.fd.hasLinage();
    }

    public String getCode(StringBuffer dynPart) {
        String code = this.fd.isSort() ? this.getCodeSort(dynPart) : (this.xml ? this.getCodeXml(dynPart) : this.getCodeFile(dynPart));
        if (this.keyWord != null) {
            code = this.tm.getCommentCode(this.keyWord, "   ") + code;
        }
        return code;
    }

    public String getCodeSort(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("/* [SELECT] */" + eol);
        Return2.append("   CobolSort ");
        String n = this.getBaseName();
        Return2.append(n);
        Return2.append(";");
        Return2.append(eol);
        dynPart.append(n);
        dynPart.append("=Factory.getSort (");
        dynPart.append("\"");
        dynPart.append(this.fileName.getWord());
        dynPart.append("\",");
        if (this.opSysNameVar != null) {
            dynPart.append(this.opSysNameVar.getCode());
        } else {
            dynPart.append(this.tm.getCodeLiteral(this.opSysName));
        }
        dynPart.append(",");
        if (this.pc.optionMS) {
            dynPart.append(this.fd.getVirtualParent().getUnivoqueName());
        } else {
            dynPart.append(this.fd.getVirtualParent().getDeclUnivoqueName());
        }
        dynPart.append(",");
        dynPart.append(this.fd.recordMin);
        if (this.sort) {
            dynPart.append(",");
            if (this.fileStatus != null) {
                dynPart.append(this.fileStatus.getCode());
            } else {
                dynPart.append("null");
            }
        }
        dynPart.append(")");
        if (this.alphabet != null) {
            dynPart.append(".collatingSequence (");
            dynPart.append(this.alphabet.getDeclUnivoqueNameBytes());
            dynPart.append(")");
        }
        dynPart.append(";");
        dynPart.append(eol);
        return Return2.toString();
    }

    public String getEfdCode() throws GeneralErrorException {
        StringBuffer Return2 = new StringBuffer();
        if (this.efdExtraInfo != null && this.efdExtraInfo.getComment() != null) {
            Return2.append(this.efdExtraInfo.getXmlComment() + eol);
        }
        Return2.append("<table name='");
        Return2.append(this.getEfdName());
        Return2.append("' type='");
        switch (this.organization) {
            case 529: {
                Return2.append("idx");
                break;
            }
            case 677: {
                Return2.append("rel");
                break;
            }
            default: {
                Return2.append("seq");
            }
        }
        int maxRecLen = this.fd.getMaxRecLen();
        Return2.append("' maxRecLen='");
        Return2.append(maxRecLen);
        Return2.append("' minRecLen='");
        if (this.tm.getOptionList().getOption("-crv") != null) {
            Return2.append(this.fd.getMinRecLen(maxRecLen));
        } else if (this.fd.recordMin == 0) {
            Return2.append(maxRecLen);
        } else {
            Return2.append(this.fd.recordMin);
        }
        if (this.efdExtraInfo != null && this.efdExtraInfo.isTemporary()) {
            Return2.append("' temporary='" + this.efdExtraInfo.getTemporaryType());
        } else if (this.fd != null && this.fd.getEfdTemporaryType() != null) {
            Return2.append("' temporary='" + this.fd.getEfdTemporaryType());
        }
        if (this.organization == 529) {
            Return2.append("' keyCount='");
            if (this.altKeys != null) {
                Return2.append("" + (this.altKeys.getItemNum() + 1));
            } else {
                Return2.append("1");
            }
            Return2.append("'>");
            Return2.append(eol);
            int i = 1;
            this.efdKeysParts = new StringList();
            this.addEfdKey(Return2, this.recordKey, i, eol);
            if (this.altKeys != null) {
                Key k = this.altKeys.getFirst();
                while (k != null) {
                    this.addEfdKey(Return2, k, ++i, eol);
                    k = this.altKeys.getNext();
                }
            }
        } else {
            Return2.append("'>");
        }
        this.fd.getEfdCode(Return2, eol, "");
        Return2.append("</table>");
        Return2.append(eol);
        return Return2.toString();
    }

    public String getEfcCode() {
        StringBuffer Return2 = new StringBuffer();
        if (this.efdExtraInfo != null && this.efdExtraInfo.getComment() != null) {
            Return2.append(this.efdExtraInfo.getXmlComment() + eol);
        }
        Return2.append("<table name='");
        Return2.append(this.getEfdName());
        int maxRecLen = this.fd.getMaxRecLen();
        Return2.append("' maxRecLen='");
        Return2.append(maxRecLen);
        Return2.append("' minRecLen='");
        if (this.tm.getOptionList().getOption("-crv") != null) {
            Return2.append(this.fd.getMinRecLen(maxRecLen));
        } else if (this.fd.recordMin == 0) {
            Return2.append(maxRecLen);
        } else {
            Return2.append(this.fd.recordMin);
        }
        Return2.append("'");
        if (this.pc.options.getOption("-dca") != null) {
            Return2.append(" dataConvention=\"-dca\"");
        } else if (this.pc.options.getOption("-dcd") != null) {
            Return2.append(" dataConvention=\"-dcd\"");
        } else if (this.pc.options.getOption("-dcm") != null) {
            Return2.append(" dataConvention=\"-dcm\"");
        } else if (this.pc.options.getOption("-dcmi") != null) {
            Return2.append(" dataConvention=\"-dcmi\"");
        }
        Return2.append(">");
        Return2.append(eol);
        if (this.organization == 529) {
            this.addEfcKey(Return2, this.recordKey, eol);
            if (this.altKeys != null) {
                Key k = this.altKeys.getFirst();
                while (k != null) {
                    this.addEfcKey(Return2, k, eol);
                    k = this.altKeys.getNext();
                }
            }
        }
        this.fd.getEfcCode(Return2, eol, "");
        Return2.append("</table>");
        Return2.append(eol);
        return Return2.toString();
    }

    public String getCodeXml(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("/* [SELECT] */" + eol);
        Return2.append("   ");
        if (this.pc.isFactory()) {
            Return2.append("static ");
        }
        Return2.append("XmlFile ");
        String n = this.getBaseName();
        Return2.append(n);
        Return2.append(";");
        Return2.append(eol);
        dynPart.append(n);
        dynPart.append("=");
        dynPart.append("Factory.getFileXml");
        dynPart.append(" (");
        dynPart.append("\"");
        dynPart.append(this.fileName.getWord());
        dynPart.append("\",");
        if (this.pc.optionMS) {
            dynPart.append(this.fd.getFirstRecord().getUnivoqueName());
        } else {
            dynPart.append(this.fd.getFirstRecord().getDeclUnivoqueName());
        }
        dynPart.append(",");
        if (this.addressVar != null) {
            dynPart.append(this.addressVar.getCode());
        } else if (this.memLengthVar != null) {
            if (this.pc.getOption("-cp") != null) {
                dynPart.append("new PicX(");
                dynPart.append(this.opSysNameVar.getCode());
                dynPart.append(".getAddress(), ");
                dynPart.append(this.memLengthVar.getCode());
                dynPart.append(".toint())");
            } else {
                dynPart.append("((CobolVar) ");
                dynPart.append(this.opSysNameVar.getCode());
                dynPart.append(".getId()).sub(1, ");
                dynPart.append(this.memLengthVar.getCode());
                dynPart.append(".toint())");
            }
        } else {
            dynPart.append("null");
        }
        dynPart.append(",");
        dynPart.append(this.xmlLineFeed);
        dynPart.append(",");
        if (this.xmlDocTypeTk != null) {
            dynPart.append(this.tm.getCodeLiteral(this.xmlDocTypeTk));
        } else if (this.xmlDocTypeVn != null) {
            dynPart.append(this.xmlDocTypeVn.getCode());
        } else {
            dynPart.append("null");
        }
        dynPart.append(");");
        dynPart.append(eol);
        return Return2.toString();
    }

    public String getCodeFile(StringBuffer dynPart) {
        Alphabet cs;
        StringBuffer Return2 = new StringBuffer();
        Return2.append("/* [SELECT] */" + eol);
        if (this.pc.isFactory()) {
            Return2.append("   static CobolFile ");
        } else {
            Return2.append("   CobolFile ");
        }
        String n = this.getBaseName();
        Return2.append(n);
        Return2.append(";");
        Return2.append(eol);
        dynPart.append(n);
        dynPart.append("=");
        if (this.classToken != null || this.classVar != null) {
            dynPart.append("Factory.getFileGeneric");
        } else if (this.organization == 677) {
            dynPart.append("Factory.getFileRelative");
        } else if (this.organization == 529) {
            dynPart.append("Factory.getFileIndexed");
        } else if (this.isPrinter) {
            if (this.tm.getOptionList().getOption("-cm") != null) {
                dynPart.append("Factory.getFilePrinterMF");
            } else {
                dynPart.append("Factory.getFilePrinter");
            }
        } else if (this.addressVar != null) {
            dynPart.append("Factory.getFileString");
        } else if (this.line) {
            if (this.flsu) {
                dynPart.append("Factory.getFileLineSeq");
            } else {
                dynPart.append("Factory.getFileLineSeq8bit");
            }
        } else {
            dynPart.append("Factory.getFileSequential");
        }
        if (this.isExternal) {
            dynPart.append("Ext");
        }
        dynPart.append(" (");
        dynPart.append("\"");
        dynPart.append(this.fileName.getWord());
        dynPart.append("\",");
        dynPart.append(this.fd.getMaxRecLen());
        dynPart.append(",");
        if (this.pc.optionMS) {
            dynPart.append(this.fd.getFirstRecord().getUnivoqueName());
        } else {
            dynPart.append(this.fd.getFirstRecord().getDeclUnivoqueName());
        }
        dynPart.append(",");
        dynPart.append(this.fd.recordMin);
        if (this.sort) {
            dynPart.append(",");
            if (this.fileStatus != null) {
                dynPart.append(this.fileStatus.getCode());
            } else {
                dynPart.append("null");
            }
        }
        dynPart.append(",");
        dynPart.append(this.optional);
        if (this.addressVar != null) {
            dynPart.append(",");
            dynPart.append(this.addressVar.getCode());
            dynPart.append(",");
            if (this.line) {
                dynPart.append("true");
            } else {
                dynPart.append("false");
            }
        }
        if (this.organization == 677 || this.organization == 529) {
            if (this.accessMode == 414) {
                dynPart.append(",CobolFile.ACCESS_DYNAMIC");
            } else if (this.accessMode == 664) {
                dynPart.append(",CobolFile.ACCESS_RANDOM");
            } else {
                dynPart.append(",CobolFile.ACCESS_SEQUENTIAL");
            }
        } else if (this.classToken != null || this.classVar != null) {
            dynPart.append(",CobolFile.ACCESS_SEQUENTIAL");
        }
        if (this.classToken != null || this.classVar != null) {
            if (this.organization == 677) {
                dynPart.append("|CobolFile.ORG_RELATIVE");
            } else if (this.organization == 529) {
                dynPart.append("|CobolFile.ORG_INDEXED");
            } else if (this.line) {
                dynPart.append("|CobolFile.ORG_LINE_SEQUENTIAL");
            } else {
                dynPart.append("|CobolFile.ORG_SEQUENTIAL");
            }
            dynPart.append(",");
            if (this.classVar != null) {
                dynPart.append(this.classVar.getCode());
            } else {
                dynPart.append(this.tm.getCodeLiteral(this.classToken));
            }
        }
        dynPart.append(")");
        if (this.organization == 529) {
            dynPart.append(".key(new CobolVar[] {");
            this.addKey(dynPart, this.recordKey);
            dynPart.append("},");
            dynPart.append(this.recordKey.duplicates);
            dynPart.append(")");
            if (this.altKeys != null) {
                Key k = this.altKeys.getFirst();
                while (k != null) {
                    dynPart.append(".key(new CobolVar[] {");
                    this.addKey(dynPart, k);
                    dynPart.append("},");
                    dynPart.append(k.duplicates);
                    dynPart.append(")");
                    k = this.altKeys.getNext();
                }
            }
            if (this.alphabet != null) {
                dynPart.append(".collatingSequence (");
                dynPart.append(this.alphabet.getDeclUnivoqueNameBytes());
                dynPart.append(")");
            }
        } else if (this.organization == 677 && this.relativeKey != null) {
            dynPart.append(".relativeKey (");
            if (this.fd.threadLocal) {
                this.relativeKey.getVarDecl().noCobolClassPfx = true;
                dynPart.append(this.relativeKey.getCode());
                this.relativeKey.getVarDecl().noCobolClassPfx = false;
            } else {
                dynPart.append(this.relativeKey.getCode());
            }
            dynPart.append(")");
        }
        if (this.fd.hasLinage()) {
            dynPart.append(".");
            this.fd.getLinageCode(dynPart);
        }
        if (this.assignExt) {
            dynPart.append(".setAssignExt(true)");
        }
        if ((cs = this.fd.getCodeSet()) != null) {
            dynPart.append(".setCodeSet(");
            dynPart.append(cs.getDeclUnivoqueNameBytes());
            dynPart.append(")");
        }
        dynPart.append(";");
        dynPart.append(eol);
        if (this.isCompressed()) {
            dynPart.append(n);
            dynPart.append(".setCompressionFactor(" + this.getCompressionFactor() + ");");
            dynPart.append(eol);
        }
        if (this.trailingSpaces && !this.isPrinter) {
            if (this.flsu) {
                dynPart.append("((LineSeqFile)");
            } else {
                dynPart.append("((LineSequentialDFile)");
            }
            dynPart.append(n);
            dynPart.append(").setTrailingSpaces();");
            dynPart.append(eol);
        }
        return Return2.toString();
    }

    public String getCodeDebug() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("/* [SELECT] */" + eol);
        Return2.append("/* fileName = [" + this.fileName.getWord() + "] */" + eol);
        Return2.append("/* optional = " + this.optional + " */" + eol);
        if (this.device != null) {
            Return2.append("/* device = [" + this.device.getWord() + "] */" + eol);
        }
        if (this.opSysName != null) {
            if (this.opSysNameVar == null) {
                Return2.append("/* opSysNam = [" + this.opSysName.getWord() + "] */" + eol);
            } else {
                Return2.append("/* opSysNam */" + eol + this.opSysNameVar.getCode());
            }
        }
        Return2.append("/* organization = " + (this.organization == 677 ? "RELATIVE */" : (this.organization == 529 ? "INDEXED */" : "SEQUENTIAL */")) + eol);
        Return2.append("/* access mode = " + (this.accessMode == 664 ? "RANDOM */" : (this.accessMode == 414 ? "DYNAMIC */" : "SEQUENTIAL */")) + eol);
        if (this.relativeKey != null) {
            Return2.append("/* relativeKey */" + eol + this.relativeKey.getCode());
        }
        if (this.recordKey != null) {
            Return2.append("/* recordKey */" + eol + this.recordKey.getCode());
        }
        if (this.altKeys != null) {
            Key k = this.altKeys.getFirst();
            while (k != null) {
                Return2.append("/* altKey */" + eol + k.getCode());
                k = this.altKeys.getNext();
            }
        }
        if (this.paddingChar != null) {
            if (this.paddingCharVar == null) {
                Return2.append("/* paddingChar = [" + this.paddingChar.getWord() + "] */" + eol);
            } else {
                Return2.append("/* paddingCharVar */" + eol + this.paddingCharVar.getCode());
            }
        }
        if (this.reserveArea > 0) {
            Return2.append("/* reserveArea = " + this.reserveArea + " */" + eol);
        }
        if (this.fileStatus != null) {
            Return2.append("/* fileStatus */" + eol + this.fileStatus.getCode());
        }
        if (this.collating != null) {
            Return2.append("/* collating = " + this.collating.getWord() + " */" + eol);
        }
        Return2.append("/* lock mode = " + (this.lockMode == 578 ? "MANUAL */" : (this.lockMode == 473 ? "EXCLUSIVE */" : (this.lockMode == 290 ? "AUTOMATIC */" : "NULL */"))) + eol);
        Return2.append("/* multipleRecords = " + this.multipleRecords + " */" + eol);
        Return2.append("/* mass-update = " + this.massUpdate + " */" + eol);
        Return2.append("/* rollback = " + this.rollback + " */" + eol);
        return Return2.toString();
    }

    @Override
    public VariableDeclaration getFirstRecord() {
        return this.fd.getFirstRecord();
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    Select() {
        this.keyWord = new Token(712, "SELECT", 0, 0, "");
        this.fileName = new Token(10009, "dummy", 0, 0, "");
    }

    public Select(Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        boolean defaultMR;
        this.tm = t;
        this.error = err;
        this.pc = p;
        boolean bl = defaultMR = this.tm.getOptionList().getOption("-fl") == null;
        if (this.tm.getOptionList().getOption("-fm") != null) {
            this.lockMode = 578;
        } else if (this.tm.getOptionList().getOption("-cm") != null) {
            this.lockMode = 0;
        } else if (this.tm.getOptionList().getOption("-ci") != null) {
            this.lockMode = 578;
            this.multipleRecords = true;
        }
        this.tm.ungetToken();
        this.keyWord = this.tm.getToken();
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 598) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 616) {
                throw new ExpectedFoundException(tk, this.error, "OPTIONAL");
            }
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 616) {
            this.optional = true;
            tk = this.tm.getToken();
        }
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.fileName = tk;
        boolean assignFound = false;
        tk = this.tm.getToken();
        while (tk.getToknum() != 10006) {
            block1 : switch (tk.getToknum()) {
                case 283: {
                    assignFound = true;
                    this.assign();
                    break;
                }
                case 257: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 587) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    switch (tk.getToknum()) {
                        case 414: 
                        case 664: 
                        case 717: {
                            this.accessMode = tk.getToknum();
                            break block1;
                        }
                    }
                    throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                }
                case 335: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 716) {
                        throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                    }
                }
                case 716: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    if ((this.collating = tk).getToknum() == 10009) break;
                    throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                }
                case 732: {
                    if (!this.sort) {
                        this.error.print(11, 4, tk, tk.getWord());
                    }
                }
                case 482: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 742) {
                        throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                    }
                }
                case 742: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 545) {
                        this.tm.ungetToken();
                    }
                    this.fileStatus = VariableName.get(this.tm, this.error);
                    if (this.fileStatus == null) {
                        throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                    }
                    if (this.tm.getOptionList().getOption("-cv") == null) break;
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.fileStatus2 = VariableName.get(this.tm, this.error);
                        if (this.fileStatus2 != null) break;
                        throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                    }
                    this.tm.ungetToken();
                    break;
                }
                case 570: {
                    this.isLockSet = true;
                    this.multipleRecords = false;
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 587) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    switch (tk.getToknum()) {
                        case 473: {
                            this.lockMode = tk.getToknum();
                            tk = this.tm.getToken();
                            if (tk.getToknum() == 813) {
                                tk = this.tm.getToken();
                            }
                            if (tk.getToknum() == 579) {
                                this.massUpdate = true;
                                break block1;
                            }
                            this.tm.ungetToken();
                            break block1;
                        }
                        case 290: 
                        case 578: {
                            this.lockMode = tk.getToknum();
                            tk = this.tm.getToken();
                            if (tk.getToknum() == 813) {
                                tk = this.tm.getToken();
                            }
                            if (tk.getToknum() == 701) {
                                this.rollback = true;
                                this.multipleRecords = defaultMR;
                                break block1;
                            }
                            if (tk.getToknum() == 570) {
                                tk = this.tm.getToken();
                            }
                            if (tk.getToknum() == 613) {
                                tk = this.tm.getToken();
                                if (tk.getToknum() == 591) {
                                    this.multipleRecords = true;
                                    defaultMR = true;
                                    tk = this.tm.getToken();
                                }
                                if (tk.getToknum() == 670 || tk.getToknum() == 672) {
                                    tk = this.tm.getToken();
                                    if (tk.getToknum() == 813) {
                                        tk = this.tm.getToken();
                                        if (tk.getToknum() != 701) {
                                            throw new UnexpectedTokenException(tk, this.error);
                                        }
                                        this.rollback = true;
                                        this.multipleRecords = defaultMR;
                                        break block1;
                                    }
                                    if (tk.getToknum() == 701) {
                                        this.rollback = true;
                                        this.multipleRecords = defaultMR;
                                        break block1;
                                    }
                                    this.tm.ungetToken();
                                    break block1;
                                }
                                if (this.multipleRecords) {
                                    this.tm.ungetToken();
                                    break block1;
                                }
                                throw new UnexpectedTokenException(tk, this.error);
                            }
                            this.tm.ungetToken();
                            break block1;
                        }
                    }
                    throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                }
                case 619: {
                    this.line = false;
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 545) {
                        this.tm.ungetToken();
                    }
                    if ((tk = this.tm.getToken()).getToknum() == 670) break;
                    this.tm.ungetToken();
                    break;
                }
                case 565: {
                    this.line = true;
                    break;
                }
                case 818: {
                    this.xml = true;
                    tk = this.tm.getToken();
                    boolean docType = false;
                    if (tk.getToknum() != 10009 || !(docType = "DOCUMENT-TYPE".equals(tk.getWord())) && !"CHECK".equals(tk.getWord())) {
                        this.tm.ungetToken();
                        break;
                    }
                    if (docType) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 545) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() != 612) {
                            if (tk.getToknum() == 478) {
                                tk = this.tm.getToken();
                            }
                            if (tk.getToknum() == 10009) {
                                this.tm.ungetToken();
                                this.xmlDocTypeVn = VariableName.get(this.tm, this.error);
                                if (this.xmlDocTypeVn == null) {
                                    tk = this.tm.getToken();
                                    throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
                                }
                            } else if (tk.getToknum() == 10001) {
                                this.xmlDocTypeTk = tk;
                            } else {
                                throw new GeneralErrorException(21, 4, tk, tk.getWord(), this.error);
                            }
                        }
                        this.xmlCheckValidity(this.tm.getToken());
                        break;
                    }
                    this.xmlCheckValidity(tk);
                    break;
                }
                case 301: {
                    this.explicitBinary = true;
                    tk = this.tm.getToken();
                    break;
                }
                case 677: {
                    if (tk.getToknum() == 677) {
                        Token ltk = this.tm.getToken();
                        if (ltk.getToknum() == 551 || ltk.getToknum() == 545 || ltk.getToknum() == 10009) {
                            tk = ltk;
                            if (tk.getToknum() == 551) {
                                tk = this.tm.getToken();
                            }
                            if (tk.getToknum() == 545) {
                                tk = this.tm.getToken();
                            }
                            this.tm.ungetToken();
                            this.relativeKey = VariableName.get(this.tm, this.error);
                            if (this.relativeKey != null) break;
                            throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
                        }
                        this.tm.ungetToken();
                    }
                }
                case 529: 
                case 717: {
                    switch (tk.getToknum()) {
                        case 529: 
                        case 677: 
                        case 717: {
                            this.organization = tk.getToknum();
                            break block1;
                        }
                    }
                    throw new SyntaxErrorException(tk, tk.getWord(), this.error);
                }
                case 813: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 354) {
                        this.compression = true;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 421) {
                            this.encryption = true;
                            break;
                        }
                        this.tm.ungetToken();
                        break;
                    }
                    if (tk.getToknum() == 421) {
                        this.encryption = true;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 354) {
                            this.compression = true;
                            break;
                        }
                        this.tm.ungetToken();
                        break;
                    }
                    throw new UnexpectedTokenException(tk, err);
                }
                case 354: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 373) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 803) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    if (!Token.isIntLit(tk)) {
                        throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        this.comprCntrlValue = Integer.parseInt(tk.getWord());
                        if (this.comprCntrlValue < 0 || this.comprCntrlValue > 100) {
                            throw new NumberFormatException();
                        }
                        break;
                    }
                    catch (NumberFormatException _ex) {
                        throw new GeneralErrorException(30, 4, tk, tk.getWord(), this.error);
                    }
                }
                case 628: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 323) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    this.paddingChar = tk;
                    if (tk.getToknum() == 10001) break;
                    if (tk.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.paddingCharVar = VariableName.get(this.tm, this.error);
                        break;
                    }
                    throw new GeneralErrorException(21, 4, tk, tk.getWord(), this.error);
                }
                case 670: 
                case 672: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 399) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 545) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() != 740) {
                            throw new UnexpectedTokenException(tk, err);
                        }
                        this.recordDelimiterStd1 = true;
                        break;
                    }
                    if (tk.getToknum() == 551) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    if (this.recordKey != null) {
                        throw new GeneralErrorException(175, 4, tk, tk.getWord(), this.error);
                    }
                    this.recordKey = new Key(this.tm, this.error, true);
                    break;
                }
                case 273: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 670) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 551) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    this.tm.ungetToken();
                    if (this.altKeys == null) {
                        this.altKeys = new KeyList();
                    }
                    this.altKeys.addItem(new Key(this.tm, this.error, false));
                    break;
                }
                case 688: {
                    tk = this.tm.getToken();
                    if (Token.isIntLit(tk)) {
                        this.reserveArea = Integer.parseInt(tk.getWord());
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 278 || tk.getToknum() == 279) break;
                        this.tm.ungetToken();
                        break;
                    }
                    throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                }
                case 325: {
                    if (this.classToken != null || this.classVar != null) {
                        throw new GeneralErrorException(92, 4, tk, tk.getWord(), this.error);
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 545) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10001) {
                        this.classToken = tk;
                        break;
                    }
                    if (tk.getToknum() == 10009) {
                        this.tm.ungetToken();
                        this.classVar = VariableName.get(this.tm, this.error);
                        break;
                    }
                    throw new GeneralErrorException(21, 4, tk, tk.getWord(), this.error);
                }
                default: {
                    throw new UnexpectedTokenException(tk, err);
                }
            }
            tk = this.tm.getToken();
        }
        if (!assignFound) {
            throw new GeneralErrorException(18, 4, this.keyWord, "ASSIGN", this.error);
        }
        if (this.organization == 717 && !this.sort && !this.explicitBinary && this.tm.getOptionList().getOption("-cfl") != null) {
            this.line = true;
        }
        if (this.line && this.device != null && (this.device.getToknum() == 534 || this.device.getToknum() == 535 || this.device.getToknum() == 623)) {
            this.trailingSpaces = true;
        } else if (this.line && this.opSysName != null && (this.opSysName.getWord().equals("CARD-PUNCH") || this.opSysName.getWord().equals("CARD-READER") || this.opSysName.getWord().equals("CASSETTE") || this.opSysName.getWord().equals("MAGNETIC-TAPE"))) {
            this.trailingSpaces = true;
        }
        this.checks();
    }

    private void xmlCheckValidity(Token tk) throws GeneralErrorException, EndOfProgramException {
        while (tk.getToknum() == 10009 && "CHECK".equals(tk.getWord())) {
            if (this.xmlCheckValidityI && this.xmlCheckValidityO) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009 && "VALIDITY".equals(tk.getWord())) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 534) {
                if (this.xmlCheckValidityI) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                this.xmlCheckValidityI = true;
            } else if (tk.getToknum() == 623) {
                if (this.xmlCheckValidityO) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                this.xmlCheckValidityO = true;
            }
            tk = this.tm.getToken();
        }
        this.tm.ungetToken();
    }

    private void assign() throws GeneralErrorException, EndOfProgramException {
        boolean optCAX;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 773) {
            tk = this.tm.getToken();
        }
        boolean bl = optCAX = this.tm.getOptionList().getOption("-cax") != null;
        if (tk.getToknum() == 478) {
            this.assignExt = true;
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 414) {
            optCAX = false;
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 598) {
            this.xmlLineFeed = false;
            tk = this.tm.getToken();
            if (tk.getToknum() != 565) {
                throw new ExpectedFoundException(tk, this.error, "LINE");
            }
            tk = this.tm.getToken();
            if (tk.getToknum() == 260) {
                tk = this.tm.getToken();
            }
        }
        switch (tk.getToknum()) {
            case 408: 
            case 552: {
                this.organization = 717;
                this.line = true;
            }
            case 406: 
            case 407: 
            case 534: 
            case 535: 
            case 623: 
            case 664: {
                this.device = tk;
                tk = this.tm.getToken();
                break;
            }
            case 644: 
            case 645: 
            case 646: {
                this.device = tk;
                tk = this.tm.getToken();
                this.isPrinter = true;
                break;
            }
            case 565: {
                tk = this.tm.getToken();
                if (tk.getToknum() == 260) {
                    this.device = tk;
                    tk = this.tm.getToken();
                    this.isPrinter = true;
                    break;
                }
                throw new ExpectedFoundException(tk, this.error, "ADVANCING");
            }
            case 259: {
                this.device = tk;
                tk = this.tm.getToken();
                if (tk.getToknum() != 609) {
                    this.tm.ungetToken();
                }
                this.addressVar = VariableName.get(this.tm, this.error);
                if (this.addressVar == null) {
                    tk = this.tm.getToken();
                    throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
                }
                tk = this.tm.getToken();
                break;
            }
            case 368: {
                throw new GeneralErrorException(19, 4, tk, tk.getWord(), this.error);
            }
            case 581: 
            case 732: 
            case 733: 
            case 734: {
                tk = this.tm.getToken();
                this.sort = true;
                break;
            }
            case 10009: {
                if (!"ADDRESS OF".equals(tk.getWord())) break;
                tk = this.tm.getToken();
                if (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    this.addressVar = VariableName.get(this.tm, this.error);
                    if (this.addressVar == null) {
                        throw new GeneralErrorException(24, 4, tk, "", this.error);
                    }
                    tk = this.tm.getToken();
                    break;
                }
                throw new GeneralErrorException(24, 4, tk, "", this.error);
            }
        }
        if (tk.getToknum() == 10001) {
            this.opSysName = tk;
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 10009) {
            if (optCAX) {
                this.assignExt = true;
            }
            if (this.tm.getOptionList().getOption("-csl") != null) {
                this.opSysName = new Token(tk);
                this.opSysName.setWord("'" + tk.getWord().replace('-', '_') + "'");
                this.opSysName.setToknum(10001);
            } else if (this.assignExt) {
                if (this.tm.getOptionList().getOption("-cv") != null) {
                    String name = tk.getWord().replace('_', '-');
                    int lastDash = name.lastIndexOf(45);
                    if (lastDash >= 0) {
                        if (++lastDash < name.length()) {
                            name = name.substring(lastDash, name.length());
                        } else {
                            throw new GeneralErrorException(144, 4, tk, tk.getWord(), this.error);
                        }
                    }
                    this.opSysName = new Token(tk);
                    this.opSysName.setWord("'" + name + "'");
                    this.opSysName.setToknum(10001);
                } else {
                    this.opSysName = new Token(tk);
                    this.opSysName.setWord("'" + tk.getWord().replace('-', '_') + "'");
                    this.opSysName.setToknum(10001);
                }
            } else {
                this.opSysName = tk;
                this.tm.ungetToken();
                this.opSysNameVar = VariableName.get(this.tm, this.error);
            }
            tk = this.tm.getToken();
            if (tk.isLength() && this.opSysNameVar != null) {
                this.memLengthTk = tk;
                tk = this.tm.getToken();
                if (tk.getToknum() == 545) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() != 10009) {
                    throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
                }
                this.tm.ungetToken();
                this.memLengthVar = VariableName.get(this.tm, this.error);
                tk = this.tm.getToken();
                this.opSysName = new Token(this.fileName);
                this.opSysName.setWord("'" + this.fileName.getWord() + "'");
                this.opSysName.setToknum(10001);
            }
        } else {
            if (this.assignExt) {
                throw new GeneralErrorException(24, 4, tk, tk.getWord(), this.error);
            }
            this.opSysName = new Token(this.fileName);
            this.opSysName.setWord("'" + this.fileName.getWord() + "'");
            this.opSysName.setToknum(10001);
        }
        if (this.tm.getOptionList().getOption("-efd") != null || this.tm.getOptionList().getOption("-efc") != null || this.tm.getOptionList().getOption("-efa") != null || this.tm.getOptionList().getOption("-efo=") != null || Config.getProperty(".compiler.easydb", false)) {
            TokenList xtl;
            boolean efc = false;
            if (this.tm.getOptionList().getOption("-efc") != null) {
                efc = true;
            }
            if ((xtl = this.tm.delExtraInfo("XFD")) != null || (xtl = this.tm.delExtraInfo("EFC")) != null || (xtl = this.tm.delExtraInfo("EFD")) != null) {
                this.efdExtraInfo = new EfdParser(xtl, efc, this.error);
            }
        }
        this.tm.ungetToken();
    }

    private void checks() throws GeneralErrorException {
        switch (this.organization) {
            case 717: {
                if (this.recordKey != null || this.relativeKey != null || this.altKeys != null || this.accessMode != 717 || this.massUpdate || this.rollback || this.collating != null && !this.isSort()) {
                    throw new ClauseClashException(this.fileName, this.error, "ORGANIZATION");
                }
                this.flsu = this.tm.getOptionList().getOption("-flsu") != null;
                break;
            }
            case 677: {
                if (this.relativeKey == null && this.accessMode != 717) {
                    throw new GeneralErrorException(25, 4, this.fileName, "RELATIVE KEY", this.error);
                }
                if (this.recordKey == null && this.altKeys == null && this.paddingChar == null && this.addressVar == null && !this.massUpdate && !this.rollback && !this.line && this.collating == null) break;
                throw new ClauseClashException(this.fileName, this.error, "ORGANIZATION");
            }
            case 529: {
                if (this.recordKey == null) {
                    throw new GeneralErrorException(25, 4, this.fileName, "RECORD KEY", this.error);
                }
                if (this.relativeKey == null && !this.line && this.addressVar == null && this.paddingChar == null) break;
                throw new ClauseClashException(this.fileName, this.error, "ORGANIZATION");
            }
        }
    }

    private Key checkAltKeys() {
        if (this.altKeys != null) {
            int i;
            Key k;
            Key lowK;
            KeyList myAltKeys;
            int akCnt = this.altKeys.getItemNum();
            VariableDeclaration[][] vds = new VariableDeclaration[akCnt + 1][];
            if (this.tm.getOptionList().getOption("-cko") != null) {
                myAltKeys = new KeyList();
                int j = 0;
                while (!this.altKeys.isEmpty()) {
                    lowK = this.altKeys.getFirst();
                    j = 0;
                    k = this.altKeys.getFirst();
                    while (k != null) {
                        if (k.getVars()[0].getOffset() < lowK.getVars()[0].getOffset()) {
                            lowK = k;
                            j = this.altKeys.getCurrentIndex();
                        }
                        k = this.altKeys.getNext();
                    }
                    myAltKeys.addItem(lowK);
                    this.altKeys.getAt(j);
                    this.altKeys.deleteCurrent();
                }
                this.altKeys = myAltKeys;
            }
            if (this.tm.getOptionList().getOption("-crko") != null) {
                myAltKeys = new KeyList();
                int keyIdx = 0;
                int u = 0;
                while (!this.altKeys.isEmpty()) {
                    k = lowK = this.altKeys.getFirst();
                    keyIdx = this.altKeys.getCurrentIndex();
                    while (k != null) {
                        if (k.getVars()[0].getOffset() < lowK.getVars()[0].getOffset()) {
                            lowK = k;
                            keyIdx = this.altKeys.getCurrentIndex();
                        } else if (k.getVars()[0].getOffset() == lowK.getVars()[0].getOffset()) {
                            for (u = 1; u < k.getVars().length; ++u) {
                                if (lowK.getVars().length <= u || k.getVars()[u].getOffset() == lowK.getVars()[u].getOffset()) continue;
                                if (k.getVars()[u].getOffset() >= lowK.getVars()[u].getOffset()) break;
                                lowK = k;
                                keyIdx = this.altKeys.getCurrentIndex();
                                break;
                            }
                        }
                        k = this.altKeys.getNext();
                    }
                    myAltKeys.addItem(lowK);
                    this.altKeys.getAt(keyIdx);
                    this.altKeys.deleteCurrent();
                }
                this.altKeys = myAltKeys;
            }
            for (i = 0; i < akCnt; ++i) {
                vds[i] = this.altKeys.getAt(i).getVars();
            }
            vds[akCnt] = this.recordKey.getVars();
            for (i = akCnt; i > 0; --i) {
                VariableDeclaration[] vd = vds[i];
                for (int j = 0; j < i; ++j) {
                    if (vd.length != vds[j].length) continue;
                    int k2 = 0;
                    for (k2 = 0; k2 < vd.length && vd[k2].getOffset() == vds[j][k2].getOffset() && vd[k2].getPhisicLen() == vds[j][k2].getPhisicLen(); ++k2) {
                    }
                    if (k2 != vd.length) continue;
                    return this.altKeys.getAt(j);
                }
            }
        }
        return null;
    }

    public void setOpSysName(Token tk) {
        this.opSysName = tk;
        this.opSysNameVar = null;
    }

    public void setOpSysNameVar(VariableName var) {
        this.opSysNameVar = var;
        this.opSysName = var.name;
    }

    public String getPathCode() {
        if (this.opSysNameVar != null && this.memLengthTk == null) {
            return this.opSysNameVar.getCode();
        }
        return this.tm.getCodeLiteral(this.opSysName);
    }

    @Override
    public int getLockMode() {
        return this.lockMode;
    }

    @Override
    public int getLockMode(int openType) {
        if (this.lockMode == 0) {
            if (openType == 534) {
                return 578;
            }
            return 473;
        }
        return this.lockMode;
    }

    @Override
    public boolean getMassUpdate() {
        return this.massUpdate;
    }

    @Override
    public boolean getMultipleRecords() {
        return this.multipleRecords;
    }

    public void setMultipleRecords(boolean holding) {
        this.multipleRecords = holding;
    }

    @Override
    public boolean isWithRollback() {
        return this.rollback;
    }

    @Override
    public boolean isEncrypted() {
        return this.encryption;
    }

    @Override
    public boolean isCompressed() {
        return this.compression;
    }

    @Override
    public VariableName getFileStatus() {
        return this.fileStatus;
    }

    @Override
    public boolean hasLockSupport() {
        if (this.classToken != null || this.classVar != null) {
            return true;
        }
        if (this.organization == 677) {
            return true;
        }
        if (this.organization == 529) {
            return true;
        }
        if (this.isPrinter) {
            return false;
        }
        if (this.addressVar != null) {
            return false;
        }
        if (this.line) {
            return !this.flsu;
        }
        return true;
    }

    void setSameRecordArea(Select s) {
        this.sameRecordAreaOf = s;
        if (s.masterRecordAreaFor == null) {
            s.masterRecordAreaFor = new Vector();
        }
        s.masterRecordAreaFor.addElement(this);
    }

    @Override
    public Select getSameRecordArea() {
        return this.sameRecordAreaOf;
    }

    @Override
    public Vector getMasterRecordAreaFor() {
        return this.masterRecordAreaFor;
    }

    @Override
    public boolean hasSameRecordArea() {
        return this.masterRecordAreaFor != null || this.sameRecordAreaOf != null;
    }

    @Override
    public VariableName getOpSysNameVar() {
        return this.opSysNameVar;
    }

    @Override
    public Token getOpSysName() {
        return this.opSysName;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isFlsu() {
        return this.flsu;
    }

    @Override
    public boolean isMassUpdate() {
        return this.massUpdate;
    }

    @Override
    public boolean isLockSet() {
        return this.isLockSet;
    }

    @Override
    public boolean isRollback() {
        return this.rollback;
    }

    @Override
    public boolean isMultipleRecords() {
        return this.multipleRecords;
    }

    @Override
    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    @Override
    public Key getRecordKey() {
        return this.recordKey;
    }

    @Override
    public KeyList getAltKeys() {
        return this.altKeys;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    @Override
    public Token getClassToken() {
        return this.classToken;
    }

    @Override
    public VariableName getClassVar() {
        return this.classVar;
    }

    @Override
    public VariableName getAddressVar() {
        return this.addressVar;
    }

    @Override
    public Token getFileName() {
        return this.fileName;
    }

    @Override
    public VariableName getRelativeKey() {
        return this.relativeKey;
    }

    @Override
    public int getOrganization() {
        return this.organization;
    }

    @Override
    public int getAccessMode() {
        return this.accessMode;
    }

    @Override
    public boolean isPrinter() {
        return this.isPrinter;
    }

    @Override
    public boolean isAssignExt() {
        return this.assignExt;
    }

    @Override
    public VariableName getUseGiving() {
        return this.useGiving;
    }

    @Override
    public Token getKeyWord() {
        return this.keyWord;
    }

    @Override
    public Token getDevice() {
        return this.device;
    }

    @Override
    public Token getCollating() {
        return this.collating;
    }

    @Override
    public int getCompressionFactor() {
        return this.comprCntrlValue;
    }

    @Override
    public IToken getPaddingChar() {
        return this.paddingChar;
    }

    @Override
    public IVariableName getPaddingCharVar() {
        return this.paddingCharVar;
    }

    @Override
    public boolean isRecordDelimiterStd1() {
        return this.recordDelimiterStd1;
    }

    @Override
    public int getReserveArea() {
        return this.reserveArea;
    }
}

