/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.InternalErrorException;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;

public class PreCondition
implements CobolToken,
ErrorsNumbers {
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private static final int OP_EQ = 1;
    private static final int OP_NE = 2;
    private static final int OP_GE = 3;
    private static final int OP_LE = 4;
    private static final int OP_GT = 5;
    private static final int OP_LT = 6;
    private static final int OP_C_POSITIVE = 7;
    private static final int OP_C_NEGATIVE = 8;
    private static final int OP_C_ZERO = 9;
    private static final int OP_C_NUMERIC = 10;
    private static final int OP_C_ALPHABETIC = 11;
    private static final int OP_C_ALPHABETIC_UPPER = 12;
    private static final int OP_C_ALPHABETIC_LOWER = 13;
    private static final int OP_C_DEFINED = 14;
    private static final byte DJ_END = 0;
    private static final byte DJ_OR = 1;
    private static final byte DJ_AND = 2;
    private static final byte DJ_NOT = 3;
    private static final byte DJ_OPEN_PAR = 4;
    private static final byte DJ_CLOSE_PAR = 5;
    private static final byte DJ_TRUE = 6;
    private static final byte DJ_FALSE = 7;
    private static final char[] djdescr = new char[]{'!', '|', '&', '~', '(', ')', 'T', 'F'};
    private final int D_2STK = 1;
    private final int D_2PFX = 2;
    private final int D_POP = 3;
    private final int D_STOP = 4;
    private final int D_ERR = 5;
    final int[][] decTab = new int[][]{{4, 1, 1, 1, 1, 5}, {2, 2, 1, 1, 1, 2}, {2, 2, 2, 1, 1, 2}, {2, 2, 2, 1, 1, 2}, {5, 1, 1, 1, 1, 3}};
    private TokenList _tl;
    private PreProcessor pp;
    private boolean result;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;

    public PreCondition(PreProcessor pp, TokenList tl) {
        this.pp = pp;
        this._tl = tl;
    }

    public int parse() {
        CondItem itm2;
        Stack<CondItem> conds = new Stack<CondItem>();
        Stack<Object> stk = new Stack<Object>();
        stk.add(new CondItem(0));
        Stack<CondItem> rpn = new Stack<CondItem>();
        do {
            itm2 = new CondItem();
            conds.add(itm2);
        } while (itm2.type > 0 && itm2.type != 0);
        if (itm2.type < 0) {
            return -itm2.type;
        }
        Iterator i = conds.iterator();
        while (i.hasNext()) {
            itm2 = (CondItem)i.next();
            if (itm2.type == 6 || itm2.type == 7) {
                rpn.add(itm2);
                continue;
            }
            boolean goOn = true;
            block18: while (goOn) {
                CondItem wki = (CondItem)stk.peek();
                switch (this.decTab[wki.type][itm2.type]) {
                    case 1: {
                        stk.add(itm2);
                        goOn = false;
                        continue block18;
                    }
                    case 2: {
                        rpn.add((CondItem)stk.pop());
                        continue block18;
                    }
                    case 3: {
                        stk.pop();
                        goOn = false;
                        continue block18;
                    }
                    case 4: {
                        if (i.hasNext()) {
                            throw new InternalErrorException("parse I");
                        }
                        goOn = false;
                        continue block18;
                    }
                    case 5: {
                        return 44;
                    }
                }
                throw new InternalErrorException("parse II");
            }
        }
        stk.clear();
        try {
            block19: for (CondItem itm2 : rpn) {
                switch (itm2.type) {
                    case 2: {
                        stk.push((Boolean)stk.pop() & (Boolean)stk.pop() ? TRUE : FALSE);
                        continue block19;
                    }
                    case 1: {
                        stk.push((Boolean)stk.pop() | (Boolean)stk.pop() ? TRUE : FALSE);
                        continue block19;
                    }
                    case 3: {
                        stk.push((Boolean)stk.pop() != false ? FALSE : TRUE);
                        continue block19;
                    }
                    case 6: {
                        stk.push(TRUE);
                        continue block19;
                    }
                    case 7: {
                        stk.push(FALSE);
                        continue block19;
                    }
                }
                return 43;
            }
            if (stk.size() != 1) {
                return 43;
            }
            this.result = (Boolean)stk.pop();
        }
        catch (EmptyStackException _ex) {
            return 43;
        }
        return 0;
    }

    public boolean evaluate() {
        return this.result;
    }

    private Token getPrevious() {
        return this._tl.getPrevious();
    }

    private Token getNext() {
        Token Return2 = this._tl.getNext();
        if (Return2 != null && (Return2.getToknum() == 10005 || Return2.getToknum() == 10020)) {
            Return2 = null;
        }
        return Return2;
    }

    class CondItem {
        final int type;
        Long[] lngOperand;
        String[] strOperand;

        private CondItem(int type) {
            this.type = type;
        }

        private CondItem() {
            Token tk = PreCondition.this.getNext();
            if (tk == null) {
                this.type = 0;
            } else {
                switch (tk.getToknum()) {
                    case 617: {
                        this.type = 1;
                        break;
                    }
                    case 274: {
                        this.type = 2;
                        break;
                    }
                    case 598: {
                        this.type = 3;
                        break;
                    }
                    case 40: {
                        this.type = 4;
                        break;
                    }
                    case 41: {
                        this.type = 5;
                        break;
                    }
                    default: {
                        PreCondition.this.getPrevious();
                        this.type = this.parse();
                    }
                }
            }
        }

        private int parse() {
            boolean not = false;
            int Return2 = this.findValue(0);
            if (Return2 == 0) {
                int op;
                Token tk = PreCondition.this.getNext();
                if (tk == null) {
                    return -43;
                }
                if (tk.getToknum() == 545 && (tk = PreCondition.this.getNext()) == null) {
                    return -43;
                }
                if (tk.getToknum() == 598) {
                    not = true;
                    tk = PreCondition.this.getNext();
                    if (tk == null) {
                        return -43;
                    }
                }
                try {
                    switch (tk.getToknum()) {
                        case 61: 
                        case 462: {
                            op = 1;
                            tk = PreCondition.this.getNext();
                            if (tk.getToknum() != 773) {
                                PreCondition.this.getPrevious();
                            }
                            break;
                        }
                        case 60: 
                        case 62: 
                        case 507: 
                        case 560: {
                            if (tk.getToknum() == 60) {
                                Token tk1 = PreCondition.this.getNext();
                                if (tk1.getToknum() == 62) {
                                    op = 2;
                                    break;
                                }
                                PreCondition.this.getPrevious();
                            }
                            op = tk.getToknum() == 560 || tk.getToknum() == 60 ? 6 : 5;
                            tk = PreCondition.this.getNext();
                            if (tk.getToknum() == 761) {
                                tk = PreCondition.this.getNext();
                            }
                            if (tk.getToknum() == 617 || tk.getToknum() == 61) {
                                if (tk.getToknum() == 617) {
                                    tk = PreCondition.this.getNext();
                                }
                                if (tk.getToknum() == 462 || tk.getToknum() == 61) {
                                    switch (op) {
                                        case 3: {
                                            op = 5;
                                            break;
                                        }
                                        case 6: {
                                            op = 4;
                                            break;
                                        }
                                        case 4: {
                                            op = 6;
                                            break;
                                        }
                                        case 5: {
                                            op = 3;
                                        }
                                    }
                                    tk = PreCondition.this.getNext();
                                    if (tk.getToknum() != 773) {
                                        PreCondition.this.getPrevious();
                                    }
                                }
                                break;
                            }
                            PreCondition.this.getPrevious();
                            break;
                        }
                        case 603: {
                            op = 10;
                            if (this.lngOperand == null) {
                                Return2 = 7;
                                break;
                            }
                            Return2 = 6;
                            break;
                        }
                        case 266: {
                            op = 11;
                            if (this.strOperand == null) {
                                Return2 = 7;
                                break;
                            }
                            Return2 = 6;
                            break;
                        }
                        case 267: {
                            op = 13;
                            if (this.strOperand == null) {
                                return -43;
                            }
                            Return2 = 6;
                            char[] a = this.strOperand[0].toCharArray();
                            for (int i = a.length - 1; i > 0; --i) {
                                if (Character.isLowerCase(a[i])) continue;
                                Return2 = 7;
                            }
                            break;
                        }
                        case 268: {
                            op = 12;
                            if (this.strOperand == null) {
                                return -43;
                            }
                            Return2 = 6;
                            char[] a = this.strOperand[0].toCharArray();
                            for (int i = a.length - 1; i > 0; --i) {
                                if (Character.isUpperCase(a[i])) continue;
                                Return2 = 7;
                            }
                            break;
                        }
                        case 642: {
                            op = 7;
                            if (this.lngOperand == null) {
                                return -43;
                            }
                            Return2 = this.lngOperand[0] > 0L ? 6 : 7;
                            break;
                        }
                        case 594: {
                            op = 8;
                            if (this.lngOperand == null) {
                                return -43;
                            }
                            Return2 = this.lngOperand[0] < 0L ? 6 : 7;
                            break;
                        }
                        case 822: {
                            op = 9;
                            if (this.lngOperand == null) {
                                return -43;
                            }
                            Return2 = this.lngOperand[0] == 0L ? 6 : 7;
                            break;
                        }
                        case 10002: {
                            if ("0".equals(tk.getWord())) {
                                op = 9;
                                if (this.lngOperand == null) {
                                    return -43;
                                }
                                Return2 = this.lngOperand[0] == 0L ? 6 : 7;
                                break;
                            }
                            return -43;
                        }
                        case 10009: {
                            if ("DEFINED".equals(tk.getWord())) {
                                op = 14;
                                if (this.strOperand != null && this.strOperand[0] != null) {
                                    Return2 = 6;
                                    break;
                                }
                                Return2 = 7;
                                break;
                            }
                            return -43;
                        }
                        default: {
                            return -43;
                        }
                    }
                }
                catch (NullPointerException _ex) {
                    return -43;
                }
                if (Return2 != 6 && Return2 != 7 && (Return2 = this.findValue(1)) == 0) {
                    try {
                        long cmp = this.compare();
                        switch (op) {
                            case 1: {
                                Return2 = cmp == 0L ? 6 : 7;
                                break;
                            }
                            case 2: {
                                Return2 = cmp != 0L ? 6 : 7;
                                break;
                            }
                            case 3: {
                                Return2 = cmp >= 0L ? 6 : 7;
                                break;
                            }
                            case 4: {
                                Return2 = cmp <= 0L ? 6 : 7;
                                break;
                            }
                            case 5: {
                                Return2 = cmp > 0L ? 6 : 7;
                                break;
                            }
                            case 6: {
                                Return2 = cmp < 0L ? 6 : 7;
                                break;
                            }
                            default: {
                                throw new InternalErrorException("op=" + op);
                            }
                        }
                    }
                    catch (Exception e) {
                        return -43;
                    }
                }
            }
            if (not) {
                Return2 = Return2 == 6 ? 7 : 6;
            }
            return Return2;
        }

        private int findValue(int lor) {
            int Return2 = 0;
            Token tk = PreCondition.this.getNext();
            if (tk == null) {
                return -43;
            }
            switch (tk.getToknum()) {
                case 10002: {
                    if (this.lngOperand == null) {
                        this.lngOperand = new Long[2];
                    }
                    this.lngOperand[lor] = new Long(tk.getWord());
                    break;
                }
                case 10001: {
                    if (this.strOperand == null) {
                        this.strOperand = new String[2];
                    }
                    this.strOperand[lor] = tk.getWord();
                    this.strOperand[lor] = this.strOperand[lor].substring(1, this.strOperand[lor].length() - 1);
                    break;
                }
                case 10009: {
                    Token str = PreCondition.this.pp.getConstant(tk.getWord());
                    if (str == null) break;
                    String val = str.getWord();
                    if (str.getToknum() == 10001) {
                        val = val.substring(1, val.length() - 1);
                    }
                    try {
                        Long c = new Long(val);
                        if (this.lngOperand == null) {
                            this.lngOperand = new Long[2];
                        }
                        this.lngOperand[lor] = c;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (this.strOperand == null) {
                        this.strOperand = new String[2];
                    }
                    this.strOperand[lor] = val;
                    break;
                }
                default: {
                    return -43;
                }
            }
            return Return2;
        }

        private long compare() throws Exception {
            long Return2;
            if (this.lngOperand != null && this.lngOperand[0] != null && this.lngOperand[1] != null) {
                Return2 = this.lngOperand[0] - this.lngOperand[1];
            } else if (this.strOperand != null && this.strOperand[0] != null && this.strOperand[1] != null) {
                Return2 = this.strOperand[0].compareTo(this.strOperand[1]);
            } else {
                throw new Exception();
            }
            return Return2;
        }

        public String toString() {
            StringBuffer Return2 = new StringBuffer();
            Return2.append('[');
            if (this.lngOperand != null && this.lngOperand[0] != null && this.lngOperand[1] != null) {
                Return2.append(this.lngOperand[0]);
                Return2.append(',');
                Return2.append(this.lngOperand[1]);
                Return2.append(',');
                Return2.append(djdescr[this.type]);
            } else if (this.strOperand != null && this.strOperand[0] != null && this.strOperand[1] != null) {
                Return2.append(this.strOperand[0]);
                Return2.append(',');
                Return2.append(this.strOperand[1]);
                Return2.append(',');
                Return2.append(djdescr[this.type]);
            } else {
                Return2.append(djdescr[this.type]);
            }
            Return2.append(']');
            return Return2.toString();
        }
    }
}

