/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.DeferredBlock;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.ParagraphCodeAnalyzer;
import com.iscobol.compiler.ParagraphDesc;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ProcedureDivision;
import com.iscobol.compiler.Section;
import com.iscobol.compiler.StatementDesc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;
import com.iscobol.interfaces.compiler.IParagraphExtension;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Paragraph
implements CobolToken,
ErrorsNumbers,
IParagraphExtension {
    private static final String DECL_PREF = "declarative$";
    private Map deferredBlocksMap = new HashMap();
    protected LinkedList deferredBlockList = new LinkedList();
    private static int globProg;
    private TokenManager tm;
    private Errors error;
    private Token name;
    private int idNumber;
    private boolean isInDeclaratives;
    private Block paragraphBlock;
    private Pcc pc;
    private int loopCount;
    private int threadCount;
    private boolean isNameDup;
    private int prog;
    private int maxParLines = 0;
    final boolean isSection;
    protected ProcedureDivision procedure;
    private Section section;
    private boolean hasGoto;
    private boolean hasExitSect;
    private boolean goOnlyNextPar = true;
    private String actPerf = "";
    private NextSentenceBlock actNextSentence;

    protected Paragraph() {
        this.isSection = false;
    }

    public Paragraph(Pcc p, Token n, TokenManager t, Errors err, boolean isdup, ProcedureDivision pd) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        this.procedure = pd;
        this.error = err;
        this.tm = t;
        this.pc = p;
        this.name = n;
        this.isInDeclaratives = this.pc.inDeclaratives;
        this.isNameDup = isdup;
        if (this.isNameDup) {
            this.prog = ++globProg;
        }
        if ((tk = this.tm.getToken()).getToknum() == 709) {
            this.isSection = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 10002) {
                tk = this.tm.getToken();
            }
        } else {
            this.isSection = false;
        }
        if (tk.getToknum() != 10006) {
            this.error.print(212, 3, n, n.getWord());
            this.tm.ungetToken();
        }
        this.setParagraphCodeLimit();
        this.init();
    }

    private void init() throws GeneralErrorException, EndOfProgramException {
        switch (this.pc.getTokenManager().getFormat()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (this.name.getOffset() < 4) break;
                this.error.print(253, 2, this.name, this.name.getWord());
            }
        }
        Pcc p = this.pc;
        while (p != null) {
            if (p.getAllVariables().get(this.getName()) != null) {
                this.error.print(254, 2, this.name, this.name.getWord());
                break;
            }
            p = p.parent;
        }
        this.paragraphBlock = new Block(this, null, this.pc, this.tm, this.error);
        this.paragraphBlock.setRaising(this.procedure.raising);
        this.paragraphBlock.parse(0);
        this.paragraphBlock.setParagraphBlock(true);
    }

    public Paragraph(Pcc p, Token n, TokenManager t, Errors err, ProcedureDivision pd) throws GeneralErrorException, EndOfProgramException {
        this.procedure = pd;
        this.error = err;
        this.tm = t;
        this.pc = p;
        this.name = n;
        this.isInDeclaratives = false;
        this.isSection = false;
        this.isNameDup = false;
        this.init();
    }

    public static void resetCounters() {
        globProg = 0;
    }

    public void setIdNumber(int i) {
        this.idNumber = i;
    }

    @Override
    public int getIdNumber() {
        return this.idNumber;
    }

    @Override
    public Token getNameToken() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name.getWord();
    }

    public String getJavaName() {
        String Return2 = this.isInDeclaratives ? DECL_PREF + this.name.getWord().replace('-', Pcc.hyphenRepl) : (Character.isDigit(this.name.getWord().charAt(0)) ? "_" + this.name.getWord().replace('-', Pcc.hyphenRepl) : this.name.getWord().replace('-', Pcc.hyphenRepl));
        if (this.section != null) {
            Return2 = Return2 + "$$" + this.section.getName().replace('-', Pcc.hyphenRepl);
        }
        if (this.isNameDup) {
            Return2 = Return2 + (Pcc.identifierSep + this.prog);
        }
        return Return2;
    }

    public void check() throws GeneralErrorException {
        this.paragraphBlock.check();
    }

    public void putDeferredBlock(int id, String name) {
        boolean modStatic = this.pc.isFactory() && !(this.pc instanceof CobolMethod);
        boolean modPrivate = !this.pc.getSplitFlag();
        this.deferredBlocksMap.put(new Integer(id), new DeferredBlock(name, modStatic, modPrivate, this));
    }

    public DeferredBlock getDeferredBlock(int id) {
        return (DeferredBlock)this.deferredBlocksMap.get(new Integer(id));
    }

    public void clearDeferredBlocks() {
        this.deferredBlocksMap.clear();
        this.deferredBlockList.clear();
    }

    static Paragraph getDebugSection(Pcc pc, Paragraph p) {
        if (!pc.isDebuggingMode()) {
            return null;
        }
        int ufd = pc.getUseForDebuggingCount();
        for (int i = 0; i < ufd; ++i) {
            Paragraph sec = pc.getUseForDebugSection(i);
            if (sec == null) continue;
            int dbgParNum = pc.getDebuggedParagraphNumber(i);
            boolean dbgParDecl = false;
            if (dbgParNum < 0) {
                dbgParDecl = true;
                dbgParNum = -dbgParNum;
            }
            if ((dbgParNum != p.getIdNumber() || dbgParDecl != p.isDeclaratives()) && (dbgParNum != Integer.MAX_VALUE || p.getSection() == sec.getSection())) continue;
            return sec;
        }
        return null;
    }

    public String getCode() {
        int sns;
        StringBuffer Return2 = new StringBuffer();
        boolean debug = this.pc.getOption("-d") != null;
        Return2.append(eol);
        Return2.append(this.tm.getCommentCode(this.name, "   "));
        if (this.pc.isFactory() && !(this.pc instanceof CobolMethod)) {
            Return2.append("   static ");
        } else {
            Return2.append("   ");
        }
        Return2.append("final ");
        if (!this.pc.getSplitFlag()) {
            Return2.append("private ");
        }
        Return2.append("int " + this.getJavaName());
        Return2.append("() ");
        if (this.procedure.raising != null) {
            this.procedure.getThrows(Return2);
            Return2.append(", GotoException");
        } else {
            Return2.append(" throws GotoException");
        }
        Return2.append(" /* section = " + this.isSection + "*/");
        boolean hasLocalStorage = false;
        boolean hasThreadLocalStorage = false;
        if (this.pc.data != null) {
            hasLocalStorage = this.pc.data.lsSec != null;
            hasThreadLocalStorage = this.pc.data.tlsSec != null;
        }
        Paragraph debugSec = Paragraph.getDebugSection(this.pc, this);
        if (hasLocalStorage || hasThreadLocalStorage || debug || debugSec != null) {
            Return2.append("   {");
            Return2.append(eol + "   ");
            if (debug) {
                this.getDebugEnterCode(Return2);
                Return2.append(eol);
            }
            if (hasLocalStorage) {
                this.pc.getLocalStorageCode(Return2);
            }
            if (hasThreadLocalStorage) {
                this.pc.getThreadLocalStorageCode(Return2);
            }
            if (debugSec != null) {
                int startNum = debugSec.getIdNumber();
                int endNum = debugSec.getLastParagraphInSameSection().getIdNumber();
                Return2.append("   if(Factory.mustExecuteDebugCode()) {");
                Return2.append(eol);
                Return2.append("   ");
                Return2.append("   " + Verb.getDebugItemLocalVar("DEBUG-NAME", this.pc.optionMS, this.pc.capitalizeNames) + ".set(\"");
                Return2.append(this.getName());
                Return2.append("\");");
                Return2.append(eol);
                Return2.append("   declaratives(");
                Return2.append(startNum);
                Return2.append(" , ");
                Return2.append(endNum);
                Return2.append(");");
                Return2.append(eol);
                Return2.append("      }");
                Return2.append(eol);
            }
        }
        if ((sns = this.getParagraphCodeLimit()) > 0) {
            int[] blockIds = ParagraphCodeAnalyzer.analyze(sns, debug, this);
            for (int i = 0; i < blockIds.length; ++i) {
                if (blockIds[i] == 0) continue;
                String newDeferredMethodName = this.generateDeferredMethodName();
                this.putDeferredBlock(blockIds[i], newDeferredMethodName);
            }
        }
        boolean printExitCode = this.paragraphBlock.getNotClosedCode(Return2);
        if (debug && printExitCode) {
            Return2.append(eol + "   ");
            Paragraph.getDebugExitCode(Return2);
            Return2.append(eol);
        }
        if (debug || hasLocalStorage || hasThreadLocalStorage || debugSec != null) {
            Return2.append("   }");
            Return2.append(eol);
        }
        if (printExitCode) {
            this.getExitCode(Return2, "0");
        }
        while (!this.deferredBlockList.isEmpty()) {
            DeferredBlock df = (DeferredBlock)this.deferredBlockList.removeFirst();
            Return2.append(df.getCode());
        }
        return Return2.toString();
    }

    protected void getExitCode(StringBuffer Return2, String returnCode) {
        if (this.pc.getOption("-pt0") != null || this.pc.getOption("-pt2") != null) {
            Return2.append("      if (");
            if (this.pc.getSplitFlag()) {
                if (this.pc instanceof CobolMethod) {
                    Return2.append("$$theMethod$$.");
                } else {
                    Return2.append("$$theProgram$$.");
                }
            }
            Return2.append(this.isInDeclaratives ? "$dexitPoint$" : "$exitPoint$");
            Return2.append("[");
            Return2.append(this.idNumber);
            Return2.append("] != 0) ");
            Return2.append(this.isInDeclaratives ? "dexit" : "exit");
            Return2.append(" (");
            Return2.append(this.idNumber);
            Return2.append(");");
            Return2.append(eol);
        }
        Return2.append("      return " + returnCode + ";");
        Return2.append(eol);
        Return2.append("   }");
        Return2.append(eol);
    }

    private void getDebugEnterCode(StringBuffer buff) {
        this.getDebugEnterCode(buff, null);
    }

    protected void getDebugEnterCode(StringBuffer buff, String entryPointName) {
        String methName;
        String methInstName;
        String parInstName;
        String parClassName;
        Pcc rootPcc = this.pc.getRoot();
        String fn = this.name.getFileName();
        if (File.separatorChar != '/') {
            fn = fn.replace(File.separatorChar, '/');
        }
        int idx = this.name.getFileIndex();
        if (entryPointName == null) {
            String method = null;
            if (this.pc instanceof CobolMethod) {
                method = ((CobolMethod)this.pc).getMethodDesc();
            }
            rootPcc.addParagraph(new ParagraphDesc(method, this.name.getWord(), idx, this.name.getFLN(), this.idNumber, this.isInDeclaratives, this.isSection));
            rootPcc.addLine(new StatementDesc(idx, this.name.getFLN(), this.idNumber, this.isDeclaratives()));
        }
        while (rootPcc.parent != null) {
            rootPcc = rootPcc.parent;
        }
        boolean dx = this.pc.getOption("-dx") != null;
        buff.append("   Debugger.enterPar");
        if (dx) {
            buff.append("Ext");
        }
        buff.append(" (");
        buff.append(this.name.getFLN());
        buff.append(", \"");
        buff.append(fn);
        buff.append("\"");
        buff.append(", ");
        buff.append(idx);
        buff.append(", \"");
        buff.append(this.name.getWord());
        buff.append("\", ");
        buff.append(this.idNumber);
        buff.append(", ");
        if (this.pc instanceof CobolMethod) {
            parClassName = rootPcc.getFullClassName() + ".class";
            parInstName = this.pc.isFactory() ? "null" : (this.pc.isDefault() ? "$This$" : rootPcc.getFullClassName() + ".this");
            methInstName = ((CobolMethod)this.pc).getLocalDataClass() + ".this";
            methName = "\"" + ((CobolMethod)this.pc).getMethodName() + "\"";
        } else {
            parClassName = rootPcc.getFullClassName() + ".class";
            parInstName = "this";
            if (this.pc.getSplitFlag()) {
                parInstName = this.pc.getClassName() + "." + parInstName;
            }
            if (entryPointName != null) {
                methInstName = parClassName;
                methName = entryPointName;
            } else {
                methInstName = "null";
                methName = "null";
            }
        }
        buff.append(parClassName);
        buff.append(", ");
        buff.append(parInstName);
        buff.append(", ");
        buff.append(methInstName);
        buff.append(", ");
        buff.append(methName);
        if (dx) {
            buff.append(", ");
            buff.append(this.isInDeclaratives);
        }
        buff.append(");");
    }

    public static void getDebugExitCode(StringBuffer buff) {
        buff.append("   Debugger.exitPar ();");
    }

    void enterLoop(boolean thread) {
        ++this.loopCount;
        if (thread) {
            ++this.threadCount;
        }
    }

    void exitLoop(boolean thread) {
        --this.loopCount;
        if (thread) {
            --this.threadCount;
        }
    }

    boolean inLoop() {
        return this.loopCount > 0;
    }

    boolean inThread() {
        return this.threadCount > 0;
    }

    boolean isDuplicate() {
        return this.isNameDup;
    }

    @Override
    public boolean isDeclaratives() {
        return this.isInDeclaratives;
    }

    void setIsDup() {
        this.isNameDup = true;
    }

    boolean isEmpty() {
        return this.paragraphBlock.verbs.getItemNum() == 0;
    }

    void setSection(Section pl) {
        this.section = pl;
    }

    public Paragraph getParagraphInSameSection(String name) {
        if (this.section != null) {
            return this.section.getParagraph(name);
        }
        return null;
    }

    public Paragraph getLastParagraphInSameSection() {
        if (this.section != null) {
            return this.section.getLastParagraph();
        }
        return null;
    }

    @Override
    public Section getSection() {
        return this.section;
    }

    @Override
    public Block getBlock() {
        return this.paragraphBlock;
    }

    public void setActPerf(String ap) {
        this.actPerf = ap;
    }

    public NextSentenceBlock getActNextSentence() {
        return this.actNextSentence;
    }

    public void setActNextSentence(NextSentenceBlock actNextSentence) {
        this.actNextSentence = actNextSentence;
    }

    public String getActPerf() {
        return this.actPerf;
    }

    public boolean hasGoto() {
        return this.hasGoto;
    }

    public boolean hasExitSect() {
        return this.hasExitSect;
    }

    public boolean hasGoOnlyNextPar() {
        return this.goOnlyNextPar;
    }

    public void setHasGoto(boolean b) {
        this.hasGoto = b;
        if (this.hasGoto) {
            this.goOnlyNextPar = false;
        }
    }

    public void setExitSect(boolean b) {
        this.hasExitSect = b;
    }

    public void setHasGoto(Paragraph p) {
        this.hasGoto = true;
        if (p == null || this.getIdNumber() + 1 != p.getIdNumber()) {
            this.goOnlyNextPar = false;
        }
    }

    @Override
    public boolean isSection() {
        return this.isSection;
    }

    public int getPreProcessorIndex() {
        return this.name.getFileIndex();
    }

    public Pcc getPcc() {
        return this.pc;
    }

    public String generateDeferredMethodName() {
        String ret = "_dm$" + this.getJavaName() + "$" + Verb.getUniqueId();
        return ret;
    }

    public int getParagraphCodeLimit() {
        return this.maxParLines;
    }

    public void setParagraphCodeLimit() {
        try {
            String sns = this.pc.getOption("-sns=");
            if (sns != null) {
                this.maxParLines = Integer.parseInt(sns);
            }
            if (this.pc.getOption("-d") != null) {
                this.maxParLines /= 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

