/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GUIControl;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class Inquire
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final int HND_NO_HANDLE = -1;
    public static final int HND_GENERIC = 1;
    public static final int HND_WINDOW = 2;
    public static final int HND_CONTROL = 3;
    LinkedList child = new LinkedList();
    Vector args = new Vector();
    int inquireType = -1;
    VariableName name;
    Token nameToken;
    GUIControl guictl;
    boolean isGraphical;
    Map<String, Object> windowProperties = new HashMap<String, Object>();
    VariableName linesVar;
    VariableName screenLineVar;
    Token screenLineToken;
    VariableName screenColumnVar;
    Token screenColumnToken;
    VariableName screenAbsLineVar;
    VariableName screenAbsColumnVar;
    VariableName sizeVar;
    VariableName colorVar;
    VariableName colorBackVar;
    VariableName colorForeVar;
    VariableName titleVar;
    boolean visible = false;
    VariableName visibleVar;
    VariableName popupMenuVar;
    VariableName classVar;
    VariableName objVar;
    VariableName statusVar;
    VariableName systemHandleVar;
    VariableName layoutManagerVar;
    VariableName hintVar;
    VariableName layoutVar;
    VariableName massUpdateVar;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Inquire(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        if (this.pc.getOption("-whttp") != null) {
            this.error.print(232, 2, kw, kw.getWord());
        }
        this.pc.useScreen = true;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 812 || tk.getToknum() == 373) {
            this.inquireType = tk.getToknum();
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 10009) {
            int typetmp;
            this.nameToken = tk;
            this.name = this.localVariableNameGet(false);
            if (this.inquireType == -1) {
                this.inquireType = this.typeItemName(this.name);
            } else if (this.inquireType == 812 && (typetmp = this.typeItemName(this.name)) != 2 && typetmp != 1) {
                throw new UnexpectedTokenException(tk, this.error);
            }
            if (this.inquireType == 2 || this.inquireType == 812) {
                if (!this.name.getVarDecl().checkDimension(this.name.getDimension())) {
                    throw new GeneralErrorException(41, 4, this.name.getNameToken(), this.name.getNameToken().getWord(), this.error);
                }
                this.inquireWindow();
            } else {
                if (this.inquireType != 3 && this.inquireType != 1) throw new UnexpectedTokenException(tk, this.error);
                VariableDeclaration vds = null;
                if (this.name != null && (vds = this.name.getVarDecl()) != null && !(vds instanceof VariableDeclarationScreen) && vds.getControlHandle() != 12 && vds.getControlHandle() != 10 && vds.getControlHandle() != 21 && vds.getControlHandle() != 7 && vds.getControlHandle() != 8 && vds.getControlHandle() != 14 && vds.getControlHandle() != 17 && !this.name.getVarDecl().checkDimension(this.name.getDimension())) {
                    throw new GeneralErrorException(41, 4, this.name.getNameToken(), this.name.getNameToken().getWord(), this.error);
                }
                if (this.name != null && this.name.hasSubValue()) {
                    tk = this.name.getNameToken();
                    throw new GeneralErrorException(17, 4, new Token(':', tk.getFLN(), tk.getOffset(), tk.getFileName()), ":", this.error);
                }
                this.guictl = new GUIControl(this.pc, this.tm, this.error, this.nameToken, this.keyWord, 5, null);
                this.guictl.setGraphicControlType(this.getGraphicControlType(this.name));
                tk = this.tm.getToken();
                if (tk.getToknum() == 40) {
                    this.guictl.sa.loadIndexes(this.nameToken, this.tm, err, this.pc);
                } else {
                    this.tm.ungetToken();
                }
                this.loadInquireControl(this.guictl);
            }
        } else if (this.inquireType == 373) {
            this.tm.ungetToken();
            this.guictl = new GUIControl(this.pc, this.tm, this.error, this.nameToken, this.keyWord, 5, null);
            this.loadInquireControl(this.guictl);
        } else {
            if (this.inquireType != 812) throw new UnexpectedTokenException(tk, this.error);
            this.tm.ungetToken();
            this.inquireWindow();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.child.add(new Inquire(kw, par, p, t, err));
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    private VariableName localVariableNameGet() throws GeneralErrorException, EndOfProgramException {
        return this.localVariableNameGet(true);
    }

    private VariableName localVariableNameGet(boolean checkname) throws GeneralErrorException, EndOfProgramException {
        this.tm.ungetToken();
        VariableName Return2 = VariableName.get(this.tm, this.error, null, this.pc, false, true, checkname, true);
        return Return2;
    }

    protected int getGraphicControlType(VariableName t) throws GeneralErrorException {
        VariableDeclaration vds = null;
        int Return2 = -1;
        vds = this.pc.getVar(t, false);
        if (vds != null && vds instanceof VariableDeclarationScreen && ((VariableDeclarationScreen)vds).guictl.isGraphicControlType()) {
            Return2 = ((VariableDeclarationScreen)vds).guictl.getGraphicControlType();
        }
        if (Return2 == -1 && vds.isControlHandle()) {
            Return2 = vds.getControlHandle();
        }
        return Return2;
    }

    protected int typeItemName(VariableName t) throws GeneralErrorException {
        VariableDeclaration vds = null;
        int Return2 = -1;
        vds = this.pc.getVar(t, false);
        if (vds != null) {
            if (vds instanceof VariableDeclarationScreen) {
                if (((VariableDeclarationScreen)vds).guictl.isGraphicControlType()) {
                    Return2 = 3;
                }
            } else if (vds instanceof VariableDeclaration) {
                if (vds.isControlHandle()) {
                    Return2 = 3;
                } else if (vds.isGenericHandle()) {
                    Return2 = 1;
                } else if (vds.isWindowHandle()) {
                    Return2 = 2;
                }
            }
        }
        return Return2;
    }

    @Override
    public void check() throws GeneralErrorException {
        this.checkPerform();
    }

    private void inquireWindow() throws GeneralErrorException, EndOfProgramException {
        Token tk;
        boolean go = true;
        block15: while (go && (tk = this.tm.getToken()) != null) {
            switch (tk.getToknum()) {
                case 566: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.linesVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new ExpectedFoundException(tk, this.error, "literal");
                }
                case 771: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.titleVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new ExpectedFoundException(tk, this.error, "literal");
                }
                case 565: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 602) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.screenLineVar = this.localVariableNameGet();
                        continue block15;
                    }
                    if (Token.isNumLit(tk)) {
                        this.screenLineToken = tk;
                        continue block15;
                    }
                    throw new ExpectedFoundException(tk, this.error, "literal");
                }
                case 334: 
                case 338: 
                case 640: 
                case 641: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 602) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.screenColumnVar = this.localVariableNameGet();
                        continue block15;
                    }
                    if (Token.isNumLit(tk)) {
                        this.screenColumnToken = tk;
                        continue block15;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 705: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 565) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 602) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.screenAbsLineVar = this.localVariableNameGet();
                            continue block15;
                        }
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    if (tk.getToknum() == 338 || tk.getToknum() == 334 || tk.getToknum() == 641 || tk.getToknum() == 640) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 602) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.screenAbsColumnVar = this.localVariableNameGet();
                            continue block15;
                        }
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 728: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.sizeVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 336: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.colorVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 292: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.colorBackVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 495: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.colorForeVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 808: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.visibleVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 639: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 580) {
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() == 10009) {
                            this.popupMenuVar = this.localVariableNameGet();
                            continue block15;
                        }
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 742: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.statusVar = this.localVariableNameGet();
                        continue block15;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 753: {
                    throw new GeneralErrorException(11, 4, tk, tk.getWord(), this.error);
                }
            }
            if (tk.getWord().equalsIgnoreCase("HINT")) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 10009) {
                    this.hintVar = this.localVariableNameGet();
                    continue;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            if (tk.getWord().equalsIgnoreCase("LAYOUT")) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 10009) {
                    this.layoutVar = this.localVariableNameGet();
                    continue;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            if (tk.getWord().equalsIgnoreCase("PLACEHOLDER")) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 10009) {
                    this.hintVar = this.localVariableNameGet();
                    continue;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            if (tk.getWord().equalsIgnoreCase("MASS-UPDATE")) {
                tk = this.tm.getToken();
                if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 10009) {
                    this.massUpdateVar = this.localVariableNameGet();
                    continue;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            if (GUIControl.windowPropertyNames.contains(tk.getWord())) {
                String propName = tk.getWord();
                tk = this.tm.getToken();
                if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                    tk = this.tm.getToken();
                }
                if (tk.getToknum() == 10009) {
                    this.windowProperties.put(propName, this.localVariableNameGet());
                    continue;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            go = false;
            this.tm.ungetToken();
        }
    }

    private String printVariableName(VariableName obj) {
        String Return2 = "";
        if (obj != null) {
            Return2 = obj.getCode();
        }
        return Return2;
    }

    private void loadJavaBeanRef() throws GeneralErrorException, EndOfProgramException {
        VariableDeclaration vd = this.name.getVarDecl();
        if (!(vd.isHandle() || vd instanceof VariableDeclarationScreen && ((VariableDeclarationScreen)vd).graphicControlType == 19)) {
            throw new GeneralErrorException(75, 4, this.name.getNameToken(), this.name.getName(), this.error);
        }
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 526 || tk.getToknum() == 61) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.objVar = VariableName.getObject(this.tm, this.error, this.parent, this.pc);
            if (this.objVar == null) {
                throw new GeneralErrorException(81, 4, tk, tk.getWord(), this.error);
            }
            if (!this.objVar.getType().getName().equals("com.iscobol.gui.server.CobolGUIJavaBean")) {
                throw new GeneralErrorException(75, 4, this.objVar.getNameToken(), this.objVar.getName(), this.error);
            }
        } else {
            throw new ExpectedFoundException(tk, this.error, "literal");
        }
    }

    private String printToken(Token obj) {
        String Return2 = "";
        if (obj != null) {
            Return2 = obj.getToknum() == 10002 || obj.getToknum() == 10017 ? obj.getCodeFltLiteral(this.tm.getDecimalPointIsComma()) : obj.getWord();
        }
        return Return2;
    }

    private void getInquireObjCode(StringBuffer Return2) {
        Return2.append(this.objVar.getCode());
        Return2.append("=CobolGUIJavaBean.getObjectRef(");
        Return2.append(this.name.getCode());
        Return2.append(");");
        Return2.append(eol);
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.objVar != null) {
            this.getInquireObjCode(Return2);
            return Return2.toString();
        }
        if (this.inquireType == 3 || this.inquireType == 1) {
            Return2.append("ScrFactory.getGUIEnviroment().inquireControl");
        } else if (this.inquireType == 812 || this.inquireType == 2) {
            Return2.append("ScrFactory.getGUIEnviroment().inquireWindow");
        }
        if (this.name != null) {
            Return2.append("(");
            if (this.guictl != null && this.guictl.sa != null) {
                Return2.append(this.guictl.sa.getCodeName(this.name, this.inquireType == 3 || this.inquireType == 812 || this.inquireType == 2));
            } else {
                Return2.append(this.name.getCode());
            }
            if (this.statusVar != null) {
                Return2.append(",");
                Return2.append(this.statusVar.getCode());
            }
            Return2.append(")");
        } else if (this.inquireType == 812) {
            if (this.statusVar != null) {
                Return2.append("Status(");
                Return2.append(this.statusVar.getCode());
            } else {
                Return2.append("(");
            }
            Return2.append(")");
        }
        if (this.inquireType == 373) {
            if (this.guictl != null && this.guictl.sa != null) {
                Return2.append("if (ScrFactory.getGUIEnviroment().getControl(");
                Return2.append(this.guictl.sa.getScreenAttributeLINEPOSITION());
                Return2.append(") != null)" + eol);
                Return2.append(this.parent.getIndent());
                Return2.append("   ScrFactory.getGUIEnviroment().inquireControl(ScrFactory.getGUIEnviroment().getControl(");
                Return2.append(this.guictl.sa.getScreenAttributeLINEPOSITION());
                Return2.append("))");
                Return2.append(this.guictl.getGraphicalScreenCodeTail(this.keyWord, ".get", false, false, true));
            }
        } else if (this.guictl != null) {
            Return2.append(this.guictl.getGraphicalScreenCodeTail(this.keyWord, ".get"));
        }
        if (this.inquireType != 373) {
            if (this.screenLineVar != null || this.screenLineToken != null) {
                Return2.append(".getAtLine(");
                Return2.append(this.printVariableName(this.screenLineVar));
                Return2.append(this.printToken(this.screenLineToken));
                Return2.append(")");
            }
            if (this.screenColumnVar != null || this.screenColumnToken != null) {
                Return2.append(".getAtColumn(");
                Return2.append(this.printVariableName(this.screenColumnVar));
                Return2.append(this.printToken(this.screenColumnToken));
                Return2.append(")");
            }
        }
        if (this.screenAbsLineVar != null) {
            Return2.append(".getScreenLine(");
            Return2.append(this.printVariableName(this.screenAbsLineVar));
            Return2.append(")");
        }
        if (this.screenAbsColumnVar != null) {
            Return2.append(".getScreenColumn(");
            Return2.append(this.printVariableName(this.screenAbsColumnVar));
            Return2.append(")");
        }
        if (this.sizeVar != null) {
            Return2.append(".getColumns(");
            Return2.append(this.printVariableName(this.sizeVar));
            Return2.append(")");
        }
        if (this.linesVar != null) {
            Return2.append(".getLines(");
            Return2.append(this.printVariableName(this.linesVar));
            Return2.append(")");
        }
        if (this.colorVar != null) {
            Return2.append(".getColor(");
            Return2.append(this.printVariableName(this.colorVar));
            Return2.append(")");
        }
        if (this.colorBackVar != null) {
            Return2.append(".getColorBackground(");
            Return2.append(this.printVariableName(this.colorBackVar));
            Return2.append(")");
        }
        if (this.colorForeVar != null) {
            Return2.append(".getColorForeground(");
            Return2.append(this.printVariableName(this.colorForeVar));
            Return2.append(")");
        }
        if (this.classVar != null) {
            Return2.append(".getClassType(");
            Return2.append(this.printVariableName(this.classVar));
            Return2.append(")");
        }
        if (this.titleVar != null) {
            Return2.append(".getTitle(");
            Return2.append(this.printVariableName(this.titleVar));
            Return2.append(")");
        }
        if (this.hintVar != null) {
            Return2.append(".getToolTipText(");
            Return2.append(this.hintVar.getCode());
            Return2.append(")");
        }
        if (this.layoutVar != null) {
            Return2.append(".getDockInfo(");
            Return2.append(this.layoutVar.getCode());
            Return2.append(")");
        }
        for (String propName : this.windowProperties.keySet()) {
            Return2.append(".getWindowProperty(\"" + propName + "\", ");
            Return2.append(this.printVariableName((VariableName)this.windowProperties.get(propName)));
            Return2.append(")");
        }
        if (this.visibleVar != null) {
            Return2.append(".getVisible(");
            Return2.append(this.printVariableName(this.visibleVar));
            Return2.append(")");
        }
        if (this.popupMenuVar != null) {
            Return2.append(".getPopupMenu(");
            Return2.append(this.printVariableName(this.popupMenuVar));
            Return2.append(")");
        }
        if (this.layoutManagerVar != null) {
            Return2.append(".getLayoutManager(");
            Return2.append(this.printVariableName(this.layoutManagerVar));
            Return2.append(")");
        }
        if (this.massUpdateVar != null) {
            Return2.append(".getMassUpdate(");
            Return2.append(this.massUpdateVar.getCode());
            Return2.append(")");
        }
        Return2.append(".endInquire();" + eol);
        if (this.inquireType == 373 && this.guictl != null && this.guictl.sa != null && this.classVar != null) {
            Return2.append(this.parent.getIndent());
            Return2.append("else" + eol);
            Return2.append(this.printVariableName(this.classVar) + ".defaultInitialize();" + eol);
        }
        if (this.child.size() > 0) {
            ListIterator ctlLI = this.child.listIterator(0);
            while (ctlLI.hasNext()) {
                Inquire ctl = (Inquire)ctlLI.next();
                Return2.append(ctl.getCode());
            }
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public void checkPerform() throws GeneralErrorException {
    }

    public void loadInquireControl(GUIControl guictl) throws GeneralErrorException, EndOfProgramException {
        Token tk;
        boolean go = true;
        block5: while (go && (tk = this.tm.getToken()) != null) {
            switch (tk.getToknum()) {
                case 325: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.classVar = this.localVariableNameGet();
                        continue block5;
                    }
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
                case 606: {
                    this.loadJavaBeanRef();
                    continue block5;
                }
                case 742: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 526 || tk.getToknum() == 61) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 10009) {
                        this.statusVar = this.localVariableNameGet();
                        continue block5;
                    }
                    throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
                }
            }
            go = guictl.tokenIsAttrScreen(tk, this.tm);
            this.tm.ungetToken();
        }
    }
}

