/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GeneralErrorInfo;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.LabelNameList;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Goto
extends Verb
implements CobolToken,
ErrorsNumbers {
    public static final String ALTER_PREF = "alter$";
    LabelNameList labels = new LabelNameList();
    int[] toNums;
    VariableName depending;
    private boolean isInDeclaratives;
    private boolean _isVariableTarget;

    public Goto(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        LabelName lbn;
        this.isInDeclaratives = this.pc.inDeclaratives;
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 773) {
            this.tm.ungetToken();
        }
        while ((lbn = LabelName.get(this.parent, this.tm, this.error, this.pc)) != null) {
            this.labels.addItem(lbn);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 400) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 613) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 10009) {
                this.tm.ungetToken();
                this.depending = VariableName.get(this.tm, this.error, this.pc);
            }
        } else {
            this.tm.ungetToken();
        }
        if (this.labels.getItemNum() != 1 && this.labels.getItemNum() > 1) {
            if (this.depending == null) {
                throw new GeneralErrorException(18, 4, this.keyWord, "DEPENDING", this.error);
            }
            if (!this.depending.getVarDecl().isInteger()) {
                throw new GeneralErrorException(46, 4, this.keyWord, this.depending.getName(), this.error);
            }
        }
        if (this.parent.parent.inThread()) {
            throw new GeneralErrorException(142, 4, this.keyWord, "THREAD", this.error);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check() throws GeneralErrorException {
        if (this.labels.getItemNum() == 0) {
            return;
        }
        if (this.isVariableTarget() || this.labels.getItemNum() == 0) {
            this.parent.parent.setHasGoto(null);
        }
        this.toNums = new int[this.labels.getItemNum()];
        int i = 0;
        LabelName lbn = this.labels.getFirst();
        while (lbn != null) {
            if (this.isInDeclaratives) {
                GeneralErrorInfo gi = lbn.check(this.isInDeclaratives);
                if (gi != null) {
                    if (gi.type != 105) throw new GeneralErrorException(gi);
                    gi = lbn.check(false);
                    if (gi != null) {
                        throw new GeneralErrorException(gi);
                    }
                }
            } else {
                lbn.check();
            }
            this.toNums[i] = lbn.getParIdNumber();
            this.parent.parent.setHasGoto(lbn.getParagraph());
            ++i;
            lbn = this.labels.getNext();
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        boolean debug = this.tm.getOptionList().getOption("-d") != null;
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.toNums != null || this.isVariableTarget()) {
            if (this.depending != null) {
                Return2.append("switch (");
                Return2.append(this.depending.getCode());
                Return2.append(".num().intValue()) {");
                Return2.append(eol);
                for (int i = 1; i <= this.toNums.length; ++i) {
                    Return2.append(this.parent.getIndent());
                    Return2.append("case ");
                    Return2.append(i);
                    Return2.append(": ");
                    if (debug) {
                        Paragraph.getDebugExitCode(Return2);
                        Return2.append(" ");
                    }
                    if (this.isInDeclaratives && !this.labels.getAt(i - 1).isInDeclaratives()) {
                        Return2.append("throw new GotoException (");
                        Return2.append(this.toNums[i - 1]);
                        Return2.append(");");
                    } else {
                        Return2.append("return ");
                        Return2.append(this.toNums[i - 1]);
                        Return2.append(";");
                    }
                    Return2.append(eol);
                }
                Return2.append(this.parent.getIndent());
                Return2.append("}");
                Return2.append(eol);
            } else {
                if (this.isVariableTarget() && this.toNums == null) {
                    Return2.append("if(");
                    Return2.append(this.getAlterVarName());
                    Return2.append(" > 0) { ");
                } else {
                    Return2.append("if(true) { ");
                }
                if (debug) {
                    Paragraph.getDebugExitCode(Return2);
                    Return2.append(" ");
                }
                if (this.isInDeclaratives && !this.labels.getAt(0).isInDeclaratives()) {
                    Return2.append("throw new GotoException (");
                    if (this.isVariableTarget()) {
                        Return2.append(this.getAlterVarName());
                    } else {
                        Return2.append(this.toNums[0]);
                    }
                    Return2.append(");");
                } else {
                    Return2.append("return ");
                    if (this.isVariableTarget()) {
                        Return2.append(this.getAlterVarName());
                    } else {
                        Return2.append(this.toNums[0]);
                    }
                    Return2.append(";");
                }
                Return2.append(" }");
                Return2.append(eol);
            }
        } else {
            Return2.append(eol);
        }
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public int[] getToNums() {
        return this.toNums;
    }

    public VariableName getDepending() {
        return this.depending;
    }

    public LabelNameList getLabels() {
        return this.labels;
    }

    public void setVariableTarget() {
        if (!this._isVariableTarget) {
            this._isVariableTarget = true;
            this.pc.addVariableTargetGoto(this);
            this.parent.parent.setHasGoto(true);
        }
    }

    public boolean isVariableTarget() {
        return this._isVariableTarget;
    }

    public String getAlterVarName() {
        if (this.isVariableTarget()) {
            return ALTER_PREF + this.parent.parent.getJavaName();
        }
        return null;
    }
}

