/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Examine
extends Verb
implements CobolToken,
ErrorsNumbers {
    private VariableName source;
    private boolean tallying;
    private boolean replacing;
    static final int E_ALL = 1;
    static final int E_LEADING = 2;
    static final int E_FIRST = 3;
    static final int E_UNTIL_FIRST = 4;
    private int type;
    private Token target;
    private Token replace;
    private boolean hasNational;

    public Examine(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009 && tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.ungetToken();
        this.source = VariableName.get(this.tm, this.error, this.pc);
        if (!this.source.getVarDecl().isUsageDisplay()) {
            throw new GeneralErrorException(68, 4, tk, tk.getWord(), this.error);
        }
        this.setHasNational(this.source);
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 757: {
                this.tallying = true;
                break;
            }
            case 683: {
                this.replacing = true;
                if (!this.source.isSetGetProperty()) break;
                throw new GeneralErrorException(68, 4, this.source.getNameToken(), this.source.getName(), this.error);
            }
            default: {
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 556: {
                this.type = 2;
                break;
            }
            case 10002: {
                if (tk.isFigurativeZero()) {
                    tk = Examine.cloneToken(tk, 10001, "'0'");
                }
            }
            case 10001: {
                if (tk.isAll()) {
                    this.type = 1;
                    tk.setAll(false);
                    this.tm.ungetToken();
                    break;
                }
                throw new UnexpectedTokenException(tk, this.error);
            }
            case 791: {
                tk = this.tm.getToken();
                if (tk.getToknum() == 489) {
                    this.type = 4;
                    break;
                }
                throw new ExpectedFoundException(tk, this.error, "FIRST");
            }
            case 489: {
                if (this.tallying) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                this.type = 3;
                break;
            }
            default: {
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
        this.target = this.tm.getToken();
        if (this.target.getToknum() != 10002 && this.target.getToknum() != 10001) {
            throw new GeneralErrorException(97, 4, this.target, this.target.getWord(), this.error);
        }
        if (this.tallying) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 683) {
                tk = this.tm.getToken();
                if (tk.getToknum() != 312) {
                    throw new ExpectedFoundException(tk, this.error, "BY");
                }
                this.replacing = true;
                this.replace = this.tm.getToken();
                if (this.replace.getToknum() != 10002 && this.replace.getToknum() != 10001) {
                    throw new GeneralErrorException(97, 4, this.replace, this.replace.getWord(), this.error);
                }
            } else {
                this.tm.ungetToken();
            }
        } else {
            tk = this.tm.getToken();
            if (tk.getToknum() == 312) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() != 10002 && tk.getToknum() != 10001) {
                throw new GeneralErrorException(97, 4, this.replace, this.replace.getWord(), this.error);
            }
            this.replace = tk;
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    static Token cloneToken(Token tk, int toknum, String word) {
        Token Return2 = new Token(tk);
        Return2.setToknum(toknum);
        Return2.setWord(word);
        Return2.setAll(tk.isAll());
        return Return2;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.tallying) {
            Return2.append("TALLY.set(");
        }
        Return2.append(this.source.getCode());
        Return2.append(".examine");
        if (!this.hasNational && this.pc.getOption("-b") != null) {
            Return2.append("Byte");
        }
        Return2.append("(");
        Return2.append(this.getCodeLiteral(this.target));
        Return2.append(" , ");
        if (this.replacing) {
            Return2.append(this.getCodeLiteral(this.replace));
            Return2.append(" , ");
            Return2.append(this.type);
            Return2.append(" , ");
            Return2.append(this.tallying);
        } else {
            Return2.append(this.type);
        }
        Return2.append(")");
        if (this.tallying) {
            Return2.append(")");
        }
        Return2.append(";");
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    private void setHasNational(VariableName vn) {
        if (!this.hasNational) {
            VariableDeclaration vd = vn.getVarDecl();
            this.hasNational = vd != null && (vd.isNational() || vd.isPicG());
        }
    }
}

