/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Compute;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.OnSizeError;
import com.iscobol.compiler.OnSizeErrorProvider;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;

public class Divide
extends Verb
implements CobolToken,
ErrorsNumbers,
OnSizeErrorProvider {
    private Token num;
    private VariableName var;
    private Token numDivisor;
    private VariableNameList varDivisorList;
    private Token numDividend;
    private VariableNameList varDividendList;
    private VariableNameList givingList = new VariableNameList();
    private VariableName remainder;
    private OnSizeError ose;
    private boolean giving;
    private boolean into;
    private boolean by;
    private final boolean cfp36 = this.pc.getOption("-cfp36") != null;

    /*
     * Unable to fully structure code
     */
    public Divide(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 10001: {
                if (tk.isNull()) {
                    tk.setZero();
                } else {
                    throw new UnexpectedTokenException(tk, this.error);
                }
            }
            case 10002: 
            case 10017: {
                this.num = tk;
                break;
            }
            case 10009: {
                this.tm.ungetToken();
                this.var = VariableName.getAny(this.tm, this.error, this.pc);
                if (this.var != null && this.var.isNumeric() && !this.var.isEdited()) break;
                throw new GeneralErrorException(109, 4, this.var.getNameToken(), this.var.getName(), this.error);
            }
            default: {
                throw new UnexpectedTokenException(tk, this.error);
            }
        }
        foundBy = false;
        tk = this.tm.getToken();
        switch (tk.getToknum()) {
            case 312: {
                foundBy = true;
                tk = this.tm.getToken();
            }
            case 10001: {
                if (!tk.isNull()) ** GOTO lbl31
                tk.setZero();
                ** GOTO lbl33
lbl31:
                // 1 sources

                if (tk.getToknum() == 10001) {
                    throw new ExpectedFoundException(tk, this.error, "'INTO | BY'");
                }
            }
lbl33:
            // 4 sources

            case 10002: 
            case 10009: 
            case 10017: {
                this.by = true;
                break;
            }
            case 542: {
                tk = this.tm.getToken();
                this.into = true;
                break;
            }
            default: {
                throw new ExpectedFoundException(tk, this.error, "'INTO | BY'");
            }
        }
        varTmp = null;
        numTmp = null;
        varListTmp = new VariableNameList();
        block16: while (true) {
            switch (tk.getToknum()) {
                case 702: {
                    if (varTmp != null) {
                        varTmp.rounded = true;
                        break;
                    }
                    throw new UnexpectedTokenException(tk, this.error);
                }
                case 10002: 
                case 10017: {
                    if (numTmp != null) {
                        throw new UnexpectedTokenException(tk, this.error);
                    }
                    numTmp = tk;
                    break;
                }
                case 10009: {
                    this.tm.ungetToken();
                    varTmp = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 2));
                    if (varTmp != null && varTmp.isNumeric() && !varTmp.isEdited()) {
                        varListTmp.addItem(varTmp);
                        break;
                    }
                    throw new GeneralErrorException(109, 4, varTmp.getNameToken(), varTmp.getName(), this.error);
                }
                default: {
                    break block16;
                }
            }
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 505) {
            this.giving = true;
            tk = this.tm.getToken();
            if (tk.getToknum() == 10009) {
                while (tk.getToknum() == 10009) {
                    this.tm.ungetToken();
                    varTmp = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
                    if (varTmp != null && varTmp.isNumeric()) {
                        this.givingList.addItem(varTmp);
                        tk = this.tm.getToken();
                        if (tk.getToknum() != 702) continue;
                        varTmp.rounded = true;
                        tk = this.tm.getToken();
                        continue;
                    }
                    throw new GeneralErrorException(109, 4, varTmp.getNameToken(), varTmp.getName(), this.error);
                }
                if (varListTmp.getItemNum() > 1) {
                    throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
                }
            } else {
                throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
            }
            if (tk.getToknum() == 679) {
                this.remainder();
            } else if (!foundBy && this.by) {
                throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
            }
            if (varListTmp.getItemNum() > 0) {
                varListTmp.getFirst().setPropTypeGet();
            }
        } else {
            if (numTmp != null) {
                throw new GeneralErrorException(17, 4, numTmp, numTmp.getWord(), this.error);
            }
            if (this.by) {
                throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
            }
            v = varListTmp.getFirst();
            while (v != null) {
                v.checkPropTypeSetGet();
                v = varListTmp.getNext();
            }
            if (tk.getToknum() == 679) {
                this.error.print(302, 3, tk, null);
                this.remainder();
            }
        }
        if (!this.giving && varTmp == null || varListTmp.getItemNum() == 0 && numTmp == null) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        if (this.by) {
            this.numDivisor = numTmp;
            this.varDivisorList = varListTmp;
            this.numDividend = this.num;
            this.varDividendList = new VariableNameList();
            this.varDividendList.addItem(this.var);
        } else {
            this.numDividend = numTmp;
            this.varDividendList = varListTmp;
            this.numDivisor = this.num;
            this.varDivisorList = new VariableNameList();
            this.varDivisorList.addItem(this.var);
        }
        this.tm.ungetToken();
        this.ose = new OnSizeError(kw, par, this, p, t, err);
        tk = this.tm.getToken();
        if (tk.getToknum() != 430) {
            this.tm.ungetToken();
        } else {
            this.endStmt = true;
        }
        if (this.pc.getOption("-wdbz") != null && this.ose.sizeErrorBlock == null && (vn = this.varDivisorList.getFirst()) != null) {
            this.error.print(220, 2, vn.name, vn.name.getWord());
        }
    }

    private void remainder() throws GeneralErrorException, EndOfProgramException {
        if (this.givingList.getItemNum() > 1) {
            throw new GeneralErrorException(11, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10009) {
            this.tm.ungetToken();
            this.remainder = VariableName.getAny(this.tm, this.error, this.parent, this.pc, new GetVarOpts(this, 1));
            if (this.remainder == null || !this.remainder.isNumeric()) {
                throw new GeneralErrorException(109, 4, this.remainder.getNameToken(), this.remainder.getName(), this.error);
            }
        } else {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.tm.getToken();
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    String getDivideEvaluation(boolean couldBenativeInt) {
        StringBuffer Return2 = new StringBuffer();
        if (couldBenativeInt) {
            if (this.giving) {
                if (this.numDividend != null) {
                    Return2.append(Expression.toNum(this.numDividend));
                } else {
                    Return2.append(this.varDividendList.getFirst().getCode());
                }
                Return2.append(" / ");
                if (this.numDivisor != null) {
                    Return2.append(Expression.toNum(this.numDivisor));
                } else {
                    Return2.append(this.varDivisorList.getFirst().getCode());
                }
            } else if (this.var != null) {
                Return2.append(this.var.getCode());
            } else {
                Return2.append(Expression.toNum(this.num));
            }
        } else if (this.giving) {
            if (this.numDividend != null) {
                Return2.append(this.getCodeLiteral(this.numDividend)).append(".num()");
            } else {
                Return2.append(Compute.getCobolNumCode(this.varDividendList.getFirst()));
            }
            if (this.cfp36) {
                Return2.append(".divide36(");
            } else {
                Return2.append(".divide(");
            }
            Return2.append(this.ose.sizeErrorBlock == null);
            Return2.append(",");
            if (this.numDivisor != null) {
                Return2.append(this.getCodeLiteral(this.numDivisor)).append(".num()");
            } else {
                Return2.append(Compute.getCobolNumCode(this.varDivisorList.getFirst()));
            }
            Return2.append(")");
        } else if (this.num != null) {
            Return2.append(this.getCodeLiteral(this.num)).append(".num()");
        } else {
            Return2.append(Compute.getCobolNumCode(this.var));
        }
        return Return2.toString();
    }

    String getRemainderEvaluation(VariableName dest, boolean couldBeNativeInt) {
        StringBuffer Return2 = new StringBuffer();
        if (couldBeNativeInt) {
            String dividend = this.numDividend != null ? Expression.toNum(this.numDividend) : this.varDividendList.getFirst().getCode();
            Return2.append(dividend);
            Return2.append(" - ((");
            Return2.append(dividend);
            Return2.append(" / ");
            String divisor = this.numDivisor != null ? Expression.toNum(this.numDivisor) : this.varDivisorList.getFirst().getCode();
            Return2.append(divisor);
            Return2.append(") * ");
            Return2.append(divisor);
            Return2.append(")");
        } else {
            if (this.numDividend != null) {
                Return2.append(this.getCodeLiteral(this.numDividend)).append(".num()");
            } else {
                Return2.append(Compute.getCobolNumCode(this.varDividendList.getFirst()));
            }
            Return2.append(".remainder(");
            Return2.append(this.ose.sizeErrorBlock == null);
            Return2.append(",");
            if (this.numDivisor != null) {
                Return2.append(this.getCodeLiteral(this.numDivisor)).append(".num()");
            } else {
                Return2.append(Compute.getCobolNumCode(this.varDivisorList.getFirst()));
            }
            Return2.append(",");
            if (dest.isNumericVar()) {
                Return2.append(dest.getCode());
                Return2.append(".scale()");
            } else if (Expression.couldBeNativeInt(dest.getVarDecl())) {
                Return2.append("0");
            } else {
                Return2.append("-1");
            }
            Return2.append(")");
        }
        return Return2.toString();
    }

    boolean isOptimizable() {
        VariableDeclaration vd;
        if (this.into && !this.ose.hasBlocks() && this.givingList.getItemNum() == 0 && this.remainder == null && (this.num != null && this.num.getToknum() == 10002 || this.var != null && (vd = this.var.getVarDecl()).isInteger() && vd.getLogicLen() <= 18)) {
            VariableName vn = this.varDividendList.getFirst();
            while (vn != null) {
                if (vn.rounded || !(vd = vn.getVarDecl()).isInteger() || vd.getLogicLen() > 18) {
                    return false;
                }
                vn = this.varDividendList.getNext();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getCode() {
        int i;
        VariableName vn;
        StringBuffer Return2 = new StringBuffer();
        if (this.isOptimizable()) {
            this.getCodeDebug(Return2);
            VariableName vn2 = this.varDividendList.getFirst();
            while (vn2 != null) {
                Return2.append(this.parent.getIndent());
                Return2.append(vn2.getCode());
                Return2.append(".divideIntoMe(");
                Return2.append(this.ose.sizeErrorBlock == null);
                Return2.append(",");
                if (this.num != null) {
                    Return2.append(this.num.getAsLong());
                } else {
                    Return2.append(this.var.getCode());
                    Return2.append(".tolong()");
                }
                Return2.append(");");
                Return2.append(eol);
                vn2 = this.varDividendList.getNext();
            }
            this.getCodeDebugEnd(Return2);
            return Return2.toString();
        }
        VariableNameList vlDest = this.giving ? this.givingList : (this.into ? this.varDividendList : this.varDivisorList);
        boolean couldBeNativeInt = this.var != null ? Expression.couldBeNativeInt(this.var.getVarDecl()) : false;
        if (couldBeNativeInt && this.giving) {
            couldBeNativeInt = this.into ? (this.numDividend != null ? (couldBeNativeInt &= false) : (couldBeNativeInt &= Expression.couldBeNativeInt(this.varDividendList.getFirst().getVarDecl()))) : (this.numDivisor != null ? (couldBeNativeInt &= false) : (couldBeNativeInt &= Expression.couldBeNativeInt(this.varDivisorList.getFirst().getVarDecl())));
        }
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        String initEval = "";
        if (vlDest.getItemNum() > 1 || this.remainder != null) {
            initEval = "div$" + Divide.getUniqueId();
            if (couldBeNativeInt) {
                Return2.append("long ");
            } else {
                Return2.append("CobolNum ");
            }
            Return2.append(initEval);
            Return2.append("=");
            if (this.remainder != null) {
                Return2.append(this.getRemainderEvaluation(vlDest.getFirst(), couldBeNativeInt));
            } else {
                Return2.append(this.getDivideEvaluation(couldBeNativeInt));
            }
            Return2.append(";");
            Return2.append(eol);
        } else {
            initEval = this.getDivideEvaluation(couldBeNativeInt);
        }
        Return2.append(this.parent.getIndent());
        VariableNameList vlDestPrim = new VariableNameList();
        int i2 = 0;
        while (i2 < vlDest.getItemNum()) {
            vn = vlDest.getAt(i2);
            if (vn.isPrimitive()) {
                vlDestPrim.addItem(vn);
                vlDest.deleteCurrent();
                continue;
            }
            ++i2;
        }
        int n = vlDestPrim.getItemNum();
        for (i = 0; i < n; ++i) {
            String val;
            vn = vlDestPrim.getAt(i);
            Return2.append(vn.getCode());
            String t = vn.getType().getName(true);
            Return2.append(" = ");
            if (this.giving) {
                if (this.remainder != null) {
                    if (couldBeNativeInt) {
                        Return2.append(Compute.addCast(t, this.getDivideEvaluation(true)));
                    } else {
                        Return2.append(Compute.getConversionMethod(t, this.getDivideEvaluation(false)));
                    }
                } else if (couldBeNativeInt) {
                    Return2.append(Compute.addCast(t, initEval));
                } else {
                    Return2.append(Compute.getConversionMethod(t, initEval));
                }
            } else if (this.by) {
                if (Expression.couldBeNativeInt(vn.getVarDecl())) {
                    if (couldBeNativeInt) {
                        Return2.append(Compute.addCast(t, initEval + " / " + vn.getCode()));
                    } else {
                        Return2.append(Compute.getConversionMethod(t, initEval + ".divide(CobolNum.noo((long) " + vn.getCode() + ", 0))"));
                    }
                } else if (couldBeNativeInt) {
                    val = initEval + " / ";
                    val = vn.isNumericVar() ? val + vn.getCode() + ".tolong()" : val + vn.getCode();
                    Return2.append(Compute.addCast(t, val));
                } else {
                    val = initEval + ".divide(";
                    val = vn.isNumericVar() ? val + vn.getCode() + ".num())" : val + "CobolNum.noo((double) " + vn.getCode() + "))";
                    Return2.append(Compute.getConversionMethod(t, val));
                }
            } else if (Expression.couldBeNativeInt(vn.getVarDecl())) {
                if (couldBeNativeInt) {
                    Return2.append(Compute.addCast(t, vn.getCode() + " / " + initEval));
                } else {
                    Return2.append(Compute.getConversionMethod(t, "CobolNum.noo((long) " + vn.getCode() + ", 0).divide(" + initEval + ")"));
                }
            } else if (couldBeNativeInt) {
                val = vn.isNumericVar() ? vn.getCode() + ".tolong()" : vn.getCode();
                val = val + " / " + initEval;
                Return2.append(Compute.addCast(t, val));
            } else {
                val = vn.isNumericVar() ? vn.getCode() + ".num()" : "CobolNum.noo((double) " + vn.getCode() + ")";
                val = val + ".divide(" + initEval + ")";
                Return2.append(Compute.getConversionMethod(t, val));
            }
            Return2.append(";");
            if (i >= n - 1) continue;
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
        }
        n = vlDest.getItemNum();
        if (n > 0) {
            if (vlDestPrim.getItemNum() > 0) {
                Return2.append(eol);
                Return2.append(this.parent.getIndent());
            }
            if (this.ose.sizeErrorBlock != null) {
                Return2.append("if((");
            } else if (this.ose.notSizeErrorBlock != null) {
                Return2.append("if(!(");
            }
            for (i = 0; i < n; ++i) {
                vn = vlDest.getAt(i);
                Return2.append(vn.getCode());
                Return2.append(".set(");
                if (this.giving) {
                    if (this.remainder != null) {
                        if (couldBeNativeInt) {
                            Return2.append("CobolNum.noo(");
                            Return2.append(this.getDivideEvaluation(true));
                            Return2.append(",0)");
                        } else {
                            Return2.append(this.getDivideEvaluation(false));
                        }
                    } else if (couldBeNativeInt) {
                        Return2.append("CobolNum.noo(");
                        Return2.append(initEval);
                        Return2.append(",0)");
                    } else {
                        Return2.append(initEval);
                    }
                } else if (this.by) {
                    if (couldBeNativeInt) {
                        Return2.append("CobolNum.noo(");
                        Return2.append(initEval);
                        Return2.append(",0)");
                    } else {
                        Return2.append(initEval);
                    }
                    if (this.cfp36) {
                        Return2.append(".divide36(");
                    } else {
                        Return2.append(".divide(");
                    }
                    Return2.append(this.ose.sizeErrorBlock == null);
                    Return2.append(",");
                    Return2.append(vn.getCode());
                    Return2.append(".num())");
                } else {
                    Return2.append(vn.getCode());
                    if (this.cfp36) {
                        Return2.append(".num().divide36(");
                    } else {
                        Return2.append(".num().divide(");
                    }
                    Return2.append(this.ose.sizeErrorBlock == null);
                    Return2.append(",");
                    if (couldBeNativeInt) {
                        Return2.append("CobolNum.noo(");
                        Return2.append(initEval);
                        Return2.append(",0)");
                    } else {
                        Return2.append(initEval);
                    }
                    Return2.append(")");
                }
                Return2.append(",");
                Return2.append(vn.rounded);
                Return2.append(",");
                Return2.append(this.ose.hasBlocks());
                Return2.append(")");
                if (i >= n - 1) break;
                if (this.ose.hasBlocks()) {
                    Return2.append("|");
                    continue;
                }
                Return2.append(";");
            }
        }
        if (this.remainder != null) {
            if (n > 0) {
                if (this.ose.hasBlocks()) {
                    Return2.append(" || ");
                } else {
                    Return2.append(";" + eol + this.parent.getIndent());
                }
            } else {
                Return2.append(eol + this.parent.getIndent());
            }
            Return2.append(this.remainder.getCode());
            if (this.remainder.isPrimitive()) {
                String t = this.remainder.getType().getName(true);
                Return2.append(" = ");
                if (couldBeNativeInt) {
                    Return2.append(Compute.addCast(t, initEval));
                } else {
                    Return2.append(Compute.getConversionMethod(t, initEval));
                }
                Return2.append(";");
            } else {
                Return2.append(".set(");
                Return2.append(initEval);
                if (couldBeNativeInt) {
                    Return2.append(",0");
                }
                Return2.append(",false,");
                Return2.append(this.ose.hasBlocks());
                Return2.append(")");
                if (this.ose.sizeErrorBlock == null && this.ose.notSizeErrorBlock == null) {
                    Return2.append(";");
                }
            }
        }
        if (this.ose.hasBlocks() && (this.remainder == null || !this.remainder.isPrimitive())) {
            Return2.append("))");
            if (this.ose.sizeErrorBlock != null) {
                Return2.append(this.ose.sizeErrorBlock.getCode());
                if (this.ose.notSizeErrorBlock != null) {
                    Return2.append(" else ");
                    Return2.append(this.ose.notSizeErrorBlock.getCode());
                }
            } else if (this.ose.notSizeErrorBlock != null) {
                Return2.append(this.ose.notSizeErrorBlock.getCode());
            }
        } else if (this.remainder == null && n > 0) {
            Return2.append(";");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    @Override
    public OnSizeError getOnSizeError() {
        return this.ose;
    }

    public VariableNameList getVarDivisorList() {
        return this.varDivisorList;
    }

    public VariableNameList getVarDividendList() {
        return this.varDividendList;
    }

    public VariableNameList getVarGivingList() {
        return this.givingList;
    }

    public VariableName getRemainder() {
        return this.remainder;
    }

    public Token getNumDivisor() {
        return this.numDivisor;
    }

    public Token getNumDividend() {
        return this.numDividend;
    }
}

