/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.BlockException;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.Evaluate;
import com.iscobol.compiler.EvaluateSuObject;
import com.iscobol.compiler.If;
import com.iscobol.compiler.NextSentence;
import com.iscobol.compiler.NextSentenceBlock;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Perform;
import com.iscobol.compiler.Search;
import com.iscobol.compiler.Try;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class DeferredBlock {
    static final String eol = CobolToken.eol;
    private String name;
    private VerbList verbs;
    private Evaluate evaluate;
    private int evaluateOptimCode;
    private String evaluateVar;
    private Set evaluateLabels;
    private int startIndex;
    private boolean modStatic;
    private boolean modPrivate;
    private Paragraph parent;

    public DeferredBlock(String name, boolean modStatic, boolean modPrivate, Paragraph parent) {
        this.name = name;
        this.modStatic = modStatic;
        this.modPrivate = modPrivate;
        this.parent = parent;
    }

    public void setEvaluate(Evaluate evaluate, int startIndex) {
        this.setEvaluate(evaluate, startIndex, 0, null, null);
    }

    public void setEvaluate(Evaluate evaluate, int startIndex, int optCode, String evaluateVar, Set labels) {
        this.evaluate = evaluate;
        this.startIndex = startIndex;
        this.evaluateOptimCode = optCode;
        this.evaluateVar = evaluateVar;
        this.evaluateLabels = labels;
    }

    public void setVerbs(VerbList verbs, int startIndex) {
        this.verbs = verbs;
        this.evaluate = null;
        this.startIndex = startIndex;
    }

    public String getCode() {
        VariableName vn;
        int deferredMethodId;
        Verb parentVerb;
        Block parentBlock;
        StringBuffer Return2 = new StringBuffer();
        Return2.append("   ");
        if (this.modStatic) {
            Return2.append("static ");
        }
        if (this.modPrivate) {
            Return2.append("private ");
        }
        Return2.append("int ");
        Return2.append(this.name);
        Return2.append(" (");
        NextSentenceBlock nsb = this.parent.getActNextSentence();
        if (this.evaluate != null) {
            parentBlock = null;
            parentVerb = this.evaluate;
            deferredMethodId = this.evaluate.getObjectSet().getAt(this.startIndex).getDeferredMethodId();
        } else {
            parentBlock = this.verbs.getFirst().getParent();
            parentVerb = parentBlock.getParentVerb();
            deferredMethodId = this.verbs.getAt(this.startIndex).getDeferredMethodId();
        }
        StringBuffer args = new StringBuffer();
        if (nsb != null && nsb.getEnd().getDeferredMethodId() == deferredMethodId) {
            args.append("boolean breakNS");
        }
        if (this.evaluate != null) {
            if (this.evaluateOptimCode == 0) {
                VerbList evSbjs = this.evaluate.getSubjectSet();
                Verb sbj = evSbjs.getFirst();
                while (sbj != null) {
                    if (((EvaluateSuObject)sbj).boolVar != null) {
                        if (args.length() > 0) {
                            args.append(',');
                        }
                        args.append("boolean " + ((EvaluateSuObject)sbj).boolVar);
                    }
                    sbj = evSbjs.getNext();
                }
            } else {
                if (args.length() > 0) {
                    args.append(',');
                }
                if (this.evaluateOptimCode == 1) {
                    args.append("int ");
                } else {
                    args.append("String ");
                }
                args.append(this.evaluateVar);
            }
        }
        if (parentBlock instanceof BlockException) {
            if (args.length() > 0) {
                args.append(',');
            }
            args.append(((BlockException)parentBlock).excpt.getName() + " " + parentBlock.getParentExceptName());
        }
        Return2.append(args);
        Return2.append(")");
        LinkedHashSet<String> throwList = new LinkedHashSet<String>();
        VariableNameList raising = this.parent.procedure.raising;
        if (raising != null) {
            vn = raising.getFirst();
            while (vn != null) {
                throwList.add(vn.getType().getName());
                vn = raising.getNext();
            }
        }
        Block blk = parentBlock;
        Verb v = parentVerb;
        while (v != null) {
            Try tr;
            if (v instanceof Try && (tr = (Try)v).getTryBlock() == blk) {
                Vector catchClasses = tr.getCatchClasses();
                for (int i = 0; i < catchClasses.size(); ++i) {
                    vn = (VariableName)catchClasses.elementAt(i);
                    throwList.add(vn.getType().getName());
                }
                if (tr.hasDefaultException()) {
                    throwList.add("java.lang.Exception");
                }
            }
            blk = v.getParent();
            v = blk.getParentVerb();
        }
        throwList.add("GotoException");
        Iterator it = throwList.iterator();
        Return2.append(" throws " + it.next());
        while (it.hasNext()) {
            Return2.append("," + it.next());
        }
        Return2.append(" {");
        Return2.append(eol);
        Pcc pc = this.parent.getPcc();
        if (pc.data != null) {
            if (pc.data.lsSec != null) {
                Return2.append("   ");
                pc.getLocalStorageCode(Return2);
            }
            if (pc.data.tlsSec != null) {
                Return2.append("   ");
                pc.getThreadLocalStorageCode(Return2);
            }
        }
        if (nsb != null && nsb.getEnd().getDeferredMethodId() == deferredMethodId) {
            Return2.append("      " + this.parent.getActNextSentence().getName() + ": {").append(eol);
            Return2.append("         if (breakNS) {").append(eol);
            Return2.append("            break " + nsb.getName() + ";").append(eol);
            Return2.append("         }").append(eol);
        }
        boolean printReturn = true;
        if (this.evaluate != null) {
            this.evaluate.setDeferredMethodId(deferredMethodId);
            if (this.evaluateOptimCode == 0) {
                this.evaluate.getCode(Return2, this.startIndex);
            } else {
                Return2.append("      switch(");
                Return2.append(this.evaluateVar);
                Return2.append(") {");
                Return2.append(eol);
                Return2.append(this.evaluate.getParent().getIndent());
                boolean emptyBlock = false;
                VerbList obs = this.evaluate.getObjectSet();
                if (this.startIndex > 0) {
                    EvaluateSuObject ob = (EvaluateSuObject)obs.getAt(this.startIndex - 1);
                    emptyBlock = ob.getBlock() != null && ob.getBlock().isEmpty();
                }
                this.evaluate.writeCases(Return2, this.evaluateOptimCode == 3, this.startIndex, this.evaluateVar, emptyBlock, true, this.evaluateLabels);
                Return2.append("      }");
                Return2.append(eol);
            }
        } else {
            for (int index = this.startIndex; index < this.verbs.getItemNum(); ++index) {
                v = this.verbs.getAt(index);
                if (v.getDeferredMethodId() > deferredMethodId) {
                    if (v instanceof NextSentenceBlock) {
                        Return2.append(v.getCode());
                        continue;
                    }
                    DeferredBlock db = this.parent.getDeferredBlock(v.getDeferredMethodId());
                    db.setVerbs(this.verbs, index);
                    this.parent.deferredBlockList.add(db);
                    Return2.append(db.getCallCode(deferredMethodId) + eol);
                    printReturn = false;
                    break;
                }
                DeferredBlock.setNextSentenceDeferredMethodName(v, this.parent, deferredMethodId);
                Return2.append(v.getCode());
            }
        }
        if (printReturn) {
            Return2.append("      return 0;");
            Return2.append(eol);
        }
        Return2.append("   }");
        Return2.append(eol);
        return Return2.toString();
    }

    public String getCallCode(int callerDeferredMethodId) {
        return this.getCallCode(callerDeferredMethodId, false, false);
    }

    public String getCallCode(int callerDeferredMethodId, boolean debug, boolean pt0_2) {
        int blockDeferredMethodId;
        Verb pv;
        Block parentBlock;
        StringBuffer Return2 = new StringBuffer();
        if (this.evaluate != null) {
            parentBlock = null;
            pv = this.evaluate;
            blockDeferredMethodId = this.evaluate.getObjectSet().getAt(this.startIndex).getDeferredMethodId();
        } else {
            parentBlock = this.verbs.getFirst().getParent();
            pv = parentBlock.getParentVerb();
            blockDeferredMethodId = this.verbs.getAt(this.startIndex).getDeferredMethodId();
        }
        NextSentenceBlock nsb = this.parent.getActNextSentence();
        String varname = "ret$" + Verb.getUniqueId();
        Return2.append("         int " + varname + " = " + this.name + "(");
        StringBuffer args = new StringBuffer();
        if (nsb != null && nsb.getEnd().getDeferredMethodId() == blockDeferredMethodId) {
            args.append("false");
        }
        if (this.evaluate != null) {
            if (this.evaluateOptimCode == 0) {
                VerbList evSbjs = this.evaluate.getSubjectSet();
                Verb sbj = evSbjs.getFirst();
                while (sbj != null) {
                    if (((EvaluateSuObject)sbj).boolVar != null) {
                        if (args.length() > 0) {
                            args.append(',');
                        }
                        args.append(((EvaluateSuObject)sbj).boolVar);
                    }
                    sbj = evSbjs.getNext();
                }
            } else {
                if (args.length() > 0) {
                    args.append(',');
                }
                args.append(this.evaluateVar);
            }
        }
        if (parentBlock != null && parentBlock.isExceptionBlock()) {
            if (args.length() > 0) {
                args.append(',');
            }
            args.append(parentBlock.getParentExceptName());
        }
        Return2.append(args);
        Return2.append(");").append(eol);
        if (nsb != null && nsb.getEnd().getDeferredMethodId() <= callerDeferredMethodId) {
            Return2.append("         if (" + varname + " == " + -3 + ") {" + eol);
            if (nsb.getEnd().getDeferredMethodId() == callerDeferredMethodId) {
                Return2.append("            break " + nsb.getName() + ";" + eol);
            } else {
                Return2.append("            return " + varname + ";").append(eol);
            }
            Return2.append("         } else {" + eol);
        }
        if (pv == null || pv.getDeferredMethodId() != callerDeferredMethodId) {
            String rc = varname;
            if (callerDeferredMethodId == 0) {
                rc = rc + " != -4 ? " + varname + " : 0";
            }
            if (pv == null) {
                if (debug || pt0_2) {
                    if (pt0_2) {
                        Return2.append("      if (" + varname + " == " + -4 + ")").append(eol);
                        Return2.append("         return 0;").append(eol);
                        Return2.append("      else if (" + varname + " != 0)").append(eol);
                        Return2.append("         return " + varname + ";").append(eol);
                    }
                    if (debug) {
                        Return2.append("      if (" + varname + " != " + -4 + " && " + varname + " <= 0)").append(eol);
                        Return2.append("      ");
                        Paragraph.getDebugExitCode(Return2);
                        Return2.append(eol);
                    }
                    if (pt0_2) {
                        this.parent.getExitCode(Return2, varname);
                    } else if (callerDeferredMethodId == 0) {
                        Return2.append("         return " + rc + ";").append(eol);
                        Return2.append("      }").append(eol);
                    }
                } else {
                    Return2.append("         return " + rc + ";").append(eol);
                    if (callerDeferredMethodId == 0) {
                        Return2.append("      }").append(eol);
                    }
                }
            } else {
                Return2.append("         return " + rc + ";").append(eol);
            }
        } else {
            Verb parentVerb = pv;
            while (parentVerb != null && !(parentVerb instanceof Perform)) {
                parentVerb = parentVerb.getParent().getParentVerb();
            }
            int performDeferredMethodId = parentVerb != null ? parentVerb.getDeferredMethodId() : -1;
            String Else = "";
            if (performDeferredMethodId >= 0) {
                String s = this.parent.getActPerf();
                String label = s == null ? "" : " " + s;
                Return2.append("      if (" + varname + " == " + -1 + ")").append(eol);
                if (performDeferredMethodId == callerDeferredMethodId) {
                    Return2.append("         break" + label + ";").append(eol);
                } else {
                    Return2.append("         return " + varname + ";").append(eol);
                }
                Return2.append("      else if (" + varname + " == " + -2 + ")").append(eol);
                if (performDeferredMethodId == callerDeferredMethodId) {
                    Return2.append("         continue" + label + ";").append(eol);
                } else {
                    Return2.append("         return " + varname + ";").append(eol);
                }
                Else = "else ";
            }
            if (callerDeferredMethodId == 0) {
                Return2.append("      " + Else + "if (" + varname + " == " + -4 + ")").append(eol);
                Return2.append("         return 0;").append(eol);
                Else = "else ";
            }
            if (nsb != null && nsb.getEnd().getDeferredMethodId() > callerDeferredMethodId) {
                Return2.append("      " + Else + "if (" + varname + " == " + -3 + ")").append(eol);
                Return2.append("         return " + this.parent.getDeferredBlock(nsb.getEnd().getDeferredMethodId()).getName() + "(true);").append(eol);
                Else = "else ";
            }
            Return2.append("      " + Else + "if (" + varname + " != 0)").append(eol);
            Return2.append("         return " + varname + ";").append(eol);
        }
        if (nsb != null && nsb.getEnd().getDeferredMethodId() <= callerDeferredMethodId) {
            Return2.append("         }" + eol);
        }
        return Return2.toString();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static void setNextSentenceDeferredMethodName(Verb v, Paragraph parent, int deferredMethodId) {
        NextSentence ns = v instanceof If ? ((If)v).getNextSentence() : (v instanceof Search ? ((Search)v).getNextSentence() : null);
        if (ns != null) {
            int nsEndId = ns.getNextSentenceBlock().getEnd().getDeferredMethodId();
            if (nsEndId > deferredMethodId) {
                DeferredBlock df = parent.getDeferredBlock(nsEndId);
                if (df != null) {
                    ns.setDeferredMethodName(df.getName());
                }
            } else if (nsEndId < deferredMethodId) {
                ns.setExitFromDeferredMethod(true);
            }
        }
    }
}

