/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.CondElement;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.SimpleCondition;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;

public class Condition
extends Verb
implements CobolToken,
ErrorsNumbers {
    VerbList allItems = new VerbList();
    int openPar;
    private Expression lastLeft;
    int lastOp = 14;
    boolean fullCondition;

    public Condition(Expression left, boolean not, Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        SimpleCondition s = new SimpleCondition(left, not, kw, par, p, t, err);
        this.setLastLeft(s.left);
        this.lastOp = s.op;
        this.allItems.addItem(s);
        this.fullCondition = s.isFullCondition();
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 274 || tk.getToknum() == 617) {
            this.allItems.addItem(new CondElement(tk, this.parent, this.pc, this.tm, this.error));
            this.init();
        } else {
            this.tm.ungetToken();
        }
    }

    public Condition(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.init();
    }

    private void init() throws GeneralErrorException, EndOfProgramException {
        while (this.fullCondition = this.parseCond()) {
            Token tk = null;
            while (this.openPar > 0 && (tk = this.tm.getToken()).getToknum() == 41) {
                this.allItems.addItem(new CondElement(new Token(')', this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()), this.parent, this.pc, this.tm, this.error));
                --this.openPar;
            }
            if (tk == null || tk.getToknum() == 41) {
                tk = this.tm.getToken();
            }
            if (tk.getToknum() == 274 || tk.getToknum() == 617) {
                this.allItems.addItem(new CondElement(tk, this.parent, this.pc, this.tm, this.error));
                continue;
            }
            this.tm.ungetToken();
            break;
        }
        if (this.openPar != 0) {
            throw new GeneralErrorException(44, 4, this.keyWord, this.keyWord.getWord(), this.error);
        }
    }

    void setLastLeft(Expression e) {
        this.lastLeft = e.getType() != 1 || e.isObjectReference() ? e : null;
    }

    public boolean parseCond() throws GeneralErrorException, EndOfProgramException {
        Token tk;
        int lOpenPar = 0;
        int[] aOpenPar = new int[1];
        while ((tk = this.tm.getToken()).getToknum() == 40 || tk.getToknum() == 598) {
            if (tk.getToknum() == 598) {
                Token tk2 = this.tm.getToken();
                this.tm.ungetToken();
                if (SimpleCondition.isBinaryOperator(tk2)) break;
                while (lOpenPar > 0) {
                    this.allItems.addItem(new CondElement(new Token('(', this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()), this.parent, this.pc, this.tm, this.error));
                    ++this.openPar;
                    --lOpenPar;
                }
                this.allItems.addItem(new CondElement(tk, this.parent, this.pc, this.tm, this.error));
                continue;
            }
            ++lOpenPar;
        }
        this.tm.ungetToken();
        aOpenPar[0] = lOpenPar;
        SimpleCondition s = new SimpleCondition(aOpenPar, this.lastLeft, this.lastOp, this.keyWord, this.parent, this.pc, this.tm, this.error);
        VariableName vn = null;
        if (s.getLeft() != null && s.getRight() != null) {
            if (this.isVarLenGroup(s.getLeft())) {
                if (!this.isVarLenGroup(s.getRight())) {
                    vn = s.getLeft().getAsVar();
                }
            } else if (this.isVarLenGroup(s.getRight()) && !this.isVarLenGroup(s.getLeft())) {
                vn = s.getRight().getAsVar();
            }
        }
        if (vn != null) {
            this.error.print(257, 2, vn.getNameToken(), vn.getName());
        }
        if ((lOpenPar = aOpenPar[0]) > 0) {
            while (lOpenPar > 0) {
                this.allItems.addItem(new CondElement(new Token('(', this.keyWord.getFLN(), this.keyWord.getOffset(), this.keyWord.getFileName()), this.parent, this.pc, this.tm, this.error));
                ++this.openPar;
                --lOpenPar;
            }
        }
        this.setLastLeft(s.left);
        this.lastOp = s.op;
        this.allItems.addItem(s);
        return s.isFullCondition();
    }

    private boolean isVarLenGroup(Expression exp) {
        VariableName vn = exp.getAsVar();
        return vn != null && vn.isVariableLengthGroup();
    }

    public boolean isFullCondition() {
        return this.fullCondition;
    }

    public Expression getLeft() {
        return ((SimpleCondition)this.allItems.getFirst()).left;
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Verb v = this.allItems.getFirst();
        while (v != null) {
            Return2.append(v.getCode());
            v = this.allItems.getNext();
        }
        return Return2.toString();
    }

    @Override
    public void check() throws GeneralErrorException {
        Verb v = this.allItems.getFirst();
        while (v != null) {
            v.check();
            v = this.allItems.getNext();
        }
    }

    public VerbList getAllItems() {
        return this.allItems;
    }
}

