/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Goto;
import com.iscobol.compiler.LabelName;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.Verb;
import com.iscobol.compiler.VerbList;
import java.util.ArrayList;
import java.util.List;

public class Alter
extends Verb
implements CobolToken,
ErrorsNumbers {
    private final List alterElements;

    public Alter(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        LabelName thingToAlter;
        if (!(this.pc instanceof CobolProgram)) {
            throw new GeneralErrorException(194, 4, this.keyWord, null, this.error);
        }
        this.error.print(194, 1, kw, null);
        this.alterElements = new ArrayList();
        while ((thingToAlter = LabelName.get(this.parent, this.tm, this.error, this.pc)) != null) {
            LabelName newTarget;
            if (this.tm.getToken().getToknum() != 773) {
                this.tm.ungetToken();
            }
            if (this.tm.getToken().getToknum() == 650) {
                if (this.tm.getToken().getToknum() != 773) {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
            }
            if ((newTarget = LabelName.get(this.parent, this.tm, this.error, this.pc)) == null) {
                throw new GeneralErrorException(144, 4, this.keyWord, thingToAlter.toString(), this.error);
            }
            this.alterElements.add(new AlterElement(thingToAlter, newTarget));
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        for (AlterElement ae : this.alterElements) {
            LabelName thingToAlter = ae.getThingToAlter();
            LabelName newTarget = ae.getNewTarget();
            thingToAlter.check();
            newTarget.check();
            VerbList verbs = thingToAlter.getParagraph().getBlock().getVerbs();
            if (verbs.getItemNum() != 1) {
                throw new GeneralErrorException(315, 4, this.keyWord, thingToAlter.getParagraph().getName(), this.error);
            }
            Verb v = verbs.getFirst();
            if (!(v instanceof Goto)) {
                throw new GeneralErrorException(315, 4, this.keyWord, thingToAlter.getParagraph().getName(), this.error);
            }
            ae.theGoto = (Goto)v;
            if (ae.theGoto.getDepending() != null) {
                throw new GeneralErrorException(315, 4, this.keyWord, thingToAlter.getParagraph().getName(), this.error);
            }
            ae.theGoto.setVariableTarget();
        }
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        boolean debug = this.tm.getOptionList().getOption("-d") != null;
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        for (AlterElement ae : this.alterElements) {
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
            Return2.append(ae.theGoto.getAlterVarName());
            Return2.append("=");
            Return2.append(ae.newTarget.getParIdNumber());
            Return2.append(";");
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public List getAlterElements() {
        return this.alterElements;
    }

    public static class AlterElement {
        private final LabelName thingToAlter;
        private final LabelName newTarget;
        private Goto theGoto;

        public AlterElement(LabelName thingToAlter, LabelName newTarget) {
            this.thingToAlter = thingToAlter;
            this.newTarget = newTarget;
        }

        public LabelName getThingToAlter() {
            return this.thingToAlter;
        }

        public LabelName getNewTarget() {
            return this.newTarget;
        }
    }
}

