/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.browser.jx;

import com.iscobol.gui.client.PicobolWidget;
import com.iscobol.gui.client.swing.CobolEvent;
import com.iscobol.gui.client.swing.CobolEventListener;
import com.iscobol.gui.client.swing.PicobolWebBrowser;
import com.iscobol.gui.client.swing.SearchKeyEvent;
import com.iscobol.gui.client.swing.SearchKeyEventListener;
import com.iscobol.rts.FindDialog;
import com.teamdev.jxbrowser.browser.Browser;
import com.teamdev.jxbrowser.browser.SavePageType;
import com.teamdev.jxbrowser.browser.callback.StartDownloadCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressKeyCallback;
import com.teamdev.jxbrowser.browser.callback.input.PressMouseCallback;
import com.teamdev.jxbrowser.browser.event.StatusChanged;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.download.Download;
import com.teamdev.jxbrowser.download.event.DownloadCanceled;
import com.teamdev.jxbrowser.download.event.DownloadFinished;
import com.teamdev.jxbrowser.download.event.DownloadInterrupted;
import com.teamdev.jxbrowser.download.event.DownloadUpdated;
import com.teamdev.jxbrowser.engine.Engine;
import com.teamdev.jxbrowser.engine.EngineOptions;
import com.teamdev.jxbrowser.engine.RenderingMode;
import com.teamdev.jxbrowser.frame.EditorCommand;
import com.teamdev.jxbrowser.frame.Frame;
import com.teamdev.jxbrowser.navigation.Navigation;
import com.teamdev.jxbrowser.navigation.callback.StartNavigationCallback;
import com.teamdev.jxbrowser.navigation.event.NavigationFinished;
import com.teamdev.jxbrowser.navigation.event.NavigationRedirected;
import com.teamdev.jxbrowser.navigation.event.NavigationStarted;
import com.teamdev.jxbrowser.navigation.event.NavigationStopped;
import com.teamdev.jxbrowser.search.FindOptions;
import com.teamdev.jxbrowser.ui.MouseButton;
import com.teamdev.jxbrowser.ui.Progress;
import com.teamdev.jxbrowser.ui.event.KeyPressed;
import com.teamdev.jxbrowser.ui.event.MousePressed;
import com.teamdev.jxbrowser.view.swing.BrowserView;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JXWebBrowser
extends JPanel
implements PicobolWidget,
PicobolWebBrowser,
FindDialog.FindListener {
    private static final long serialVersionUID = 1L;
    private Engine engine;
    private Browser browser;
    private BrowserView browserComponent;
    private URL url;
    private String beforeNavigateUrl;
    private String fileName;
    private boolean noMsgBeforeNavigate;
    private boolean startNavigationCbEnabled = true;
    private boolean activeAccept;
    private boolean selfAct;
    private String statusText;
    private String progress;
    private Map<String, String> attributes;
    private Vector<CobolEventListener> listeners = new Vector();
    private Vector<SearchKeyEventListener> searchListeners = new Vector();
    private FindDialog findDialog;

    public JXWebBrowser() {
        this((Map<String, String>)null);
    }

    public JXWebBrowser(Map<String, String> attributes) {
        this.attributes = attributes;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.setLayout(new BorderLayout());
        this.createBrowser();
    }

    private void createBrowser() {
        String userAgent;
        String dataDir;
        String chromiumSwitches;
        String chromiumDir;
        EngineOptions.Builder builder = EngineOptions.newBuilder((RenderingMode)RenderingMode.HARDWARE_ACCELERATED);
        String licenseKey = this.attributes.get("licenseKey");
        if (licenseKey != null) {
            builder = builder.licenseKey(licenseKey);
            System.setProperty("jxbrowser.license.key", licenseKey);
        }
        if ((chromiumDir = this.attributes.get("chromiumDir")) != null) {
            builder = builder.chromiumDir(new File(chromiumDir).toPath());
        }
        if ((chromiumSwitches = this.attributes.get("chromiumSwitches")) != null) {
            for (String sw : chromiumSwitches.split("\\,")) {
                builder = builder.addSwitch(sw);
            }
        }
        if ((dataDir = this.attributes.get("dataDir")) != null) {
            builder = builder.userDataDir(new File(dataDir).toPath());
        }
        if ((userAgent = this.attributes.get("userAgent")) != null) {
            builder = builder.userAgent(userAgent);
        }
        EngineOptions opts = builder.build();
        this.engine = Engine.newInstance((EngineOptions)opts);
        this.browser = this.engine.newBrowser();
        this.browserComponent = BrowserView.newInstance((Browser)this.browser);
        this.browser.set(StartDownloadCallback.class, (Callback)((StartDownloadCallback)(params, action) -> {
            File selectedFile;
            Download download = params.download();
            download.on(DownloadFinished.class, event -> {
                this.progress = "100";
                this.pushEvent(16432);
            });
            download.on(DownloadInterrupted.class, event -> {
                this.progress = "0";
                this.pushEvent(16432);
            });
            download.on(DownloadCanceled.class, event -> {
                this.progress = "0";
                this.pushEvent(16432);
            });
            download.on(DownloadUpdated.class, event -> {
                this.progress = Integer.toString(event.progress().isPresent() ? Math.round(((Progress)event.progress().get()).value()) : 0);
                this.pushEvent(16433);
            });
            JFileChooser jfc = new JFileChooser();
            jfc.setSelectedFile(new File(params.download().target().suggestedFileName()));
            if (jfc.showSaveDialog(this) == 0 && (selectedFile = jfc.getSelectedFile()) != null) {
                action.download(selectedFile.toPath());
            }
        }));
        this.browser.on(TitleChanged.class, event -> this.pushEvent(16435));
        this.browser.on(StatusChanged.class, event -> {
            this.statusText = event.statusText();
            this.pushEvent(16434);
        });
        Navigation navigation = this.browser.navigation();
        navigation.set(StartNavigationCallback.class, (Callback)((StartNavigationCallback)params -> {
            if (!this.startNavigationCbEnabled) {
                this.startNavigationCbEnabled = true;
                return StartNavigationCallback.Response.start();
            }
            if (params.isMainFrame()) {
                if (params.url().startsWith("chrome-extension://")) {
                    return StartNavigationCallback.Response.start();
                }
                if (this.noMsgBeforeNavigate) {
                    this.pushEvent(16431);
                    return StartNavigationCallback.Response.start();
                }
                if (this.beforeNavigateUrl != null) {
                    this.beforeNavigateUrl = null;
                    return StartNavigationCallback.Response.start();
                }
                this.beforeNavigateUrl = params.url();
                this.pushEvent(16429);
                return StartNavigationCallback.Response.ignore();
            }
            return StartNavigationCallback.Response.start();
        }));
        navigation.on(NavigationStarted.class, evt -> this.pushEvent(16432));
        navigation.on(NavigationStopped.class, evt -> {
            this.setURL();
            this.pushEvent(16430);
        });
        navigation.on(NavigationFinished.class, evt -> {
            this.setURL();
            this.pushEvent(16430);
        });
        navigation.on(NavigationRedirected.class, evt -> this.pushEvent(16432));
        this.browser.set(PressKeyCallback.class, (Callback)((PressKeyCallback)params -> {
            boolean issearchkey = false;
            KeyPressed kp = params.event();
            for (SearchKeyEventListener s : this.searchListeners) {
                try {
                    issearchkey = s.isSearchKeyEvent(new SearchKeyEvent(this, kp.keyChar(), kp.keyModifiers().isShiftDown(), kp.keyModifiers().isControlDown(), kp.keyModifiers().isAltDown()));
                }
                catch (Exception exception) {}
            }
            if (issearchkey) {
                SwingUtilities.invokeLater(() -> this.find());
            }
            if (kp.keyModifiers().isControlDown()) {
                switch (kp.keyCode()) {
                    case KEY_CODE_C: {
                        this.copySelection();
                        break;
                    }
                }
            }
            return PressKeyCallback.Response.proceed();
        }));
        if (!JPopupMenu.getDefaultLightWeightPopupEnabled()) {
            this.addPopupMenu();
        }
        this.add((Component)this.browserComponent, "Center");
    }

    private void addPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem item = new JMenuItem("Reload");
        item.addActionListener(e -> this.refresh());
        popup.add(item);
        popup.add(new JPopupMenu.Separator());
        item = new JMenuItem("Back");
        item.addActionListener(e -> {
            if (this.canGoBack()) {
                this.back();
            }
        });
        popup.add(item);
        JMenuItem backItem = item;
        item = new JMenuItem("Forward");
        item.addActionListener(e -> {
            if (this.canGoForward()) {
                this.forward();
            }
        });
        popup.add(item);
        JMenuItem forwardItem = item;
        popup.add(new JPopupMenu.Separator());
        item = new JMenuItem("Copy");
        item.addActionListener(e -> this.copySelection());
        popup.add(item);
        item = new JMenuItem("Select All");
        item.addActionListener(e -> this.selectAll());
        popup.add(item);
        popup.add(new JPopupMenu.Separator());
        item = new JMenuItem("Find");
        item.addActionListener(e -> this.find());
        popup.add(item);
        popup.add(new JPopupMenu.Separator());
        item = new JMenuItem("Print");
        item.addActionListener(e -> this.print());
        popup.add(item);
        item = new JMenuItem("Save As");
        item.addActionListener(e -> this.saveAs(true));
        popup.add(item);
        this.browser.set(PressMouseCallback.class, (Callback)((PressMouseCallback)params -> {
            MousePressed mp = params.event();
            if (mp.button() == MouseButton.SECONDARY) {
                SwingUtilities.invokeLater(() -> {
                    backItem.setEnabled(this.canGoBack());
                    forwardItem.setEnabled(this.canGoForward());
                    popup.show((Component)this.browserComponent, mp.location().x(), mp.location().y());
                });
            }
            return PressMouseCallback.Response.proceed();
        }));
    }

    private void find() {
        JFrame ownerFrame = null;
        JDialog ownerDialog = null;
        for (Container cnt = this.getParent(); cnt != null; cnt = cnt.getParent()) {
            if (cnt instanceof JFrame) {
                ownerFrame = (JFrame)cnt;
                break;
            }
            if (!(cnt instanceof JDialog)) continue;
            ownerDialog = (JDialog)cnt;
            break;
        }
        if (this.findDialog == null) {
            this.findDialog = ownerFrame != null ? new FindDialog(ownerFrame, "Find", false, false) : (ownerDialog != null ? new FindDialog(ownerDialog, "Find", false, false) : new FindDialog((JFrame)null, "Find", false, false));
            this.findDialog.setFindListener(this);
        }
        if (!this.findDialog.isVisible()) {
            this.findDialog.setLocationRelativeTo(this);
            this.findDialog.open();
            this.findDialog.toFront();
        }
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        if (this.browserComponent != null) {
            this.browserComponent.addMouseListener(ml);
        } else {
            super.addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        if (this.browserComponent != null) {
            this.browserComponent.removeMouseListener(ml);
        } else {
            super.removeMouseListener(ml);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mml) {
        if (this.browserComponent != null) {
            this.browserComponent.addMouseMotionListener(mml);
        } else {
            super.addMouseMotionListener(mml);
        }
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener ml) {
        if (this.browserComponent != null) {
            this.browserComponent.removeMouseMotionListener(ml);
        } else {
            super.removeMouseMotionListener(ml);
        }
    }

    @Override
    public void addKeyListener(KeyListener kl) {
        if (this.browserComponent != null) {
            this.browserComponent.addKeyListener(kl);
        } else {
            super.addKeyListener(kl);
        }
    }

    @Override
    public void removeKeyListener(KeyListener kl) {
        if (this.browserComponent != null) {
            this.browserComponent.removeKeyListener(kl);
        } else {
            super.removeKeyListener(kl);
        }
    }

    @Override
    public void addFocusListener(FocusListener fl) {
        if (this.browserComponent != null) {
            this.browserComponent.addFocusListener(fl);
        } else {
            super.addFocusListener(fl);
        }
    }

    @Override
    public void removeFocusListener(FocusListener fl) {
        if (this.browserComponent != null) {
            this.browserComponent.removeFocusListener(fl);
        } else {
            super.removeFocusListener(fl);
        }
    }

    @Override
    public void setFocusable(boolean f) {
        if (this.browserComponent != null) {
            this.browserComponent.setFocusable(f);
        } else {
            super.setFocusable(f);
        }
    }

    @Override
    public boolean isFocusable() {
        if (this.browserComponent != null) {
            return this.browserComponent.isFocusable();
        }
        return super.isFocusable();
    }

    @Override
    public void setEnabled(boolean e) {
        if (this.browserComponent != null) {
            this.browserComponent.setEnabled(e);
        } else {
            super.setEnabled(e);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.browserComponent != null) {
            return this.browserComponent.isEnabled();
        }
        return super.isEnabled();
    }

    @Override
    public void requestFocus() {
        if (this.browserComponent != null) {
            this.browserComponent.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public boolean canGoBack() {
        return this.browser.navigation().canGoBack();
    }

    public boolean canGoForward() {
        return this.browser.navigation().canGoForward();
    }

    @Override
    public void selectAll() {
        Frame f = this.getFocusedOrMainFrame();
        if (f != null) {
            f.execute(EditorCommand.selectAll());
        }
    }

    @Override
    public void copySelection() {
        Frame f = this.getFocusedOrMainFrame();
        if (f != null) {
            f.execute(EditorCommand.copy());
        }
    }

    @Override
    public String getTitle() {
        return this.browser.title();
    }

    public boolean isDisposed() {
        return this.browser.isClosed();
    }

    public void loadURL(String url) {
        url = this.checkUrl(url);
        this.startNavigationCbEnabled = false;
        if (url.startsWith("file:")) {
            this.browser.navigation().loadUrl(url);
        } else {
            Frame f = this.getFocusedOrMainFrame();
            if (f != null) {
                f.loadUrl(url);
            }
        }
    }

    private String checkUrl(String url) {
        String lcurl = url.toLowerCase();
        if (lcurl.toLowerCase().indexOf("://") < 0 && !lcurl.startsWith("file:")) {
            url = "http://" + url;
        }
        return url;
    }

    private Frame getFocusedOrMainFrame() {
        if (this.browser.focusedFrame().isPresent()) {
            return (Frame)this.browser.focusedFrame().get();
        }
        if (this.browser.mainFrame().isPresent()) {
            return (Frame)this.browser.mainFrame().get();
        }
        return null;
    }

    private void print() {
        Frame f = this.getFocusedOrMainFrame();
        if (f != null) {
            f.print();
        }
    }

    public void reload(boolean checkForRepost) {
        if (checkForRepost) {
            this.browser.navigation().reloadAndCheckForRepost();
        } else {
            this.browser.navigation().reload();
        }
    }

    @Override
    public void addCobolEventListener(CobolEventListener cel) {
        this.listeners.addElement(cel);
    }

    @Override
    public void removeCobolEventListener(CobolEventListener cel) {
        this.listeners.removeElement(cel);
    }

    @Override
    public void addSearchKeyEventListener(SearchKeyEventListener skl) {
        if (!this.searchListeners.contains(skl)) {
            this.searchListeners.addElement(skl);
        }
    }

    @Override
    public void removeSearchKeyEventListener(SearchKeyEventListener skl) {
        this.searchListeners.removeElement(skl);
    }

    @Override
    public URL getURL() {
        if (this.beforeNavigateUrl != null) {
            try {
                return new URL(this.beforeNavigateUrl);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.url;
    }

    @Override
    public String getURLString() {
        return this.url != null ? this.url.toString() : "";
    }

    @Override
    public void setURL(URL u) {
        this.url = u;
        this.loadURL(this.url.toString());
    }

    @Override
    public boolean isBusy() {
        return this.browser.navigation().isLoading();
    }

    @Override
    public String getStatusText() {
        return this.statusText != null ? this.statusText : "";
    }

    @Override
    public String getProgress() {
        return this.progress != null ? this.progress : "0";
    }

    @Override
    public void back() {
        this.browser.navigation().goBack();
    }

    @Override
    public void forward() {
        this.browser.navigation().goForward();
    }

    @Override
    public void refresh() {
        this.browser.navigation().reload();
    }

    @Override
    public void abortOpenURL() {
        this.browser.navigation().stop();
    }

    @Override
    public void doOpenURL() {
        if (this.beforeNavigateUrl != null) {
            try {
                this.setURL(new URL(this.beforeNavigateUrl));
            }
            catch (MalformedURLException e) {
                this.loadURL(this.beforeNavigateUrl);
            }
        }
    }

    @Override
    public void destroy() {
        if (!this.browser.isClosed()) {
            this.browser.close();
        }
        if (!this.engine.isClosed()) {
            this.engine.close();
        }
    }

    @Override
    public void printContent(boolean b) {
        this.print();
    }

    @Override
    public void printNoPrompt(boolean b) {
        this.print();
    }

    @Override
    public void saveAs(boolean b) {
        SwingUtilities.invokeLater(() -> {
            File selectedFile;
            JFileChooser jfc = new JFileChooser();
            if (jfc.showSaveDialog(this) == 0 && (selectedFile = jfc.getSelectedFile()) != null) {
                this.browser.saveWebPage(selectedFile.toPath(), selectedFile.getParentFile().toPath(), SavePageType.COMPLETE_HTML);
            }
        });
    }

    @Override
    public void saveAsNoPrompt(boolean b) {
        if (this.fileName != null) {
            File f = new File(this.fileName);
            File p = f.getParentFile();
            this.browser.saveWebPage(f.toPath(), p != null ? p.toPath() : null, SavePageType.COMPLETE_HTML);
        }
    }

    @Override
    public void setFileName(String f) {
        this.fileName = f;
    }

    @Override
    public void setValue(String url) {
        try {
            this.setURL(new URL(url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void setURL() {
        try {
            this.url = new URL(this.browser.url());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public void setNoMsgBeforeNavigate(boolean b) {
        this.noMsgBeforeNavigate = b;
    }

    @Override
    public void setActiveAccept(boolean b) {
        this.activeAccept = b;
    }

    @Override
    public boolean getActiveAccept() {
        return this.activeAccept;
    }

    @Override
    public void setSelfAct(boolean b) {
        this.selfAct = b;
    }

    @Override
    public boolean getSelfAct() {
        return this.selfAct;
    }

    @Override
    public void asyncProcessEvent(AWTEvent e) {
    }

    private void pushEvent(int cobev) {
        CobolEvent ce = new CobolEvent(this, 7, cobev);
        for (CobolEventListener l : this.listeners) {
            try {
                l.cobolEvent(ce);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void stop() {
        this.abortOpenURL();
    }

    @Override
    public void find(FindDialog.FindParam param) {
        FindOptions.Builder b = FindOptions.newBuilder();
        b = b.matchCase(param.matchCase);
        b = b.searchBackward(param.backSearch);
        this.browser.textFinder().find(param.toSearch, b.build(), t -> {});
    }
}

