/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.ClientThread;
import com.iscobol.as.IDESettings;
import com.iscobol.as.Login;
import com.iscobol.as.UserData;
import com.iscobol.interfaces.runtime.IIDESettings;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.server.AbstractServerRpcHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rts.Auth;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class IDEHandler
extends AbstractServerRpcHandler {
    private static final String SETTINGS_FILE_NAME = "ide_configuration";
    public static final String OPTION_CHECKED = "___iscobol.option.true";
    public static final String OPTION_NOT_CHECKED = "___iscobol.option.false";
    private final int auth;
    private final byte[] challenge;
    private final DualRpcServerDispatcher caller;

    public IDEHandler(DualRpcServerDispatcher d) {
        super(d);
        d.setDefaultCallTimeoutInSeconds(0);
        this.auth = Config.getProperty("iscobol.as.authentication", 1);
        this.challenge = this.auth == 0 ? Auth.nullChallenge() : Auth.newChallenge();
        this.caller = d;
    }

    public IIDESettings getConfiguration() {
        return IDEHandler.getConfigurationFile();
    }

    public void setConfiguration() {
        if (this.auth != 0) {
            this.checkLogin();
        }
        try {
            IIDESettings newConf = (IIDESettings)this.caller.call("com.iscobol.gui.client.IDEClientHandler", "getNewConfiguration");
            this.setConfigurationFile(newConf);
        }
        catch (CallException e) {
            throw new IscobolRuntimeException(3, "getNewConfiguration");
        }
    }

    public String[] list(String parentDir, boolean selectDir, String[] filterExtensions) {
        if (parentDir == null) {
            parentDir = ".";
        }
        FileFilter filter = selectDir ? pathname -> pathname.isDirectory() : (filterExtensions != null && filterExtensions.length > 0 ? pathname -> {
            if (pathname.isDirectory()) {
                return true;
            }
            for (String ext : filterExtensions) {
                if (!pathname.getName().endsWith("." + ext)) continue;
                return true;
            }
            return false;
        } : null);
        File[] f = new File(parentDir).listFiles(filter);
        String[] Return2 = new String[f.length];
        for (int i = 0; i < f.length; ++i) {
            Return2[i] = f[i].getName();
            if (!f[i].isDirectory()) continue;
            int n = i;
            Return2[n] = Return2[n] + "/";
            if (f[i].listFiles(filter).length <= 0) continue;
            int n2 = i;
            Return2[n2] = Return2[n2] + ">";
        }
        return Return2;
    }

    public final boolean isIDE() {
        return true;
    }

    private void checkLogin() {
        try {
            boolean retry = false;
            while (true) {
                Object[] u;
                if ((u = (Object[])this.caller.call("com.iscobol.gui.client.IDEClientHandler", "login", this.challenge, (Object)retry)) == null || u.length < 2 || u[0] == null || u[1] == null) {
                    throw new IscobolRuntimeException(146, "");
                }
                Login login = new Login();
                String user = (String)u[0];
                byte[] pwd = (byte[])u[1];
                UserData ud = login.checkLogin(user, pwd, this.challenge, ClientThread.AUTH_FILE);
                if (ud != null) {
                    if (ud.id != 0) {
                        throw new IscobolRuntimeException(146, "operation not permitted");
                    }
                    break;
                }
                retry = true;
            }
        }
        catch (IscobolRuntimeException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new IscobolRuntimeException(146, "");
        }
    }

    public static IIDESettings getConfigurationFile() {
        IIDESettings Return2;
        ObjectInputStream is = null;
        try {
            is = new ObjectInputStream(new FileInputStream(SETTINGS_FILE_NAME));
            Return2 = (IIDESettings)is.readObject();
            if (Return2.getModes().get("Default") == null) {
                Return2.getModes().put("Default", new LinkedHashMap());
            }
        }
        catch (Exception ex) {
            Return2 = IDEHandler.createAndSaveSettings();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IIDESettings createAndSaveSettings() {
        IDESettings Return2 = new IDESettings();
        LinkedHashMap<String, Map<String, String>> cmpModes = new LinkedHashMap<String, Map<String, String>>();
        cmpModes.put("Debug", new LinkedHashMap());
        cmpModes.put("Release", new LinkedHashMap());
        ((Map)cmpModes.get("Release")).put("-smat", OPTION_CHECKED);
        ((Map)cmpModes.get("Debug")).put("-smat", OPTION_CHECKED);
        ((Map)cmpModes.get("Debug")).put("-d", OPTION_CHECKED);
        ((Map)cmpModes.get("Debug")).put("-dx", OPTION_CHECKED);
        LinkedHashMap<String, Map<String, String>> rtnModes = new LinkedHashMap<String, Map<String, String>>();
        rtnModes.put("Run", new LinkedHashMap());
        Return2.setName("ide_settings");
        Return2.setModes(cmpModes);
        Return2.setRuntimeModes(rtnModes);
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(SETTINGS_FILE_NAME));
            oos.writeObject(Return2);
        }
        catch (Exception exception) {
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Return2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfigurationFile(IIDESettings contents) {
        if (contents == null) {
            return;
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(SETTINGS_FILE_NAME));
            out.writeObject(contents);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String[] getIscobolLibraryFiles() {
        String loc = RtsUtil.getIscobolInstallLocation();
        ArrayList<String> result = new ArrayList<String>();
        File libDir = new File(loc + "/lib");
        if (libDir.exists() && libDir.isDirectory()) {
            File[] jars;
            for (File f : jars = libDir.listFiles((dir, name) -> name.endsWith(".jar") && !name.startsWith("wow"))) {
                result.add(f.getName());
            }
        }
        return result.toArray(new String[result.size()]);
    }
}

