/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.as;

import com.iscobol.as.AbstractClientThread;
import com.iscobol.as.ClientInfo;
import com.iscobol.as.ClientThread;
import com.iscobol.as.FileServerIntf;
import com.iscobol.as.HttpServerIntf;
import com.iscobol.as.IDEHandler;
import com.iscobol.as.MultitaskingServerHandler;
import com.iscobol.as.ServerCallMessageLoop;
import com.iscobol.as.ServerHandler;
import com.iscobol.as.TRServerIntf;
import com.iscobol.gui.AppFactory;
import com.iscobol.gui.ServerCall;
import com.iscobol.rmi.RemoteInvocationHandler;
import com.iscobol.rpc.dualrpc.server.DualRpcServer;
import com.iscobol.rpc.dualrpc.server.DualRpcServerDispatcher;
import com.iscobol.rpc.messageserver.common.Session;
import com.iscobol.rts.CallLoader;
import com.iscobol.rts.CommunicationException;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.LicenseCheck;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.Version;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.tools.ToolProvider;

public class AppServerImpl
implements RuntimeErrorsNumbers {
    private static boolean logging;
    private static boolean logExceptionStack;
    private static Logger logger;
    private static final String eol;
    private static int m;
    private static Hashtable<Integer, AbstractClientThread> threadList;
    private static Hashtable<String, int[]> clientList;
    static String commandLine;
    static String defaultPrg;
    static String[] confOption;
    static IscobolCall hook;
    static int mtskValue;

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("com.iscobol.as");
            logging = Config.getProperty("iscobol.as.logging", false);
            logExceptionStack = Config.getProperty("iscobol.as.logging.exception", false);
            if (logging) {
                String logFile = Config.getProperty("iscobol.as.logfile", "%t/iscobolAs.log");
                try {
                    FileHandler h = new FileHandler(logFile);
                    logger.addHandler(h);
                    h.setFormatter(new SimpleFormatter());
                }
                catch (Exception _ex) {
                    logger.warning("AppServerImpl :" + _ex.getMessage());
                }
                logger.setLevel(Level.FINEST);
            } else {
                logger.setLevel(Level.OFF);
            }
        }
        return logger;
    }

    public static void warning(Logger log, String msg, Throwable ex) {
        log.warning(AppServerImpl.getMessage(msg, ex));
    }

    public static void severe(Logger log, String msg, Throwable ex) {
        log.severe(AppServerImpl.getMessage(msg, ex));
    }

    private static String getMessage(String msg, Throwable ex) {
        if (ex == null) {
            return msg;
        }
        if (logExceptionStack) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (msg != null) {
                pw.println(msg);
            }
            ex.printStackTrace(pw);
            pw.close();
            return sw.toString();
        }
        if (msg != null) {
            return msg + " " + ex.toString();
        }
        return ex.toString();
    }

    public static void closeLogger(Logger logger) {
        if (logger != null) {
            Handler[] handlers = logger.getHandlers();
            try {
                for (int i = 0; i < handlers.length; ++i) {
                    if (handlers[i] == null) continue;
                    handlers[i].close();
                }
            }
            catch (Exception _ex) {
                System.out.println("AppServerImpl exception closing the logger " + _ex);
            }
        }
    }

    public static void main(String[] args) {
        boolean ra;
        IscobolSystem.setAS(true);
        new CommunicationException(null);
        defaultPrg = Config.getPropertySeparateThread("iscobol.default_program", null);
        boolean aC = false;
        for (int i = 0; i < args.length; ++i) {
            commandLine = commandLine + args[i];
            commandLine = commandLine + " ";
            if (args[i].equalsIgnoreCase("-c") || args[i].equalsIgnoreCase("-conly")) {
                if (args.length <= i + 1) continue;
                if (aC) {
                    System.out.println("Command line error: " + args[i]);
                    AppServerImpl.usage();
                    System.exit(1);
                }
                String propName = args[i + 1];
                if (args[i].equalsIgnoreCase("-conly")) {
                    System.setProperty("iscobol.conf.only", propName);
                } else {
                    System.setProperty("iscobol.conf", propName);
                }
                Config.setProperty("iscobol.conf", propName);
                if (defaultPrg == null) {
                    defaultPrg = Config.getPropertySeparateThread("iscobol.default_program", null);
                }
                confOption = new String[]{args[i], args[i + 1]};
                ++i;
                aC = true;
                continue;
            }
            if (!args[i].equalsIgnoreCase("-v") && !args[i].equalsIgnoreCase("-vv")) continue;
            Config.markNoIscobolRuntimeThread();
        }
        m = Config.getMod(-1, -1, null);
        commandLine = commandLine.trim();
        int portNumber = 0;
        String hostName = null;
        boolean reuseAddress = false;
        boolean fileServer = Config.getProperty("iscobol.as.fileserver", false);
        boolean trServer = Config.getProperty("iscobol.as.turborun", false);
        boolean appServer = Config.getProperty("iscobol.as.appserver", false);
        boolean ide = Config.getProperty("iscobol.as.ide", false);
        boolean httpServer = Config.getProperty("iscobol.as.httpserver", false);
        int fsPort = Config.getProperty("iscobol.as.fileserver.port", 10997);
        int trPort = Config.getProperty("iscobol.as.turborun.port", 10995);
        int hsPort = Config.getProperty("iscobol.as.httpserver.port", 10996);
        String hsBaseDir = Config.getProperty("iscobol.as.httpserver.root", "");
        System.setProperty("iscobol.terminal.info.remote", "Y");
        CallLoader.init();
        String checkAlive = Config.getProperty("iscobol.as.check_alive_interval", null);
        Logger log = AppServerImpl.getLogger();
        Thread t = null;
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("-v")) {
                AppServerImpl.copyright(false);
                System.exit(0);
            } else if (args[0].equalsIgnoreCase("-vv")) {
                AppServerImpl.copyright(true);
                System.exit(0);
            }
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-port")) {
                    portNumber = Integer.parseInt(args[++i]);
                    System.setProperty("iscobol.port", String.valueOf(portNumber));
                    continue;
                }
                if (args[i].equalsIgnoreCase("-hostname")) {
                    hostName = args[++i];
                    System.setProperty("iscobol.hostname", hostName);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-help")) {
                    AppServerImpl.usage();
                    System.exit(0);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-force")) {
                    reuseAddress = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-fs")) {
                    fileServer = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-tr")) {
                    trServer = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-hs")) {
                    httpServer = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-as")) {
                    appServer = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-ide")) {
                    ide = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-fsport")) {
                    fsPort = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-trport")) {
                    trPort = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-hsport")) {
                    hsPort = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-hsroot")) {
                    hsBaseDir = args[++i];
                    continue;
                }
                if ((args[i].equalsIgnoreCase("-c") || args[i].equalsIgnoreCase("-conly")) && args.length > i + 1) {
                    ++i;
                    continue;
                }
                System.out.println("Command line error: " + args[i]);
                AppServerImpl.usage();
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("Command line error");
            AppServerImpl.usage();
            System.exit(1);
        }
        if (portNumber <= 0) {
            portNumber = Config.getProperty("iscobol.port", ServerHandler.getDefaultPort());
        }
        if (hostName == null) {
            hostName = Config.getProperty("iscobol.hostname", null);
        }
        if (ide && ToolProvider.getSystemJavaCompiler() == null && Config.getProperty("iscobol.compiler.javac", null) == null) {
            System.out.println("No Java compiler, ensure you're running with a JDK or set the 'iscobol.compiler.javac' configuration property");
            if (!(appServer || fileServer || httpServer)) {
                System.exit(1);
            } else {
                ide = false;
            }
        }
        if (fileServer) {
            String fsName = "com.iscobol.as.fileserver.FileServer";
            FileServerIntf fs = null;
            try {
                fs = (FileServerIntf)Class.forName("com.iscobol.as.fileserver.FileServer").newInstance();
            }
            catch (ClassNotFoundException ex) {
                log.info("File server not available");
            }
            catch (Exception ex) {
                AppServerImpl.warning(log, null, ex);
            }
            if (fs != null) {
                FileServerIntf f = fs;
                int fp = fsPort;
                ra = reuseAddress;
                t = new Thread(() -> f.listen(fp, ra));
                t.setDaemon(true);
                t.start();
                log.info("File server started on port " + fsPort);
                System.out.println("Application Server (file services) started and listening on port " + fsPort);
            } else {
                log.warning("Cannot start file server on port " + fsPort);
            }
        }
        if (httpServer) {
            String hsName = "com.iscobol.updater.server.HttpServer";
            HttpServerIntf hs = null;
            try {
                hs = (HttpServerIntf)Class.forName("com.iscobol.updater.server.HttpServer").newInstance();
            }
            catch (ClassNotFoundException ex) {
                log.info("Http server not available");
            }
            catch (Exception ex) {
                log.warning(ex.toString());
            }
            if (hs != null) {
                try {
                    hs.setLogger(log);
                    hs.start(hsPort, hsBaseDir);
                }
                catch (Exception ex) {
                    String err = "Http server port " + hsPort + ": exception " + ex;
                    log.severe(err);
                    System.err.println(err);
                }
            }
        }
        if (trServer) {
            String fsName = "com.iscobol.as.turborun.TRServer";
            TRServerIntf tr = null;
            try {
                tr = (TRServerIntf)Class.forName("com.iscobol.as.turborun.TRServer").newInstance();
            }
            catch (ClassNotFoundException ex) {
                log.info("TurboRun server not available");
            }
            catch (Exception ex) {
                AppServerImpl.warning(log, null, ex);
            }
            if (tr != null) {
                TRServerIntf trs = tr;
                int trp = trPort;
                ra = reuseAddress;
                t = new Thread(() -> {
                    try {
                        trs.start(trp, ra);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                t.setDaemon(true);
                t.start();
                log.info("TurboRun server started on port " + trPort);
                System.out.println("Application Server (TurboRun) started and listening on port " + trPort);
            } else {
                log.warning("Cannot start TurboRun server on port " + trPort);
            }
        }
        if (appServer || ide || !fileServer && !httpServer && !trServer) {
            AppServerImpl.setHook(log);
            log.info("Starting " + (ide ? "IDE Remote " : "") + "Server on hostname: " + hostName + " with port number: " + portNumber);
            System.out.println((ide ? "IDE Remote" : "Application") + " Server started and listening on port " + portNumber);
            if (ide) {
                System.setProperty("iscobol.as.multitasking", "1");
                System.setProperty("iscobol.as.ide", "1");
                mtskValue = 1;
            } else {
                mtskValue = Config.getProperty("iscobol.as.multitasking", 2);
            }
            if (checkAlive != null) {
                int[] values = AppServerImpl.parseCheckAlive(checkAlive);
                int interval = values[0];
                int timeout = values[1];
                int attempts = values[2];
                int attemptTimeout = values[3];
                String msg = "Check alive every " + interval + ", timeout " + timeout;
                if (attempts > 1) {
                    msg = msg + ", attempts " + attempts + ", attempt timeout " + attemptTimeout;
                }
                log.info(msg);
                AppServerImpl.checkAlive(interval, timeout, attempts, attemptTimeout);
            }
            if (mtskValue > 0) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    AbstractClientThread[] a;
                    for (AbstractClientThread value : a = AppServerImpl.getThreads()) {
                        ClientThread ct;
                        if (!(value instanceof ClientThread) || (ct = (ClientThread)value).getProcess() == null) continue;
                        ct.getProcess().destroy();
                    }
                }));
            }
            DualRpcServer server = ServerHandler.init(hostName, portNumber, reuseAddress, log, ide ? "IDE Remote Server" : "AppServerImpl");
            if (ide) {
                try {
                    server.registerServerSideHandlerClassname("com.iscobol.compiler.remote.server.IDERemoteCompilerHandler");
                    server.registerServerSideHandlerClassname(IDEHandler.class.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                server.listen();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (t != null) {
            try {
                t.join();
            }
            catch (Exception _ex) {
                log.warning("Application Server (file services) Interrupted (" + _ex + ")");
            }
        }
        AppServerImpl.closeLogger(log);
    }

    public static int getClientListCount() {
        int Return2;
        if (m > 0) {
            Return2 = 0;
            for (int[] clcnt : clientList.values()) {
                Return2 += clcnt[0] / m;
                if (clcnt[0] % m <= 0) continue;
                ++Return2;
            }
        } else {
            Return2 = clientList.size();
        }
        return Return2;
    }

    public static int getWebClientListCount() {
        int Return2 = 0;
        if (m > 0) {
            for (int[] clcnt : clientList.values()) {
                if (clcnt[1] <= 0) continue;
                Return2 += clcnt[1] / m;
                if (clcnt[1] % m <= 0) continue;
                ++Return2;
            }
        } else {
            for (int[] clcnt : clientList.values()) {
                if (clcnt[1] <= 0) continue;
                ++Return2;
            }
        }
        return Return2;
    }

    static void setHook(Logger log) {
        String hookName = Config.getProperty("iscobol.as.hook", null);
        if (hookName != null) {
            try {
                hook = (IscobolCall)Class.forName(hookName).newInstance();
                log.info("Hook enabled: " + hookName);
            }
            catch (Exception _ex) {
                log.warning("Hook disabled (" + _ex + ")");
            }
        }
    }

    public static void usage() {
        System.out.println("usage: <command> [-hostname host] [-as] [-ide] [-port n1] [-fs] [-fsport n2] [-hs] [-hsport n3] [-hsroot path] [-tr] [-trport n4] [-c conf-file | -conly conf-file]");
        System.out.println("usage: <command> -help");
        System.out.println("usage: <command> -v");
        System.out.println("usage: <command> -vv");
    }

    private static void copyright(boolean vv) {
        String infolic = Config.getProperty(".licinfo", "Missing license!");
        String exdate = infolic.substring(infolic.length() - 8).equals("99991231") ? "None" : infolic.substring(infolic.length() - 8);
        String[] licid = infolic.substring(0, infolic.length() - 9).split("(##)");
        String licenseId = licid.length > 1 ? LicenseCheck.displayLicenseId(licid[1], true) : "Missing";
        String javaInfo = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String fullVersionNumber = RuntimeProperties.getFullVersionNumber();
        if (fullVersionNumber.startsWith("isCOBOL")) {
            fullVersionNumber = "isCOBOL-Server" + fullVersionNumber.substring(7);
        }
        String fileHandlerVersion = "";
        if (vv) {
            fileHandlerVersion = "DB " + Config.getProperty(".file.index.version", "version unknown") + eol;
        }
        String productCopyright = RuntimeProperties.getProductCopyright();
        System.out.println(fullVersionNumber + eol + productCopyright + eol + fileHandlerVersion + "C/S Version " + Config.getProperty(".runtime.cs.version", "c/s version unknown") + ", F/S Version " + Config.getProperty(".runtime.fs.version", "F/S version unknown") + ", UID Version " + Version.getUIDVersion() + eol + eol + "Company:         " + licid[0] + eol + "License ID:      " + licenseId + eol + "Expiration Date: " + exdate + eol + eol + "Java version:    " + javaInfo + eol + "                 " + System.getProperty("java.home"));
        System.exit(0);
    }

    public static Vector getUsersList() {
        Vector<ClientInfo> Return2;
        AppServerImpl.getLogger();
        ClientInfo ci = (ClientInfo)IscobolSystem.get(ClientInfo.class);
        if (ci == null) {
            Return2 = null;
        } else {
            Return2 = new Vector<ClientInfo>();
            if (MultitaskingServerHandler.sessionId >= 0) {
                Return2.addElement(ci);
            } else {
                AbstractClientThread[] a;
                for (AbstractClientThread value : a = AppServerImpl.getThreads()) {
                    ci = value.getClientInfo();
                    if (ci == null) continue;
                    Return2.addElement(ci);
                }
            }
        }
        return Return2;
    }

    public static void setCustomInfo(int tid, String info) throws IllegalArgumentException {
        AbstractClientThread t = threadList.get(tid);
        if (t == null) {
            throw new IllegalArgumentException("Unknown thread id: " + tid);
        }
        t.setCustomInfo(info);
    }

    public static String getCustomInfo(int tid) throws IllegalArgumentException {
        AbstractClientThread t = threadList.get(tid);
        if (t != null) {
            return t.getCustomInfo();
        }
        throw new IllegalArgumentException("Unknown thread id: " + tid);
    }

    static int[] parseCheckAlive(String checkAlive) {
        int attemptTimeout;
        int attempts;
        int timeout;
        int interval;
        StringTokenizer st = new StringTokenizer(checkAlive);
        if (st.hasMoreTokens()) {
            try {
                interval = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException _ex) {
                interval = 300;
            }
            if (st.hasMoreTokens()) {
                try {
                    timeout = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException _ex) {
                    timeout = 60;
                }
                if (st.hasMoreTokens()) {
                    try {
                        attempts = Integer.parseInt(st.nextToken());
                    }
                    catch (NumberFormatException _ex) {
                        attempts = 0;
                    }
                    if (st.hasMoreTokens()) {
                        try {
                            attemptTimeout = Integer.parseInt(st.nextToken());
                        }
                        catch (NumberFormatException _ex) {
                            attemptTimeout = 60;
                        }
                    } else {
                        attemptTimeout = 60;
                    }
                } else {
                    attempts = 0;
                    attemptTimeout = 0;
                }
            } else {
                timeout = 60;
                attempts = 0;
                attemptTimeout = 0;
            }
        } else {
            interval = 300;
            timeout = 60;
            attempts = 0;
            attemptTimeout = 0;
        }
        return new int[]{interval, timeout, attempts, attemptTimeout};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractClientThread[] getThreads() {
        AbstractClientThread[] a;
        Hashtable<Integer, AbstractClientThread> hashtable = threadList;
        synchronized (hashtable) {
            a = new AbstractClientThread[threadList.size()];
            threadList.values().toArray(a);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, AbstractClientThread> getThreadsMap() {
        HashMap<Integer, AbstractClientThread> m;
        Hashtable<Integer, AbstractClientThread> hashtable = threadList;
        synchronized (hashtable) {
            m = new HashMap<Integer, AbstractClientThread>(threadList);
        }
        return m;
    }

    static void checkAlive(final int interval, int timeOut, final int attempts, final int attemptTimeout) {
        String threadName = "Check alive " + interval + " " + timeOut;
        if (attempts > 1) {
            threadName = threadName + " " + attempts + " " + timeOut;
        }
        Thread t = new Thread(threadName){

            @Override
            public void run() {
                while (true) {
                    AbstractClientThread[] a;
                    for (AbstractClientThread value : a = AppServerImpl.getThreads()) {
                        AppFactory ap;
                        if (value.isCheckAlive() || value instanceof ClientThread && ((ClientThread)value).getProcess() != null || (ap = value.getAppFactory()) == null) continue;
                        try {
                            ap.getNoexit();
                        }
                        catch (IOException _ex) {
                            if (logExceptionStack) {
                                AppServerImpl.warning(AppServerImpl.getLogger(), null, _ex);
                            }
                            if (attempts > 1) {
                                value.setCheckAlive(true);
                                final AbstractClientThread v = value;
                                new Thread("Check alive: retry every " + attemptTimeout + " seconds for " + (attempts - 1) + " times"){

                                    @Override
                                    public void run() {
                                        AppServerImpl.checkAlive(v, attempts - 1, attemptTimeout);
                                    }
                                }.start();
                                continue;
                            }
                            AppServerImpl.kill(value);
                        }
                        catch (Exception _ex) {
                            Logger log = AppServerImpl.getLogger();
                            log.warning("Check alive, unexpected exception:" + _ex);
                        }
                    }
                    try {
                        Thread.sleep(interval * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private static void checkAlive(AbstractClientThread value, int attempts, int attemptTimeout) {
        AppFactory ap = value.getAppFactory();
        RemoteInvocationHandler hdl = null;
        int timeout = 0;
        if (attemptTimeout > 0) {
            hdl = (RemoteInvocationHandler)Proxy.getInvocationHandler(ap);
            timeout = hdl.getRpcCallTimeout();
            hdl.setRpcCallTimeout(attemptTimeout);
        }
        Logger log = AppServerImpl.getLogger();
        for (int i = 0; i < attempts; ++i) {
            log.info("Check alive: attempt n. " + (i + 1) + " failed [" + value.getSessionId() + "]");
            try {
                ap.getNoexit();
                value.setCheckAlive(false);
                break;
            }
            catch (IOException _ex) {
                if (!logExceptionStack) continue;
                AppServerImpl.warning(log, null, _ex);
                continue;
            }
            catch (Exception _ex) {
                AppServerImpl.warning(log, "Check alive, unexpected exception:", _ex);
            }
        }
        if (attemptTimeout > 0) {
            hdl.setRpcCallTimeout(timeout);
        }
        if (value.isCheckAlive()) {
            AppServerImpl.kill(value);
        }
    }

    private static void kill(AbstractClientThread value) {
        int id = value.getSessionId();
        Logger log = AppServerImpl.getLogger();
        log.info("Check alive failed, killing [" + id + "]");
        AppServerImpl.kill(id, 252);
    }

    public static void info() {
        Logger log = AppServerImpl.getLogger();
        log.info(IscobolSystem.info(eol));
        Map<Integer, AbstractClientThread> map = AppServerImpl.getThreadsMap();
        for (Integer key : map.keySet()) {
            AbstractClientThread value = map.get(key);
            Factory.displayUponSysOut(false, "[" + key + "] " + value.info(eol));
        }
    }

    public static void kill(int id, int xCode) {
        AppServerImpl.kill(id, xCode, false);
    }

    public static void kill(int id, int xCode, boolean killedByServer) {
        AbstractClientThread ct = threadList.get(id);
        Logger log = AppServerImpl.getLogger();
        log.info("kill [" + id + "] exit code=" + xCode);
        if (ct != null) {
            Boolean[] exitOk = new Boolean[1];
            if (ct.getAppFactory() != null) {
                new Thread(() -> {
                    boolean ok = false;
                    try {
                        if (killedByServer) {
                            ct.getAppFactory().killedByServer(xCode);
                        } else {
                            ct.getAppFactory().exit("" + xCode);
                        }
                        ok = true;
                    }
                    catch (IOException iOException) {
                        Boolean[] booleanArray = exitOk;
                        synchronized (exitOk) {
                            exitOk[0] = ok;
                            exitOk.notify();
                            // ** MonitorExit[var5_7] (shouldn't be in output)
                        }
                    }
                    finally {
                        Boolean[] booleanArray = exitOk;
                        synchronized (exitOk) {
                            exitOk[0] = ok;
                            exitOk.notify();
                            // ** MonitorExit[var5_5] (shouldn't be in output)
                        }
                    }
                    {
                        return;
                    }
                }).start();
            }
            ct.shutdown(exitOk);
        }
    }

    public static void stop(int xCode) {
        AppServerImpl.getLogger().info("Shutting down server...");
        Map<Integer, AbstractClientThread> map = AppServerImpl.getThreadsMap();
        Integer currThreadId = null;
        for (Integer id : map.keySet()) {
            if (map.get(id) == Thread.currentThread()) {
                currThreadId = id;
                continue;
            }
            AppServerImpl.kill(id, xCode, true);
        }
        if (currThreadId != null) {
            AppServerImpl.kill(currThreadId, 0, false);
        }
        System.exit(xCode);
    }

    public static void cleanUp(int id, Logger l) {
        AbstractClientThread ct = threadList.remove(new Integer(id));
        if (ct != null) {
            AppServerImpl.cleanUp(ct, l);
        }
    }

    public static void cleanUp(AbstractClientThread ct, Logger l) {
        Logger log = l != null ? l : AppServerImpl.getLogger();
        String k = ct.getUnivoqueId();
        int[] clcnt = clientList.get(k);
        if (clcnt == null) {
            log.warning("client not found [" + ct.hostaddress + "]");
        } else if (clcnt[0] > 1) {
            clcnt[0] = clcnt[0] - 1;
            if (ct instanceof ClientThread && ((ClientThread)ct).isWebClient) {
                clcnt[1] = clcnt[1] - 1;
            }
        } else {
            clientList.remove(k);
        }
        log.info("cleanUp [" + ct + "]");
        log.info("remove " + ct + "=" + IscobolSystem.destroyAndFinalizeEnv(ct));
    }

    public static void add(int id, AbstractClientThread ct) {
        boolean wc = ct instanceof ClientThread && ((ClientThread)ct).isWebClient;
        String k = ct.getUnivoqueId();
        int[] clcnt = clientList.get(k);
        if (clcnt == null) {
            m = Config.getMod(AppServerImpl.getClientListCount(), wc ? AppServerImpl.getWebClientListCount() : -1, clcnt);
            clientList.put(k, new int[]{1, wc ? 1 : 0});
        } else {
            clcnt[0] = clcnt[0] + 1;
            if (wc) {
                clcnt[1] = clcnt[1] + 1;
            }
            m = Config.getMod(AppServerImpl.getClientListCount(), wc ? AppServerImpl.getWebClientListCount() : -1, clcnt);
        }
        threadList.put(id, ct);
    }

    public static int start(String clienthost, int clientport, Session sess, String prog, String[] args, String[] clData, AppFactory af) throws IOException {
        return AppServerImpl.start(clienthost, clientport, sess, prog, args, clData, null, null, af);
    }

    public static int start(String clienthost, int clientport, Session sess, String prog, String[] args, String[] clData, Map<String, String> ideSettings, String ideDeplFolder, AppFactory af) throws IOException {
        Integer id = new Integer(sess.getSessionId());
        ClientThread ct = new ClientThread(sess, af, prog, clienthost, clientport, args, clData);
        ct.setIdeSettings(ideSettings);
        ct.setIdeDeploymentFolder(ideDeplFolder);
        ct.start();
        return id;
    }

    public static ServerCall getServerCall(String clienthost, int clientport, int sessionId, int clientSessionId, String[] clData, DualRpcServerDispatcher disp) {
        ServerCallMessageLoop scml = new ServerCallMessageLoop(sessionId, clientSessionId, clienthost, clientport, clData, disp);
        AppServerImpl.add(sessionId, scml);
        return scml.doStart();
    }

    static int getUserCount() {
        return threadList.size();
    }

    public static int sendMessage(int tId, String msg, String title, boolean isCp) {
        AppFactory af;
        AbstractClientThread ct = threadList.get(tId);
        if (ct != null && (af = ct.getAppFactory()) != null) {
            try {
                af.sendMessage(msg, title, isCp);
                return 0;
            }
            catch (IOException e) {
                return -3;
            }
        }
        return -2;
    }

    static {
        eol = System.getProperty("line.separator", "\n");
        threadList = new Hashtable();
        clientList = new Hashtable();
        commandLine = "";
        mtskValue = 2;
    }
}

