/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.OdbcStatement;
import com.veryant.jdbc.PicoConnection;
import com.veryant.jdbc.PicoDbApi;
import com.veryant.jdbc.PicoResultSet;
import com.veryant.jdbc.PicoSQLWarning;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class PicoStatement
implements Statement {
    protected PicoDbApi odbcApi;
    protected OdbcStatement hStmt;
    protected SQLWarning lastWarning = null;
    protected ResultSet myResultSet;
    protected PicoConnection myConnection;
    private boolean updateCountInvoked;

    public PicoStatement(PicoConnection con, PicoDbApi api) throws SQLException {
        this.myConnection = con;
        this.odbcApi = api;
        this.hStmt = new OdbcStatement(this.odbcApi, this.myConnection.getHDBC());
    }

    OdbcStatement getHSTMT() {
        return this.hStmt;
    }

    public void addBatch(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.addBatch(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void cancel() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.cancel");
        }
        this.clearWarnings();
        try {
            this.odbcApi.SQLCancel(this.hStmt);
        }
        catch (SQLWarning sqlwarning) {
            this.setWarning(sqlwarning);
        }
    }

    public void clearBatch() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.clearBatch()");
        }
        throw new UnsupportedOperationException();
    }

    protected synchronized void clearMyResultSet() throws SQLException {
        if (this.myResultSet != null) {
            this.myResultSet.close();
            this.myResultSet = null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public synchronized void close() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.close hStmt=" + this.hStmt + ", rs=" + this.myResultSet + ", this=" + this);
        }
        if (!this.myConnection.isClosed()) {
            this.clearMyResultSet();
            try {
                this.clearWarnings();
                if (!this.hStmt.isDropped()) {
                    this.hStmt.drop();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.myConnection.deregisterStatement(this);
    }

    public synchronized boolean execute(String s) throws SQLException {
        boolean Return = false;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.execute (" + s + ")");
        }
        this.clearWarnings();
        this.reset();
        this.lockIfNecessary(s);
        try {
            this.odbcApi.SQLExecDirect(this.hStmt, s);
        }
        catch (SQLWarning sqlwarning) {
            this.setWarning(sqlwarning);
        }
        int nCol = -1;
        nCol = this.getColumnCount();
        if (nCol > 0) {
            Return = true;
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.execute nCol=" + nCol);
        }
        return Return;
    }

    public boolean execute(String s, int autoGeneratedKeys) throws SQLException {
        return this.execute(s);
    }

    public boolean execute(String s, int[] columnIndexes) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.execute(String s, int columnIndexes[])");
        }
        throw new UnsupportedOperationException();
    }

    public boolean execute(String s, String[] columnIndexes) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.execute(String s, String columnIndexes[])");
        }
        throw new UnsupportedOperationException();
    }

    public int[] executeBatch() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.executeBatch()");
        }
        throw new UnsupportedOperationException();
    }

    public ResultSet executeQuery(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.executeQuery (" + s + ")");
        }
        ResultSet resultset = null;
        if (!this.execute(s)) {
            throw new SQLException("No ResultSet was produced");
        }
        resultset = this.getResultSet(false);
        return resultset;
    }

    public int executeUpdate(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.executeUpdate (" + s + ")");
        }
        int i = -1;
        if (this.execute(s)) {
            throw new SQLException("No row count was produced");
        }
        i = this.myGetUpdateCount();
        return i;
    }

    public int executeUpdate(String s, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(s);
    }

    public int executeUpdate(String s, int[] columnIndexes) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.");
        }
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String s, String[] columnIndexes) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.executeUpdate(String s, String columnIndexes[])");
        }
        throw new UnsupportedOperationException();
    }

    protected void finalize() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Statement.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected int getColumnCount() throws SQLException {
        int i = 0;
        try {
            i = this.odbcApi.SQLNumResultCols(this.hStmt);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
            i = bigdecimal.intValue();
        }
        return i;
    }

    public Connection getConnection() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.getConnection()");
        }
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.getFetchDirection()");
        }
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.getFetchSize()");
        }
        throw new UnsupportedOperationException();
    }

    public int getMaxFieldSize() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getMaxFieldSize");
        }
        return this.getStmtOption((short)3);
    }

    public int getMaxRows() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getMaxRows");
        }
        return this.getStmtOption((short)1);
    }

    public boolean getMoreResults() throws SQLException {
        return false;
    }

    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getQueryTimeout");
        }
        return this.getStmtOption((short)0);
    }

    public ResultSet getResultSet() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getResultSet");
        }
        this.myResultSet = this.getResultSet(true);
        return this.myResultSet;
    }

    protected ResultSet getResultSet(boolean flag) throws SQLException {
        if (this.myResultSet != null) {
            throw new SQLException("Invalid state for getResultSet");
        }
        Object rs = null;
        int i = 1;
        if (flag) {
            i = this.getColumnCount();
        }
        if (i > 0) {
            this.myResultSet = new PicoResultSet(this.odbcApi, this);
        } else {
            this.clearMyResultSet();
        }
        return this.myResultSet;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.getResultSetConcurrency()");
        }
        throw new UnsupportedOperationException();
    }

    public int getResultSetType() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.getResultSetType()");
        }
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.getResultSetHoldability()");
        }
        throw new UnsupportedOperationException();
    }

    protected int getRowCount() throws SQLException {
        int i = 0;
        try {
            i = this.odbcApi.SQLRowCount(this.hStmt);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
            i = bigdecimal.intValue();
        }
        return i;
    }

    protected int getStmtOption(short word0) throws SQLException {
        int i = 0;
        this.clearWarnings();
        try {
            i = this.odbcApi.SQLGetStmtOption(this.hStmt, word0);
        }
        catch (PicoSQLWarning jdbcodbcsqlwarning) {
            BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
            i = bigdecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
        }
        return i;
    }

    protected int myGetUpdateCount() throws SQLException {
        int i = -1;
        if (this.getColumnCount() == 0) {
            i = this.getRowCount();
        }
        return i;
    }

    public int getUpdateCount() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getUpdateCount");
        }
        if (this.updateCountInvoked) {
            return -1;
        }
        this.updateCountInvoked = true;
        return this.myGetUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.getWarnings");
        }
        return this.lastWarning;
    }

    protected boolean lockIfNecessary(String s) throws SQLException {
        boolean flag = false;
        String s1 = s.toUpperCase();
        int i = s1.indexOf(" FOR UPDATE");
        if (i > 0) {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("Setting concurrency for update");
            }
            try {
                this.odbcApi.SQLSetStmtOption(this.hStmt, (short)7, 2);
            }
            catch (SQLWarning sqlwarning) {
                this.setWarning(sqlwarning);
            }
            flag = true;
        }
        return flag;
    }

    protected void reset() throws SQLException {
        this.clearWarnings();
        this.updateCountInvoked = false;
        if (this.myResultSet != null) {
            this.clearMyResultSet();
        } else {
            this.hStmt.close();
        }
    }

    public void setCursorName(String s) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.setCursorName(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void setEscapeProcessing(boolean flag) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.setEscapeProcessing (" + flag + ")");
        }
        int i = 0;
        if (!flag) {
            i = 1;
        }
        this.odbcApi.SQLSetStmtOption(this.hStmt, (short)2, i);
    }

    public void setFetchDirection(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.setFetchDirection(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoStatement.setFetchSize(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void setMaxFieldSize(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.setMaxFieldSize (" + i + ")");
        }
        this.odbcApi.SQLSetStmtOption(this.hStmt, (short)3, i);
    }

    public void setMaxRows(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.setMaxRows (" + i + ")");
        }
        this.odbcApi.SQLSetStmtOption(this.hStmt, (short)1, i);
    }

    public void setQueryTimeout(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*Statement.setQueryTimeout (" + i + ")");
        }
        this.odbcApi.SQLSetStmtOption(this.hStmt, (short)0, i);
    }

    public void setWarning(SQLWarning sqlwarning) throws SQLException {
        this.lastWarning = sqlwarning;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.executeQuery("SELECT SERIAL");
    }
}

