      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id.                 menuthread.

       working-storage section.

       copy "isgui.def".
       copy "iscrt.def".

       77  key-status   is special-names crt status pic 9(5).

       77  prg-to-lunch                            pic x(15).
 
       78  78-Max-Prog                            value 5.
       01  Tab-Program  occurs 78-Max-Prog times.
           05 Prog-Name                           pic x(15).
           05 Prog-H-Thread  handle of thread.
 
       77  hVerifyProg       handle of thread.
       77  W-H-Th            handle of thread.
       77  hMain             handle of thread.

       78  78-terminate      value "A".
       77  I-Prog            pic 9.
       77  I-Prog2           pic 9.
       77  W-Prog-executed   pic 9 value 0.
       77  StatusWait        pic xx.
       77  msg               pic x.

       77  num-program       pic 9(3).
       77  call-status       pic 9.

       77  hWin              handle of window.
       77  close-win         pic 9 value 0.

       77  external-var      pic x(20) external.
       77  link-var          pic x(20).

       screen section.
       01  mask.
           03 Pb1 
              push-button
              line              3
              col               7
              size              20
              title             "Progam 1"
              exception-value   101
              .
           03 Pb2 
              push-button
              line              6
              size              20
              col               7
              title             "Program 2"
              exception-value   102
              .
           03 Pb-exit  
              push-button
              line              9 
              col               7 
              size              20
              title             "Exit" 
              exception-value   27
              .

       procedure division.
       MAIN.
           set environment "gui.quit_mode"  to 27
           set environment "my_environment" to "My Environment".
           move "External"                  to external-var

           accept hMain from thread.
           display standard graphical window
                   background-low  
                   line 2
                   col 65
                   title  "Menu with 'call thread'"
                   lines 11 
                   size 34
                   handle hWin
                   .

           display Mask upon hWin

      * initialize the table of program
           perform varying I-Prog from 1 by 1 until I-Prog > 78-Max-Prog
              move space to Prog-Name(I-Prog)
              move 0     to Prog-H-Thread(I-Prog)
           end-perform

      * start the check of the program in execution
           perform thread VERIFY-PROGRAM handle in hVerifyProg

           perform until key-status = 27
              accept mask
                 on exception continue
              end-accept
              evaluate key-status
              when 101
                   move "program1" to prg-to-lunch
                   perform CALL-PGM
              when 102
                   move "program2" to prg-to-lunch
                   perform CALL-PGM
              when 27
                   perform VERIFY-PROGRAM-EXECUTION
                   if num-program = 1
                      move zero to key-status
                   end-if
              end-evaluate
              move 4 to accept-control
           end-perform

      * close the thread VERIFY-PROGRAM
           send 78-terminate to  hVerifyProg
           wait              for hVerifyProg
           move 0            to  hVerifyProg

           perform EXIT-PRG

           goback
           .

       CALL-PGM.
      *  Verify if program is already in use
           perform varying I-Prog from 1 by 1 
                                  until I-Prog > 78-Max-Prog
              if prg-to-lunch = Prog-Name(I-Prog)
                 display message box "Program already in use!"
                 move 1 to W-Prog-executed
                 exit perform
              end-if
           end-perform
           if W-Prog-executed = 1
              move 0 to W-Prog-executed
           else
      * Verify the max number of program
              perform varying I-Prog from 1 by 1 
                                   until I-Prog > 78-Max-Prog
                 if Prog-Name(I-Prog) = spaces
                    exit perform
                 end-if
              end-perform
              if I-Prog > 78-Max-Prog
                 display message box "Too many programs running!"
                    icon mb-warning-icon
              else
                 initialize link-var
                 string "link " 
                        prg-to-lunch
                        into link-var
                 call thread prg-to-lunch handle in W-H-Th
                                   using link-var
                    on overflow
                       perform CALL-NOT-FOUND
                    not on overflow
                       move W-H-Th         to Prog-H-Thread(I-Prog)
                       move prg-to-lunch   to Prog-Name(I-Prog)
                 end-call
              end-if
           end-if.

       CALL-NOT-FOUND.
           display message box "Program not Found!".

       VERIFY-PROGRAM.
           perform until 1 = 2 yield
              perform varying I-Prog2 
                             from 1 by 1 until I-Prog2 > 78-Max-Prog
                 if Prog-H-Thread(I-Prog2) not = null
                    wait for Prog-H-Thread(I-Prog2) 
                       test only 
                       status in StatusWait
                    if StatusWait = "10" 
                       move spaces  to Prog-Name(I-Prog2)
                       move 0       to Prog-H-Thread(I-Prog2)
                    end-if
                 end-if
              end-perform
              receive msg from hMain before time 100
                 not on exception  
                 if msg = 78-terminate
                    exit perform
                 end-if
              end-receive
           end-perform.


       EXIT-PRG.
           perform DESTROY-RESOURCE
           .

       DESTROY-RESOURCE.
           modify hwin visible 0
           destroy mask
                   hWin 
           .

       VERIFY-PROGRAM-EXECUTION.
           move zero   to num-program
           perform varying I-Prog from 1 by 1 until I-Prog > 78-Max-Prog
              if Prog-Name(I-Prog) not = space
                display message "Close all called programs before exit!"
                 add   1  to num-program
              exit perform
              end-if
           end-perform
           .

