      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CUSTOMER.

       WORKING-STORAGE SECTION.
       copy "constants.def".
       copy "customer.wrk".
       copy "customer.wrk" replacing 
                                 leading "Customer" by "Customer-back"
                                 leading "Cust" by "Cust-back".
       copy "state.wrk".
       copy "isfonts.def".
       copy "isgui.def".
       77  key-status is special-names crt status pic 999.
       77  w-key                pic 9(5).
       77  w-key-ed             pic zz,zz9 blank when zero.
       77  sub1                 handle of window.
       77  h-main               handle of window.
       77  idx1                 pic 99.
       77  idx2                 pic 99.
       77  idx3                 pic 99.
       77  varx3                pic xxx.
       01  w-table.
           03 w-record          occurs 10.
             05 w-code          pic x(6).
             05 filler          pic xx.
             05 w-first-name    pic x(30).
             05 filler          pic xx.
             05 w-last-name     pic x(30).

       01                       pic 9.
           88 check-ok          value 0 false 1.
       77  err-message          pic x any length.
       77  err-icon             pic 9.
       77  err-code             pic 99.

       SCREEN SECTION.
       01  S1.
           03 label "Customer code:"             line 3 col 2.
           03 entry-field using cust-code        col + 2 high prompt.
           03 label "First name: "               line 4 col 2.
           03 entry-field using Cust-First-Name  col + 2 high prompt.
           03 label "Last name:"                 line 5 col 2.
           03 entry-field using Cust-last-Name   col + 2 high prompt.
           03 label "Address:"                   line 7 col 2.
           03 label "Street:"                    line 8 col 2.
           03 entry-field using Cust-Street      col + 2 high prompt.
           03 label "City:"                      col 50.
           03 entry-field using Cust-City        col + 2 high prompt.
           03 label " State:"                    line 9 col 2.
           03 entry-field using Cust-State       col + 2
                                                 after CHECK-STATE.
           03 label State-Description            col + 2.
           03 label "Zip code:"                  col 50.
           03 entry-field using Cust-Zip         col + 2 high prompt.
           03 label "Gender:"                    line 11 col 2.
           03 entry-field using Cust-Gender      col + 2 high prompt.
           03 label "Phone number:"              line 13 col 2.
           03 entry-field using Cust-Phone       col + 2 high prompt.
           03 label "Cell Phone number:"         line 14 col 2.
           03 entry-field using Cust-CellPhone   col + 2 high prompt.

       01  s-func.
           03 label "F1=Lookup"             line 16 col 2 reverse.
           03 label "F2=Lookup State"       col + 2  reverse.
           03 label "F3=Delete"             col + 2  reverse.
           03 label "F5=First"              col + 2 reverse.
           03 label "F6=Prev"               col + 2 reverse.
           03 label "F7=Next"               col + 2 reverse.
           03 label "F8=Last"               col + 2 reverse.
           03 label "F9=Save"               col + 2 reverse.
           03 label "F10=Print"             line 17 col 2 reverse.
           03 label "ESC=Exit"              col + 2 reverse.

       01  s-lookup.
           03 label "<Code>"                line 1 col 3. 
           03 label "<First name>"          col + 2.
           03 label "<Last name>"           col + 19.
           03 from W-RECORD(1)              line + 1 col 3.
           03 from W-RECORD(2)              line + 1 col 3.
           03 from W-RECORD(3)              line + 1 col 3.
           03 from W-RECORD(4)              line + 1 col 3.
           03 from W-RECORD(5)              line + 1 col 3.
           03 from W-RECORD(6)              line + 1 col 3.
           03 from W-RECORD(7)              line + 1 col 3.
           03 from W-RECORD(8)              line + 1 col 3.
           03 from W-RECORD(9)              line + 1 col 3.
           03 from W-RECORD(10)             line + 1 col 3.
           03 label 
            "Select customer and press <ENTER> or press <ESC> to cancel" 
                                            line 13 col 3.

       PROCEDURE DIVISION.
       MAIN.
           call "PCUSTOMER" using 78-open-i-o
           call "PSTATE" using 78-open-input

           display independent graphical window
                   background-low  
                   title  "CUSTOMER MAINTENANCE"
                   cell size is entry-field font 
                   size 84
                   lines 18
                   label-offset 10
                   control font fixed-font
                   handle h-main

           display s1.
           display s-func.
           perform until key-status = 27
              accept s1 
                 on exception 
                    continue 
              end-accept
              evaluate key-status
              when 1   
                   perform LOOKUP
              when 2
                   perform LOOKUP-STATE
              when 3
                   perform REC-DELETE
              when 5
                   perform REC-FIRST
              when 6
                   perform REC-PREV
              when 7
                   perform REC-NEXT
              when 8
                   perform REC-LAST
              when 9
                   perform REC-SAVE
              when 10
                   perform PRINT-REPORT
              end-evaluate
           end-perform.
           call "PCUSTOMER" using 78-close
           call "PSTATE" using 78-close
           destroy h-main 
           goback.
       
       REC-FIRST.
           move low-value to w-key(1:)
           call "PCUSTOMER" using 78-start-great, w-key
           call "PCUSTOMER" using 78-read-next, customer-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display s1
           end-if.

       REC-PREV.  
           call "PCUSTOMER" using 78-read-prev, customer-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display s1
           end-if.

       REC-NEXT.  
           call "PCUSTOMER" using 78-read-next, customer-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display s1
           end-if.

       REC-LAST.  
           move high-value to w-key
           call "PCUSTOMER" using 78-start-less, w-key
           call "PCUSTOMER" using 78-read-next, customer-rec
           if return-code > 9
              perform SHOW-FILE-ERROR
           else
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
              display s1
           end-if.

       REC-DELETE.
           display message 
                 "ARE YOU SURE YOU WANT TO DELETE THIS RECORD?"
                 type mb-yes-no
                 default mb-no
                 icon mb-warning-icon  
                 giving varx3
           if varx3 = mb-yes 
              call "PCUSTOMER" using 78-delete, cust-code
              if return-code > 9
                 perform SHOW-FILE-ERROR
              else
                 initialize customer-rec
                 initialize state-rec
                 display s1
              end-if
           end-if.

       REC-SAVE.
           perform CHECK-FIELDS.
           if check-ok
              call "PCUSTOMER" using 78-write, customer-rec
              if return-code = 22
                 call "PCUSTOMER" using 78-rewrite, customer-rec
                 if return-code > 9
                    perform SHOW-FILE-ERROR
                 end-if
              end-if
           end-if.

       CHECK-FIELDS.
           set check-ok   to true.

           if cust-Code = 0
              move "CUSTOMER CODE MANDATORY"  to err-message
              perform SHOW-ERROR
              set check-ok   to false
           end-if

           if check-ok 
              if Cust-First-Name = space and 
                 Cust-Last-Name = space
                 move "CUSTOMER NAME MANDATORY"  to err-message
                 perform SHOW-ERROR
                 set check-ok   to false
              end-if
           end-if
           
           if check-ok
              perform CHECK-STATE
           end-if.
           .

       CHECK-STATE.
           set check-ok   to true
           if Cust-State not = space
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, State-rec
              if return-code > 9
                 move "INVALID STATE CODE"  to err-message
                 perform SHOW-ERROR
                 move space  to State-Description
                 set check-ok   to false
              end-if
              display s1
           end-if
           .

       PRINT-REPORT.
           call "PCustomer" using 78-close.
           call "PRINTCUSTOMER".
           call "PCustomer" using 78-open-i-o.
           call "PCustomer" using 78-read, customer-rec.

       SHOW-FILE-ERROR.
           initialize err-message
           
           if return-code = 10
              move "NO MORE RECORDS"  to err-message
              move mb-warning-icon    to err-icon
           else
              move return-code        to err-code 
              move err-code           to err-message
              move mb-error-icon      to err-icon
           end-if
           
           display message box err-message
                   title "ERROR: "
                   icon err-icon 
           .

       SHOW-ERROR.
           display message box err-message
                   title "ERROR: "
                   icon mb-error-icon 
           .

       LOOKUP.
           move customer-rec to customer-back-rec
           initialize w-table

           display floating window 
                   line 4 col 4 size 74 lines 13
                   title "CUSTOMER LOOKUP" handle sub1
                   cell size is entry-field font separate 
                   control font fixed-font. 

           move low-value to w-key
           call "PCUSTOMER" using 78-start-great, w-key
           perform LOAD-TABLE
           move 1 to idx1
           display omitted, line idx1 + 1, pos 1, size 74, reverse
           perform until key-status = 27 or 13
              accept omitted line idx1 + 1, col 1
                 on exception perform LOOKUP-EXCEPTION
              end-accept
              display omitted, line idx1 + 1 pos 1, size 74 reverse
           end-perform
           destroy sub1
           if key-status = 13
              move w-code(idx1) to cust-code
              call "PCUSTOMER" using 78-read, customer-rec
              move Cust-State   to state-Code
              call "PSTATE" using 78-read, state-rec
           else
              move Cust-back-Code         to Cust-Code
              call "PCUSTOMER" using 78-read, customer-rec
              move customer-back-rec to customer-rec
           end-if
           display s1
           move 0 to key-status
           .

       LOOKUP-STATE.
           call "LOOKUP-STATE" using state-rec
           move state-Code   to Cust-State
           display s1
           .

       LOOKUP-EXCEPTION.
           display omitted, line idx1 + 1 pos 1, size 74.
           evaluate key-status
           when 52 |UP
                subtract 1 from idx1
                if idx1 < 1
                   move 1 to idx1
                   move w-code(idx1) to w-key with convert
                   call "PCUSTOMER" using 78-start-less, w-key
                   if return-code not > 9
                      call "PCUSTOMER" using 78-read-prev, customer-rec
                      if return-code not > 9
                         perform SHIFT-TABLE-UP
                         perform MOVE-CUST-TO-W
                         display s-lookup
                     end-if
                   end-if
                end-if
           when 53 |DOWN
                add 1 to idx1
                if idx1 > 10
                   move 10 to idx1
                   move w-code(idx1) to w-key with convert
                   call "PCUSTOMER" using 78-start-great, w-key
                   if return-code not > 9
                      call "PCUSTOMER" using 78-read-next, customer-rec
                      if return-code not > 9
                         perform SHIFT-TABLE-DOWN
                         perform MOVE-CUST-TO-W
                         display s-lookup
                      end-if
                   end-if
                else
                   if w-code(idx1) = spaces
                      subtract 1 from idx1
                   end-if
                end-if
           end-evaluate.

       MOVE-CUST-TO-W.
           move cust-code       to w-key-ed
           move w-key-ed        to w-code(idx1).
           move cust-first-name to w-first-name(idx1).
           move cust-last-name  to w-last-name(idx1).

       LOAD-TABLE.
           perform varying idx1 from 1 by 1 until idx1 > 10
              call "PCUSTOMER" using 78-read-next, customer-rec
              if return-code > 9
                 exit perform
              else
                 perform MOVE-CUST-TO-W
              end-if
           end-perform
           subtract 1 from idx1
           display s-lookup
           .

       SHIFT-TABLE-DOWN.
           perform varying idx2 from 2 by 1 until idx2 > 10
              compute idx3 = idx2 - 1
              move w-record(idx2) to w-record(idx3)
           end-perform.

       SHIFT-TABLE-UP.
           perform varying idx2 from 9 by -1 until idx2 < 1
              compute idx3 = idx2 + 1
              move w-record(idx2) to w-record(idx3)
           end-perform.

