      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION.
       PROGRAM-ID. ISCHECK.

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       REPOSITORY.
           CLASS out-of-memory AS "java.lang.OutOfMemoryError".

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.

       DATA DIVISION.
       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isfilesys.def".
       01  cmd         pic x(10).
       01  max-threads pic 9(18).
       01  max-files   pic 9(18).
       01  max-locks   pic 9(18).
       01  max-memory  pic 9(18).
       77  pic 9 value 0.
           88  max-threads-error value 1.
           88  max-files-error   value 2.
           88  max-memory-error  value 3.

       77  file-io    pic x(256).
       01  sio-lparms.
           03 max-rec-sz pic 9.
           03 filler     pic x value ",".
           03 file-type  signed-short.
           03 filler     pic x value ",".
           03 block-sz   pic 9 value 0.

       01  rec-buffer.
           03 rec-val    pic 9(5).
           03 filler     pic x value x"00".

       77  m1        handle.

       77  advanced-num   pic 9(4).
       77  property-name  pic x(100).
       77  property-Value pic x(10).

       PROCEDURE DIVISION CHAINING CMD.
       MAIN-LOGIC.
           evaluate cmd
              when "-t" 
              when "-T"
                   perform CHECK-MAX-THREADS 
              when "-f"
              when "-F" 
                   perform CHECK-MAX-FILES
              when "-m"
              when "-M" 
                   perform CHECK-MAX-MEMORY
           end-evaluate.

           perform SHOW-HELP 
           goback.

       CHECK-MAX-THREADS.
           display "Starting to check maximum number of threads..."
           display " "
           move zero   to advanced-num
           perform until max-threads-error
              add 1 to max-threads
              add 1 to advanced-num
              try
                if advanced-num = 100
                   display "=" no
                   if max-threads(16:3) = "000"
                      display max-threads no
                   end-if
                   move zero to advanced-num
                end-if
                perform thread 
                  call "C$SLEEP" using 1000
                end-perform
              catch out-of-memory
                 subtract 1 from max-threads 
                 display " "
                 display exception-object
                 display "Maximum number of threads : " max-threads
                 set max-threads-error to true
                 goback
              end-try 
           end-perform.

       CHECK-MAX-FILES.
           display "Starting to check maximum number of files..." 
           display " "

           set environment "file.open_check" to 0

           move "tmpissfile" to file-io
           inspect file-io replacing trailing space by low-value

           move s-line    to seq-type
           move seq-type  to file-type
           set max-rec-sz to size of rec-val

           set s-make-function to true
           call "s$io" using sio-function,
                             file-io,
                             sio-lparms
           if return-code = 0
              display "f_errno value : " F_ERRNO
              display "Maximum number of files : " max-files
              set max-files-error to true
              goback
           end-if

           move zero   to advanced-num
           perform until max-files-error 
              add 1 to max-files
              add 1 to advanced-num
              if advanced-num = 100
                 display "=" no
                 if max-files(16:3) = "000"
                    display max-files no
                 end-if
                 move zero to advanced-num
              end-if

              set s-open-function to true
              move finput to open-mode
              call "s$io" using sio-function,
                             file-io,
                             open-mode,
                             max-rec-sz,
                             seq-type,
                             0,
                             0
               if return-code > 0
                 continue
               else
                 display " "
                 subtract 1 from max-files
                 if f-errmsg not = space
                    display function trim(f-errmsg)
                 end-if
                 display "f_errno number ( " F_ERRNO " )"
                 display "Maximum number of files : " max-files
                 set max-files-error to true
                 goback
               end-if
           end-perform.


       CHECK-MAX-MEMORY.
           display "Starting to check maximum memory available..." 
           display " " 
           move zero   to advanced-num
           perform until max-memory-error
              add 1 to max-memory
              add 1 to advanced-num 
              if advanced-num = 10
                 display "=" no
                 move zero to advanced-num
                 if max-memory(16:3) = "000"
                    display max-memory no
                 end-if
              end-if
              try
                 call "M$ALLOC" using 1000000 m1
              catch out-of-memory
                 subtract 1 from max-memory 
                 display " "
                 display exception-object
                 display "Maximum memory allocated : " max-memory "MB"
                 set max-memory-error to true
                 goback
              end-try
           end-perform.

       SHOW-HELP.
           display "ISCHECK version 1.0"
           display ""
           display "Usage is:" .
           display "     -t    to check maximum number of threads".
           display "     -f    to check maximum number of files".
           display "     -m    to check maximum memory to be allocated".

