      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. WCREATEFONT.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".  
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
                                        
       77  createfont-status       pic s99. 
       77  wfont-status            pic s99. 
       77  h-font                  handle of font.
       77  wrk-font-name           pic x any length.

       SCREEN SECTION.
       01  Mask.
           03  label 
               line                2 
               col                 2
               title               "Font:"
               .
           03  lb-fontname
               label 
               line                2
               col                 + 2    
               .
           03  label 
               line                5 
               col                 2
               title               "Size:"
               .
           03  lb-fontsize
               label 
               line                5 
               col                 + 2
               .
           03  label 
               line                6
               col                 2
               title               "type some text below:"
               .
           03  ef-test
               entry-field 
               multiline
               use-return
               line                + 2 
               col                 2   
               size                68 cells
               lines               11 cells   
               font                h-font
               .   
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       INI.
           call "W$CREATEFONT" using "files/fsex2p00_public.ttf"
                                      wrk-font-name
                              giving createfont-status
           initialize wfont-data
           move wrk-font-name   to wfont-name
           move "11"            to wfont-size
           call "W$FONT" using wfont-get-font, h-font, wfont-data
                        giving wfont-status

           if wfont-status < 0
              display message "w$font error: " wfont-status
              goback
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "W$CREATEFONT Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform DESCRIBE-FONT

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform
           
           destroy Mask
           destroy hWin
           destroy h-font
           destroy control-font
           goback
           .
           
       DESCRIBE-FONT.
           initialize wfont-data.
           call "W$FONT" using wfont-describe-font
                               h-font
                               wfont-data
           modify lb-fontname title wfont-name
           modify lb-fontsize title wfont-size
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
