      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. PPRINTER.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select print-job assign to printer spooler-name
           organization line sequential.

       FILE SECTION.
       FD  print-job.
       01  print-record            pic x(80).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "iscobol.def".
       copy "isresize.def".

       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  spooler-name            pic x(128).
       77  lbl-status-text         pic x(50).
       77  result                  pic S9(3).

       78  LF-FaceNameParam        value "Face Name".
       78  LF-HeightParam          value "Height".
       78  LF-WeightParam          value "Weight".

       01  DeviceCapabilities.
           02  DC-DriverVersion    pic 9(10) Binary(4).
           02  DC-TechnologyValue  pic 9     Binary(4).
           02  DC-HorzSize         pic 9(10) Binary(4).
           02  DC-VertSize         pic 9(10) Binary(4).
           02  DC-HorzRes          pic 9(10) Binary(4).
           02  DC-VertRes          pic 9(10) Binary(4).
           02  DC-LogPixelsX       pic 9(10) Binary(4).
           02  DC-LogPixelsY       pic 9(10) Binary(4).
           02  DC-AspectX          pic 9(10) Binary(4).
           02  DC-AspectY          pic 9(10) Binary(4).
           02  DC-AspectXY         pic 9(10) Binary(4).
           02  DC-PhysicalWidth    pic 9(10) Binary(4).
           02  DC-PhysicalHeight   pic 9(10) Binary(4).
           02  DC-PhysicalOffsetX  pic 9(10) Binary(4).
           02  DC-PhysicalOffsetY  pic 9(10) Binary(4).
           02  DC-ScalingFactorX   pic 9(10) Binary(4).
           02  DC-ScalingFactorY   pic 9(10) Binary(4).

       01 LogicalFont.
           02  LF-Height           pic S9(5) Binary(2).
           02  LF-Width            pic 9(5) Binary(2).
           02  LF-Escapement       pic 9(5) Binary(2).
           02  LF-Orientation      pic 9(5) Binary(2).
           02  LF-WeightValue      pic 9(3) Binary(2).
           02  LF-ItalicValue      pic x.
           02  LF-UnderlineValue   pic x.
           02  LF-StrikeoutValue   pic x.
           02  LF-CharSetValue     pic 9(3) Binary(2).
           02  LF-OutPrecisValue   pic 9 Binary(2).
           02  LF-ClipPrecisValue  pic 9(3) Binary(2).
           02  LF-QualityValue     pic 9 Binary(2).
           02  LF-PitchValue       pic 9 Binary(2).
           02  LF-FamilyValue      pic 9 Binary(2).
           02  LF-FaceName         pic x(31).

       01  TextMetrics.
           02  TM-Height           pic 9(10) Binary(4).
           02  TM-Ascent           pic 9(10) Binary(4).
           02  TM-Descent          pic 9(10) Binary(4).
           02  TM-InternalLeading  pic 9(10) Binary(4).
           02  TM-ExternalLeading  pic 9(10) Binary(4).
           02  TM-AveCharWidth     pic 9(10) Binary(4).
           02  TM-MaxCharWidth     pic 9(10) Binary(4).
           02  TM-WeightValue      pic 9(3) Binary(4).
           02  TM-Overhang         pic 9(10) Binary(4).
           02  TM-DigitizedAspectX pic 9(10) Binary(4).
           02  TM-DigitizedAspectY pic 9(10) Binary(4).
           02  TM-ItalicValue      pic x.
           02  TM-UnderlinedValue  pic x.
           02  TM-StruckOutValue   pic x.
           02  TM-FirstChar        pic x.
           02  TM-LastChar         pic x.
           02  TM-DefaultChar      pic x.
           02  TM-BreakChar        pic x.
           02  TM-PitchValue       pic 9 Binary(2).
           02  TM-FamilyValue      pic 9 Binary(2).
           02  TM-CharSetValue     pic 9(3) Binary(2).
  
       77  font-point-size        pic 999v99.
       77  font-name              pic x(20).
       77  lf-height-ori           pic s9(5) binary(2).

       SCREEN SECTION.
       01  Mask. 
           03 push-button
              line                 2
              col                  2
              title                "&Print"
              exception-value      101
              .
           03 push-button
              line                  2
              col                   + 2
              title                 "Pre&view"
              exception-value       102
              .
           03 push-button
              line                 2
              col                  + 2
              title                "PD&F"
              exception-value      103
              .
           03 lbl-status 
              label
              line                 5 
              col                  2
              size                 30 cells
              value                lbl-status-text
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       main. 
           call "c$guicfg" using "Printer Dialog Always=False"
           
           call "c$setdevelopmentmode"    

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "P$ Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask   

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 101  
                   perform NORMAL-PRINT
              when 102  
                   perform PRINT-PREVIEW 
              when 103
                   perform PRINT-PDF  
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           GOBACK
           .

       PRINT-PREVIEW.
           move "-P PREVIEW" to spooler-name
           perform PRINT-PROCEDURE
           .

       PRINT-PDF.
           initialize opensave-data, spooler-name.
           call client "C$GETENV" USING "user.home"
                                         opnsav-default-dir
           move "PDF Files (*.pdf)|*.pdf" to opnsav-filters
           move "pdf"                     to opnsav-default-ext
           call "C$OPENSAVEBOX" using opensave-save-box
                                      opensave-data
           if return-code < 0
              exit paragraph
           end-if

           string "-P PDF "       delimited by size
                  opnsav-filename delimited by trailing spaces
                                  into spooler-name

           perform PRINT-PROCEDURE
           .

       NORMAL-PRINT.
           move "-P SPOOLER" to spooler-name
           call "P$DisplayDialog" giving result
           if result = 0
              perform PRINT-PROCEDURE
           else
              move "Printing is aborted" to lbl-status-text
              display lbl-status
           end-if
           .

       PRINT-PROCEDURE.
           move "Printing Started ..." to lbl-status-text
           display lbl-status.

           open output print-job

           Call "P$GetDEviceCapabilities" using DeviceCapabilities

      *    Header Printing
      *    Print bitmap, change fonts and text color
           call "p$drawbitmap" using "files/img.png", 
                                     2, 2, 
                                     "Absolute", 
                                     "Metric"

           move 14        to font-point-size
           move "Arial"   to font-name
           perform SET-FONT

           call "p$settextcolor" using "Blue"

           call "p$textOut" using "Veryant, LLC", 
                                  8, 3.6, 
                                  "Absolute", 
                                  "Metric" 

      *    Draw a multi-lined table
      *    Draw a box and lines in the box
           call "p$drawroundbox" using 2,  6, 
                                       "Absolute", 
                                       "Metric"
                                       16,  5, 
                                       "Metric" 

      *    Draw a vertical line
           call "p$drawline" using 6.4,  6, "Absolute", "Metric"
                                   6.4, 11, "Absolute", "Metric" 

      *    Draw 3 horizontal lines
           call "p$drawline" using 2,  7.2, "Absolute", "Metric"
                                   18, 7.2, "Absolute", "Metric"
           call "p$drawline" using 2,  8.5, "Absolute", "Metric"
                                  18,  8.5, "Absolute", "Metric"
           call "p$drawline" using 2,  9.8, "Absolute", "Metric"
                                  18,  9.8, "Absolute", "Metric"

      *    Print text in the box

           move 12        to font-point-size
           move "Calibri" to font-name
           perform SET-FONT

           call "p$settextcolor" using "Black"
           call "P$TextOut" using "FONT NAME"
                                  2.5, 6.5, 
                                  "Absolute"
                                  "Metric"

           call "P$TextOut" using "SAMPLE TEXT"
                                  7, 6.5, 
                                  "Absolute", 
                                  "Metric"

           move 12        to font-point-size
           move "Arial"   to font-name
           perform SET-FONT

           call "p$settextcolor" using "Red"
           call "p$textout" using "Arial",
                                  2.5, 7.7,
                                  "Absolute", 
                                  "Metric"
           call "p$textout" using "This is red Arial text",
                                  7, 7.7,
                                  "Absolute"
                                  "Metric"
           move 12              to font-point-size
           move "Courier New"   to font-name
           perform SET-FONT

           call "p$settextcolor" using "Dark Cyan"
           call "p$textout" using "Courier New"
                                  2.5, 9.0, 
                                  "Absolute", 
                                  "Metric"
           call "p$textout" using "This is Dark cyan Courier New text",
                                   7, 9.0, 
                                   "Absolute", 
                                   "Metric"
      *
 
           move 12                 to font-point-size
           move "Times New Roman"  to font-name
           perform SET-FONT

           call "p$settextcolor" using "Brown"
           call "p$textout" using "Times New Roman",
                                  2.5, 
                                  10.3, 
                                  "Absolute", 
                                  "Metric"
           call "p$textout" using "This is brown Times New Roman text",
                                  7, 10.3, 
                                  "Absolute", 
                                  "Metric"

           close print-job
           move "Printing is done" to lbl-status-text
           display lbl-status.
           .

       SET-FONT.
           compute lf-height rounded = (font-point-size * 
                                        DC-logpixelsy) / 72

           MOVE font-name  TO LF-FaceName.

           Call "P$setfont" using lf-FaceNameParam LF-FaceName
                                  lf-HeightParam LF-Height       
                                  LF-WeightParam LF-WeightValue. 

           move lf-height to lf-height-ori
           move lf-facename to font-name.
           Call "P$GetTextMetrics" using TextMetrics.
           call "P$clearfont".
           move lf-height-ori to lf-height
           compute LF-Height = (LF-Height * TM-Height) /
                               (TM-Height - TM-InternalLeading). 
           move font-name to lf-facename

           call "P$SetFont" using lf-FaceNameParam LF-FaceName
                                  LF-HeightParam LF-Height       
                                  LF-WeightParam LF-WeightValue. 

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
