      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. KEISEN-SAMPLE.


       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iskeisen.def".
       copy "iscobol.def".
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  hWin2                   handle of window.
       77  close-win               pic 9 value 0.  

       77  k-method                pic x.
       
       77  v-keisen-1              pic 9 value 0.
       77  v-keisen-2              pic 9 value 0.

       SCREEN SECTION.
       01  Mask.
           03  push-button
               line                2 
               col                 2
               size                15 cells
               title               "Keisen method 1"
               visible             v-keisen-1 
               exception-value     101
               .
           03  push-button
               line                4 
               col                 2
               size                15 cells
               title               "Keisen method 2" 
               visible             v-keisen-2 
               exception-value     102
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.         
           accept k-method from environment "keisen.method"
              on  exception
                  move 1 to v-keisen-1
                  move 1 to v-keisen-2
           end-accept

           evaluate k-method
           when "1"
                move 1 to v-keisen-1
           when "2"
                move 1 to v-keisen-2
           when other
                move 1 to v-keisen-1
                move 1 to v-keisen-2
           end-evaluate

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "KEISEN Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept 
              if crt-status = 101 or crt-status = 102
                 perform DRAW-KEISEN 
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       DRAW-KEISEN.           

           display independent graphical window                   
                   color  65793
                   with   system menu
                   title  "KEISEN Routines"
                   lines 21
                   size 70
                   control font control-font  
                   handle hWin 2
           display window erase.

           evaluate crt-status
           when 101
                perform KEISEN-1
           when 102
                perform KEISEN-2
           end-evaluate

           display message 
                   "The lines on the screen have been drawn with KEISEN"
           .

       KEISEN-1.
           move 5  to KEI-CMD
           move 3  to KEI-LINE 
           move 3  to KEI-COL
           move 66 to KEI-LNG1
           move 18 to KEI-LNG2
           move 2  to KEI-COLOR
           move 4  to KEI-PTN
           call "KEISEN" using KEISEN
           .

       KEISEN-2.
           move 5  to KEI2-CMD
           move 3  to KEI2-START-LINE 
           move 3  to KEI2-START-COL
           move 68 to KEI2-END-COL
           move 18 to KEI2-END-LINE
           move 2  to KEI2-COLOR
           move 4  to KEI2-PRN
           call "KEISEN" using KEISEN2
           .  
                  
