      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. envmap.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  env-val                 pic x(10).
       77  new-val                 pic x(10) value "my value".
      

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2 
              col                  2
              size                 10 cells
              title                "ENV-VAR:" 
              .
           03 entry-field
              line                 2 
              col                  13
              size                 15 cells
              min-val              1
              max-val              10 
              max-text             10
              value                new-val
              .
           03 push-button
              line                 2
              col                  30
              size                 4 cells
              title                "Set"
              exception-value      1000
              .
           03 push-button
              line                 4
              col                  2
              size                 25 cells
              title                "Backup Environment"
              exception-value      1001
              .
           03 push-button
              line                 6 
              col                  2 
              size                 25 cells
              title                "Restore Environment"
              exception-value      1002
              .
           03 push-button
              line                 8
              col                  2
              size                 25 cells
              title                "Check environment variable"
              exception-value      1003
              .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           set environment "ENV-VAR" to new-val.
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$ENVMAP Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 1000
                   set environment "ENV-VAR" to new-val
              when 1001
                   call "C$ENVMAP" using 1
              when 1002
                   call "C$ENVMAP" using 0
              when 1003
                   accept env-val 
                          from environment "ENV-VAR"
                   display message "EVN-VAR = " env-val
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
