      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. dispregsample.

       WORKING-STORAGE SECTION.
       copy "iscoblib.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  hFloat                  handle of window.
       77  close-win               pic 9 value 0.

       01  open-key-handle         usage unsigned-long.
       01  subkey-handle           usage unsigned-long.
       77  status-code             pic 9(3).
       01  subkey-to-be-created    pic x(40).
       01  subkey-to-be-opened     pic x(40).
       01  subkey-to-be-deleted    pic x(40).
       01  subkey-name             pic x(40).
       01  key-class               pic x(10) value spaces.
       01  key-options             usage unsigned-long. 
       01  key-sam                 usage unsigned-long.
       01  key-disposition         usage unsigned-long.
       01  value-name              pic x(40).
       01  name-size               usage unsigned-long.
       01  data-type               usage unsigned-long.
       01  value-data              pic x(40).
       01  data-size               usage unsigned-long.
       01  ndx                     usage unsigned-long.
       77  idx                     pic 9(3).
       77  v-client                pic 9.
       77  e-adminitrator          pic 9.
       01                          pic 9.
           88 win-administrator    value 1 false zero.

       SCREEN SECTION.
       01  Mask.
           03 frame
              engraved
              line                 1
              col                  2
              lines                3 cells
              size                 68 cells
              .
           03 label
              line                 2
              col                  3
              title                "We will operate on HKEY_LOCAL_MACHIN
      -                            "E / Software".
           03 frame
              engraved
              line                 4
              col                  2
              lines                16 cells
              size                 32 cells
              .
           03 push-button
              line                 5
              col                  3
              size                 30 cells
              title                "Enum Subkeys"
              exception-value      100
              .
           03 ls-subkeys
              list-box
              line                 7
              col                  3
              lines                12 cells
              size                 30 cells
              .
           03 frame 
              engraved
              line                 4
              col                  36
              lines                16 cells
              size                 34 cells
              .           
           03 pb-create-key
              push-button 
              line                 5 
              col                  37
              size                 32 cells
              title                "Create a test key"
              exception-value      101
              enabled              e-adminitrator
              .
           03 ls-values
              list-box
              line                 7
              col                  37
              lines                12 cells
              size                 15 cells
              .
           03 pb-add-value
              push-button
              line                 8 
              col                  54
              size                 15 cells 
              enabled              0
              title                "Insert new value"
              exception-value      102
              .
           03 pb-query-value
              push-button
              line                 10
              col                  54
              size                 15 cells
              enabled              0
              title                "Query this value"
              exception-value      103
              .
           03 pb-clear-values
              push-button
              line                 12
              col                  54
              size                 15 cells
              enabled              0
              title                "Delete this value"
              exception-value      104
              .
           03 pb-delete-key
              push-button
              line                 17
              col                  54
              size                 15 cells
              enabled              0
              title                "Delete the key"
              exception-value      105
              .
           03 label
              line                 20
              col                  2
              title                "Note: the data are retrieved from cl
      -                            "ient machine"
              visible              v-client
              .
           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       01  MaskNewVal.
           03 label 
              line                 2
              col                  2
              size                 6 cells
              title                "Name:"
              .
           03 entry-field
              line                 2
              col                  12
              size                 10 cells
              value                value-name
              .
           03 label
              line                 4
              col                  2
              size                 6 cells
              title                "Data:"
              .
           03 entry-field 
              line                 4
              col                  12
              size                 10 cells
              value                value-data
              .
           03 push-button
              line                 6
              col                  2
              title                "&OK"
              exception-value      400
              .


       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1      to v-client
           else
              move zero   to v-client
           end-if
           
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title 
                        "Windows Registry handling sample (Thin client)"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform OPEN-KEY

      *     display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask 
                 on exception 
                    continue 
              end-accept
              evaluate crt-status
              when 100 
                   perform GET-SUBKEYS
              when 101
                   perform SUBKEY-CREATION
              when 102
                   perform SET-VALUE
              when 103
                   perform QUERY-VALUE
              when 104 
                   perform DELETE-VALUE
              when 105 
                   perform SUBKEY-DELETION
              end-evaluate
              move 4   to accept-control
           end-perform

           perform CLOSE-KEY

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       OPEN-KEY.
           move 1                  to e-adminitrator
           set win-administrator   to true.

           move hkey_local_machine to open-key-handle
           move KEY_ALL_ACCESS     to key-sam

           call "DISPLAY_REG_OPEN_KEY_EX" using open-key-handle
                                                "SOFTWARE"
                                                key-sam
                                                subkey-handle
                                         giving status-code. 

           if status-code not = 0
              set win-administrator to false
           else
              move subkey-handle to open-key-handle
           end-if

           if not win-administrator
              move hkey_local_machine to open-key-handle
              move KEY_READ           to key-sam
              call "DISPLAY_REG_OPEN_KEY_EX" using open-key-handle
                                                   "SOFTWARE"
                                                   key-sam
                                                   subkey-handle
                                            giving status-code 
              if status-code not = 0
                 display message "Error opening "
                                 "HKEY_LOCAL_MACHINE/Software"
                                  x"0D0A" 
                                  "Error code: " 
                                  status-code
             destroy hWin
             goback
           else
              move zero            to e-adminitrator
              move subkey-handle   to open-key-handle
              display message "You don't have System Administrator "
                              "privileges."
                              x"0D0A" 
                              "Some functions can be disabled"
                              icon mb-warning-icon 
           end-if
           .

       SUBKEY-CREATION.
           move "iscobol-test-key"       to subkey-to-be-created
           move REG_OPTION_NON_VOLATILE  to key-options
           move KEY_ALL_ACCESS           to key-sam
           move space                    to key-class

           call "DISPLAY_REG_CREATE_KEY" using open-key-handle
                                               subkey-to-be-created
                                               key-class
                                               key-options
                                               key-sam
                                               subkey-handle
                                               key-disposition
                                        giving status-code

           if status-code not = 0 
              display message box "Error creating a new test key"
                                  x"0D0A" "Error code: " status-code
                                  x"0D0A" 
                                  "Make sure you have "
                                  "administrator privileges"
           else
              modify pb-create-key   enabled 0
              modify pb-add-value    enabled 1
              modify pb-query-value  enabled 1
              modify pb-clear-values enabled 1
              modify pb-delete-key   enabled 1
           end-if
           .

       GET-SUBKEYS.  
           modify ls-subkeys reset-list 1      
           set name-size to size of subkey-name

           perform varying ndx from 1 by 1 until 1 = 2
              call "DISPLAY_REG_ENUM_KEY" using  open-key-handle
                                                 ndx
                                                 subkey-name
                                                 name-size
                                          giving status-code

              if status-code not = 0  
                 exit perform  
              end-if

              modify ls-subkeys item-to-add subkey-name
           end-perform
           .

       SET-VALUE.
           move spaces to value-name, value-data

           display floating graphical window
                   background-low
                   lines 8, size 30
                   title "New Registry Value"
                   control font control-font
                   handle hFloat

           display MaskNewVal

           perform until value-name not = spaces and
                         value-data not = spaces
              accept MaskNewVal on exception continue end-accept
           end-perform

           destroy MaskNewVal
           destroy hFloat
           .

           move REG_SZ to data-type
           inspect  value-data replacing trailing spaces by low-value
           move 1 to data-size
           inspect value-data tallying data-size 
                   for characters before initial x"00"   

           call "DISPLAY_REG_SET_VALUE_EX" using subkey-handle  
                                                 data-type
                                                 value-data
                                                 data-size 
                                                 value-name
                                          giving status-code

           if status-code not = 0 
              display message box "Error creating value"
                                  x"0D0A" "Error code: " status-code
                             icon mb-error-icon
                            title "Registry Error"
           else
              display  message box "Value creation successful!"
                              icon mb-default-icon
                             title "Registry Value" 
              perform ENUM-VALUES                    
           end-if
           .                   

       QUERY-VALUE.
           inquire ls-values selection-index idx
           modify  ls-values query-index idx
           inquire ls-values item-value value-name

           if value-name = spaces
              exit paragraph
           end-if
  
           set data-size to size of value-data
           call "DISPLAY_REG_QUERY_VALUE_EX" using subkey-handle
                                                   value-name
                                                   data-type
                                                   value-data
                                                   data-size
                                            giving status-code

           if status-code not = 0 
              display message box "Error getting value information"
                                  x"0D0A" "Error code: " status-code
                             icon mb-error-icon
                            title "Registry Error"
           else
              display  message box "Value name: " value-name x"0D0A"
                                   "Value data: " value-data
                              icon mb-default-icon
                             title "Registry Value"
           end-if
           .


       ENUM-VALUES.        
           modify ls-values reset-list 1

           perform varying ndx from 1 by 1 until 1 = 2
              set name-size to size of value-name
              set data-size to size of value-data

              call "DISPLAY_REG_ENUM_VALUE" using subkey-handle
                                                  ndx
                                                  value-name
                                                  name-size
                                                  data-type
                                                  value-data 
                                                  data-size
                                           giving status-code

              if status-code not = 0   
                 exit perform    
              end-if

              modify ls-values item-to-add value-name
           end-perform
           .      


       DELETE-VALUE. 
           inquire ls-values selection-index idx
           modify  ls-values query-index idx
           inquire ls-values item-value value-name

           if value-name = spaces
              exit paragraph
           end-if
    
           call "DISPLAY_REG_DELETE_VALUE" using subkey-handle
                                                 value-name
                                          giving status-code

           if status-code not = 0               
              display message box "Error deleting value"
                                  x"0D0A" "Error code: " status-code
                             icon mb-error-icon
                            title "Registry Error"
           else
              display message box "Value successfully deleted!"
                             icon mb-default-icon
                            title spaces
              perform ENUM-VALUES
           end-if
           .
                    

       SUBKEY-DELETION.
           move "iscobol-test-key" to subkey-to-be-deleted

           call "DISPLAY_REG_DELETE_KEY" using  open-key-handle
                                                subkey-to-be-deleted
                                         giving status-code

           if status-code not = 0 
              display message box "Error deleting the test key"
                              x"0D0A" "Error code: " status-code
           else
              modify pb-create-key   enabled 1
              modify pb-add-value    enabled 0
              modify pb-query-value  enabled 0                 
              modify pb-clear-values enabled 0
              modify pb-delete-key   enabled 0
              modify ls-values       reset-list 1
           end-if
           .                  

           
       CLOSE-KEY.     
           call "DISPLAY_REG_CLOSE_KEY" using  open-key-handle 
                                        giving status-code
           .