      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID.    CCONVERT.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(4).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

      *    List of numeric convention
       78  ConvDCA                 value 0.
       78  ConvDCI                 value 1.
       78  ConvDCM                 value 2.
       78  ConvDCMI                value 3.
       78  ConvDCII                value 4.
       78  ConvDCD                 value 5.
       78  ConvDCDM                value 6.
       78  ConvDCN                 value 7.
       78  ConvDCB                 value 8.
       78  ConvDCR                 value 9.

      *    List of possible item types
       78  NumEdited               value 0.  | Numeric Edited
       78  NumUnsigned             value 1.  | Unsigned numeric
       78  NumSignSep              value 2.  | Signed numeric (trail sep)
       78  NumSigned               value 3.  | Signed numeric (trail comb)
       78  NumSepLead              value 4.  | Signed numeric (lead sep)
       78  NumLeading              value 5.  | Signed numeric (lead comb)
       78  CompSigned              value 6.  | Signed computational
       78  CompUnsigned            value 7.  | Unsigned computational
       78  PackedPositive          value 8.  | Positive packed-decimal
       78  PackedSigned            value 9.  | Signed packed-decimal
       78  PackedUnsigned          value 10. | Computational-6
       78  BinarySigned            value 11. | Signed binary
       78  BinaryUnsigned          value 12. | Unsigned binary
       78  NativeSigned            value 13. | Signed native-order binary
       78  NativeUnsigned          value 14. | Unsigned native-order binary
       78  Alphanum                value 16. | Alphanumeric
       78  JustAN                  value 17. | Alphanumeric (justified)
       78  Alphbetic               value 18. | Alphabetic
       78  JustAlpha               value 19. | Alphabetic (justified)
       78  AlphaEdited             value 20. | Alphanumeric Edited
       78  Group                   value 22. | Group
       78  Flt                     value 23. | Float or Double
       78  Nat-type                value 24. | National
       78  JustNat                 value 25. | National (justified)
       78  NatEdited               value 26. | National edited
       78  Wide-type               value 27. | Wide
       78  JustWide                value 28. | Wide (justified)
       78  WideEdited              value 29. | Wide edited
       78  NativeVSigned           value 30. | Signed var-len native-order binary
       78  NativeVUnsigned         value 31. | Unsigned var-len native-order binary

       77  wrk-date                pic x(8).

       01  wrk-buffer              pic x any length.
       01  my-rec-data.
           05 mr-name              pic x(30).
           05 mr-birthday-date     pic 9(8) comp-4.

       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              lines                5
              size                 68 cells
              title                "This buffer string simulates a varia
      -                            "ble length linkage with a comp-4 dat
      -                            "a item at the end. C$LCONVERT will e
      -                            "xtract the comp-4 variable and conve
      -                            "rt it to readable text. C$RCONVERT w
      -                            "ill take readable text and convert i
      -                            "t to comp-4." 
              .
           03 lbl-buffer
              label
              line                 6
              col                  2
              size                 30 cells
              title                wrk-buffer
              .
           03 label
              line                 9
              col                  2
              title                "Extract the last part of the buffer 
      -                            "(Pic 9(8) comp-4)"
              .
           03 push-button
              default-button
              line                 9
              col                  45
              size                 12
              title                "C$LCONVERT"
              exception-value      101
              self-act
              .
           03 label
              line                 11
              col                  2
              title                "C$LCONVERT result:"
              .
           03 lbl-cl-result
              label
              line                 11
              col                  20
              .
           03 label
              line                 14
              col                  2
              title                "Update the last part of the buffer 
      -                            "(Pic 9(8) comp-4)"
              .
           03 push-button
              default-button
              line                 14
              col                  45
              size                 12
              title                "C$RCONVERT"
              exception-value      102
              self-act
              .

           03 label
              line                 16
              col                  2
              title                "C$RCONVERT result:"
              .
           03 lbl-cr-result
              label
              line                 16
              col                  20
              .


           03 Pb-exit  
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .


       PROCEDURE DIVISION.
       MAIN.       
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$LCONVERT and C$RCONVERT Routines"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT


           move "John Doe"   to mr-name
           move "20000101"   to mr-birthday-date

           move my-rec-data  to wrk-buffer.

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask 
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 101
                   perform CLCONVERT
              when 102
                   perform CRCONVERT
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           if event-type = cmd-close
              move 1 to close-win 
           end-if
           .
      
       CLCONVERT.
           CALL "C$LCONVERT" USING wrk-date
                                   wrk-buffer
                                   30
                                   4
                                   BinaryUnsigned
                                   8 
                                   0
                                   ConvDCA 
           .

           evaluate return-code
           when 0
                modify lbl-cl-result title wrk-date

           when 1
                display message "Error"
           when 2
                display message "Error: Invalid parameter"
           end-evaluate
           .

       CRCONVERT.
           accept wrk-date   from century-date

           CALL "C$RCONVERT" USING wrk-date
                                   wrk-buffer
                                   30
                                   4
                                   BinaryUnsigned
                                   8 
                                   0
                                   ConvDCA 
           .

           move wrk-buffer   to my-rec-data

           evaluate return-code
           when 0
                modify lbl-buffer title wrk-buffer 
                modify lbl-cr-result title wrk-buffer 
           when 1
                display message "Error"
           when 2
                display message "Error: Invalid parameter"
           end-evaluate

           .