      *> Copyright (c) 2005 - 2024 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CCALLEDB.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  calling-prg             pic x(256). 
       77  label-calling           pic x(256) value space. 


       SCREEN SECTION.
       01  Mask.
           03 label
              line                 2
              col                  2
              size                 34 cells
              title                "Who called me?"
              .
           03 label
              line                 4
              col                  2
              size                 34 cells
              title                label-calling
              .
           03  push-button
               line                8 
               col                 2
               size                20 cells
               title               "Call another Program" 
               exception-value     101
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       INI.   
           call "C$CALLEDBY" using calling-prg
           if calling-prg = spaces
              move "I've not been called"   to label-calling
           else
              string "I've been called by:" delimited by size
                     calling-prg            delimited by size
                     into label-calling
           end-if

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$CALLEDBY Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception
                    continue 
              end-accept
              if crt-status = 101
                 call "CCALLEDB2"
                 cancel "CCALLEDB2"
              end-if
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           if event-type = cmd-close   
              move 1 to close-win
           end-if
           .
   